/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.backtest;

/**
 * バックテスト進行状況イベントを受け取る為のリスナーインタフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface BacktesterListener {

	/**
	 * データセット毎のバックテスト開始前に呼出されます。
	 * 
	 * @param event バックテスト進行状況イベント情報
	 */
	public void backtestStart(BacktesterEvent event);

	/**
	 * データセット毎のバックテスト完了後に呼出されます。
	 * 
	 * @param event バックテスト進行状況イベント情報
	 */
	public void backtestProcessed(BacktesterEvent event);

//	/**
//	 * 全てのデータセットのバックテスト完了後に呼び出されます。
//	 * 
//	 * @param event バックテスト進行状況イベント情報
//	 * @param summary パフォーマンス概要情報
//	 */
//	public void backtestComplete(BacktesterEvent event, Summary summary);

}
