/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 *
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 *
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.csv.manager;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.fail;

import java.io.IOException;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.List;

import jp.sf.orangesignal.csv.CsvConfig;
import jp.sf.orangesignal.csv.model.SamplePrice;

import org.junit.Ignore;
import org.junit.Test;

/**
 * {@link CsvBeanManager} クラスの単体テストです。
 *
 * @author 杉澤 浩二
 */
public class CsvBeanManagerTest {

	@Test
	public void testCsvBeanManager() {
		new CsvBeanManager();
	}

	@Test
	public void testCsvBeanManagerCsvConfig() {
		new CsvBeanManager(new CsvConfig());
	}

	@Test
	public void testConfig() {
		new CsvBeanManager().config(new CsvConfig());
	}

	@Test
	public void testLoad() throws IOException {
		final CsvConfig cfg = new CsvConfig();
		cfg.setEscapeDisabled(false);

		final List<SamplePrice> list
			= new CsvBeanManager()
				.config(cfg)
				.load(SamplePrice.class)
				.format("date", new SimpleDateFormat("yyyy/MM/dd"))
				.format("price", new DecimalFormat("#,##0.00"))
				.from(new StringReader("date,name,price\r\n2009/01/01,商品A,10\\,005.89\r\n2009/01/02,商品B,2\\,000.05"));

		assertThat(list.size(), is(2));
		SamplePrice o1 = list.get(0);
		assertThat(new SimpleDateFormat("yyyy/MM/dd").format(o1.getDate()), is("2009/01/01"));
		assertThat(o1.getName(), is("商品A"));
		assertThat(o1.getPrice().toString(), is("10005.89"));
		SamplePrice o2 = list.get(1);
		assertThat(new SimpleDateFormat("yyyy/MM/dd").format(o2.getDate()), is("2009/01/02"));
		assertThat(o2.getName(), is("商品B"));
		assertThat(o2.getPrice().toString(), is("2000.05"));
	}

	@Ignore
	@Test
	public void testSave() {
		fail("まだ実装されていません");
	}

}
