/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import java.awt.Image;

import javax.swing.ImageIcon;

/**
 * アイコン情報を提供します。
 * このクラスはアプレットや画面の初期化で使用されます。
 * 
 * @author 杉澤 浩二
 */
public class Icons {

	/**
	 * ワンポイントアイコンを保持します。
	 */
	private ImageIcon onepoint;

	/**
	 * 株式分割アイコンを保持します。
	 */
	private ImageIcon split;

	/**
	 * デフォルトコンストラクタです。
	 */
	public Icons() {}

	/**
	 * ワンポイントアイコンを返します。
	 * 
	 * @return ワンポイントアイコン
	 */
	public ImageIcon getOnepoint() { return onepoint; }

	/**
	 * ワンポイントアイコンを設定します。
	 * 
	 * @param onepoint ワンポイントアイコン
	 */
	public void setOnepoint(final ImageIcon onepoint) { this.onepoint = onepoint; }

	/**
	 * ワンポイントアイコンを設定します。
	 * 
	 * @param onepoint ワンポイントアイコン
	 */
	public void setOnepoint(final Image onepoint) { this.onepoint = new ImageIcon(onepoint); }

	/**
	 * 株式分割アイコンを返します。
	 * 
	 * @return 株式分割アイコン
	 */
	public ImageIcon getSplit() { return split; }

	/**
	 * 株式分割アイコンを設定します。
	 * 
	 * @param split 株式分割アイコン
	 */
	public void setSplit(final ImageIcon split) { this.split = split; }

	/**
	 * 株式分割アイコンを設定します。
	 * 
	 * @param split 株式分割アイコン
	 */
	public void setSplit(final Image split) { this.split = new ImageIcon(split); }

}
