/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import java.awt.Color;

import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.util.StringManager;

/**
 * 陰陽色を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum UpDownColorType {

	/**
	 * 陰陽色が赤と青であることを表します。
	 */
	RED_BLUE {
		@Override public Color getUpColor1() { return ChartColor.VERY_LIGHT_RED; }
		@Override public Color getUpColor2() { return Color.RED; }
		@Override public Color getUpLineColor() { return Color.RED; }
		@Override public Color getDownColor1() { return ChartColor.VERY_LIGHT_BLUE; }
		@Override public Color getDownColor2() { return Color.BLUE; }
		@Override public Color getDownLineColor() { return Color.BLUE; }
		@Override public String toString() { return StringManager.getString("color1"); }
	},

	/**
	 * 陰陽色が緑と赤であることを表します。
	 */
	GREEN_RED {
		@Override public Color getUpColor1() { return ChartColor.GREEN; }
		@Override public Color getUpColor2() { return ChartColor.DARK_GREEN; }
		@Override public Color getUpLineColor() { return ChartColor.DARK_GREEN; }
		@Override public Color getDownColor1() { return ChartColor.VERY_LIGHT_RED; }
		@Override public Color getDownColor2() { return Color.RED; }
		@Override public Color getDownLineColor() { return Color.RED; }
		@Override public String toString() { return StringManager.getString("color2"); }
	},

	/**
	 * 陰陽色が赤と黒であることを表します。
	 */
	RED_BLACK {
		@Override public Color getUpColor1() { return ChartColor.VERY_LIGHT_RED; }
		@Override public Color getUpColor2() { return Color.RED; }
		@Override public Color getUpLineColor() { return Color.RED; }
		@Override public Color getDownColor1() { return Color.LIGHT_GRAY; }
		@Override public Color getDownColor2() { return Color.BLACK; }
		@Override public Color getDownLineColor() { return Color.BLACK; }
		@Override public String toString() { return StringManager.getString("color0"); }
	},

	/**
	 * 陰陽色が白と黒であることを表します。
	 */
	WHITE_BLACK {
		@Override public Color getUpColor1() { return Color.WHITE; }
		@Override public Color getUpColor2() { return ChartColor.VERY_LIGHT_GRAY; }
		@Override public Color getUpLineColor() { return Color.BLACK; }
		@Override public Color getDownColor1() { return Color.LIGHT_GRAY; }
		@Override public Color getDownColor2() { return Color.BLACK; }
		@Override public Color getDownLineColor() { return Color.BLACK; }
		@Override public String toString() { return StringManager.getString("color3"); }
	},

	/**
	 * 陰陽色が白(赤枠)と青であることを表します。
	 */
	WHITE_BLUE_RED_OUTLINE {
		@Override public Color getUpColor1() { return Color.WHITE; }
		@Override public Color getUpColor2() { return ChartColor.VERY_VERY_LIGHT_RED; }
		@Override public Color getUpLineColor() { return Color.RED; }
		@Override public Color getDownColor1() { return Color.BLUE; }
		@Override public Color getDownColor2() { return ChartColor.VERY_DARK_BLUE; }
		@Override public Color getDownLineColor() { return Color.BLUE; }
		@Override public String toString() { return StringManager.getString("color6"); }
	},

	/**
	 * 陰陽色が白(青枠)と青であることを表します。
	 */
	WHITE_BLUE_BLUE_OUTLINE {
		@Override public Color getUpColor1() { return Color.WHITE; }
		@Override public Color getUpColor2() { return ChartColor.VERY_VERY_LIGHT_BLUE; }
		@Override public Color getUpLineColor() { return Color.BLUE; }
		@Override public Color getDownColor1() { return Color.BLUE; }
		@Override public Color getDownColor2() { return ChartColor.VERY_DARK_BLUE; }
		@Override public Color getDownLineColor() { return Color.BLUE; }
		@Override public String toString() { return StringManager.getString("color5"); }
	},

	/**
	 * 陰陽色が白(黒枠)と青であることを表します。
	 */
	WHITE_BLUE_BLACK_OUTLINE {
		@Override public Color getUpColor1() { return Color.WHITE; }
		@Override public Color getUpColor2() { return ChartColor.VERY_LIGHT_GRAY; }
		@Override public Color getUpLineColor() { return Color.BLACK; }
		@Override public Color getDownColor1() { return Color.BLUE; }
		@Override public Color getDownColor2() { return ChartColor.VERY_DARK_BLUE; }
		@Override public Color getDownLineColor() { return Color.BLACK; }
		@Override public String toString() { return StringManager.getString("color4"); }
	};

	/**
	 * 陽線本体の明色を返します。
	 * 
	 * @return 陽線本体の明色
	 */
	public abstract Color getUpColor1();

	/**
	 * 陽線本体の暗色を返します。
	 * 
	 * @return 陽線本体の暗色
	 */
	public abstract Color getUpColor2();

	/**
	 * 陽線のヒゲや枠の色を返します。
	 * 
	 * @return 陽線のヒゲや枠の色
	 */
	public abstract Color getUpLineColor();

	/**
	 * 陰線本体の明色を返します。
	 * 
	 * @return 陰線本体の明色
	 */
	public abstract Color getDownColor1();

	/**
	 * 陰線本体の暗色を返します。
	 * 
	 * @return 陰線本体の暗色
	 */
	public abstract Color getDownColor2();

	/**
	 * 陰線のヒゲや枠の色を返します。
	 * 
	 * @return 陰線のヒゲや枠の色
	 */
	public abstract Color getDownLineColor();

}
