/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui.canvas;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;

import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.FontConstants;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.util.DrawUtils;
import jp.sf.orangesignal.chart.util.StringManager;
import jp.sf.orangesignal.ta.util.StringUtils;

public abstract class AbstractChartCanvas extends DoubleBufferedCanvas {

	private static final long serialVersionUID = -4148557430424577501L;

	/**
	 * デフォルトコンストラクタです。
	 */
	public AbstractChartCanvas() {
		setBackground(Color.WHITE);
	}

	@Override
	public void setRenderingHints(final Graphics2D g2) {
/*
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
		g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
		g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
		g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
		g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
		g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
		g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
		g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
*/
		g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
		g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
		g2.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
		g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
		g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
		g2.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
		g2.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
		g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
	}

	/**
	 * データセットを切替えます。
	 * 
	 * @param e チャートイベント情報
	 */
	public abstract void switchDataset(ChartEvent e);

	/**
	 * 開始位置を設定します。
	 * 
	 * @param start 開始位置
	 */
	public abstract void setStart(int start);

	/**
	 * チャートの説明を追加します。
	 * 
	 * @param sb 文字列バッファ
	 * @param text 追加する文字列
	 */
	protected static final void addDescription(final StringBuilder sb, final String text) {
		if (StringUtils.isEmpty(text)) {
			return;
		}
		if (sb.length() > 0) {
			sb.append(StringManager.getString("conjunction"));
		}
		sb.append(text);
	}

	/**
	 * チャートの説明を描画します。
	 * 
	 * @param g2 グラフィックスオブジェクト
	 * @param area 描画領域
	 * @param text チャートの説明文
	 */
	protected static final void drawDescription(final Graphics2D g2, final Rectangle2D area, final String text) {
		g2.setFont(FontConstants.FONT_GUI);
		final float x = (float) area.getMinX();
		final float y = (float) area.getMinY() + g2.getFontMetrics().getAscent();
		DrawUtils.drawText(g2, text, x, y, ChartColor.GRAY);
	}

}
