/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;
import jp.sf.orangesignal.ta.MovingAverage;

import org.junit.Test;

/**
 * {@link MAType} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class MATypeTest {

	@Test
	public void testValues() {
		final MAType[] values = MAType.values();
		for (final MAType value : values) {
			switch (value) {
				case SMA:
				case SMMA:
				case RMA:
				case WMA:
				case HMA:
				case TMA:
				case EMA:
				case DEMA:
				case TEMA:
				case ZLEMA:
				case EPMA:
				case T3:
					assertTrue(true);
					break;
				default:
					assertTrue(false);
			}
		}
	}

	@Test
	public void testGetMovingAverage() {
		assertThat(MAType.SMA.getMovingAverage(), is(MovingAverage.SMA));
		assertThat(MAType.SMMA.getMovingAverage(), is(MovingAverage.SMMA));
		assertThat(MAType.RMA.getMovingAverage(), is(MovingAverage.RMA));
		assertThat(MAType.WMA.getMovingAverage(), is(MovingAverage.WMA));
		assertThat(MAType.HMA.getMovingAverage(), is(MovingAverage.HMA));
		assertThat(MAType.TMA.getMovingAverage(), is(MovingAverage.TMA));
		assertThat(MAType.EMA.getMovingAverage(), is(MovingAverage.EMA));
		assertThat(MAType.DEMA.getMovingAverage(), is(MovingAverage.DEMA));
		assertThat(MAType.TEMA.getMovingAverage(), is(MovingAverage.TEMA));
		assertThat(MAType.ZLEMA.getMovingAverage(), is(MovingAverage.ZLEMA));
		assertThat(MAType.EPMA.getMovingAverage(), is(MovingAverage.EPMA));
		assertThat(MAType.T3.getMovingAverage(), is(MovingAverage.T3));
	}

	@Test
	public void testToString() {
		assertNotNull(MAType.SMA.toString());
		assertNotNull(MAType.SMMA.toString());
		assertNotNull(MAType.RMA.toString());
		assertNotNull(MAType.WMA.toString());
		assertNotNull(MAType.HMA.toString());
		assertNotNull(MAType.TMA.toString());
		assertNotNull(MAType.EMA.toString());
		assertNotNull(MAType.DEMA.toString());
		assertNotNull(MAType.TEMA.toString());
		assertNotNull(MAType.ZLEMA.toString());
		assertNotNull(MAType.EPMA.toString());
		assertNotNull(MAType.T3.toString());
	}

}
