/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

/**
 * {@link PeriodType} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class PeriodTypeTest {

	@Test
	public void testValues() {
		final PeriodType[] values = PeriodType.values();
		for (final PeriodType value : values) {
			switch (value) {
				case THREE_MONTH:
				case SIX_MONTH:
				case ONE_YEAR:
				case TWO_YEAR:
				case THREE_YEAR:
				case FOUR_YEAR:
				case FIVE_YEAR:
				case TEN_YEAR:
				case ALL:
					assertTrue(true);
					break;
				default:
					assertTrue(false);
			}
		}
	}

	@Test
	public void testGetPeriod() {
		assertThat(PeriodType.THREE_MONTH.getPeriod(DatasetType.DAILY), is(65));
		assertThat(PeriodType.THREE_MONTH.getPeriod(DatasetType.WEEKLY), is(13));
		assertThat(PeriodType.THREE_MONTH.getPeriod(DatasetType.MONTHLY), is(3));
		assertThat(PeriodType.SIX_MONTH.getPeriod(DatasetType.DAILY), is(127));
		assertThat(PeriodType.SIX_MONTH.getPeriod(DatasetType.WEEKLY), is(26));
		assertThat(PeriodType.SIX_MONTH.getPeriod(DatasetType.MONTHLY), is(6));
		assertThat(PeriodType.ONE_YEAR.getPeriod(DatasetType.DAILY), is(246));
		assertThat(PeriodType.ONE_YEAR.getPeriod(DatasetType.WEEKLY), is(52));
		assertThat(PeriodType.ONE_YEAR.getPeriod(DatasetType.MONTHLY), is(12));
		assertThat(PeriodType.TWO_YEAR.getPeriod(DatasetType.DAILY), is(246 * 2));
		assertThat(PeriodType.TWO_YEAR.getPeriod(DatasetType.WEEKLY), is(52 * 2));
		assertThat(PeriodType.TWO_YEAR.getPeriod(DatasetType.MONTHLY), is(12 * 2));
		assertThat(PeriodType.THREE_YEAR.getPeriod(DatasetType.DAILY), is(246 * 3));
		assertThat(PeriodType.THREE_YEAR.getPeriod(DatasetType.WEEKLY), is(52 * 3));
		assertThat(PeriodType.THREE_YEAR.getPeriod(DatasetType.MONTHLY), is(12 * 3));
		assertThat(PeriodType.FOUR_YEAR.getPeriod(DatasetType.DAILY), is(246 * 4));
		assertThat(PeriodType.FOUR_YEAR.getPeriod(DatasetType.WEEKLY), is(52 * 4));
		assertThat(PeriodType.FOUR_YEAR.getPeriod(DatasetType.MONTHLY), is(12 * 4));
		assertThat(PeriodType.FIVE_YEAR.getPeriod(DatasetType.DAILY), is(246 * 5));
		assertThat(PeriodType.FIVE_YEAR.getPeriod(DatasetType.WEEKLY), is(52 * 5));
		assertThat(PeriodType.FIVE_YEAR.getPeriod(DatasetType.MONTHLY), is(12 * 5));
		assertThat(PeriodType.TEN_YEAR.getPeriod(DatasetType.DAILY), is(246 * 10));
		assertThat(PeriodType.TEN_YEAR.getPeriod(DatasetType.WEEKLY), is(52 * 10));
		assertThat(PeriodType.TEN_YEAR.getPeriod(DatasetType.MONTHLY), is(12 * 10));
		assertThat(PeriodType.ALL.getPeriod(DatasetType.DAILY), is(-1));
		assertThat(PeriodType.ALL.getPeriod(DatasetType.WEEKLY), is(-1));
		assertThat(PeriodType.ALL.getPeriod(DatasetType.MONTHLY), is(-1));
	}

	@Test
	public void testToString() {
		assertNotNull(PeriodType.THREE_MONTH.toString());
		assertNotNull(PeriodType.SIX_MONTH.toString());
		assertNotNull(PeriodType.ONE_YEAR.toString());
		assertNotNull(PeriodType.TWO_YEAR.toString());
		assertNotNull(PeriodType.THREE_YEAR.toString());
		assertNotNull(PeriodType.FOUR_YEAR.toString());
		assertNotNull(PeriodType.FIVE_YEAR.toString());
		assertNotNull(PeriodType.TEN_YEAR.toString());
		assertNotNull(PeriodType.ALL.toString());
	}

}
