/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertThat;

import java.util.Locale;

import org.junit.Test;

/**
 * {@link NumberFormatConfig} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class NumberFormatConfigTest {

	@Test
	public void testNumberFormatConfig() {
		new NumberFormatConfig();
	}

	@Test
	public void testNumberFormatConfigStringLocaleString() {
		new NumberFormatConfig("#,##0", null, null);
		new NumberFormatConfig("#,##0", Locale.JAPAN, null);
		new NumberFormatConfig("\u00A4\u00A4 #,##0", Locale.JAPAN, "USD");
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNumberFormatConfigStringLocaleStringIllegalArgumentException1() {
		new NumberFormatConfig(null, null, null);
	}

	@Test(expected = IllegalArgumentException.class)
	public void testNumberFormatConfigStringLocaleStringIllegalArgumentException2() {
		new NumberFormatConfig("", null, null);
	}

	@Test
	public void testGetPattern() {
		final NumberFormatConfig config1 = new NumberFormatConfig("#,##0", null, null);
		assertThat(config1.getPattern(), is("#,##0"));
		final NumberFormatConfig config2 = new NumberFormatConfig("\u00A4\u00A4 #,##0", Locale.JAPAN, "USD");
		assertThat(config2.getPattern(), is("\u00A4\u00A4 #,##0"));
	}

	@Test
	public void testGetLocale() {
		final NumberFormatConfig config1 = new NumberFormatConfig("#,##0", null, null);
		assertNull(config1.getLocale());
		final NumberFormatConfig config2 = new NumberFormatConfig("\u00A4\u00A4 #,##0", Locale.JAPAN, "USD");
		assertThat(config2.getLocale().getCountry(), is("JP"));
	}

	@Test
	public void testGetCurrencyCode() {
		final NumberFormatConfig config1 = new NumberFormatConfig("#,##0", null, null);
		assertNull(config1.getCurrencyCode());
		final NumberFormatConfig config2 = new NumberFormatConfig("\u00A4\u00A4 #,##0", Locale.JAPAN, "USD");
		assertThat(config2.getCurrencyCode(), is("USD"));
	}

}
