/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.data;

import jp.sf.orangesignal.ta.data.DatasetSource;
import jp.sf.orangesignal.ta.data.MergeGapFillType;
import jp.sf.orangesignal.ta.data.MergeMatchType;
import jp.sf.orangesignal.ta.data.annotation.AnnotationParser;
import jp.sf.orangesignal.ta.data.model.Margin;
import jp.sf.orangesignal.ta.data.model.Price;
import jp.sf.orangesignal.ta.data.model.StockSplit;
import jp.sf.orangesignal.ta.util.Assert;

abstract class DatasetGenerator {

	public static <T> T generate(final Class<? extends T> datasetClass, final Price[] prices, final Margin[] margins, final StockSplit[] splits, final boolean calcSplit) {
		Assert.notNull(datasetClass, "Dataset class must not be null");
		Assert.notEmpty(prices, "Prices must not be empty");

		final DatasetSource source = AnnotationParser.parse(prices);

		// 分割情報を処理します。
		if (splits != null && splits.length > 0) {
			source.merge(AnnotationParser.parse(splits), MergeMatchType.CURRENT);
			if (calcSplit) {
				source.split("split", "open", "high", "low", "close");
			}
		}

		// 信用残を処理します。
		if (margins != null && margins.length > 0) {
			source.merge(AnnotationParser.parse(margins), MergeMatchType.CURRENT, MergeGapFillType.PREVIOUS, null);
		}

		return source.build(datasetClass).execute();
	}

}
