package jp.sf.orangesignal.trading.backtest;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.LinkedList;

import jp.sf.orangesignal.trading.Position;
import jp.sf.orangesignal.trading.backtest.BacktesterEvent;
import jp.sf.orangesignal.trading.stats.Stats;

import org.junit.Test;

public class BacktesterEventTest {

	@Test
	public void testBacktesterEvent() {
		new BacktesterEvent(this, 3, 1, "n225", "日経平均株価 255種", null);
		assertTrue(true);
	}

	@Test
	public void testGetMax() {
		assertTrue(new BacktesterEvent(this, 3, 1, "n225", "日経平均株価 255種", null).getMax() == 3);
	}

	@Test
	public void testGetCount() {
		assertTrue(new BacktesterEvent(this, 3, 1, "n225", "日経平均株価 255種", null).getCount() == 1);
	}

	@Test
	public void testGetSymbol() {
		assertEquals(new BacktesterEvent(this, 3, 1, "n225", "日経平均株価 255種", null).getSymbol(), "n225");
	}

	@Test
	public void testGetSymbolName() {
		assertEquals(new BacktesterEvent(this, 3, 1, "n225", "日経平均株価 255種", null).getSymbolName(), "日経平均株価 255種");
	}

	@Test
	public void testGetStats() {
		assertNull(new BacktesterEvent(this, 3, 1, "n225", "日経平均株価 255種", null).getStats());
		assertNotNull(new BacktesterEvent(this, 3, 1, "n225", "日経平均株価 255種", new Stats(new LinkedList<Position>(), 1000000)).getStats());
	}

}
