/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.candle.generator;

import jp.sf.orangesignal.ta.candle.TrendType;
import jp.sf.orangesignal.ta.candle.generator.DefaultCandlestick;
import jp.sf.orangesignal.ta.candle.generator.TrendProcessor;

public final class ParabolicSarTrendProcessor
implements TrendProcessor {
    private Number[] sar;

    public ParabolicSarTrendProcessor(Number[] sar) {
        this.sar = sar;
    }

    @Override
    public void execute(DefaultCandlestick[] c) {
        int len = Math.min(this.sar.length, c.length);
        for (int i = 0; i < len; ++i) {
            if (this.sar[i] == null || c[i] == null) continue;
            double x = this.sar[i].doubleValue();
            if (c[i].getClose() < x) {
                c[i].trend = TrendType.DOWN;
                continue;
            }
            if (!(c[i].getClose() > x)) continue;
            c[i].trend = TrendType.UP;
        }
    }
}

