/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.data;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import jp.sf.orangesignal.ta.data.CompressType;
import jp.sf.orangesignal.ta.data.DataConvertException;
import jp.sf.orangesignal.ta.data.DateFormatConfig;
import jp.sf.orangesignal.ta.data.DateTruncater;
import jp.sf.orangesignal.ta.data.MergeGapFillType;
import jp.sf.orangesignal.ta.data.MergeMatchType;
import jp.sf.orangesignal.ta.data.NumberFormatConfig;
import jp.sf.orangesignal.ta.util.Assert;
import jp.sf.orangesignal.ta.util.DateFormatUtils;
import jp.sf.orangesignal.ta.util.NumberFormatUtils;

public abstract class DataConvertUtils {
    public static final MergeMatchType DEFAULT_MERGE_MATCH_TYPE = MergeMatchType.CURRENT;

    public static Date toDate(Object obj) throws IllegalArgumentException, DataConvertException {
        return DataConvertUtils.toDate(obj, null);
    }

    public static Date toDate(Object obj, DateFormatConfig cfg) throws IllegalArgumentException, DataConvertException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)((Date)obj).clone();
        }
        if (obj instanceof Calendar) {
            return ((Calendar)obj).getTime();
        }
        if (obj instanceof Number) {
            return DataConvertUtils.toDate((Number)obj);
        }
        if (obj instanceof CharSequence) {
            Assert.notNull(cfg, "DateFormatConfig must not be null");
            try {
                return DateFormatUtils.parse(obj.toString(), new String[]{cfg.getPattern()}, cfg.getLocale(), cfg.getTimeZone());
            }
            catch (ParseException e) {
                throw new DataConvertException(e.getMessage(), e);
            }
        }
        try {
            return new Date(new BigDecimal(obj.toString()).longValue());
        }
        catch (NumberFormatException e) {
            throw new DataConvertException(e.getMessage(), e);
        }
    }

    public static Date toDate(Number number) throws IllegalArgumentException, DataConvertException {
        return DataConvertUtils.toDate(number, Date.class);
    }

    public static <T extends Date> T toDate(Number number, Class<T> dateClass) throws IllegalArgumentException, DataConvertException {
        try {
            Constructor<T> constructor = dateClass.getConstructor(Long.TYPE);
            return (T)((Date)constructor.newInstance(number.longValue()));
        }
        catch (Exception e) {
            throw new DataConvertException(e.getMessage(), e);
        }
    }

    public static Number toNumber(Object obj) throws IllegalArgumentException, DataConvertException {
        return DataConvertUtils.toNumber(obj, null);
    }

    public static Number toNumber(Object obj, NumberFormatConfig cfg) throws IllegalArgumentException, DataConvertException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return ((Date)obj).getTime();
        }
        if (obj instanceof Calendar) {
            return ((Calendar)obj).getTimeInMillis();
        }
        if (obj instanceof CharSequence) {
            Assert.notNull(cfg, "NumberFormatConfig must not be null");
            try {
                String[] stringArray;
                String string = obj.toString();
                String[] stringArray2 = new String[]{cfg.getPattern()};
                Locale locale = cfg.getLocale();
                if (cfg.getCurrencyCode() != null && !cfg.getCurrencyCode().isEmpty()) {
                    String[] stringArray3 = new String[1];
                    stringArray = stringArray3;
                    stringArray3[0] = cfg.getCurrencyCode();
                } else {
                    stringArray = null;
                }
                return NumberFormatUtils.parse(string, stringArray2, locale, stringArray);
            }
            catch (ParseException e) {
                throw new DataConvertException(e.getMessage(), e);
            }
        }
        try {
            return new BigDecimal(obj.toString());
        }
        catch (NumberFormatException e) {
            throw new DataConvertException(e.getMessage(), e);
        }
    }

    public static Date[] toDateArray(Collection<?> c) throws IllegalArgumentException, DataConvertException {
        return DataConvertUtils.toDateArray(c, null);
    }

    public static Date[] toDateArray(Collection<?> c, DateFormatConfig cfg) throws IllegalArgumentException, DataConvertException {
        if (c == null) {
            return null;
        }
        return DataConvertUtils.toDateArray(c.toArray(), cfg);
    }

    public static Date[] toDateArray(Object[] array) throws IllegalArgumentException, DataConvertException {
        return DataConvertUtils.toDateArray(array, null);
    }

    public static Date[] toDateArray(Object[] array, DateFormatConfig cfg) throws IllegalArgumentException, DataConvertException {
        if (array == null) {
            return null;
        }
        int size = array.length;
        Date[] results = new Date[size];
        for (int i = 0; i < size; ++i) {
            results[i] = DataConvertUtils.toDate(array[i], cfg);
        }
        return results;
    }

    public static Number[] toNumberArray(int[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            results[i] = data[i];
        }
        return results;
    }

    public static Number[] toNumberArray(long[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            results[i] = data[i];
        }
        return results;
    }

    public static Number[] toNumberArray(float[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            results[i] = Float.valueOf(data[i]);
        }
        return results;
    }

    public static Number[] toNumberArray(double[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            results[i] = data[i];
        }
        return results;
    }

    public static Number[] toNumberArray(Collection<?> c) throws IllegalArgumentException, DataConvertException {
        return DataConvertUtils.toNumberArray(c, null);
    }

    public static Number[] toNumberArray(Collection<?> c, NumberFormatConfig cfg) throws IllegalArgumentException, DataConvertException {
        if (c == null) {
            return null;
        }
        return DataConvertUtils.toNumberArray(c.toArray(), cfg);
    }

    public static Number[] toNumberArray(Object[] data) throws IllegalArgumentException, DataConvertException {
        return DataConvertUtils.toNumberArray(data, null);
    }

    public static Number[] toNumberArray(Object[] data, NumberFormatConfig cfg) throws IllegalArgumentException, DataConvertException {
        if (data == null) {
            return null;
        }
        int size = data.length;
        Number[] results = new Number[size];
        for (int i = 0; i < size; ++i) {
            results[i] = DataConvertUtils.toNumber(data[i], cfg);
        }
        return results;
    }

    public static Number[] toNumberArrayWithNullIfZero(int[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (data[i] == 0) continue;
            results[i] = data[i];
        }
        return results;
    }

    public static Number[] toNumberArrayWithNullIfZero(long[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (data[i] == 0L) continue;
            results[i] = data[i];
        }
        return results;
    }

    public static Number[] toNumberArrayWithNullIfZero(float[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (data[i] == 0.0f) continue;
            results[i] = Float.valueOf(data[i]);
        }
        return results;
    }

    public static Number[] toNumberArrayWithNullIfZero(double[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            if (data[i] == 0.0) continue;
            results[i] = data[i];
        }
        return results;
    }

    public static Number[] toNumberArrayWithPreviousIfZero(int[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        Integer last = null;
        for (int i = 0; i < length; ++i) {
            if (data[i] != 0) {
                last = data[i];
            }
            results[i] = last;
        }
        return results;
    }

    public static Number[] toNumberArrayWithPreviousIfZero(long[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        Long last = null;
        for (int i = 0; i < length; ++i) {
            if (data[i] != 0L) {
                last = data[i];
            }
            results[i] = last;
        }
        return results;
    }

    public static Number[] toNumberArrayWithPreviousIfZero(float[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        Float last = null;
        for (int i = 0; i < length; ++i) {
            if (data[i] != 0.0f) {
                last = Float.valueOf(data[i]);
            }
            results[i] = last;
        }
        return results;
    }

    public static Number[] toNumberArrayWithPreviousIfZero(double[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        Double last = null;
        for (int i = 0; i < length; ++i) {
            if (data[i] != 0.0) {
                last = data[i];
            }
            results[i] = last;
        }
        return results;
    }

    public static Number[] zeroIfNull(Number[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        for (int i = 0; i < length; ++i) {
            results[i] = data[i] == null ? (Number)0 : (Number)data[i].doubleValue();
        }
        return results;
    }

    public static Number[] previousIfNull(Number[] data) {
        if (data == null) {
            return null;
        }
        int length = data.length;
        Number[] results = new Number[length];
        Double last = null;
        for (int i = 0; i < length; ++i) {
            if (data[i] != null) {
                last = data[i].doubleValue();
            }
            results[i] = last;
        }
        return results;
    }

    public static <T> SortedMap<Date, T> toSortedMap(Date[] date, T[] data) {
        Assert.notNull(date, "Date must not be null.");
        TreeMap<Date, T> results = new TreeMap<Date, T>();
        if (data == null) {
            int length = date.length;
            for (int i = 0; i < length; ++i) {
                results.put(date[i], null);
            }
        } else {
            int length = Math.min(date.length, data.length);
            for (int i = 0; i < length; ++i) {
                results.put(date[i], data[i]);
            }
        }
        return results;
    }

    public static <T> SortedMap<Date, T> merge(Date[] base, Date[] date, T[] data) {
        return DataConvertUtils.merge(base, date, data, DEFAULT_MERGE_MATCH_TYPE, null, null);
    }

    public static <T> SortedMap<Date, T> merge(Date[] base, Date[] date, T[] data, MergeMatchType matchType, MergeGapFillType fillType, T fill) {
        Assert.notNull(base, "Base date must not be null");
        return DataConvertUtils.merge(new TreeSet<Date>(Arrays.asList(base)), DataConvertUtils.toSortedMap(date, data), matchType, fillType, fill);
    }

    public static <T> SortedMap<Date, T> merge(Collection<Date> base, SortedMap<Date, T> data) {
        return DataConvertUtils.merge(base, data, DEFAULT_MERGE_MATCH_TYPE, null, null);
    }

    public static <T> SortedMap<Date, T> merge(Collection<Date> base, SortedMap<Date, T> data, MergeMatchType matchType, MergeGapFillType fillType, T fill) {
        Assert.notNull(base, "Base date must not be null");
        HashMap<Date, Object> map = new HashMap<Date, Object>();
        for (Date _date : base) {
            map.put(_date, null);
        }
        return DataConvertUtils.merge(map, data, matchType, fillType, fill);
    }

    public static <T> SortedMap<Date, T> merge(Map<Date, T> base, SortedMap<Date, T> data, MergeMatchType matchType, MergeGapFillType fillType, T fill) {
        Assert.notNull(base, "Base date must not be null");
        Assert.notNull((Object)matchType, "MergeType must not be null");
        if (data == null) {
            return null;
        }
        TreeMap<Date, T> results = new TreeMap<Date, T>(base);
        block4: for (Map.Entry<Date, T> _data : data.entrySet()) {
            Map.Entry<Date, T> result;
            Date _date = _data.getKey();
            if (_date == null) continue;
            Date match = null;
            if (matchType == MergeMatchType.INSERT || results.containsKey(_date)) {
                results.put(_date, _data.getValue());
                match = _date;
            } else if (matchType == MergeMatchType.CURRENT) {
                result = results.floorEntry(_date);
                if (result != null) {
                    results.put(result.getKey(), _data.getValue());
                    match = result.getKey();
                }
            } else if (matchType == MergeMatchType.NEXT && (result = results.ceilingEntry(_date)) != null) {
                results.put(result.getKey(), _data.getValue());
                match = result.getKey();
            }
            if (fillType == null || match == null) continue;
            switch (fillType) {
                case PREVIOUS: {
                    T prev = results.get(match);
                    for (Map.Entry entry : results.tailMap(match, false).entrySet()) {
                        entry.setValue(prev);
                    }
                    continue block4;
                }
                case PARAMETER: {
                    for (Map.Entry entry : results.tailMap(match, false).entrySet()) {
                        entry.setValue(fill);
                    }
                    break;
                }
            }
        }
        return results;
    }

    public static SortedMap<Date, Number> compress(Date[] date, Number[] data, CompressType compressType, int truncateUnit) {
        return DataConvertUtils.compress(DataConvertUtils.toSortedMap(date, data), compressType, truncateUnit, Calendar.getInstance(), new DateTruncater());
    }

    public static SortedMap<Date, Number> compress(Date[] date, Number[] data, CompressType compressType, int truncateUnit, Calendar calendar) {
        return DataConvertUtils.compress(DataConvertUtils.toSortedMap(date, data), compressType, truncateUnit, calendar, new DateTruncater());
    }

    public static SortedMap<Date, Number> compress(Date[] date, Number[] data, CompressType compressType, int truncateUnit, Calendar calendar, DateTruncater truncater) {
        return DataConvertUtils.compress(DataConvertUtils.toSortedMap(date, data), compressType, truncateUnit, calendar, truncater);
    }

    public static SortedMap<Date, Number> compress(SortedMap<Date, Number> data, CompressType compressType, int truncateUnit) {
        return DataConvertUtils.compress(data, compressType, truncateUnit, Calendar.getInstance(), new DateTruncater());
    }

    public static SortedMap<Date, Number> compress(SortedMap<Date, Number> data, CompressType compressType, int truncateUnit, Calendar calendar) {
        return DataConvertUtils.compress(data, compressType, truncateUnit, calendar, new DateTruncater());
    }

    public static SortedMap<Date, Number> compress(SortedMap<Date, Number> data, CompressType compressType, int truncateUnit, Calendar calendar, DateTruncater truncater) {
        Assert.notNull((Object)compressType, "CompressType must not be null");
        Assert.notNull(calendar, "Calendar must not be null");
        Assert.notNull(truncater, "DateTruncater must not be null");
        if (data == null) {
            return null;
        }
        TreeMap<Date, Number> results = new TreeMap<Date, Number>();
        Calendar _calendar = (Calendar)calendar.clone();
        block7: for (Map.Entry<Date, Number> _data : data.entrySet()) {
            Date _date = _data.getKey();
            if (_date == null) continue;
            _calendar.setTime(_date);
            Date truncatedDate = truncater.truncate(_calendar, truncateUnit).getTime();
            Number _value = _data.getValue();
            if (results.containsKey(truncatedDate)) {
                Number value = (Number)results.get(truncatedDate);
                switch (compressType) {
                    case FIRST: {
                        break;
                    }
                    case HIGHEST: {
                        if (value != null && (_value == null || !(value.doubleValue() < _value.doubleValue()))) continue block7;
                        results.put(truncatedDate, _value);
                        break;
                    }
                    case LOWEST: {
                        if (value != null && (_value == null || !(value.doubleValue() > _value.doubleValue()))) continue block7;
                        results.put(truncatedDate, _value);
                        break;
                    }
                    case LAST: {
                        results.put(truncatedDate, _value);
                        break;
                    }
                    case SUM: {
                        if (value == null && _value == null) continue block7;
                        results.put(truncatedDate, (value == null ? 0.0 : value.doubleValue()) + (_value == null ? 0.0 : _value.doubleValue()));
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown CompressType [" + compressType.toString() + "]");
                    }
                }
                continue;
            }
            results.put(truncatedDate, _value);
        }
        return results;
    }

    public static String toString(Date date, DateFormatConfig cfg) {
        if (date == null) {
            return null;
        }
        if (cfg == null) {
            return date.toString();
        }
        return DateFormatUtils.format(date, cfg.getPattern(), cfg.getLocale(), cfg.getTimeZone());
    }

    public static String toString(Number number, NumberFormatConfig cfg) {
        if (number == null) {
            return null;
        }
        if (cfg == null) {
            return number.toString();
        }
        return NumberFormatUtils.format(number, cfg.getPattern(), cfg.getLocale(), cfg.getCurrencyCode());
    }

    public static String[] toStringArray(Date[] array, DateFormatConfig cfg) {
        if (array == null) {
            return null;
        }
        int size = array.length;
        String[] results = new String[size];
        for (int i = 0; i < size; ++i) {
            results[i] = DataConvertUtils.toString(array[i], cfg);
        }
        return results;
    }

    public static String[] toStringArray(Number[] array, NumberFormatConfig cfg) {
        if (array == null) {
            return null;
        }
        int size = array.length;
        String[] results = new String[size];
        for (int i = 0; i < size; ++i) {
            results[i] = DataConvertUtils.toString(array[i], cfg);
        }
        return results;
    }
}

