/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.ta.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Currency;
import java.util.Locale;
import jp.sf.orangesignal.ta.util.ArrayUtils;
import jp.sf.orangesignal.ta.util.Assert;

public abstract class NumberFormatUtils {
    public static Number parse(String source, String[] patterns) throws ParseException {
        return NumberFormatUtils.parse(source, patterns, null, null);
    }

    public static Number parse(String source, String[] patterns, Locale locale) throws ParseException {
        return NumberFormatUtils.parse(source, patterns, locale, null);
    }

    public static Number parse(String source, String[] patterns, Locale locale, String[] currencyCodes) throws ParseException {
        Assert.notNull(source, "Source must not be null");
        Assert.notNull(patterns, "Patterns must not be null");
        Assert.noNullElements(patterns, "Patterns must not contain null elements");
        Assert.noNullElements(currencyCodes, "Currency codes must not contain null elements");
        DecimalFormat parser = null;
        ParsePosition pos = new ParsePosition(0);
        for (String pattern : patterns) {
            if (parser == null) {
                parser = locale != null ? new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(locale)) : new DecimalFormat(pattern);
            } else {
                parser.applyPattern(pattern);
            }
            if (ArrayUtils.isEmpty(currencyCodes)) {
                pos.setIndex(0);
                Number number = parser.parse(source, pos);
                if (number == null) continue;
                return number;
            }
            for (String currencyCode : currencyCodes) {
                parser.setCurrency(Currency.getInstance(currencyCode));
                pos.setIndex(0);
                Number number = parser.parse(source, pos);
                if (number == null) continue;
                return number;
            }
        }
        throw new ParseException("Unable to parse the number: " + source, -1);
    }

    public static String format(Number number, String pattern) {
        return NumberFormatUtils.format(number, pattern, null, null);
    }

    public static String format(Number number, String pattern, Locale locale) {
        return NumberFormatUtils.format(number, pattern, locale, null);
    }

    public static String format(Number number, String pattern, Locale locale, String currencyCode) {
        Assert.notNull(number, "Number must not be null");
        Assert.notNull(pattern, "Pattern must not be null");
        DecimalFormat formatter = locale != null ? new DecimalFormat(pattern, DecimalFormatSymbols.getInstance(locale)) : new DecimalFormat(pattern);
        if (currencyCode != null && !currencyCode.isEmpty()) {
            formatter.setCurrency(Currency.getInstance(currencyCode));
        }
        return formatter.format(number);
    }
}

