/*
 * Decompiled with CFR 0.152.
 */
package jp.sf.orangesignal.chart.ui.canvas;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Date;
import jp.sf.orangesignal.chart.ChartColor;
import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.axis.DateAxis;
import jp.sf.orangesignal.chart.axis.IntervalMarker;
import jp.sf.orangesignal.chart.axis.NumberAxis;
import jp.sf.orangesignal.chart.axis.Orientation;
import jp.sf.orangesignal.chart.axis.Range;
import jp.sf.orangesignal.chart.axis.ValueMarker;
import jp.sf.orangesignal.chart.data.TimeSeriesChartDataset;
import jp.sf.orangesignal.chart.data.VolumePriceHistogram;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.ui.BandType;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.ui.PriceChartType;
import jp.sf.orangesignal.chart.ui.UpDownColorType;
import jp.sf.orangesignal.chart.ui.VolumeType;
import jp.sf.orangesignal.chart.ui.canvas.AbstractChartCanvas;
import jp.sf.orangesignal.chart.ui.screen.ChartScreen;
import jp.sf.orangesignal.chart.util.DrawUtils;
import jp.sf.orangesignal.chart.util.StringManager;
import jp.sf.orangesignal.ta.result.Step;
import jp.sf.orangesignal.ta.util.DateArrayUtils;

public class TimeSeriesChartCanvas
extends AbstractChartCanvas {
    private static final long serialVersionUID = 2873840209510087160L;
    private final DateAxis dateAxis = new DateAxis();
    private Rectangle2D chartArea;
    private static final int PRICE = 0;
    private static final int VOLUME = 1;
    private static final int AROON_INDICATOR = 2;
    private static final int AROON_OSCILLATOR = 3;
    private static final int ATR = 4;
    private static final int NATR = 5;
    private static final int BOP = 6;
    private static final int CHV = 7;
    private static final int CCI = 8;
    private static final int CMF = 9;
    private static final int CMO = 10;
    private static final int COPPOCK = 11;
    private static final int DPO = 12;
    private static final int DMI = 13;
    private static final int EMV = 14;
    private static final int HV = 15;
    private static final int KAIRI = 16;
    private static final int MI = 17;
    private static final int MOM = 18;
    private static final int MFI = 19;
    private static final int MACD = 20;
    private static final int PAIN = 21;
    private static final int PCR = 22;
    private static final int APO = 23;
    private static final int PPO = 24;
    private static final int PSY = 25;
    private static final int QSTICK = 26;
    private static final int RCI = 27;
    private static final int ROC = 28;
    private static final int RSI = 29;
    private static final int RVI = 30;
    private static final int SHINOHARA = 31;
    private static final int SRV_FAST = 32;
    private static final int TII = 33;
    private static final int TRIX = 34;
    private static final int TSI = 35;
    private static final int ULTIMATE = 36;
    private static final int WAD = 37;
    private static final int WR = 38;
    private static final int AD = 39;
    private static final int CHO = 40;
    private static final int AVO = 41;
    private static final int PVO = 42;
    private static final int VKAIRI = 43;
    private static final int VR1 = 44;
    private static final int VR2 = 45;
    private static final int VROC = 46;
    private static final int VRSI = 47;
    private static final int WVR = 48;
    private static final int PVI = 49;
    private static final int NVI = 50;
    private static final int OBV = 51;
    private static final int PVT = 52;
    private static final int RATIO = 53;
    private static final int PRICE_PERFORMANCE = 54;
    private static final int PERCENT_PERFORMANCE = 55;
    private final NumberAxis[] axes = new NumberAxis[56];
    private final Rectangle2D[] areas = new Rectangle2D[56];
    private String priceDescription;
    private String volumeDescription;
    private final NumberAxis vpPriceAxis = new NumberAxis();
    private final NumberAxis vpVolumeAxis = new NumberAxis();
    private Rectangle2D vpArea;
    private Number[] vp;
    private Point mousePosition;
    private int datePosition = -1;
    private Rectangle2D traceArea;
    private NumberAxis traceAxis;
    private final ChartScreen parent;
    private final Image splitIcon;
    private TimeSeriesChartDataset dataset;
    private int start;
    private int period;
    private ChartSettings settings;
    private static final int MARGIN = 6;
    private static final double ITEM_WIDTH_FACTOR = 0.6428571428571429;
    private double periodWidth;
    private double itemWidth;
    private Image screenCache;
    private static final Color LINE_COLOR = ChartColor.BLUE;
    private static final Composite COMPOSITE = AlphaComposite.getInstance(3, 0.5f);
    private int vpLower;
    private int vpStep;

    public TimeSeriesChartCanvas(Icons icons, ChartScreen parent) {
        this.parent = parent;
        this.splitIcon = icons.getSplit().getImage();
        for (int i = 0; i < this.axes.length; ++i) {
            this.axes[i] = new NumberAxis();
        }
        this.axes[0].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[0].setUpperPadding(0.05);
        this.axes[0].setLowerPadding(0.05);
        this.vpPriceAxis.setRangeType(NumberAxis.RangeType.POSITIVE);
        this.vpVolumeAxis.setOrientation(Orientation.HORIZONTAL);
        this.vpVolumeAxis.setRangeType(NumberAxis.RangeType.POSITIVE);
        this.vpVolumeAxis.setUpperPadding(0.05);
        this.vpVolumeAxis.setFixedLower(0.0);
        this.vpVolumeAxis.setGap(1.5);
        this.axes[1].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[1].setFixedLower(0.0);
        this.axes[1].setUpperPadding(0.05);
        this.axes[2].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[2].setFixedUpper(100.0);
        this.axes[2].setFixedLower(0.0);
        this.axes[2].addMarker(new ValueMarker(30.0, Color.BLACK));
        this.axes[2].addMarker(new ValueMarker(70.0, Color.BLACK));
        this.axes[3].setFixedUpper(100.0);
        this.axes[3].setFixedLower(-100.0);
        this.axes[3].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[4].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[4].setUpperPadding(0.05);
        this.axes[4].setLowerPadding(0.05);
        this.axes[5].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[5].setUpperPadding(0.05);
        this.axes[5].setLowerPadding(0.05);
        this.axes[6].setFixedUpper(100.0);
        this.axes[6].setFixedLower(-100.0);
        this.axes[6].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[7].setUpperPadding(0.05);
        this.axes[7].setLowerPadding(0.05);
        this.axes[7].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[8].setUpperPadding(0.05);
        this.axes[8].setLowerPadding(0.05);
        this.axes[8].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[9].setUpperPadding(0.05);
        this.axes[9].setLowerPadding(0.05);
        this.axes[9].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[10].setUpperPadding(0.05);
        this.axes[10].setLowerPadding(0.05);
        this.axes[10].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[11].setUpperPadding(0.05);
        this.axes[11].setLowerPadding(0.05);
        this.axes[11].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[12].setUpperPadding(0.05);
        this.axes[12].setLowerPadding(0.05);
        this.axes[12].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[13].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[13].setFixedUpper(100.0);
        this.axes[13].setFixedLower(0.0);
        this.axes[14].setUpperPadding(0.05);
        this.axes[14].setLowerPadding(0.05);
        this.axes[14].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[15].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[15].setUpperPadding(0.05);
        this.axes[15].setLowerPadding(0.05);
        this.axes[16].setUpperPadding(0.05);
        this.axes[16].setLowerPadding(0.05);
        this.axes[17].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[17].setUpperPadding(0.05);
        this.axes[17].setLowerPadding(0.05);
        this.axes[17].addMarker(new ValueMarker(26.5, Color.BLACK));
        this.axes[17].addMarker(new ValueMarker(27.0, Color.BLACK));
        this.axes[18].setUpperPadding(0.05);
        this.axes[18].setLowerPadding(0.05);
        this.axes[18].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[19].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[19].setFixedUpper(100.0);
        this.axes[19].setFixedLower(0.0);
        this.axes[20].setUpperPadding(0.05);
        this.axes[20].setLowerPadding(0.05);
        this.axes[20].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[21].setUpperPadding(0.05);
        this.axes[21].setLowerPadding(0.05);
        this.axes[21].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[22].setRangeType(NumberAxis.RangeType.NEGATIVE);
        this.axes[22].setFixedUpper(0.0);
        this.axes[22].setFixedLower(-100.0);
        this.axes[23].setUpperPadding(0.05);
        this.axes[23].setLowerPadding(0.05);
        this.axes[23].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[24].setUpperPadding(0.05);
        this.axes[24].setLowerPadding(0.05);
        this.axes[24].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[25].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[25].setFixedUpper(100.0);
        this.axes[25].setFixedLower(0.0);
        this.axes[26].setUpperPadding(0.05);
        this.axes[26].setLowerPadding(0.05);
        this.axes[26].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[27].setFixedUpper(100.0);
        this.axes[27].setFixedLower(-100.0);
        this.axes[27].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[28].setUpperPadding(0.05);
        this.axes[28].setLowerPadding(0.05);
        this.axes[28].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[29].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[29].setFixedUpper(100.0);
        this.axes[29].setFixedLower(0.0);
        this.axes[30].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[30].setFixedUpper(100.0);
        this.axes[30].setFixedLower(0.0);
        this.axes[30].addMarker(new ValueMarker(50.0, Color.BLACK));
        this.axes[31].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[31].setUpperPadding(0.05);
        this.axes[31].setLowerPadding(0.05);
        this.axes[31].addMarker(new ValueMarker(100.0, Color.BLACK));
        this.axes[32].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[32].setFixedUpper(100.0);
        this.axes[32].setFixedLower(0.0);
        this.axes[33].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[33].setFixedUpper(100.0);
        this.axes[33].setFixedLower(0.0);
        this.axes[33].addMarker(new ValueMarker(50.0, Color.BLACK));
        this.axes[34].setUpperPadding(0.05);
        this.axes[34].setLowerPadding(0.05);
        this.axes[34].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[35].setFixedUpper(100.0);
        this.axes[35].setFixedLower(-100.0);
        this.axes[35].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[36].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[36].setUpperPadding(0.05);
        this.axes[36].setLowerPadding(0.05);
        this.axes[37].setUpperPadding(0.05);
        this.axes[37].setLowerPadding(0.05);
        this.axes[38].setRangeType(NumberAxis.RangeType.NEGATIVE);
        this.axes[38].setFixedUpper(0.0);
        this.axes[38].setFixedLower(-100.0);
        this.axes[39].setUpperPadding(0.05);
        this.axes[39].setLowerPadding(0.05);
        this.axes[40].setUpperPadding(0.05);
        this.axes[40].setLowerPadding(0.05);
        this.axes[41].setUpperPadding(0.05);
        this.axes[41].setLowerPadding(0.05);
        this.axes[41].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[42].setUpperPadding(0.05);
        this.axes[42].setLowerPadding(0.05);
        this.axes[42].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[43].setUpperPadding(0.05);
        this.axes[43].setLowerPadding(0.05);
        this.axes[44].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[44].setUpperPadding(0.05);
        this.axes[44].setLowerPadding(0.05);
        this.axes[45].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[45].setFixedUpper(100.0);
        this.axes[45].setFixedLower(0.0);
        this.axes[45].addMarker(new ValueMarker(50.0, Color.BLACK));
        this.axes[46].setUpperPadding(0.05);
        this.axes[46].setLowerPadding(0.05);
        this.axes[46].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[47].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[47].setFixedUpper(100.0);
        this.axes[47].setFixedLower(0.0);
        this.axes[48].setFixedUpper(100.0);
        this.axes[48].setFixedLower(-100.0);
        this.axes[48].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[49].setUpperPadding(0.05);
        this.axes[49].setLowerPadding(0.05);
        this.axes[49].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[50].setUpperPadding(0.05);
        this.axes[50].setLowerPadding(0.05);
        this.axes[50].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.axes[51].setUpperPadding(0.05);
        this.axes[51].setLowerPadding(0.05);
        this.axes[52].setUpperPadding(0.05);
        this.axes[52].setLowerPadding(0.05);
        this.axes[53].setRangeType(NumberAxis.RangeType.POSITIVE);
        this.axes[53].setUpperPadding(0.05);
        this.axes[53].setLowerPadding(0.05);
        this.axes[54].setUpperPadding(0.05);
        this.axes[54].setLowerPadding(0.05);
        this.axes[55].setUpperPadding(0.05);
        this.axes[55].setLowerPadding(0.05);
        this.axes[55].addMarker(new ValueMarker(0.0, Color.BLACK));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                TimeSeriesChartCanvas.this.processPosition(null);
                TimeSeriesChartCanvas.this.repaint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                TimeSeriesChartCanvas.this.processPosition(new Point(e.getX(), e.getY()));
                TimeSeriesChartCanvas.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TimeSeriesChartCanvas.this.processLayout();
            }
        });
    }

    private void processPosition(Point point) {
        this.mousePosition = null;
        this.datePosition = this.start + this.period - 1;
        this.traceAxis = null;
        this.traceArea = null;
        if (point != null) {
            if (this.vpArea != null && this.vpArea.contains(point)) {
                this.mousePosition = point;
                this.traceAxis = this.vpVolumeAxis;
                this.traceArea = this.vpArea;
            } else {
                for (int i = 0; i < this.areas.length; ++i) {
                    Rectangle2D area = this.areas[i];
                    if (area == null || !area.contains(point)) continue;
                    this.mousePosition = point;
                    this.datePosition = this.start + Math.min((int)Math.floor(((double)point.x - area.getMinX()) / this.periodWidth), this.period - 1);
                    this.traceAxis = this.axes[i];
                    this.traceArea = area;
                    break;
                }
            }
        }
        this.parent.sendPositionChanged(new ChartScreenEvent(this, this.mousePosition, this.start, this.period, this.datePosition, this.getVolumePriceHistogram(point)));
    }

    private VolumePriceHistogram getVolumePriceHistogram(Point point) {
        int n;
        if (this.vpArea == null) {
            return null;
        }
        VolumePriceHistogram vph = new VolumePriceHistogram();
        if (point != null && (this.vpArea.contains(point) || this.areas[0].contains(point)) && (n = (int)Math.ceil((this.axes[0].java2DToValue(point.y, this.areas[0]) - (double)this.vpLower) / (double)this.vpStep)) >= 0 && n < this.vp.length) {
            vph.upper = this.vpLower + n * this.vpStep;
            vph.lower = this.vpLower + (n - 1) * this.vpStep;
            vph.volume = this.vp[n];
        }
        return vph;
    }

    public void processLayout() {
        int basePlotWidth;
        ChartSettings.TimeSeriesSettings settings = this.settings.timeSeries;
        int count = 1;
        if (settings.volumeType != VolumeType.NONE) {
            ++count;
        }
        if (settings.aroon) {
            count += 2;
        }
        if (settings.atr) {
            ++count;
        }
        if (settings.natr) {
            ++count;
        }
        if (settings.bop) {
            ++count;
        }
        if (settings.chv) {
            ++count;
        }
        if (settings.cci) {
            ++count;
        }
        if (settings.cmf) {
            ++count;
        }
        if (settings.cmo) {
            ++count;
        }
        if (settings.coppock) {
            ++count;
        }
        if (settings.dpo) {
            ++count;
        }
        if (settings.dmi) {
            ++count;
        }
        if (settings.emv) {
            ++count;
        }
        if (settings.hv) {
            ++count;
        }
        if (settings.kairi) {
            ++count;
        }
        if (settings.mi) {
            ++count;
        }
        if (settings.mom) {
            ++count;
        }
        if (settings.mfi) {
            ++count;
        }
        if (settings.macd) {
            ++count;
        }
        if (settings.pain) {
            ++count;
        }
        if (settings.pcr) {
            ++count;
        }
        if (settings.apo) {
            ++count;
        }
        if (settings.ppo) {
            ++count;
        }
        if (settings.psy) {
            ++count;
        }
        if (settings.qstick) {
            ++count;
        }
        if (settings.rci) {
            ++count;
        }
        if (settings.roc) {
            ++count;
        }
        if (settings.rsi) {
            ++count;
        }
        if (settings.rvi) {
            ++count;
        }
        if (settings.shinohara) {
            ++count;
        }
        if (settings.srv) {
            ++count;
        }
        if (settings.tii) {
            ++count;
        }
        if (settings.trix) {
            ++count;
        }
        if (settings.tsi) {
            ++count;
        }
        if (settings.ultimate) {
            ++count;
        }
        if (settings.wvr) {
            ++count;
        }
        if (settings.wad) {
            ++count;
        }
        if (settings.williamsR) {
            ++count;
        }
        if (settings.ad) {
            ++count;
        }
        if (settings.cho) {
            ++count;
        }
        if (settings.avo) {
            ++count;
        }
        if (settings.pvo) {
            ++count;
        }
        if (settings.vkairi) {
            ++count;
        }
        if (settings.vr1) {
            ++count;
        }
        if (settings.vr2) {
            ++count;
        }
        if (settings.vroc) {
            ++count;
        }
        if (settings.vrsi) {
            ++count;
        }
        if (settings.pvi) {
            ++count;
        }
        if (settings.nvi) {
            ++count;
        }
        if (settings.obv) {
            ++count;
        }
        if (settings.pvt) {
            ++count;
        }
        if (settings.ratio) {
            ++count;
        }
        if (settings.price_performance) {
            ++count;
        }
        if (settings.percent_performance) {
            ++count;
        }
        Graphics2D g2 = (Graphics2D)this.getGraphics();
        int axisWidth = this.axes[0].getSpace(g2);
        int axisHeight = this.dateAxis.getSpace(g2);
        int x = 6 + axisWidth;
        int plotWidth = basePlotWidth = this.getWidth() - x - 6;
        int plotHeight = this.getHeight() - axisHeight;
        FontMetrics fm = g2.getFontMetrics(NumberAxis.FONT);
        double marginHeight = (double)fm.getAscent() * 0.5 + (double)fm.getDescent();
        this.chartArea = new Rectangle2D.Double(x, marginHeight, plotWidth, (double)plotHeight - marginHeight);
        double chartHeight = Math.min((double)(plotHeight / count), (double)plotHeight * 0.2);
        double vpWidth = settings.vp ? this.chartArea.getWidth() * 0.2 : 0.0;
        double _x = this.chartArea.getMinX();
        double _width = this.chartArea.getWidth() - vpWidth;
        double _height = chartHeight - marginHeight;
        double y = this.initChartArea(0, true, _x, 0.0, _width, (double)plotHeight - chartHeight * (double)(count - 1) - marginHeight, marginHeight);
        this.vpArea = settings.vp ? new Rectangle2D.Double(this.areas[0].getMaxX() + 4.0, this.areas[0].getMinY(), vpWidth - 4.0, this.areas[0].getHeight()) : null;
        y = this.initChartArea(1, settings.volumeType != VolumeType.NONE, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(2, settings.aroon, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(3, settings.aroon, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(4, settings.atr, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(5, settings.natr, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(6, settings.bop, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(7, settings.chv, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(8, settings.cci, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(9, settings.cmf, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(10, settings.cmo, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(11, settings.coppock, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(12, settings.dpo, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(13, settings.dmi, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(14, settings.emv, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(15, settings.hv, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(16, settings.kairi, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(17, settings.mi, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(18, settings.mom, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(19, settings.mfi, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(20, settings.macd, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(21, settings.pain, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(22, settings.pcr, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(23, settings.apo, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(24, settings.ppo, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(25, settings.psy, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(26, settings.qstick, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(27, settings.rci, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(28, settings.roc, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(29, settings.rsi, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(30, settings.rvi, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(31, settings.shinohara, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(32, settings.srv, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(33, settings.tii, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(34, settings.trix, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(35, settings.tsi, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(36, settings.ultimate, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(37, settings.wad, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(38, settings.williamsR, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(39, settings.ad, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(40, settings.cho, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(41, settings.avo, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(42, settings.pvo, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(43, settings.vkairi, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(44, settings.vr1, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(45, settings.vr2, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(46, settings.vroc, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(47, settings.vrsi, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(48, settings.wvr, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(49, settings.pvi, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(50, settings.nvi, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(51, settings.obv, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(52, settings.pvt, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(53, settings.ratio, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(54, settings.price_performance, _x, y, _width, _height, marginHeight);
        y = this.initChartArea(55, settings.percent_performance, _x, y, _width, _height, marginHeight);
        if (this.dataset != null) {
            this.dateAxis.refreshTicks(g2, this.areas[0]);
        }
        for (int i = 0; i < this.areas.length; ++i) {
            if (this.areas[i] == null) continue;
            this.axes[i].refreshTicks(g2, this.areas[i]);
        }
        this.periodWidth = (this.areas[0].getWidth() - 1.0) / (double)this.period;
        this.itemWidth = this.periodWidth * 0.6428571428571429;
        this.screenCache = null;
    }

    private double initChartArea(int index, boolean setup, double x, double y, double width, double height, double marginTop) {
        if (setup) {
            this.areas[index] = new Rectangle2D.Double(x, y + marginTop, width, height);
            return this.areas[index].getMaxY();
        }
        this.areas[index] = null;
        return y;
    }

    @Override
    public void switchDataset(ChartEvent e) {
        this.dataset = (TimeSeriesChartDataset)e.getDataset();
        if (!e.isIgnoreStart()) {
            this.start = e.getStart();
        }
        this.period = e.getPeriod();
        this.settings = e.getSettings();
        this.dateAxis.prepare(e.getType(), this.period);
        ChartSettings.TimeSeriesSettings settings = this.settings.timeSeries;
        if (settings.fixed) {
            this.axes[0].setFixedLower(0.0);
        } else {
            this.axes[0].setFixedLower(null);
        }
        this.axes[0].setScale(settings.scale);
        StringBuilder description = new StringBuilder();
        TimeSeriesChartCanvas.addDescription(description, settings.chartType.toString());
        if (settings.avgprice) {
            TimeSeriesChartCanvas.addDescription(description, StringManager.getString("avgprice", new Object[0]));
        }
        if (settings.mp) {
            TimeSeriesChartCanvas.addDescription(description, StringManager.getString("mp", new Object[0]));
        }
        if (settings.tp) {
            TimeSeriesChartCanvas.addDescription(description, StringManager.getString("tp", new Object[0]));
        }
        if (settings.wc) {
            TimeSeriesChartCanvas.addDescription(description, StringManager.getString("wc", new Object[0]));
        }
        if (settings.ma) {
            TimeSeriesChartCanvas.addDescription(description, StringManager.getString("ma", new Object[0]));
        }
        if (settings.bandType != BandType.NONE) {
            TimeSeriesChartCanvas.addDescription(description, settings.bandType.getLabel());
        }
        this.priceDescription = description.toString();
        description = new StringBuilder();
        TimeSeriesChartCanvas.addDescription(description, settings.volumeType.toString());
        this.volumeDescription = description.toString();
        for (NumberAxis axis : this.axes) {
            axis.removeIntervalMarkers();
        }
        if (settings.signalMarker) {
            this.axes[16].addMarker(new ValueMarker(0.0, Color.BLACK));
            this.axes[16].addMarker(new IntervalMarker(null, settings.biasUpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[16].addMarker(new IntervalMarker(settings.biasLowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[8].addMarker(new IntervalMarker(null, settings.cciUpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[8].addMarker(new IntervalMarker(settings.cciLowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[10].addMarker(new IntervalMarker(null, settings.cmo_upper_signal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[10].addMarker(new IntervalMarker(settings.cmo_lower_signal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[19].addMarker(new IntervalMarker(null, settings.mfiUpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[19].addMarker(new IntervalMarker(settings.mfiLowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[22].addMarker(new IntervalMarker(null, settings.pcr_upper_signal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[22].addMarker(new IntervalMarker(settings.pcr_lower_signal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[25].addMarker(new IntervalMarker(null, settings.psy_upper_signal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[25].addMarker(new IntervalMarker(settings.psy_lower_signal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[29].addMarker(new IntervalMarker(null, settings.rsiUpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[29].addMarker(new IntervalMarker(settings.rsiLowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[30].addMarker(new IntervalMarker(null, settings.rvi_upper_signal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[30].addMarker(new IntervalMarker(settings.rvi_lower_signal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[27].addMarker(new IntervalMarker(null, settings.rciUpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[27].addMarker(new IntervalMarker(settings.rciLowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[32].addMarker(new IntervalMarker(null, settings.srvUpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[32].addMarker(new IntervalMarker(settings.srvLowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[33].addMarker(new IntervalMarker(null, settings.tii_upper_signal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[33].addMarker(new IntervalMarker(settings.tii_lower_signal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[35].addMarker(new IntervalMarker(null, settings.tsi_upper_signal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[35].addMarker(new IntervalMarker(settings.tsi_lower_signal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[38].addMarker(new IntervalMarker(null, settings.williamsRUpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[38].addMarker(new IntervalMarker(settings.williamsRLowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[43].addMarker(new ValueMarker(0.0, Color.BLACK));
            this.axes[44].addMarker(new IntervalMarker(null, settings.vr1UpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[44].addMarker(new IntervalMarker(settings.vr1LowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[45].addMarker(new IntervalMarker(null, settings.vr2UpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[45].addMarker(new IntervalMarker(settings.vr2LowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[47].addMarker(new IntervalMarker(null, settings.vrsiUpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[47].addMarker(new IntervalMarker(settings.vrsiLowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[48].addMarker(new IntervalMarker(null, settings.wvrUpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[48].addMarker(new IntervalMarker(settings.wvrLowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
            this.axes[53].addMarker(new IntervalMarker(null, settings.ratioUpperSignal, ChartColor.VERY_LIGHT_GRAY));
            this.axes[53].addMarker(new IntervalMarker(settings.ratioLowerSignal, null, ChartColor.VERY_LIGHT_GRAY));
        }
        if (this.dataset != null) {
            this.axes[0].prepare(new Number[][]{this.dataset.techHigh, this.dataset.techLow, this.dataset.ma1, this.dataset.ma2, this.dataset.lr1_upper2, this.dataset.lr1_lower2, this.dataset.lr2_upper2, this.dataset.lr2_lower2, this.dataset.zigzag, this.dataset.donchian_upper, this.dataset.donchian_lower, this.dataset.hma, this.dataset.lma, this.dataset.envelope_upper2, this.dataset.envelope_lower2, this.dataset.bb_upper2, this.dataset.bb_lower2, this.dataset.pivot_hbop, this.dataset.pivot_lbop, this.dataset.vi_upper, this.dataset.vi_lower, this.dataset.sar, this.dataset.kijun, this.dataset.tenkan, this.dataset.senkou1, this.dataset.senkou2, this.dataset.chikou, this.dataset.mama, this.dataset.fama, this.dataset.vidya});
            this.vpPriceAxis.prepare(new Number[][]{this.dataset.high, this.dataset.low, this.dataset.close});
            if (this.dataset.volume != null || this.dataset.sold != null || this.dataset.bought != null || this.dataset.vma1 != null || this.dataset.vma2 != null) {
                this.axes[1].prepare(new Number[][]{settings.volumeType != VolumeType.NONE ? this.dataset.volume : null, settings.volumeType == VolumeType.MARGIN ? this.dataset.sold : null, settings.volumeType == VolumeType.MARGIN ? this.dataset.bought : null, this.dataset.vma1, this.dataset.vma2});
            }
            if (this.dataset.atr != null) {
                this.axes[4].prepare(new Number[][]{this.dataset.atr});
            }
            if (this.dataset.natr != null) {
                this.axes[5].prepare(new Number[][]{this.dataset.natr});
            }
            if (this.dataset.chv != null) {
                this.axes[7].prepare(new Number[][]{this.dataset.chv});
            }
            if (this.dataset.cci != null) {
                this.axes[8].prepare(new Number[][]{this.dataset.cci});
            }
            if (this.dataset.cmf != null) {
                this.axes[9].prepare(new Number[][]{this.dataset.cmf});
            }
            if (this.dataset.cmo != null) {
                this.axes[10].prepare(new Number[][]{this.dataset.cmo});
            }
            if (this.dataset.coppock != null) {
                this.axes[11].prepare(new Number[][]{this.dataset.coppock});
            }
            if (this.dataset.dpo != null) {
                this.axes[12].prepare(new Number[][]{this.dataset.dpo});
            }
            if (this.dataset.pdi != null || this.dataset.mdi != null || this.dataset.adx != null) {
                this.axes[13].prepare(new Number[][]{this.dataset.pdi, this.dataset.mdi, this.dataset.adx});
            }
            if (this.dataset.emv != null) {
                this.axes[14].prepare(new Number[][]{this.dataset.emv});
            }
            if (this.dataset.hv != null) {
                this.axes[15].prepare(new Number[][]{this.dataset.hv});
            }
            if (this.dataset.kairi != null) {
                this.axes[16].prepare(new Number[][]{this.dataset.kairi});
            }
            if (this.dataset.mi != null) {
                this.axes[17].prepare(new Number[][]{this.dataset.mi});
            }
            if (this.dataset.mom != null) {
                this.axes[18].prepare(new Number[][]{this.dataset.mom});
            }
            if (this.dataset.pain != null) {
                this.axes[21].prepare(new Number[][]{this.dataset.pain});
            }
            if (this.dataset.macd != null || this.dataset.macdSignal != null) {
                this.axes[20].prepare(new Number[][]{this.dataset.macd, this.dataset.macdSignal, this.dataset.macdHistogram});
            }
            if (this.dataset.apo != null) {
                this.axes[23].prepare(new Number[][]{this.dataset.apo});
            }
            if (this.dataset.ppo != null) {
                this.axes[24].prepare(new Number[][]{this.dataset.ppo});
            }
            if (this.dataset.qstick != null) {
                this.axes[26].prepare(new Number[][]{this.dataset.qstick});
            }
            if (this.dataset.roc != null) {
                this.axes[28].prepare(new Number[][]{this.dataset.roc});
            }
            if (this.dataset.shinohara_a != null || this.dataset.shinohara_b != null) {
                this.axes[31].prepare(new Number[][]{this.dataset.shinohara_a, this.dataset.shinohara_b});
            }
            if (this.dataset.trix != null || this.dataset.trixSignal != null) {
                this.axes[34].prepare(new Number[][]{this.dataset.trix, this.dataset.trixSignal});
            }
            if (this.dataset.wad != null) {
                this.axes[37].prepare(new Number[][]{this.dataset.wad});
            }
            if (this.dataset.ultimate != null) {
                this.axes[36].prepare(new Number[][]{this.dataset.ultimate});
            }
            if (this.dataset.ad != null) {
                this.axes[39].prepare(new Number[][]{this.dataset.ad});
            }
            if (this.dataset.cho != null) {
                this.axes[40].prepare(new Number[][]{this.dataset.cho});
            }
            if (this.dataset.vkairi != null) {
                this.axes[43].prepare(new Number[][]{this.dataset.vkairi});
            }
            if (this.dataset.avo != null) {
                this.axes[41].prepare(new Number[][]{this.dataset.avo});
            }
            if (this.dataset.pvo != null) {
                this.axes[42].prepare(new Number[][]{this.dataset.pvo});
            }
            if (this.dataset.vroc != null) {
                this.axes[46].prepare(new Number[][]{this.dataset.vroc});
            }
            if (this.dataset.vr1 != null) {
                this.axes[44].prepare(new Number[][]{this.dataset.vr1});
            }
            if (this.dataset.pvi != null) {
                this.axes[49].prepare(new Number[][]{this.dataset.pvi, this.dataset.pvi_ma1, this.dataset.pvi_ma2});
            }
            if (this.dataset.nvi != null) {
                this.axes[50].prepare(new Number[][]{this.dataset.nvi, this.dataset.nvi_ma1, this.dataset.nvi_ma2});
            }
            if (this.dataset.obv != null) {
                this.axes[51].prepare(new Number[][]{this.dataset.obv});
            }
            if (this.dataset.pvt != null) {
                this.axes[52].prepare(new Number[][]{this.dataset.pvt});
            }
            if (this.dataset.ratio != null) {
                this.axes[53].prepare(new Number[][]{this.dataset.ratio});
            }
            if (this.dataset.price_performance != null) {
                this.axes[54].prepare(new Number[][]{this.dataset.price_performance});
            }
            if (this.dataset.percent_performance != null) {
                this.axes[55].prepare(new Number[][]{this.dataset.percent_performance});
            }
        }
        this.processLayout();
        this.update();
    }

    private void adjustTicks() {
        if (this.dataset != null) {
            for (int i = 0; i < this.areas.length; ++i) {
                if (this.areas[i] == null) continue;
                NumberAxis axis = this.axes[i];
                axis.autoAdjustRange(this.start, this.period);
                axis.refreshTicks();
            }
            if (this.vpArea != null) {
                this.vpPriceAxis.autoAdjustRange(this.start, this.period);
                this.calculateVolumePriceHistogram();
                this.vpVolumeAxis.refreshTicks();
            }
        }
    }

    @Override
    public void setStart(int start) {
        this.start = start;
        this.update();
    }

    private void update() {
        this.adjustTicks();
        this.processPosition(null);
        this.screenCache = null;
        this.repaint();
    }

    @Override
    public void draw(Graphics2D g2) {
        if (this.screenCache == null) {
            this.screenCache = this.createImage();
        }
        g2.drawImage(this.screenCache, 0, 0, this);
        if (this.settings.trace) {
            this.drawAxisTrace(g2);
        }
    }

    private Image createImage() {
        Image image = this.createImage(this.getWidth(), this.getHeight());
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        this.setRenderingHints(g2);
        for (int i = 0; i < this.areas.length; ++i) {
            if (this.areas[i] == null) continue;
            this.axes[i].draw(g2, this.areas[i]);
        }
        if (this.vpArea != null) {
            this.vpVolumeAxis.draw(g2, this.vpArea);
            this.axes[0].drawGlidline(g2, this.vpArea);
        }
        this.dateAxis.draw(g2, this.chartArea, this.areas, this.periodWidth, this.dataset == null ? null : this.dataset.date, this.start, this.period);
        if (this.dataset != null) {
            this.drawChart(g2);
        }
        g2.dispose();
        return image;
    }

    private void drawAxisTrace(Graphics2D g2) {
        if (this.mousePosition != null) {
            Rectangle2D priceArea = this.areas[0];
            if (this.traceArea.equals(this.vpArea)) {
                this.vpVolumeAxis.drawAxisTrace(g2, this.vpArea, this.mousePosition.x, 2);
            } else if (this.dataset != null) {
                double x = priceArea.getMinX() + (double)(this.datePosition - this.start) * this.periodWidth + this.periodWidth * 0.5;
                this.dateAxis.drawAxisTrace(g2, this.chartArea, x, 2, this.dataset.date[this.datePosition]);
            }
            if (this.vpArea != null && (this.traceArea.equals(this.vpArea) || this.traceArea.equals(this.areas[0]))) {
                this.axes[0].drawAxisTrace(g2, new Rectangle2D.Double(priceArea.getMinX(), priceArea.getMinY(), this.vpArea.getMaxX() - priceArea.getMinX(), priceArea.getHeight()), this.mousePosition.y, 2);
            } else {
                this.traceAxis.drawAxisTrace(g2, this.traceArea, this.mousePosition.y, 2);
            }
        }
    }

    private void drawChart(Graphics2D g2) {
        NumberAxis axis;
        Rectangle2D area;
        int i;
        NumberAxis priceAxis;
        Rectangle2D priceArea;
        Shape saved = g2.getClip();
        ChartSettings.TimeSeriesSettings settings = this.settings.timeSeries;
        if (this.areas[0] != null) {
            priceArea = this.areas[0];
            priceAxis = this.axes[0];
            g2.setClip(priceArea);
            if (this.dataset.senkou1 != null && this.dataset.senkou2 != null) {
                this.drawDifference(g2, priceArea, priceAxis, this.dataset.senkou1, this.dataset.senkou2, ChartColor.VERY_LIGHT_GRAY, ChartColor.GRAY, ChartColor.WHITE, ChartColor.LIGHT_GRAY);
            }
            if (settings.signalMarker) {
                if (settings.bullishLongWhiteDay) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishLongWhiteDay);
                }
                if (settings.bullishBeltHold) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishBeltHold);
                }
                if (settings.bullishHammer) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishHammer);
                }
                if (settings.bullishDragonflyDoji) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishDragonflyDoji);
                }
                if (settings.bullishLongLeggedDoji) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishLongLeggedDoji);
                }
                if (settings.bullishInvertedHammer) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishInvertedHammer);
                }
                if (settings.bullishHarami) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishHarami);
                }
                if (settings.bullishHaramiCross) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishHaramiCross);
                }
                if (settings.bullishEngulfing) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishEngulfing);
                }
                if (settings.bullishGravestoneDoji) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishGravestoneDoji);
                }
                if (settings.bullishMeetingLines) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishMeetingLines);
                }
                if (settings.bullishDojiStar) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishDojiStar);
                }
                if (settings.bullishHomingPigeon) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishHomingPigeon);
                }
                if (settings.bullishMatchingLow) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishMatchingLow);
                }
                if (settings.bullishTweezerBottom) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishTweezerBottom);
                }
                if (settings.bullishKicking) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishKicking);
                }
                if (settings.bullishPiercingLine) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishPiercingLine);
                }
                if (settings.bullishSeparatingLines) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishSeparatingLines);
                }
                if (settings.bullishTriStar) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishTriStar);
                }
                if (settings.bullishThreeStarsInTheSouth) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishThreeStarsInTheSouth);
                }
                if (settings.bullishUniqueThreeRiverBottom) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishUniqueThreeRiverBottom);
                }
                if (settings.bullishStickSandwich) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishStickSandwich);
                }
                if (settings.bullishAbandonedBaby) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishAbandonedBaby);
                }
                if (settings.bullishMorningDojiStar) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishMorningDojiStar);
                }
                if (settings.bullishMorningStar) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishMorningStar);
                }
                if (settings.bullishThreeOutsideUp) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishThreeOutsideUp);
                }
                if (settings.bullishThreeInsideUp) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishThreeInsideUp);
                }
                if (settings.bullishThreeWhiteSoldiers) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishThreeWhiteSoldiers);
                }
                if (settings.bullishUpsideTasukiGap) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishUpsideTasukiGap);
                }
                if (settings.bullishUpsideGapThreeMethods) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishUpsideGapThreeMethods);
                }
                if (settings.bullishSideBySideWhiteLines) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishSideBySideWhiteLines);
                }
                if (settings.bullishConcealingBabySwallow) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishConcealingBabySwallow);
                }
                if (settings.bullishThreeLineStrike) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishThreeLineStrike);
                }
                if (settings.bullishThreeGaps) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishThreeGaps);
                }
                if (settings.bullishBreakaway) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishBreakaway);
                }
                if (settings.bullishLadderBottom) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishLadderBottom);
                }
                if (settings.bullishRisingThreeMethods) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishRisingThreeMethods);
                }
                if (settings.bullishMatHold) {
                    this.drawSignal(g2, CandlePattern.BULLISH, this.dataset.bullishMatHold);
                }
                if (settings.bearishLongBlackDay) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishLongBlackDay);
                }
                if (settings.bearishBeltHold) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishBeltHold);
                }
                if (settings.bearishHangingMan) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishHangingMan);
                }
                if (settings.bearishDragonflyDoji) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishDragonflyDoji);
                }
                if (settings.bearishLongLeggedDoji) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishLongLeggedDoji);
                }
                if (settings.bearishShootingStar) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishShootingStar);
                }
                if (settings.bearishHarami) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishHarami);
                }
                if (settings.bearishHaramiCross) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishHaramiCross);
                }
                if (settings.bearishEngulfing) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishEngulfing);
                }
                if (settings.bearishGravestoneDoji) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishGravestoneDoji);
                }
                if (settings.bearishMeetingLines) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishMeetingLines);
                }
                if (settings.bearishDojiStar) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishDojiStar);
                }
                if (settings.bearishDescendingHawk) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishDescendingHawk);
                }
                if (settings.bearishMatchingHigh) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishMatchingHigh);
                }
                if (settings.bearishTweezerTop) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishTweezerTop);
                }
                if (settings.bearishKicking) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishKicking);
                }
                if (settings.bearishDarkCloudCover) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishDarkCloudCover);
                }
                if (settings.bearishSeparatingLines) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishSeparatingLines);
                }
                if (settings.bearishThrusting) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishThrusting);
                }
                if (settings.bearishOnNeck) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishOnNeck);
                }
                if (settings.bearishInNeck) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishInNeck);
                }
                if (settings.bearishTriStar) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishTriStar);
                }
                if (settings.bearishTwoCrows) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishTwoCrows);
                }
                if (settings.bearishAdvanceBlock) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishAdvanceBlock);
                }
                if (settings.bearishDeliberation) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishDeliberation);
                }
                if (settings.bearishAbandonedBaby) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishAbandonedBaby);
                }
                if (settings.bearishEveningDojiStar) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishEveningDojiStar);
                }
                if (settings.bearishEveningStar) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishEveningStar);
                }
                if (settings.bearishThreeOutsideDown) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishThreeOutsideDown);
                }
                if (settings.bearishThreeInsideDown) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishThreeInsideDown);
                }
                if (settings.bearishUpsideGapTwoCrows) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishUpsideGapTwoCrows);
                }
                if (settings.bearishThreeBlackCrows) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishThreeBlackCrows);
                }
                if (settings.bearishIdenticalThreeCrows) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishIdenticalThreeCrows);
                }
                if (settings.bearishDownsideTasukiGap) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishDownsideTasukiGap);
                }
                if (settings.bearishDownsideGapThreeMethods) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishDownsideGapThreeMethods);
                }
                if (settings.bearishSideBySideWhiteLines) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishSideBySideWhiteLines);
                }
                if (settings.bearishThreeLineStrike) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishThreeLineStrike);
                }
                if (settings.bearishThreeGaps) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishThreeGaps);
                }
                if (settings.bearishBreakaway) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishBreakaway);
                }
                if (settings.bearishFallingThreeMethods) {
                    this.drawSignal(g2, CandlePattern.BEARISH, this.dataset.bearishFallingThreeMethods);
                }
                if (settings.ma) {
                    this.drawLineCrossMarker(g2, priceArea, priceAxis, this.dataset.ma1, this.dataset.ma2);
                }
                if (settings.bandType == BandType.ENVELOPE) {
                    this.drawSignal(g2, priceArea, priceAxis, this.dataset.high, this.dataset.low, this.dataset.envelope_upper2, this.dataset.envelope_lower2);
                } else if (settings.bandType == BandType.HIGH_LOW_MOVING_AVERAGE) {
                    this.drawSignal(g2, priceArea, priceAxis, this.dataset.close, this.dataset.close, this.dataset.hma, this.dataset.lma);
                } else if (settings.bandType == BandType.DONCHIAN) {
                    this.drawSignal(g2, priceArea, priceAxis, this.dataset.close, this.dataset.close, this.dataset.donchian_upper, this.dataset.donchian_lower);
                } else if (settings.bandType == BandType.BOLLINGER_BANDS) {
                    this.drawSignal(g2, priceArea, priceAxis, this.dataset.high, this.dataset.low, this.dataset.bb_upper2, this.dataset.bb_lower2);
                } else if (settings.bandType == BandType.VIX) {
                    this.drawSignal(g2, priceArea, priceAxis, this.dataset.high, this.dataset.low, this.dataset.vi_upper, this.dataset.vi_lower);
                } else if (settings.bandType == BandType.MESA) {
                    this.drawLineCrossMarker(g2, priceArea, priceAxis, this.dataset.mama, this.dataset.fama);
                }
            }
            if (settings.chartType == PriceChartType.LINE) {
                g2.setColor(LINE_COLOR);
                this.drawLine(g2, priceArea, priceAxis, this.dataset.techClose);
            } else if (settings.chartType == PriceChartType.BAR) {
                this.drawBar(g2);
            } else if (settings.chartType == PriceChartType.BOH) {
                this.drawBoh(g2);
            } else if (settings.chartType == PriceChartType.CANDLESTICK || settings.chartType == PriceChartType.HEIKIN) {
                this.drawCandlestick(g2);
            } else {
                throw new RuntimeException();
            }
            if (settings.kagi && this.dataset.kagi != null) {
                this.drawKagi(g2);
            }
            if (settings.lr) {
                if (this.dataset.lr1_upper2 != null) {
                    g2.setColor(settings.lr2UpperColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.lr1_upper2);
                }
                if (this.dataset.lr1_upper1 != null) {
                    g2.setColor(settings.lr1UpperColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.lr1_upper1);
                }
                if (this.dataset.lr1 != null) {
                    g2.setColor(settings.lrColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.lr1);
                }
                if (this.dataset.lr1_lower1 != null) {
                    g2.setColor(settings.lr1LowerColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.lr1_lower1);
                }
                if (this.dataset.lr1_lower2 != null) {
                    g2.setColor(settings.lr2LowerColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.lr1_lower2);
                }
                if (this.dataset.lr2_upper2 != null) {
                    g2.setColor(settings.lr2UpperColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.lr2_upper2);
                }
                if (this.dataset.lr2_upper1 != null) {
                    g2.setColor(settings.lr1UpperColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.lr2_upper1);
                }
                if (this.dataset.lr2 != null) {
                    g2.setColor(settings.lrColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.lr2);
                }
                if (this.dataset.lr2_lower1 != null) {
                    g2.setColor(settings.lr1LowerColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.lr2_lower1);
                }
                if (this.dataset.lr2_lower2 != null) {
                    g2.setColor(settings.lr2LowerColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.lr2_lower2);
                }
            }
            if (settings.ma) {
                if (this.dataset.ma1 != null) {
                    g2.setColor(settings.ma1Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.ma1);
                }
                if (this.dataset.ma2 != null) {
                    g2.setColor(settings.ma2Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.ma2);
                }
            }
            if (settings.avgprice && this.dataset.avgprice != null) {
                g2.setColor(LINE_COLOR);
                this.drawLine(g2, priceArea, priceAxis, this.dataset.avgprice);
            }
            if (settings.mp && this.dataset.mp != null) {
                g2.setColor(LINE_COLOR);
                this.drawLine(g2, priceArea, priceAxis, this.dataset.mp);
            }
            if (settings.tp && this.dataset.tp != null) {
                g2.setColor(LINE_COLOR);
                this.drawLine(g2, priceArea, priceAxis, this.dataset.tp);
            }
            if (settings.wc && this.dataset.wc != null) {
                g2.setColor(LINE_COLOR);
                this.drawLine(g2, priceArea, priceAxis, this.dataset.wc);
            }
            if (settings.zigzag && this.dataset.zigzag != null) {
                this.drawLine(g2, priceArea, priceAxis, this.dataset.zigzag, this.settings.updownLineColors);
            }
            if (settings.bandType == BandType.ENVELOPE) {
                if (this.dataset.envelope_upper2 != null) {
                    g2.setColor(settings.envelopeUpper2Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.envelope_upper2);
                }
                if (this.dataset.envelope_upper1 != null) {
                    g2.setColor(settings.envelopeUpper1Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.envelope_upper1);
                }
                if (this.dataset.envelope != null) {
                    g2.setColor(settings.envelopeColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.envelope);
                }
                if (this.dataset.envelope_lower1 != null) {
                    g2.setColor(settings.envelopeLower1Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.envelope_lower1);
                }
                if (this.dataset.envelope_lower2 != null) {
                    g2.setColor(settings.envelopeLower2Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.envelope_lower2);
                }
            } else if (settings.bandType == BandType.HIGH_LOW_MOVING_AVERAGE) {
                if (this.dataset.hma != null) {
                    g2.setColor(settings.ma1Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.hma);
                }
                if (this.dataset.lma != null) {
                    g2.setColor(settings.ma2Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.lma);
                }
            } else if (settings.bandType == BandType.DONCHIAN) {
                if (this.dataset.donchian_upper != null) {
                    g2.setColor(settings.ma1Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.donchian_upper);
                }
                if (this.dataset.donchian_lower != null) {
                    g2.setColor(settings.ma2Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.donchian_lower);
                }
            } else if (settings.bandType == BandType.BOLLINGER_BANDS) {
                if (this.dataset.bb_upper2 != null) {
                    g2.setColor(settings.bbUpper2Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.bb_upper2);
                }
                if (this.dataset.bb_upper1 != null) {
                    g2.setColor(settings.bbUpper1Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.bb_upper1);
                }
                if (this.dataset.bb_tpma != null) {
                    g2.setColor(settings.bbColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.bb_tpma);
                }
                if (this.dataset.bb_lower1 != null) {
                    g2.setColor(settings.bbLower1Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.bb_lower1);
                }
                if (this.dataset.bb_lower2 != null) {
                    g2.setColor(settings.bbLower2Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.bb_lower2);
                }
            } else if (settings.bandType == BandType.PARABOLIC_TIME_PRICE) {
                this.drawSAR(g2);
            } else if (settings.bandType == BandType.PIVOT) {
                if (this.dataset.pivot_hbop != null) {
                    g2.setColor(settings.pivotHBOPColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.pivot_hbop);
                }
                if (this.dataset.pivot_s2 != null) {
                    g2.setColor(settings.pivotS2Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.pivot_s2);
                }
                if (this.dataset.pivot_s1 != null) {
                    g2.setColor(settings.pivotS1Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.pivot_s1);
                }
                if (this.dataset.pivot_b1 != null) {
                    g2.setColor(settings.pivotB1Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.pivot_b1);
                }
                if (this.dataset.pivot_b2 != null) {
                    g2.setColor(settings.pivotB2Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.pivot_b2);
                }
                if (this.dataset.pivot_lbop != null) {
                    g2.setColor(settings.pivotLBOPColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.pivot_lbop);
                }
            } else if (settings.bandType == BandType.VIX) {
                if (this.dataset.vi_upper != null) {
                    g2.setColor(settings.viUpperColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.vi_upper);
                }
                if (this.dataset.vi_lower != null) {
                    g2.setColor(settings.viLowerColor);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.vi_lower);
                }
            } else if (settings.bandType == BandType.ICHIMOKU) {
                g2.setColor(settings.ichimokuKijunColor);
                this.drawLine(g2, priceArea, priceAxis, this.dataset.kijun);
                g2.setColor(settings.ichimokuTenkanColor);
                this.drawLine(g2, priceArea, priceAxis, this.dataset.tenkan);
                g2.setColor(settings.ichimokuSenkou1Color);
                this.drawLine(g2, priceArea, priceAxis, this.dataset.senkou1);
                g2.setColor(settings.ichimokuSenkou2Color);
                this.drawLine(g2, priceArea, priceAxis, this.dataset.senkou2);
                g2.setColor(settings.ichimokuChikouColor);
                this.drawLine(g2, priceArea, priceAxis, this.dataset.chikou);
            } else if (settings.bandType == BandType.MESA) {
                if (this.dataset.mama != null) {
                    g2.setColor(settings.ma1Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.mama);
                }
                if (this.dataset.fama != null) {
                    g2.setColor(settings.ma2Color);
                    this.drawLine(g2, priceArea, priceAxis, this.dataset.fama);
                }
            } else if (settings.bandType == BandType.VIDYA && this.dataset.vidya != null) {
                g2.setColor(settings.bbColor);
                this.drawLine(g2, priceArea, priceAxis, this.dataset.vidya);
            }
            if (settings.splitMarker) {
                this.drawSplitMarker(g2);
            }
            TimeSeriesChartCanvas.drawDescription(g2, priceArea, this.priceDescription);
        }
        if (this.vpArea != null) {
            g2.setClip(this.vpArea);
            priceArea = this.areas[0];
            priceAxis = this.axes[0];
            for (i = 0; i < this.vp.length; ++i) {
                if (this.vp[i] == null) continue;
                double y1 = priceAxis.valueToJava2D(this.vpLower + (i + 1) * this.vpStep, priceArea);
                double y2 = priceAxis.valueToJava2D(this.vpLower + i * this.vpStep, priceArea);
                double maxY = Math.max(y1, y2);
                double minY = Math.min(y1, y2);
                double x1 = this.vpArea.getMinX();
                double x2 = this.vpVolumeAxis.valueToJava2D(this.vp[i].doubleValue(), this.vpArea);
                g2.setPaint(new GradientPaint((float)x1, (float)maxY, settings.volumeColor1, (float)x2, (float)minY, settings.volumeColor2));
                Rectangle2D.Double bar = new Rectangle2D.Double(x1, maxY, x2 - x1, maxY - minY);
                g2.fill(bar);
            }
            TimeSeriesChartCanvas.drawDescription(g2, this.vpArea, StringManager.getString("vp", new Object[0]));
        }
        if (this.areas[1] != null) {
            Rectangle2D volumeArea = this.areas[1];
            NumberAxis volumeAxis = this.axes[1];
            g2.setClip(volumeArea);
            if (settings.volumeType != VolumeType.NONE) {
                for (i = 0; i < this.period; ++i) {
                    int n = this.start + i;
                    if (n < 0 || n >= this.dataset.getCount() || this.dataset.volume[n] == null) continue;
                    double y = volumeAxis.valueToJava2D(this.dataset.volume[n].doubleValue(), volumeArea);
                    double x = volumeArea.getMinX() + (double)i * this.periodWidth;
                    g2.setPaint(new GradientPaint((float)x, (float)y, settings.volumeColor1, (float)(x + this.periodWidth), (float)volumeArea.getMaxY(), settings.volumeColor2));
                    Rectangle2D.Double bar = new Rectangle2D.Double(x, y, this.periodWidth, volumeArea.getMaxY() - y);
                    g2.fill(bar);
                }
            }
            if (settings.volumeType == VolumeType.MARGIN) {
                if (this.dataset.sold != null) {
                    g2.setColor(settings.soldColor);
                    this.drawLine(g2, volumeArea, volumeAxis, this.dataset.sold);
                }
                if (this.dataset.bought != null) {
                    g2.setColor(settings.boughtColor);
                    this.drawLine(g2, volumeArea, volumeAxis, this.dataset.bought);
                }
            } else if (settings.volumeType == VolumeType.MOVING_AVERAGE) {
                if (this.dataset.vma1 != null) {
                    g2.setColor(settings.ma1Color);
                    this.drawLine(g2, volumeArea, volumeAxis, this.dataset.vma1);
                }
                if (this.dataset.vma2 != null) {
                    g2.setColor(settings.ma2Color);
                    this.drawLine(g2, volumeArea, volumeAxis, this.dataset.vma2);
                }
            }
            TimeSeriesChartCanvas.drawDescription(g2, volumeArea, this.volumeDescription);
        }
        if (this.areas[2] != null) {
            area = this.areas[2];
            axis = this.axes[2];
            g2.setClip(area);
            if (this.dataset.aroonUp != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.aroonUp);
            }
            if (this.dataset.aroonDown != null) {
                g2.setColor(settings.oscillatorColor2);
                this.drawLine(g2, area, axis, this.dataset.aroonDown);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("aroon.updown", new Object[0]));
        }
        if (this.areas[3] != null) {
            area = this.areas[3];
            axis = this.axes[3];
            g2.setClip(area);
            if (this.dataset.aroon != null) {
                g2.setColor(settings.oscillatorColor3);
                this.drawLine(g2, area, axis, this.dataset.aroon);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("aroon", new Object[0]));
        }
        if (settings.atr && this.dataset.atr != null) {
            area = this.areas[4];
            axis = this.axes[4];
            g2.setClip(area);
            g2.setColor(settings.oscillatorColor1);
            this.drawLine(g2, area, axis, this.dataset.atr);
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("atr", new Object[0]));
        }
        if (settings.natr && this.dataset.natr != null) {
            area = this.areas[5];
            axis = this.axes[5];
            g2.setClip(area);
            g2.setColor(settings.oscillatorColor1);
            this.drawLine(g2, area, axis, this.dataset.natr);
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("natr", new Object[0]));
        }
        if (settings.bop && this.dataset.bop != null) {
            area = this.areas[6];
            axis = this.axes[6];
            g2.setClip(area);
            g2.setColor(settings.oscillatorColor1);
            this.drawLine(g2, area, axis, this.dataset.bop);
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("bmp", new Object[0]));
        }
        if (this.areas[7] != null) {
            area = this.areas[7];
            g2.setClip(area);
            if (this.dataset.chv != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, this.axes[7], this.dataset.chv);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("cv", new Object[0]));
        }
        if (this.areas[8] != null) {
            area = this.areas[8];
            axis = this.axes[8];
            g2.setClip(area);
            if (this.dataset.cci != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, area, axis, this.dataset.cci, settings.cciUpperSignal, settings.cciLowerSignal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.cci);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("cci", new Object[0]));
        }
        if (this.areas[9] != null) {
            area = this.areas[9];
            axis = this.axes[9];
            g2.setClip(area);
            if (this.dataset.cmf != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.cmf);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("cmf", new Object[0]));
        }
        if (this.areas[10] != null) {
            area = this.areas[10];
            axis = this.axes[10];
            g2.setClip(area);
            if (this.dataset.cmo != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, area, axis, this.dataset.cmo, settings.cmo_upper_signal, settings.cmo_lower_signal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.cmo);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("cmo", new Object[0]));
        }
        if (this.areas[11] != null) {
            area = this.areas[11];
            g2.setClip(area);
            if (this.dataset.coppock != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, this.axes[11], this.dataset.coppock);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("coppock", new Object[0]));
        }
        if (this.areas[12] != null) {
            area = this.areas[12];
            g2.setClip(area);
            if (this.dataset.dpo != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, this.axes[12], this.dataset.dpo);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("dpo", new Object[0]));
        }
        if (this.areas[13] != null) {
            area = this.areas[13];
            axis = this.axes[13];
            g2.setClip(area);
            if (this.dataset.pdi != null) {
                g2.setColor(settings.pdiColor);
                this.drawLine(g2, area, axis, this.dataset.pdi);
            }
            if (this.dataset.mdi != null) {
                g2.setColor(settings.mdiColor);
                this.drawLine(g2, area, axis, this.dataset.mdi);
            }
            if (this.dataset.adx != null) {
                g2.setColor(settings.adxColor);
                this.drawLine(g2, area, axis, this.dataset.adx);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("dmi", new Object[0]));
        }
        if (this.areas[14] != null) {
            area = this.areas[14];
            g2.setClip(area);
            if (this.dataset.emv != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, this.axes[14], this.dataset.emv);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("emv", new Object[0]));
        }
        if (this.areas[15] != null) {
            area = this.areas[15];
            g2.setClip(area);
            if (this.dataset.hv != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, this.axes[15], this.dataset.hv);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("hv", new Object[0]));
        }
        if (this.areas[16] != null) {
            area = this.areas[16];
            axis = this.axes[16];
            g2.setClip(area);
            if (this.dataset.kairi != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, area, axis, this.dataset.kairi, settings.biasUpperSignal, settings.biasLowerSignal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.kairi);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("bias", new Object[0]));
        }
        if (this.areas[17] != null) {
            area = this.areas[17];
            axis = this.axes[17];
            g2.setClip(area);
            if (this.dataset.mi != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.mi);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("mi", new Object[0]));
        }
        if (this.areas[18] != null) {
            area = this.areas[18];
            g2.setClip(area);
            if (this.dataset.mom != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, this.axes[18], this.dataset.mom);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("momentum", new Object[0]));
        }
        if (this.areas[19] != null) {
            area = this.areas[19];
            axis = this.axes[19];
            g2.setClip(area);
            if (this.dataset.mfi != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, area, axis, this.dataset.mfi, settings.mfiUpperSignal, settings.mfiLowerSignal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.mfi);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("mfi", new Object[0]));
        }
        if (this.areas[20] != null) {
            area = this.areas[20];
            axis = this.axes[20];
            g2.setClip(area);
            if (this.dataset.macd != null) {
                g2.setColor(settings.macdColor);
                this.drawLine(g2, area, axis, this.dataset.macd);
            }
            if (this.dataset.macdSignal != null) {
                g2.setColor(settings.macdSignalColor);
                this.drawLine(g2, area, axis, this.dataset.macdSignal);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("macd", new Object[0]));
        }
        if (this.areas[21] != null) {
            area = this.areas[21];
            axis = this.axes[21];
            g2.setClip(area);
            if (this.dataset.pain != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.pain);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("pain", new Object[0]));
        }
        if (this.areas[22] != null) {
            area = this.areas[22];
            axis = this.axes[22];
            g2.setClip(area);
            if (this.dataset.pcr != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, area, axis, this.dataset.pcr, settings.pcr_upper_signal, settings.pcr_lower_signal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.pcr);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("pcr", new Object[0]));
        }
        if (this.areas[23] != null) {
            Rectangle2D apoArea = this.areas[23];
            g2.setClip(apoArea);
            if (this.dataset.apo != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, apoArea, this.axes[23], this.dataset.apo);
            }
            TimeSeriesChartCanvas.drawDescription(g2, apoArea, StringManager.getString("apo", new Object[0]));
        }
        if (this.areas[24] != null) {
            Rectangle2D ppoArea = this.areas[24];
            g2.setClip(ppoArea);
            if (this.dataset.ppo != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, ppoArea, this.axes[24], this.dataset.ppo);
            }
            TimeSeriesChartCanvas.drawDescription(g2, ppoArea, StringManager.getString("ppo", new Object[0]));
        }
        if (this.areas[25] != null) {
            Rectangle2D psychologicalArea = this.areas[25];
            NumberAxis psychologicalAxis = this.axes[25];
            g2.setClip(psychologicalArea);
            if (this.dataset.psy != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, psychologicalArea, psychologicalAxis, this.dataset.psy, settings.psy_upper_signal, settings.psy_lower_signal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, psychologicalArea, psychologicalAxis, this.dataset.psy);
            }
            TimeSeriesChartCanvas.drawDescription(g2, psychologicalArea, StringManager.getString("psychological", new Object[0]));
        }
        if (this.areas[26] != null) {
            area = this.areas[26];
            axis = this.axes[26];
            g2.setClip(area);
            if (this.dataset.qstick != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.qstick);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("qstick", new Object[0]));
        }
        if (this.areas[27] != null) {
            Rectangle2D rciArea = this.areas[27];
            NumberAxis rciAxis = this.axes[27];
            g2.setClip(rciArea);
            if (this.dataset.rci != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, rciArea, rciAxis, this.dataset.rci, settings.rciUpperSignal, settings.rciLowerSignal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, rciArea, rciAxis, this.dataset.rci);
            }
            TimeSeriesChartCanvas.drawDescription(g2, rciArea, StringManager.getString("rci", new Object[0]));
        }
        if (this.areas[28] != null) {
            Rectangle2D rocArea = this.areas[28];
            g2.setClip(rocArea);
            if (this.dataset.roc != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, rocArea, this.axes[28], this.dataset.roc);
            }
            TimeSeriesChartCanvas.drawDescription(g2, rocArea, StringManager.getString("roc", new Object[0]));
        }
        if (this.areas[29] != null) {
            Rectangle2D rsiArea = this.areas[29];
            NumberAxis rsiAxis = this.axes[29];
            g2.setClip(rsiArea);
            if (this.dataset.rsi != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, rsiArea, rsiAxis, this.dataset.rsi, settings.rsiUpperSignal, settings.rsiLowerSignal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, rsiArea, rsiAxis, this.dataset.rsi);
            }
            TimeSeriesChartCanvas.drawDescription(g2, rsiArea, StringManager.getString("rsi", new Object[0]));
        }
        if (this.areas[30] != null) {
            area = this.areas[30];
            axis = this.axes[30];
            g2.setClip(area);
            if (this.dataset.rvi != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, area, axis, this.dataset.rvi, settings.rvi_upper_signal, settings.rvi_lower_signal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.rvi);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("rvi", new Object[0]));
        }
        if (this.areas[31] != null) {
            area = this.areas[31];
            axis = this.axes[31];
            g2.setClip(area);
            if (this.dataset.shinohara_a != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.shinohara_a);
            }
            if (this.dataset.shinohara_b != null) {
                g2.setColor(settings.oscillatorColor2);
                this.drawLine(g2, area, axis, this.dataset.shinohara_b);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("shinohara", new Object[0]));
        }
        if (this.areas[32] != null) {
            Rectangle2D srvFastArea = this.areas[32];
            NumberAxis srvFastAxis = this.axes[32];
            g2.setClip(srvFastArea);
            if (settings.signalMarker && this.dataset.srvK != null) {
                this.drawSignal(g2, srvFastArea, srvFastAxis, this.dataset.srvK, settings.srvUpperSignal, settings.srvLowerSignal);
                if (this.dataset.srvD != null) {
                    // empty if block
                }
            }
            if (this.dataset.srvK != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, srvFastArea, srvFastAxis, this.dataset.srvK);
            }
            if (this.dataset.srvD != null) {
                g2.setColor(settings.oscillatorColor2);
                this.drawLine(g2, srvFastArea, srvFastAxis, this.dataset.srvD);
            }
            TimeSeriesChartCanvas.drawDescription(g2, srvFastArea, StringManager.getString("srv.fast", new Object[0]));
        }
        if (this.areas[33] != null) {
            area = this.areas[33];
            axis = this.axes[33];
            g2.setClip(area);
            if (this.dataset.tii != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, area, axis, this.dataset.tii, settings.tii_upper_signal, settings.tii_lower_signal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, axis, this.dataset.tii);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("tii", new Object[0]));
        }
        if (this.areas[34] != null) {
            Rectangle2D trixArea = this.areas[34];
            NumberAxis trixAxis = this.axes[34];
            g2.setClip(trixArea);
            if (this.dataset.trix != null) {
                g2.setColor(settings.macdColor);
                this.drawLine(g2, trixArea, trixAxis, this.dataset.trix);
            }
            if (this.dataset.trixSignal != null) {
                g2.setColor(settings.macdSignalColor);
                this.drawLine(g2, trixArea, trixAxis, this.dataset.trixSignal);
            }
            TimeSeriesChartCanvas.drawDescription(g2, trixArea, StringManager.getString("trix", new Object[0]));
        }
        if (this.areas[35] != null) {
            area = this.areas[35];
            axis = this.axes[35];
            g2.setClip(area);
            if (this.dataset.tsi != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, area, axis, this.dataset.tsi, settings.tsi_upper_signal, settings.tsi_lower_signal);
                }
                g2.setColor(settings.macdColor);
                this.drawLine(g2, area, axis, this.dataset.tsi);
            }
            if (this.dataset.tsi_signal != null) {
                g2.setColor(settings.macdSignalColor);
                this.drawLine(g2, area, axis, this.dataset.tsi_signal);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("tsi", new Object[0]));
        }
        if (this.areas[36] != null) {
            Rectangle2D ultimateArea = this.areas[36];
            g2.setClip(ultimateArea);
            if (this.dataset.ultimate != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, ultimateArea, this.axes[36], this.dataset.ultimate);
            }
            TimeSeriesChartCanvas.drawDescription(g2, ultimateArea, StringManager.getString("ultimate", new Object[0]));
        }
        if (this.areas[37] != null) {
            Rectangle2D wadArea = this.areas[37];
            g2.setClip(wadArea);
            if (this.dataset.wad != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, wadArea, this.axes[37], this.dataset.wad);
            }
            TimeSeriesChartCanvas.drawDescription(g2, wadArea, StringManager.getString("wad", new Object[0]));
        }
        if (this.areas[38] != null) {
            Rectangle2D williamsRArea = this.areas[38];
            NumberAxis williamsRAxis = this.axes[38];
            g2.setClip(williamsRArea);
            if (this.dataset.williamsR != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, williamsRArea, williamsRAxis, this.dataset.williamsR, settings.williamsRUpperSignal, settings.williamsRLowerSignal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, williamsRArea, williamsRAxis, this.dataset.williamsR);
            }
            TimeSeriesChartCanvas.drawDescription(g2, williamsRArea, StringManager.getString("williamsr", new Object[0]));
        }
        if (this.areas[39] != null) {
            Rectangle2D adArea = this.areas[39];
            g2.setClip(adArea);
            if (this.dataset.ad != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, adArea, this.axes[39], this.dataset.ad);
            }
            TimeSeriesChartCanvas.drawDescription(g2, adArea, StringManager.getString("ad", new Object[0]));
        }
        if (this.areas[40] != null) {
            area = this.areas[40];
            g2.setClip(area);
            if (this.dataset.cho != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, this.axes[40], this.dataset.cho);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("cho", new Object[0]));
        }
        if (this.areas[41] != null) {
            Rectangle2D avoArea = this.areas[41];
            g2.setClip(avoArea);
            if (this.dataset.avo != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, avoArea, this.axes[41], this.dataset.avo);
            }
            TimeSeriesChartCanvas.drawDescription(g2, avoArea, StringManager.getString("avo", new Object[0]));
        }
        if (this.areas[42] != null) {
            Rectangle2D pvoArea = this.areas[42];
            g2.setClip(pvoArea);
            if (this.dataset.pvo != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, pvoArea, this.axes[42], this.dataset.pvo);
            }
            TimeSeriesChartCanvas.drawDescription(g2, pvoArea, StringManager.getString("pvo", new Object[0]));
        }
        if (this.areas[43] != null) {
            Rectangle2D vbiasArea = this.areas[43];
            NumberAxis vbiasAxis = this.axes[43];
            g2.setClip(vbiasArea);
            if (this.dataset.vkairi != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, vbiasArea, vbiasAxis, this.dataset.vkairi);
            }
            TimeSeriesChartCanvas.drawDescription(g2, vbiasArea, StringManager.getString("vbias", new Object[0]));
        }
        if (this.areas[44] != null) {
            Rectangle2D vr1Area = this.areas[44];
            NumberAxis vr1Axis = this.axes[44];
            g2.setClip(vr1Area);
            if (this.dataset.vr1 != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, vr1Area, vr1Axis, this.dataset.vr1, settings.vr1UpperSignal, settings.vr1LowerSignal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, vr1Area, vr1Axis, this.dataset.vr1);
            }
            TimeSeriesChartCanvas.drawDescription(g2, vr1Area, StringManager.getString("vr1", new Object[0]));
        }
        if (this.areas[45] != null) {
            Rectangle2D vr2Area = this.areas[45];
            NumberAxis vr2Axis = this.axes[45];
            g2.setClip(vr2Area);
            if (this.dataset.vr2 != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, vr2Area, vr2Axis, this.dataset.vr2, settings.vr2UpperSignal, settings.vr2LowerSignal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, vr2Area, vr2Axis, this.dataset.vr2);
            }
            TimeSeriesChartCanvas.drawDescription(g2, vr2Area, StringManager.getString("vr2", new Object[0]));
        }
        if (this.areas[46] != null) {
            Rectangle2D vrocArea = this.areas[46];
            g2.setClip(vrocArea);
            if (this.dataset.vroc != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, vrocArea, this.axes[46], this.dataset.vroc);
            }
            TimeSeriesChartCanvas.drawDescription(g2, vrocArea, StringManager.getString("vroc", new Object[0]));
        }
        if (this.areas[47] != null) {
            Rectangle2D vrsiArea = this.areas[47];
            NumberAxis vrsiAxis = this.axes[47];
            g2.setClip(vrsiArea);
            if (this.dataset.vrsi != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, vrsiArea, vrsiAxis, this.dataset.vrsi, settings.vrsiUpperSignal, settings.vrsiLowerSignal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, vrsiArea, vrsiAxis, this.dataset.vrsi);
            }
            TimeSeriesChartCanvas.drawDescription(g2, vrsiArea, StringManager.getString("vrsi", new Object[0]));
        }
        if (this.areas[48] != null) {
            Rectangle2D wvrArea = this.areas[48];
            NumberAxis wvrAxis = this.axes[48];
            g2.setClip(wvrArea);
            if (this.dataset.wvr != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, wvrArea, wvrAxis, this.dataset.wvr, settings.wvrUpperSignal, settings.wvrLowerSignal);
                }
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, wvrArea, wvrAxis, this.dataset.wvr);
            }
            TimeSeriesChartCanvas.drawDescription(g2, wvrArea, StringManager.getString("wvr", new Object[0]));
        }
        if (this.areas[49] != null) {
            area = this.areas[49];
            g2.setClip(area);
            if (this.dataset.pvi != null) {
                g2.setColor(settings.oscillatorColor3);
                this.drawLine(g2, area, this.axes[49], this.dataset.pvi);
            }
            if (this.dataset.pvi_ma1 != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, this.axes[49], this.dataset.pvi_ma1);
            }
            if (this.dataset.pvi_ma2 != null) {
                g2.setColor(settings.oscillatorColor2);
                this.drawLine(g2, area, this.axes[49], this.dataset.pvi_ma2);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("pvi", new Object[0]));
        }
        if (this.areas[50] != null) {
            area = this.areas[50];
            g2.setClip(area);
            if (this.dataset.nvi != null) {
                g2.setColor(settings.oscillatorColor3);
                this.drawLine(g2, area, this.axes[50], this.dataset.nvi);
            }
            if (this.dataset.nvi_ma1 != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, this.axes[50], this.dataset.nvi_ma1);
            }
            if (this.dataset.nvi_ma2 != null) {
                g2.setColor(settings.oscillatorColor2);
                this.drawLine(g2, area, this.axes[50], this.dataset.nvi_ma2);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("nvi", new Object[0]));
        }
        if (this.areas[51] != null) {
            area = this.areas[51];
            g2.setClip(area);
            if (this.dataset.obv != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, this.axes[51], this.dataset.obv);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("obv", new Object[0]));
        }
        if (this.areas[52] != null) {
            area = this.areas[52];
            g2.setClip(area);
            if (this.dataset.pvt != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, area, this.axes[52], this.dataset.pvt);
            }
            TimeSeriesChartCanvas.drawDescription(g2, area, StringManager.getString("pvt", new Object[0]));
        }
        if (this.areas[53] != null) {
            Rectangle2D ratioArea = this.areas[53];
            NumberAxis ratioAxis = this.axes[53];
            g2.setClip(ratioArea);
            if (this.dataset.ratio != null) {
                if (settings.signalMarker) {
                    this.drawSignal(g2, ratioArea, ratioAxis, this.dataset.ratio, settings.ratioUpperSignal, settings.ratioLowerSignal);
                }
                g2.setColor(ChartColor.RED);
                this.drawLine(g2, ratioArea, ratioAxis, this.dataset.ratio);
            }
            TimeSeriesChartCanvas.drawDescription(g2, ratioArea, StringManager.getString("ratio", new Object[0]));
        }
        if (this.areas[54] != null) {
            Rectangle2D priceFluctuationsArea = this.areas[54];
            g2.setClip(priceFluctuationsArea);
            if (this.dataset.price_performance != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, priceFluctuationsArea, this.axes[54], this.dataset.price_performance);
            }
            TimeSeriesChartCanvas.drawDescription(g2, priceFluctuationsArea, StringManager.getString("fluctuations.price", new Object[0]));
        }
        if (this.areas[55] != null) {
            Rectangle2D fluctuationsArea = this.areas[55];
            g2.setClip(fluctuationsArea);
            if (this.dataset.percent_performance != null) {
                g2.setColor(settings.oscillatorColor1);
                this.drawLine(g2, fluctuationsArea, this.axes[55], this.dataset.percent_performance);
            }
            TimeSeriesChartCanvas.drawDescription(g2, fluctuationsArea, StringManager.getString("fluctuations", new Object[0]));
        }
        g2.setClip(saved);
    }

    private void drawSplitMarker(Graphics2D g2) {
        Rectangle2D priceArea = this.areas[0];
        FontMetrics fm = g2.getFontMetrics();
        for (int i = 0; i < this.period; ++i) {
            int n = this.start + i;
            if (n < 0 || n >= this.dataset.getCount() || this.dataset.split == null || this.dataset.split[n] == null) continue;
            double x = priceArea.getMinX() + (double)i * this.periodWidth + (this.periodWidth - (double)this.splitIcon.getWidth(null)) * 0.5;
            double y = priceArea.getMaxY() - (double)this.splitIcon.getHeight(null);
            g2.drawImage(this.splitIcon, (int)x, (int)y, this);
            double d = (double)(this.splitIcon.getHeight(null) - fm.getHeight()) * 0.5;
            DrawUtils.drawText(g2, "1", (float)(x - (double)fm.stringWidth("1") - 1.0), (float)(priceArea.getMaxY() + d));
            DrawUtils.drawText(g2, this.dataset.split[n].toString(), (float)(x + (double)this.splitIcon.getWidth(null) + 1.0), (float)(priceArea.getMaxY() + d));
        }
    }

    private void drawLineCrossMarker(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] shortTermData, Number[] longTermData) {
        UpDownColorType colors = this.settings.updownLineColors;
        double w = Math.min(20.0, this.itemWidth) * 5.0;
        for (int i = -1; i < this.period + 1; ++i) {
            Composite originalComposite;
            Ellipse2D.Double ellipse;
            float longY2;
            float longY1;
            float shortY2;
            int n = this.start + i;
            if (n < 0 || n >= shortTermData.length || shortTermData[n] == null || longTermData[n] == null || n + 1 < shortTermData.length && shortTermData[n + 1] == null || n + 1 < longTermData.length && longTermData[n + 1] == null || n >= shortTermData.length - 1) continue;
            float x1 = (float)(area.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5);
            float x2 = (float)((double)x1 + this.periodWidth);
            float shortY1 = (float)axis.valueToJava2D(shortTermData[n].doubleValue(), area);
            Point2D point = TimeSeriesChartCanvas.getIntersectPoint(x1, shortY1, x2, shortY2 = (float)axis.valueToJava2D(shortTermData[n + 1].doubleValue(), area), x1, longY1 = (float)axis.valueToJava2D(longTermData[n].doubleValue(), area), x2, longY2 = (float)axis.valueToJava2D(longTermData[n + 1].doubleValue(), area));
            if (point == null) continue;
            if (shortY1 < longY1 && shortY2 > longY2) {
                ellipse = new Ellipse2D.Double(point.getX() - w * 0.5, point.getY() - w * 0.5, w, w);
                g2.setColor(colors.getDownLineColor());
                g2.draw(ellipse);
                originalComposite = g2.getComposite();
                g2.setComposite(COMPOSITE);
                g2.setColor(colors.getDownColor1());
                g2.fill(ellipse);
                g2.setComposite(originalComposite);
                continue;
            }
            if (!(shortY1 > longY1) || !(shortY2 < longY2)) continue;
            ellipse = new Ellipse2D.Double(point.getX() - w * 0.5, point.getY() - w * 0.5, w, w);
            g2.setColor(colors.getUpLineColor());
            g2.draw(ellipse);
            originalComposite = g2.getComposite();
            g2.setComposite(COMPOSITE);
            g2.setColor(colors.getUpColor1());
            g2.fill(ellipse);
            g2.setComposite(originalComposite);
        }
    }

    private void drawSignal(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] data, Number upperSignal, Number lowerSignal) {
        if (upperSignal != null) {
            this.drawUpperSignal(g2, area, axis, data, upperSignal.doubleValue());
        }
        if (lowerSignal != null) {
            this.drawLowerSignal(g2, area, axis, data, lowerSignal.doubleValue());
        }
    }

    private void drawUpperSignal(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] data, double signal) {
        Composite originalComposite = g2.getComposite();
        g2.setComposite(COMPOSITE);
        g2.setColor(this.settings.updownLineColors.getUpColor1());
        float signalY = (float)axis.valueToJava2D(signal, area);
        for (int i = -1; i < this.period + 1; ++i) {
            float y2;
            int n = this.start + i;
            if (n < 0 || n >= data.length || data[n] == null || n + 1 < data.length && data[n + 1] == null || n >= data.length - 1 || data[n].doubleValue() < signal && data[n + 1].doubleValue() < signal) continue;
            float x1 = (float)(area.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5);
            float x2 = (float)((double)x1 + this.periodWidth);
            float y1 = (float)axis.valueToJava2D(data[n].doubleValue(), area);
            Point2D point = TimeSeriesChartCanvas.getIntersectPoint(x1, y1, x2, y2 = (float)axis.valueToJava2D(data[n + 1].doubleValue(), area), x1, signalY, x2, signalY);
            Rectangle2D.Double body = point != null ? (y1 > y2 ? new Rectangle2D.Double(point.getX(), area.getMinY(), (double)x2 - point.getX(), area.getHeight()) : (y1 < y2 ? new Rectangle2D.Double(x1, area.getMinY(), point.getX() - (double)x1, area.getHeight()) : new Rectangle2D.Double(x1, area.getMinY(), x2 - x1, area.getHeight()))) : new Rectangle2D.Double(x1, area.getMinY(), x2 - x1, area.getHeight());
            g2.fill(body);
        }
        g2.setComposite(originalComposite);
    }

    private void drawLowerSignal(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] data, double signal) {
        Composite originalComposite = g2.getComposite();
        g2.setComposite(COMPOSITE);
        g2.setColor(this.settings.updownLineColors.getDownColor1());
        float signalY = (float)axis.valueToJava2D(signal, area);
        for (int i = -1; i < this.period + 1; ++i) {
            float y2;
            int n = this.start + i;
            if (n < 0 || n >= data.length || data[n] == null || n + 1 < data.length && data[n + 1] == null || n >= data.length - 1 || data[n].doubleValue() > signal && data[n + 1].doubleValue() > signal) continue;
            float x1 = (float)(area.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5);
            float x2 = (float)((double)x1 + this.periodWidth);
            float y1 = (float)axis.valueToJava2D(data[n].doubleValue(), area);
            Point2D point = TimeSeriesChartCanvas.getIntersectPoint(x1, y1, x2, y2 = (float)axis.valueToJava2D(data[n + 1].doubleValue(), area), x1, signalY, x2, signalY);
            Rectangle2D.Double body = point != null ? (y1 < y2 ? new Rectangle2D.Double(point.getX(), area.getMinY(), (double)x2 - point.getX(), area.getHeight()) : (y1 > y2 ? new Rectangle2D.Double(x1, area.getMinY(), point.getX() - (double)x1, area.getHeight()) : new Rectangle2D.Double(x1, area.getMinY(), x2 - x1, area.getHeight()))) : new Rectangle2D.Double(x1, area.getMinY(), x2 - x1, area.getHeight());
            g2.fill(body);
        }
        g2.setComposite(originalComposite);
    }

    private void drawSignal(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] upperData, Number[] lowerData, Number[] upperSignal, Number[] lowerSignal) {
        if (upperSignal != null) {
            this.drawUpperSignal(g2, area, axis, upperData, upperSignal);
        }
        if (lowerSignal != null) {
            this.drawLowerSignal(g2, area, axis, lowerData, lowerSignal);
        }
    }

    private void drawUpperSignal(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] data, Number[] signal) {
        Composite originalComposite = g2.getComposite();
        g2.setComposite(COMPOSITE);
        g2.setColor(this.settings.updownLineColors.getUpColor1());
        for (int i = -1; i < this.period + 1; ++i) {
            float signalY2;
            int n = this.start + i;
            if (n < 0 || n >= data.length || data[n] == null || signal[n] == null || n + 1 < data.length && data[n + 1] == null || n + 1 < signal.length && signal[n + 1] == null || n >= data.length - 1) continue;
            float x1 = (float)(area.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5);
            float x2 = (float)((double)x1 + this.periodWidth);
            float y1 = (float)axis.valueToJava2D(data[n].doubleValue(), area);
            float y2 = (float)axis.valueToJava2D(data[n + 1].doubleValue(), area);
            if (!(data[n].doubleValue() >= signal[n].doubleValue()) && !(data[n + 1].doubleValue() >= signal[n + 1].doubleValue())) continue;
            float signalY1 = (float)axis.valueToJava2D(signal[n].doubleValue(), area);
            Point2D point = TimeSeriesChartCanvas.getIntersectPoint(x1, y1, x2, y2, x1, signalY1, x2, signalY2 = (float)axis.valueToJava2D(signal[n + 1].doubleValue(), area));
            Rectangle2D.Double body = point != null ? (y1 > y2 ? new Rectangle2D.Double(point.getX(), area.getMinY(), (double)x2 - point.getX(), area.getHeight()) : (y1 < y2 ? new Rectangle2D.Double(x1, area.getMinY(), point.getX() - (double)x1, area.getHeight()) : new Rectangle2D.Double(x1, area.getMinY(), x2 - x1, area.getHeight()))) : new Rectangle2D.Double(x1, area.getMinY(), x2 - x1, area.getHeight());
            g2.fill(body);
        }
        g2.setComposite(originalComposite);
    }

    private void drawLowerSignal(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] data, Number[] signal) {
        Composite originalComposite = g2.getComposite();
        g2.setComposite(COMPOSITE);
        g2.setColor(this.settings.updownLineColors.getDownColor1());
        for (int i = -1; i < this.period + 1; ++i) {
            float signalY2;
            int n = this.start + i;
            if (n < 0 || n >= data.length || data[n] == null || signal[n] == null || n + 1 < data.length && data[n + 1] == null || n + 1 < signal.length && signal[n + 1] == null || n >= data.length - 1) continue;
            float x1 = (float)(area.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5);
            float x2 = (float)((double)x1 + this.periodWidth);
            float y1 = (float)axis.valueToJava2D(data[n].doubleValue(), area);
            float y2 = (float)axis.valueToJava2D(data[n + 1].doubleValue(), area);
            if (!(data[n].doubleValue() <= signal[n].doubleValue()) && !(data[n + 1].doubleValue() <= signal[n + 1].doubleValue())) continue;
            float signalY1 = (float)axis.valueToJava2D(signal[n].doubleValue(), area);
            Point2D point = TimeSeriesChartCanvas.getIntersectPoint(x1, y1, x2, y2, x1, signalY1, x2, signalY2 = (float)axis.valueToJava2D(signal[n + 1].doubleValue(), area));
            Rectangle2D.Double body = point != null ? (y1 < y2 ? new Rectangle2D.Double(point.getX(), area.getMinY(), (double)x2 - point.getX(), area.getHeight()) : (y1 > y2 ? new Rectangle2D.Double(x1, area.getMinY(), point.getX() - (double)x1, area.getHeight()) : new Rectangle2D.Double(x1, area.getMinY(), x2 - x1, area.getHeight()))) : new Rectangle2D.Double(x1, area.getMinY(), x2 - x1, area.getHeight());
            g2.fill(body);
        }
        g2.setComposite(originalComposite);
    }

    private void drawSignal(Graphics2D g2, CandlePattern type, boolean[] signal) {
        Composite originalComposite = g2.getComposite();
        g2.setComposite(COMPOSITE);
        Rectangle2D area = this.areas[0];
        for (int i = 0; i < this.period; ++i) {
            int n = this.start + i;
            if (n < 0 || n >= this.dataset.getCount() || !signal[n]) continue;
            double x = area.getMinX() + (double)i * this.periodWidth;
            Rectangle2D.Double body = new Rectangle2D.Double(x, area.getMinY(), this.periodWidth, area.getHeight());
            switch (type) {
                case BEARISH: {
                    g2.setColor(this.settings.updownLineColors.getUpColor1());
                    break;
                }
                case BULLISH: {
                    g2.setColor(this.settings.updownLineColors.getDownColor1());
                }
            }
            g2.fill(body);
        }
        g2.setComposite(originalComposite);
    }

    private void drawDifference(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] data1, Number[] data2, Color positiveColor1, Color positiveColor2, Color negativeColor1, Color negativeColor2) {
        GradientPaint positivePaint = new GradientPaint(0.0f, (float)area.getMinY(), positiveColor1, 0.0f, (float)area.getMaxY(), positiveColor2);
        GradientPaint negativePaint = new GradientPaint(0.0f, (float)area.getMinY(), negativeColor1, 0.0f, (float)area.getMaxY(), negativeColor2);
        Composite originalComposite = g2.getComposite();
        g2.setComposite(COMPOSITE);
        for (int i = -1; i < this.period + 1; ++i) {
            float yb2;
            float yb1;
            float ya2;
            int n = this.start + i;
            if (n < 0 || n >= data1.length || data1[n] == null || data2[n] == null || n + 1 < data1.length && data1[n + 1] == null || n + 1 < data2.length && data2[n + 1] == null || n >= data1.length - 1) continue;
            float x1 = (float)(area.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5);
            float x2 = (float)((double)x1 + this.periodWidth);
            float ya1 = (float)axis.valueToJava2D(data1[n].doubleValue(), area);
            Point2D point = TimeSeriesChartCanvas.getIntersectPoint(x1, ya1, x2, ya2 = (float)axis.valueToJava2D(data1[n + 1].doubleValue(), area), x1, yb1 = (float)axis.valueToJava2D(data2[n].doubleValue(), area), x2, yb2 = (float)axis.valueToJava2D(data2[n + 1].doubleValue(), area));
            if (point != null) {
                GeneralPath left = new GeneralPath();
                left.moveTo(x1, ya1);
                left.lineTo((float)point.getX(), (float)point.getY());
                left.lineTo(x1, yb1);
                left.closePath();
                if (ya1 > yb1) {
                    g2.setPaint(negativePaint);
                } else {
                    g2.setPaint(positivePaint);
                }
                g2.fill(left);
                GeneralPath right = new GeneralPath();
                right.moveTo(x2, ya2);
                right.lineTo((float)point.getX(), (float)point.getY());
                right.lineTo(x2, yb2);
                right.closePath();
                if (ya2 > yb2) {
                    g2.setPaint(negativePaint);
                } else {
                    g2.setPaint(positivePaint);
                }
                g2.fill(right);
                continue;
            }
            GeneralPath path = new GeneralPath();
            path.moveTo(x1, ya1);
            path.lineTo(x2, ya2);
            path.lineTo(x2, yb2);
            path.lineTo(x1, yb1);
            path.closePath();
            if (ya1 > yb1) {
                g2.setPaint(negativePaint);
            } else {
                g2.setPaint(positivePaint);
            }
            g2.fill(path);
        }
        g2.setComposite(originalComposite);
    }

    private static Point2D getIntersectPoint(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4) {
        if (!Line2D.linesIntersect(x1, y1, x2, y2, x3, y3, x4, y4)) {
            return null;
        }
        double a = (y2 - y1) / (x2 - x1);
        double b = (y4 - y3) / (x4 - x3);
        if (x1 != x2 && x3 != x4) {
            double x = (x1 * a - y1 - x3 * b + y3) / (a - b);
            double y = a * (x - x1) + y1;
            return new Point2D.Double(x, y);
        }
        if (x1 == x2 && x3 != x4) {
            double x = x1;
            double y = b * (x - x3) + y3;
            return new Point2D.Double(x, y);
        }
        if (x1 != x2 && x3 == x4) {
            double x = x3;
            double y = a * (x - x1) + y1;
            return new Point2D.Double(x, y);
        }
        return null;
    }

    private void drawLine(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] data) {
        for (int i = -1; i < this.period + 1; ++i) {
            int n = this.start + i;
            if (n < 0 || n >= data.length - 1 || data[n] == null || n + 1 < data.length && data[n + 1] == null) continue;
            double x1 = area.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5;
            double x2 = x1 + this.periodWidth;
            double y1 = axis.valueToJava2D(data[n].doubleValue(), area);
            double y2 = axis.valueToJava2D(data[n + 1].doubleValue(), area);
            g2.draw(new Line2D.Double(x1, y1, x2, y2));
        }
    }

    private void drawLine(Graphics2D g2, Rectangle2D area, NumberAxis axis, Number[] data, UpDownColorType colors) {
        for (int i = -1; i < this.period + 1; ++i) {
            int n = this.start + i;
            if (n < 0 || n >= data.length - 1 || data[n] == null || n + 1 < data.length && data[n + 1] == null) continue;
            double x1 = area.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5;
            double x2 = x1 + this.periodWidth;
            double y1 = axis.valueToJava2D(data[n].doubleValue(), area);
            double y2 = axis.valueToJava2D(data[n + 1].doubleValue(), area);
            boolean up = data[n].doubleValue() < data[n + 1].doubleValue();
            g2.setColor(up ? colors.getUpLineColor() : colors.getDownLineColor());
            g2.draw(new Line2D.Double(x1, y1, x2, y2));
        }
    }

    private void drawBar(Graphics2D g2) {
        Rectangle2D priceArea = this.areas[0];
        NumberAxis priceAxis = this.axes[0];
        UpDownColorType colors = this.settings.updownLineColors;
        for (int i = 0; i < this.period; ++i) {
            int n = this.start + i;
            if (n < 0 || n >= this.dataset.getCount() || this.dataset.open[n] == null || this.dataset.high[n] == null || this.dataset.low[n] == null || this.dataset.close[n] == null) continue;
            double openY = priceAxis.valueToJava2D(this.dataset.open[n].doubleValue(), priceArea);
            double highY = priceAxis.valueToJava2D(this.dataset.high[n].doubleValue(), priceArea);
            double lowY = priceAxis.valueToJava2D(this.dataset.low[n].doubleValue(), priceArea);
            double closeY = priceAxis.valueToJava2D(this.dataset.close[n].doubleValue(), priceArea);
            boolean down = closeY > openY;
            g2.setColor(down ? colors.getDownLineColor() : colors.getUpLineColor());
            double x = priceArea.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5;
            g2.draw(new Line2D.Double(x, highY, x, lowY));
            double delta = 2.0;
            g2.draw(new Line2D.Double(x - 2.0, openY, x, openY));
            g2.draw(new Line2D.Double(x, closeY, x + 2.0, closeY));
        }
    }

    private void drawCandlestick(Graphics2D g2) {
        Rectangle2D priceArea = this.areas[0];
        NumberAxis priceAxis = this.axes[0];
        UpDownColorType colors = this.settings.updownBarColors;
        for (int i = 0; i < this.period; ++i) {
            int n = this.start + i;
            if (n < 0 || n >= this.dataset.getCount() || this.dataset.open[n] == null || this.dataset.high[n] == null || this.dataset.low[n] == null || this.dataset.close[n] == null) continue;
            double openY = priceAxis.valueToJava2D(this.dataset.open[n].doubleValue(), priceArea);
            double highY = priceAxis.valueToJava2D(this.dataset.high[n].doubleValue(), priceArea);
            double lowY = priceAxis.valueToJava2D(this.dataset.low[n].doubleValue(), priceArea);
            double closeY = priceAxis.valueToJava2D(this.dataset.close[n].doubleValue(), priceArea);
            double maxOpenCloseY = Math.max(openY, closeY);
            double minOpenCloseY = Math.min(openY, closeY);
            boolean down = closeY > openY;
            double x = priceArea.getMinX() + (double)i * this.periodWidth + this.periodWidth * 0.5;
            g2.setColor(down ? colors.getDownLineColor() : colors.getUpLineColor());
            g2.draw(new Line2D.Double(x, highY, x, maxOpenCloseY));
            g2.draw(new Line2D.Double(x, lowY, x, minOpenCloseY));
            double x1 = priceArea.getMinX() + (double)i * this.periodWidth + (this.periodWidth - this.itemWidth) * 0.5;
            double x2 = x1 + this.itemWidth;
            if (down) {
                g2.setPaint(new GradientPaint((float)x1, (float)minOpenCloseY, colors.getDownColor1(), (float)x2, (float)maxOpenCloseY, colors.getDownColor2()));
            } else {
                g2.setPaint(new GradientPaint((float)x1, (float)minOpenCloseY, colors.getUpColor1(), (float)x2, (float)maxOpenCloseY, colors.getUpColor2()));
            }
            Rectangle2D.Double body = new Rectangle2D.Double(x1, minOpenCloseY, this.itemWidth, maxOpenCloseY - minOpenCloseY);
            g2.fill(body);
            g2.setColor(down ? colors.getDownLineColor() : colors.getUpLineColor());
            g2.draw(body);
        }
    }

    private void drawBoh(Graphics2D g2) {
        Rectangle2D priceArea = this.areas[0];
        NumberAxis priceAxis = this.axes[0];
        UpDownColorType colors = this.settings.updownBarColors;
        for (int i = 0; i < this.period; ++i) {
            int n = this.start + i;
            if (n < 0 || n >= this.dataset.getCount() || this.dataset.open[n] == null || this.dataset.high[n] == null || this.dataset.low[n] == null || this.dataset.close[n] == null) continue;
            double highY = priceAxis.valueToJava2D(this.dataset.high[n].doubleValue(), priceArea);
            double lowY = priceAxis.valueToJava2D(this.dataset.low[n].doubleValue(), priceArea);
            double maxOpenCloseY = Math.max(highY, lowY);
            double minOpenCloseY = Math.min(highY, lowY);
            boolean down = this.dataset.close[n].doubleValue() < this.dataset.open[n].doubleValue();
            double x1 = priceArea.getMinX() + (double)i * this.periodWidth + (this.periodWidth - this.itemWidth) * 0.5;
            double x2 = x1 + this.itemWidth;
            if (down) {
                g2.setPaint(new GradientPaint((float)x1, (float)minOpenCloseY, colors.getDownColor1(), (float)x2, (float)maxOpenCloseY, colors.getDownColor2()));
            } else {
                g2.setPaint(new GradientPaint((float)x1, (float)minOpenCloseY, colors.getUpColor1(), (float)x2, (float)maxOpenCloseY, colors.getUpColor2()));
            }
            Rectangle2D.Double body = new Rectangle2D.Double(x1, minOpenCloseY, this.itemWidth, maxOpenCloseY - minOpenCloseY);
            g2.fill(body);
            g2.setColor(down ? colors.getDownLineColor() : colors.getUpLineColor());
            g2.draw(body);
        }
    }

    private void drawKagi(Graphics2D g2) {
        Step[] data = this.dataset.kagi.toArray(new Step[0]);
        int s = Math.max(this.start, 0);
        int _start = Step.indexOf((Step[])data, (Date)this.dataset.date[s]);
        int _end = Math.min(Step.lastIndexOf((Step[])data, (Date)this.dataset.date[Math.min(this.start + this.period, this.dataset.getCount() - 1)]) + 1, data.length - 1);
        UpDownColorType colors = this.settings.updownLineColors;
        boolean up = data[_start].open < data[_start].high;
        g2.setColor(up ? colors.getUpLineColor() : colors.getDownLineColor());
        Rectangle2D area = this.areas[0];
        NumberAxis axis = this.axes[0];
        double x1 = area.getMinX();
        for (int i = _start; i <= _end; ++i) {
            double high = data[i].high;
            double low = data[i].low;
            double x2 = area.getMinX() + (double)(DateArrayUtils.indexOf((Date[])this.dataset.date, (Date)data[i].openDate) - s) * this.periodWidth + this.periodWidth * 0.5;
            double y1 = axis.valueToJava2D(high, area);
            double y2 = axis.valueToJava2D(low, area);
            g2.draw(new Line2D.Double(x2, y1, x2, y2));
            if (data[i].open < high) {
                double prevHigh;
                g2.draw(new Line2D.Double(x1, y2, x2, y2));
                if (!up && high > (prevHigh = data[i - 1].high)) {
                    g2.setColor(colors.getUpLineColor());
                    g2.draw(new Line2D.Double(x2, y1, x2, axis.valueToJava2D(prevHigh, area)));
                    up = true;
                }
            } else {
                double prevLow;
                g2.draw(new Line2D.Double(x1, y1, x2, y1));
                if (up && low < (prevLow = data[i - 1].low)) {
                    g2.setColor(colors.getDownLineColor());
                    g2.draw(new Line2D.Double(x2, this.axes[0].valueToJava2D(prevLow, this.areas[0]), x2, y2));
                    up = false;
                }
            }
            x1 = x2;
        }
    }

    private void drawSAR(Graphics2D g2) {
        Rectangle2D priceArea = this.areas[0];
        NumberAxis priceAxis = this.axes[0];
        UpDownColorType colors = this.settings.updownLineColors;
        double w = Math.min(20.0, this.itemWidth);
        Object originalStrokeControl = g2.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        for (int i = 0; i < this.period; ++i) {
            int n = this.start + i;
            if (n < 0 || n >= this.dataset.getCount() || this.dataset.techClose[n] == null || this.dataset.sar[n] == null) continue;
            double x1 = priceArea.getMinX() + (double)i * this.periodWidth + (this.periodWidth - w) * 0.5;
            double y = priceAxis.valueToJava2D(this.dataset.sar[n].doubleValue(), priceArea);
            double closeY = priceAxis.valueToJava2D(this.dataset.techClose[n].doubleValue(), priceArea);
            boolean down = closeY > y;
            g2.setColor(down ? colors.getDownLineColor() : colors.getUpLineColor());
            g2.drawOval((int)x1, (int)(y - w * 0.5), (int)w, (int)w);
        }
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, originalStrokeControl);
    }

    private void calculateVolumePriceHistogram() {
        Range range = this.vpPriceAxis.getRange();
        this.vpStep = (int)Math.ceil(range.getLength() * (100.0 / (double)this.settings.timeSeries.vpCount) / 100.0);
        this.vpLower = (int)Math.floor(range.getLower() / (double)this.vpStep * (double)this.vpStep);
        int count = (int)Math.floor((range.getUpper() - (double)this.vpLower) / (double)this.vpStep + 2.0);
        this.vp = new Number[count];
        for (int i = this.start; i < this.start + this.period; ++i) {
            if (i < 0 || i >= this.dataset.getCount() || this.dataset.close[i] == null) continue;
            int n = (int)Math.ceil((this.dataset.close[i].doubleValue() - (double)this.vpLower) / (double)this.vpStep);
            this.vp[n] = this.vp[n] == null ? (Number)this.dataset.volume[i] : (Number)(this.vp[n].doubleValue() + this.dataset.volume[i].doubleValue());
        }
        this.vpVolumeAxis.prepare(new Number[][]{this.vp});
        this.vpVolumeAxis.autoAdjustRange(0, this.vp.length);
    }

    private static enum CandlePattern {
        BEARISH,
        BULLISH;

    }
}

