/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.axis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 数値の目盛り単位情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public class NumberTickUnits {

	/**
	 * 目盛り単位情報のリストを保持します。
	 */
	private final List<NumberTickUnit> tickUnits = new ArrayList<NumberTickUnit>(31);

	/**
	 * デフォルトコンストラクタです。
	 */
	public NumberTickUnits() {
		this.tickUnits.add(new NumberTickUnit(          1));
		this.tickUnits.add(new NumberTickUnit(          2));
		this.tickUnits.add(new NumberTickUnit(          5));
		this.tickUnits.add(new NumberTickUnit(         10));
		this.tickUnits.add(new NumberTickUnit(         20));
		this.tickUnits.add(new NumberTickUnit(         50));
		this.tickUnits.add(new NumberTickUnit(        100));
		this.tickUnits.add(new NumberTickUnit(        200));
		this.tickUnits.add(new NumberTickUnit(        500));
		this.tickUnits.add(new NumberTickUnit(       1000));
		this.tickUnits.add(new NumberTickUnit(       2000));
		this.tickUnits.add(new NumberTickUnit(       5000));
		this.tickUnits.add(new NumberTickUnit(      10000));
		this.tickUnits.add(new NumberTickUnit(      20000));
		this.tickUnits.add(new NumberTickUnit(      50000));
		this.tickUnits.add(new NumberTickUnit(     100000));
		this.tickUnits.add(new NumberTickUnit(     200000));
		this.tickUnits.add(new NumberTickUnit(     500000));
		this.tickUnits.add(new NumberTickUnit(    1000000));
		this.tickUnits.add(new NumberTickUnit(    2000000));
		this.tickUnits.add(new NumberTickUnit(    5000000));
		this.tickUnits.add(new NumberTickUnit(   10000000));
		this.tickUnits.add(new NumberTickUnit(   20000000));
		this.tickUnits.add(new NumberTickUnit(   50000000));
		this.tickUnits.add(new NumberTickUnit(  100000000));
		this.tickUnits.add(new NumberTickUnit(  200000000));
		this.tickUnits.add(new NumberTickUnit(  500000000));
		this.tickUnits.add(new NumberTickUnit( 1000000000));
		this.tickUnits.add(new NumberTickUnit( 2000000000));
		this.tickUnits.add(new NumberTickUnit( 5000000000L));
		this.tickUnits.add(new NumberTickUnit(10000000000L));
        Collections.sort(this.tickUnits);
	}

	public NumberTickUnit getCeilingTickUnit(final NumberTickUnit unit) {
		int index = Collections.binarySearch(this.tickUnits, unit);
		if (index >= 0)
			return this.tickUnits.get(index);

		index = -(index + 1);
		return this.tickUnits.get(Math.min(index, this.tickUnits.size() - 1));
    }

	public NumberTickUnit getCeilingTickUnit(final double size) {
		return getCeilingTickUnit(new NumberTickUnit(size));
	}

}
