/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.data;

import java.util.Date;
import java.util.List;

import jp.sf.orangesignal.ta.Step;
import jp.sf.orangesignal.ta.util.Assert;

/**
 * 非時系列データセットを提供します。
 * 
 * @author 杉澤 浩二
 */
public class StepChartDataset implements ChartDataset {

	/**
	 * 開始日の配列を保持します。
	 */
	public Date[] startDate;

	/**
	 * 開始日価格の配列を保持します。
	 */
	public Number[] start;

	/**
	 * 高値日の配列を保持します。
	 */
	public Date[] highDate;

	/**
	 * 高値の配列を保持します。
	 */
	public Number[] high;

	/**
	 * 安値日の配列を保持します。
	 */
	public Date[] lowDate;

	/**
	 * 安値の配列を保持します。
	 */
	public Number[] low;

	/**
	 * 終了日の配列を保持します。
	 */
	public Date[] endDate;

	/**
	 * 終了日価格の配列を保持します。
	 */
	public Number[] end;

	/**
	 * 期間を保持します。
	 */
	public int[] period;

	/**
	 * 値幅を保持します。
	 */
	public double point;

	/**
	 * コンストラクタです。
	 * 
	 * @param list 値幅情報のリスト
	 */
	public StepChartDataset(final List<Step> list) {
		this(list, 0);
	}

	/**
	 * コンストラクタです。
	 * 
	 * @param list 値幅情報のリスト
	 * @param point ポイント＆フィギュアのポイント
	 */
	public StepChartDataset(final List<Step> list, final double point) {
		Assert.notNull(list, "Step list must not be null");
		Assert.isTrue(point >= 0);

		final int length = list.size();//Math.max(list.size(), 1);
		startDate = new Date[length];
		start = new Number[length];
		highDate = new Date[length];
		high = new Number[length];
		lowDate = new Date[length];
		low = new Number[length];
		endDate = new Date[length];
		end = new Number[length];
		period = new int[length];

		for (int i = 0; i < list.size(); i++) {
			final Step step = list.get(i);
			startDate[i] = step.openDate;
			start[i] = step.open;
			highDate[i] = step.highDate;
			high[i] = step.high;
			lowDate[i] = step.lowDate;
			low[i] = step.low;
			endDate[i] = step.closeDate;
			end[i] = step.close;
			period[i] = step.period;
		}

		this.point = point;
	}

	@Override public int getCount() { return startDate == null ? 0 : startDate.length; }

}
