/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui.screen;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.ChartSettings.TimeSeriesSettings;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.event.ChartScreenEvent;
import jp.sf.orangesignal.chart.ui.BandType;
import jp.sf.orangesignal.chart.ui.PriceChartType;
import jp.sf.orangesignal.chart.ui.MAType;
import jp.sf.orangesignal.chart.ui.PeriodType;
import jp.sf.orangesignal.chart.ui.PriceScaleType;
import jp.sf.orangesignal.chart.ui.ChartScreenType;
import jp.sf.orangesignal.chart.ui.VolumeType;
import jp.sf.orangesignal.chart.util.StringManager;

/**
 * 分析タブの画面を提供します。
 * 
 * @author 杉澤 浩二
 */
public class Analysis extends SideScreen {

	private static final long serialVersionUID = 4236992178578098729L;

	private static final String SIGNAL_MARK = StringManager.getString("marker.signal.mark");

	// 表示設定
	private final JCheckBox signalMarker = new JCheckBox(StringManager.getString("marker.signal") + StringManager.getString("marker.signal.desc"));
	private final JCheckBox splitMarker = new JCheckBox(StringManager.getString("marker.split"));

	private final JCheckBox fixed = new JCheckBox(StringManager.getString("fixed"));
	private final JComboBox scale = new JComboBox(PriceScaleType.values());
	private final JComboBox chartType = new JComboBox(PriceChartType.values());

	private final Map<JCheckBox, JPanel> paramPanels = new HashMap<JCheckBox, JPanel>();

	private final JCheckBox avgprice = new JCheckBox(StringManager.getString("avgprice"));
	private final JCheckBox mp = new JCheckBox(StringManager.getString("mp"));
	// ティピカル・プライス
	private final JCheckBox tp = new JCheckBox(StringManager.getString("tp"));
	// 加重終値
	private final JCheckBox wc = new JCheckBox(StringManager.getString("wc"));

	// 出来高
	private final JComboBox volumeType = new JComboBox(VolumeType.values());
	private final Map<VolumeType, JPanel> volumeParamPanels = new HashMap<VolumeType, JPanel>();

	// 出来高移動平均
	private final JComboBox vmaMaType = createMovingAverageJComboBox();
	private final JSpinner vma1Period = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	private final JSpinner vma2Period = new JSpinner(new SpinnerNumberModel(75, 1, 200, 1));

	// 線形回帰トレンド
	private final JCheckBox lr = new JCheckBox(StringManager.getString("lr"));
	private final JSpinner lr1Period = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	private final JSpinner lr2Period = new JSpinner(new SpinnerNumberModel(75, 1, 200, 1));
	// 時系列カギ足
	private final JCheckBox kagi = new JCheckBox(StringManager.getString("screen.kagi"));
	private final JSpinner kagi_rate = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));
	// ZigZag
	private final JCheckBox zigzag = new JCheckBox(StringManager.getString("zigzag"));
	private final JSpinner zigzag_rate = new JSpinner(new SpinnerNumberModel(1, 1, 100, 1));

	// MA (移動平均線)
	private final JCheckBox ma = new JCheckBox(StringManager.getString("ma") + SIGNAL_MARK);
	private final JComboBox maType = createMovingAverageJComboBox();
	private final JSpinner ma1Period = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	private final JSpinner ma2Period = new JSpinner(new SpinnerNumberModel(75, 1, 200, 1));

	// バンド系
	private final JComboBox bandType = new JComboBox(BandType.values());
	private final Map<BandType, JPanel> bandParamPanels = new HashMap<BandType, JPanel>();

	// ボリンジャーバンド
	private final JSpinner bbPeriod = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	// ドンチャンズ
	private final JSpinner donchianPeriod = new JSpinner(new SpinnerNumberModel(20, 1, 200, 1));
	// エンベロープ
	private final JComboBox envelopeMaType = createMovingAverageJComboBox();
	private final JSpinner envelopePeriod = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	private final JSpinner envelopeRate = new JSpinner(new SpinnerNumberModel(5, 1, 100, 1));
	// チャネルシステム
	private final JComboBox hlmaMaType = createMovingAverageJComboBox();
	private final JSpinner hmaPeriod = new JSpinner(new SpinnerNumberModel(10, 1, 200, 1));
	private final JSpinner lmaPeriod = new JSpinner(new SpinnerNumberModel(10, 1, 200, 1));
	// 一目均衡表
	private final JSpinner kijunPeriod = new JSpinner(new SpinnerNumberModel(26, 1, 200, 1));
	private final JSpinner tenkanPeriod = new JSpinner(new SpinnerNumberModel(9, 1, 200, 1));
	private final JSpinner spanPeriod = new JSpinner(new SpinnerNumberModel(26, 1, 200, 1));
	// ボラティリティ・システム
	private final JSpinner atrPeriod = new JSpinner(new SpinnerNumberModel(5, 1, 200, 1));
	private final JSpinner atrWeight = new JSpinner(new SpinnerNumberModel(2.0, 0.1, 10.0, 0.1));

	// アルーン
	private final JCheckBox aroon = new JCheckBox(StringManager.getString("aroon"));
	private final JSpinner aroonPeriod = new JSpinner(new SpinnerNumberModel(14, 1, 200, 1));

	// ATR
	private final JCheckBox atr = new JCheckBox(StringManager.getString("atr"));
	private final JSpinner atr_period = new JSpinner(new SpinnerNumberModel(14, 1, 200, 1));
	private final JCheckBox natr = new JCheckBox(StringManager.getString("natr"));
	private final JSpinner natr_period = new JSpinner(new SpinnerNumberModel(14, 1, 200, 1));

	// BMP
	private final JCheckBox bmp = new JCheckBox(StringManager.getString("bmp"));

	// CCI
	private final JCheckBox cci = new JCheckBox(StringManager.getString("cci") + SIGNAL_MARK);
	private final JSpinner cciPeriod = new JSpinner(new SpinnerNumberModel(20, 1, 200, 1));
	private final JSpinner cciUpperSignal = new JSpinner(new SpinnerNumberModel(100, 100, 100, 1));
	private final JSpinner cciLowerSignal = new JSpinner(new SpinnerNumberModel(-100, -100, -100, 1));

	// チャイキンズ・ボラィリティ
	private final JCheckBox chv = new JCheckBox(StringManager.getString("cv"));
	private final JSpinner chv_period1 = new JSpinner(new SpinnerNumberModel(10, 1, 200, 1));
	private final JSpinner chv_period2 = new JSpinner(new SpinnerNumberModel(10, 1, 200, 1));

	// チャイキンズ・マネー・フロー
	private final JCheckBox cmf = new JCheckBox(StringManager.getString("cmf"));
	private final JSpinner cmf_period = new JSpinner(new SpinnerNumberModel(21, 1, 200, 1));

	// CMO
	private final JCheckBox cmo = new JCheckBox(StringManager.getString("cmo") + SIGNAL_MARK);
	private final JSpinner cmo_period = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	private final JSpinner cmo_upper_signal = new JSpinner(new SpinnerNumberModel(50, 0, 100, 1));
	private final JSpinner cmo_lower_signal = new JSpinner(new SpinnerNumberModel(-50, -100, 0, 1));

	// コポック買い指標
	private final JCheckBox coppock = new JCheckBox(StringManager.getString("coppock"));
	private final JSpinner coppockRocPeriod = new JSpinner(new SpinnerNumberModel(12, 1, 200, 1));
	private final JComboBox coppockMaType = createMovingAverageJComboBox();
	private final JSpinner coppockPeriod = new JSpinner(new SpinnerNumberModel(10, 1, 200, 1));

	// DPO
	private final JCheckBox dpo = new JCheckBox(StringManager.getString("dpo"));
	private final JComboBox dpoMaType = createMovingAverageJComboBox();
	private final JSpinner dpoPeriod = new JSpinner(new SpinnerNumberModel(10, 2, 200, 2));

	// DMI
	private final JCheckBox dmi = new JCheckBox(StringManager.getString("dmi"));
	private final JSpinner diPeriod = new JSpinner(new SpinnerNumberModel(14, 1, 200, 1));
	private final JSpinner adxPeriod = new JSpinner(new SpinnerNumberModel(9, 1, 200, 1));

	// EMV
	private final JCheckBox emv = new JCheckBox(StringManager.getString("emv"));
	private final JSpinner emv_period = new JSpinner(new SpinnerNumberModel(1, 1, 200, 1));

	// ヒストリカル・ボラティリティ
	private final JCheckBox hv = new JCheckBox(StringManager.getString("hv"));
	private final JSpinner hvPeriod = new JSpinner(new SpinnerNumberModel(20, 1, 200, 1));

	// 移動平均乖離率
	private final JCheckBox kairi = new JCheckBox(StringManager.getString("bias") + SIGNAL_MARK);
	private final JComboBox biasMaType = createMovingAverageJComboBox();
	private final JSpinner biasPeriod = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	private final JSpinner biasUpperSignal = new JSpinner(new SpinnerNumberModel(10, 0, 100, 1));
	private final JSpinner biasLowerSignal = new JSpinner(new SpinnerNumberModel(-10, -100, 0, 1));

	// マス・インデックス(MI)
	private final JCheckBox mi = new JCheckBox(StringManager.getString("mi"));
	private final JComboBox miMaType = createMovingAverageJComboBox();
	private final JSpinner miMaPeriod = new JSpinner(new SpinnerNumberModel(9, 1, 200, 1));
	private final JSpinner miSumPeriod = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));

	// モメンタム
	private final JCheckBox mom = new JCheckBox(StringManager.getString("momentum"));
	private final JSpinner mom_period = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));

	// MFI
	private final JCheckBox mfi = new JCheckBox(StringManager.getString("mfi") + SIGNAL_MARK);
	private final JSpinner mfiPeriod = new JSpinner(new SpinnerNumberModel(18, 1, 200, 1));
	private final JSpinner mfiUpperSignal = new JSpinner(new SpinnerNumberModel(80, 50, 100, 1));
	private final JSpinner mfiLowerSignal = new JSpinner(new SpinnerNumberModel(20, 0, 50, 1));

	// MACD
	private final JCheckBox macd = new JCheckBox(StringManager.getString("macd"));
	private final JSpinner macdMa1Period = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	private final JSpinner macdMa2Period = new JSpinner(new SpinnerNumberModel(75, 1, 200, 1));
	private final JComboBox macdSignalMaType = createMovingAverageJComboBox();
	private final JSpinner macdSignalPeriod = new JSpinner(new SpinnerNumberModel(9, 1, 200, 1));

	// PAIN
	private final JCheckBox pain = new JCheckBox(StringManager.getString("pain"));

	// PCR
	private final JCheckBox pcr = new JCheckBox(StringManager.getString("pcr") + SIGNAL_MARK);
	private final JSpinner pcr_period = new JSpinner(new SpinnerNumberModel(9, 1, 200, 1));
	private final JSpinner pcr_upper_signal = new JSpinner(new SpinnerNumberModel(-20, -50, 0, 1));
	private final JSpinner pcr_lower_signal = new JSpinner(new SpinnerNumberModel(-80, -100, -50, 1));

	// プライス・オシレータ(APO)
	private final JCheckBox apo = new JCheckBox(StringManager.getString("apo"));
	private final JSpinner apoMa1Period = new JSpinner(new SpinnerNumberModel(10, 1, 200, 1));
	private final JSpinner apoMa2Period = new JSpinner(new SpinnerNumberModel(30, 1, 200, 1));

	// プライス・オシレータ(PPO)
	private final JCheckBox ppo = new JCheckBox(StringManager.getString("ppo"));
	private final JSpinner ppoMa1Period = new JSpinner(new SpinnerNumberModel(10, 1, 200, 1));
	private final JSpinner ppoMa2Period = new JSpinner(new SpinnerNumberModel(30, 1, 200, 1));

	// サイコロジカル・ライン
	private final JCheckBox psy = new JCheckBox(StringManager.getString("psychological") + SIGNAL_MARK);
	private final JSpinner psy_period = new JSpinner(new SpinnerNumberModel(12, 1, 200, 1));
	private final JSpinner psy_upper_signal = new JSpinner(new SpinnerNumberModel(75, 50, 100, 1));
	private final JSpinner psy_lower_signal = new JSpinner(new SpinnerNumberModel(25, 0, 50, 1));

	// Qstick
	private final JCheckBox qstick = new JCheckBox(StringManager.getString("qstick"));
	private final JComboBox qstick_matype = createMovingAverageJComboBox();
	private final JSpinner qstick_period = new JSpinner(new SpinnerNumberModel(8, 1, 200, 1));

	// RCI (順位相関指数)
	private final JCheckBox rci = new JCheckBox(StringManager.getString("rci") + SIGNAL_MARK);
	private final JSpinner rciPeriod = new JSpinner(new SpinnerNumberModel(9, 2, 200, 1));
	private final JSpinner rciUpperSignal = new JSpinner(new SpinnerNumberModel(80, 0, 100, 1));
	private final JSpinner rciLowerSignal = new JSpinner(new SpinnerNumberModel(-80, -100, 0, 1));

	// ROC
	private final JCheckBox roc = new JCheckBox(StringManager.getString("roc"));
	private final JSpinner rocPeriod = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));

	// RSI (相対力指数)
	private final JCheckBox rsi = new JCheckBox(StringManager.getString("rsi") + SIGNAL_MARK);
	private final JSpinner rsiPeriod = new JSpinner(new SpinnerNumberModel(14, 1, 200, 1));
	private final JSpinner rsiUpperSignal = new JSpinner(new SpinnerNumberModel(75, 50, 100, 1));
	private final JSpinner rsiLowerSignal = new JSpinner(new SpinnerNumberModel(25, 0, 50, 1));

	// RVI (相対変動指数)
	private final JCheckBox rvi = new JCheckBox(StringManager.getString("rvi"));
	private final JSpinner rvi_period = new JSpinner(new SpinnerNumberModel(14, 1, 200, 1));
	private final JSpinner rvi_upper_signal = new JSpinner(new SpinnerNumberModel(70, 50, 100, 1));
	private final JSpinner rvi_lower_signal = new JSpinner(new SpinnerNumberModel(30, 0, 50, 1));

	// 強弱レシオ(篠原レシオ)
	private final JCheckBox shinohara = new JCheckBox(StringManager.getString("shinohara"));
	private final JSpinner shinoharaPeriod = new JSpinner(new SpinnerNumberModel(20, 1, 200, 1));

	// ストキャスティクス
	private final JCheckBox srv = new JCheckBox(StringManager.getString("srv.fast") + SIGNAL_MARK);
	private final JSpinner srvKPeriod = new JSpinner(new SpinnerNumberModel(9, 1, 200, 1));
	private final JSpinner srvDPeriod = new JSpinner(new SpinnerNumberModel(3, 1, 200, 1));
	private final JSpinner srvUpperSignal = new JSpinner(new SpinnerNumberModel(70, 50, 100, 1));
	private final JSpinner srvLowerSignal = new JSpinner(new SpinnerNumberModel(30, 0, 50, 1));

	// TII
	private final JCheckBox tii = new JCheckBox(StringManager.getString("tii") + SIGNAL_MARK);
	private final JComboBox tii_matype = createMovingAverageJComboBox();
	private final JSpinner tii_period = new JSpinner(new SpinnerNumberModel(30, 1, 200, 1));
	private final JSpinner tii_upper_signal = new JSpinner(new SpinnerNumberModel(80, 50, 100, 1));
	private final JSpinner tii_lower_signal = new JSpinner(new SpinnerNumberModel(20, 0, 50, 1));

	// トリックス(Trix)
	private final JCheckBox trix = new JCheckBox(StringManager.getString("trix"));
	private final JSpinner trixPeriod = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	private final JComboBox trixSignalMaType = createMovingAverageJComboBox();
	private final JSpinner trixSignalPeriod = new JSpinner(new SpinnerNumberModel(9, 1, 200, 1));

	// TSI
	private final JCheckBox tsi = new JCheckBox(StringManager.getString("tsi") + SIGNAL_MARK);
	private final JSpinner tsi_period1 = new JSpinner(new SpinnerNumberModel(13, 1, 200, 1));
	private final JSpinner tsi_period2 = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	private final JComboBox tsi_signal_matype = createMovingAverageJComboBox();
	private final JSpinner tsi_signal_period = new JSpinner(new SpinnerNumberModel(7, 1, 200, 1));
	private final JSpinner tsi_upper_signal = new JSpinner(new SpinnerNumberModel(25, 0, 100, 1));
	private final JSpinner tsi_lower_signal = new JSpinner(new SpinnerNumberModel(-25, -100, 0, 1));

	// 究極のオシレーター
	private final JCheckBox ultimate = new JCheckBox(StringManager.getString("ultimate"));
	private final JSpinner ultimatePeriod = new JSpinner(new SpinnerNumberModel(20, 1, 200, 1));

	// ウィリアムズAD
	private final JCheckBox wad = new JCheckBox(StringManager.getString("wad"));

	// ウィリアムズ%R
	private final JCheckBox williamsR = new JCheckBox(StringManager.getString("williamsr") + SIGNAL_MARK);
	private final JSpinner williamsRPeriod = new JSpinner(new SpinnerNumberModel(20, 1, 200, 1));
	private final JSpinner williamsRUpperSignal = new JSpinner(new SpinnerNumberModel(-20, -50, 0, 1));
	private final JSpinner williamsRLowerSignal = new JSpinner(new SpinnerNumberModel(-80, -100, -50, 1));

	// A/Dライン
	private final JCheckBox ad = new JCheckBox(StringManager.getString("ad"));

	// チャイキンズA/Dオシレーター
	private final JCheckBox cho = new JCheckBox(StringManager.getString("cho"));
	private final JComboBox cho_matype = createMovingAverageJComboBox();
	private final JSpinner cho_fast = new JSpinner(new SpinnerNumberModel(3, 1, 200, 1));
	private final JSpinner cho_slow = new JSpinner(new SpinnerNumberModel(10, 1, 200, 1));

	// ボリューム・オシレータ(AVO)
	private final JCheckBox avo = new JCheckBox(StringManager.getString("avo"));
	private final JSpinner avoMa1Period = new JSpinner(new SpinnerNumberModel(10, 1, 200, 1));
	private final JSpinner avoMa2Period = new JSpinner(new SpinnerNumberModel(30, 1, 200, 1));

	// ボリューム・オシレータ(PVO)
	private final JCheckBox pvo = new JCheckBox(StringManager.getString("pvo"));
	private final JSpinner pvoMa1Period = new JSpinner(new SpinnerNumberModel(10, 1, 200, 1));
	private final JSpinner pvoMa2Period = new JSpinner(new SpinnerNumberModel(30, 1, 200, 1));

	// 出来高乖離率
	private final JCheckBox vkairi = new JCheckBox(StringManager.getString("vbias"));
	private final JComboBox vkairiMaType = createMovingAverageJComboBox();
	private final JSpinner vkairiPeriod = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));

	// VR1
	private final JCheckBox vr1 = new JCheckBox(StringManager.getString("vr1") + SIGNAL_MARK);
	private final JSpinner vr1Period = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	private final JSpinner vr1UpperSignal = new JSpinner(new SpinnerNumberModel(450, 150, 600, 1));
	private final JSpinner vr1LowerSignal = new JSpinner(new SpinnerNumberModel(70, 0, 150, 1));

	// VR2
	private final JCheckBox vr2 = new JCheckBox(StringManager.getString("vr2") + SIGNAL_MARK);
	private final JSpinner vr2Period = new JSpinner(new SpinnerNumberModel(14, 1, 200, 1));
	private final JSpinner vr2UpperSignal = new JSpinner(new SpinnerNumberModel(70, 50, 100, 1));
	private final JSpinner vr2LowerSignal = new JSpinner(new SpinnerNumberModel(30, 0, 50, 1));

	// 出来高ROC
	private final JCheckBox vroc = new JCheckBox(StringManager.getString("vroc"));
	private final JSpinner vrocPeriod = new JSpinner(new SpinnerNumberModel(30, 1, 200, 1));

	// V-RSI (出来高相対力指数)
	private final JCheckBox vrsi = new JCheckBox(StringManager.getString("vrsi") + SIGNAL_MARK);
	private final JSpinner vrsiPeriod = new JSpinner(new SpinnerNumberModel(14, 1, 200, 1));
	private final JSpinner vrsiUpperSignal = new JSpinner(new SpinnerNumberModel(75, 50, 100, 1));
	private final JSpinner vrsiLowerSignal = new JSpinner(new SpinnerNumberModel(25, 0, 50, 1));

	// WVR
	private final JCheckBox wvr = new JCheckBox(StringManager.getString("wvr") + SIGNAL_MARK);
	private final JSpinner wvrPeriod = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));
	private final JSpinner wvrUpperSignal = new JSpinner(new SpinnerNumberModel(60, 0, 100, 1));
	private final JSpinner wvrLowerSignal = new JSpinner(new SpinnerNumberModel(-60, -100, 0, 1));

	// PVI
	private final JCheckBox pvi = new JCheckBox(StringManager.getString("pvi"));
	private final JComboBox pvi_matype = createMovingAverageJComboBox();
	private final JSpinner pvi_fast = new JSpinner(new SpinnerNumberModel(9, 1, 200, 1));
	private final JSpinner pvi_slow = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));

	// PVI
	private final JCheckBox nvi = new JCheckBox(StringManager.getString("nvi"));
	private final JComboBox nvi_matype = createMovingAverageJComboBox();
	private final JSpinner nvi_fast = new JSpinner(new SpinnerNumberModel(9, 1, 200, 1));
	private final JSpinner nvi_slow = new JSpinner(new SpinnerNumberModel(25, 1, 200, 1));

	// OBV
	private final JCheckBox obv = new JCheckBox(StringManager.getString("obv"));
	private final JSpinner obvPeriod = new JSpinner(new SpinnerNumberModel(75, 1, 200, 1));

	// PVT
	private final JCheckBox pvt = new JCheckBox(StringManager.getString("pvt"));

	// 価格帯別出来高
	private final JCheckBox vp = new JCheckBox(StringManager.getString("vp"));
	private final JSpinner vpCount = new JSpinner(new SpinnerNumberModel(20, 10, 100, 1));

	// 信用倍率
	private final JCheckBox ratio = new JCheckBox(StringManager.getString("ratio") + SIGNAL_MARK);
	private final JSpinner ratioUpperSignal = new JSpinner(new SpinnerNumberModel(10.0, 5.0, 1000.0, 0.1));
	private final JSpinner ratioLowerSignal = new JSpinner(new SpinnerNumberModel(1.0, 0.1, 5.0, 0.1));

	// 騰落価格
	private final JCheckBox priceFluctuations = new JCheckBox(StringManager.getString("fluctuations.price"));
	private final JComboBox priceFluctuationsPeriodType = new JComboBox(PeriodType.values());

	// 騰落率
	private final JCheckBox fluctuations = new JCheckBox(StringManager.getString("fluctuations"));
	private final JComboBox fluctuationsPeriodType = new JComboBox(PeriodType.values());

	// ローソク足パターン
	private final JComboBox candlestickTrend = new JComboBox(new ChartScreenType[] { ChartScreenType.NONE, ChartScreenType.POINT_AND_FIGURE, ChartScreenType.KAGI, ChartScreenType.RENKOH, ChartScreenType.SHINNE });
	private final JCheckBox bullishLongWhiteDay = new JCheckBox(StringManager.getString("bullishLongWhiteDay"));
	private final JCheckBox bullishBeltHold = new JCheckBox(StringManager.getString("bullishBeltHold"));
	private final JCheckBox bullishHammer = new JCheckBox(StringManager.getString("bullishHammer"));
	private final JCheckBox bullishDragonflyDoji = new JCheckBox(StringManager.getString("bullishDragonflyDoji"));
	private final JCheckBox bullishLongLeggedDoji = new JCheckBox(StringManager.getString("bullishLongLeggedDoji"));
	private final JCheckBox bullishInvertedHammer = new JCheckBox(StringManager.getString("bullishInvertedHammer"));
	private final JCheckBox bullishHarami = new JCheckBox(StringManager.getString("bullishHarami"));
	private final JCheckBox bullishHaramiCross = new JCheckBox(StringManager.getString("bullishHaramiCross"));
	private final JCheckBox bullishEngulfing = new JCheckBox(StringManager.getString("bullishEngulfing"));
	private final JCheckBox bullishGravestoneDoji = new JCheckBox(StringManager.getString("bullishGravestoneDoji"));
	private final JCheckBox bullishMeetingLines = new JCheckBox(StringManager.getString("bullishMeetingLines"));
	private final JCheckBox bullishDojiStar = new JCheckBox(StringManager.getString("bullishDojiStar"));
	private final JCheckBox bullishHomingPigeon = new JCheckBox(StringManager.getString("bullishHomingPigeon"));
	private final JCheckBox bullishMatchingLow = new JCheckBox(StringManager.getString("bullishMatchingLow"));
	private final JCheckBox bullishTweezerBottom = new JCheckBox(StringManager.getString("bullishTweezerBottom"));
	private final JCheckBox bullishKicking = new JCheckBox(StringManager.getString("bullishKicking"));
	private final JCheckBox bullishPiercingLine = new JCheckBox(StringManager.getString("bullishPiercingLine"));
	private final JCheckBox bullishSeparatingLines = new JCheckBox(StringManager.getString("bullishSeparatingLines"));
	private final JCheckBox bullishTriStar = new JCheckBox(StringManager.getString("bullishTriStar"));
	private final JCheckBox bullishThreeStarsInTheSouth = new JCheckBox(StringManager.getString("bullishThreeStarsInTheSouth"));
	private final JCheckBox bullishUniqueThreeRiverBottom = new JCheckBox(StringManager.getString("bullishUniqueThreeRiverBottom"));
	private final JCheckBox bullishStickSandwich = new JCheckBox(StringManager.getString("bullishStickSandwich"));
	private final JCheckBox bullishAbandonedBaby = new JCheckBox(StringManager.getString("bullishAbandonedBaby"));
	private final JCheckBox bullishMorningDojiStar = new JCheckBox(StringManager.getString("bullishMorningDojiStar"));
	private final JCheckBox bullishMorningStar = new JCheckBox(StringManager.getString("bullishMorningStar"));
	private final JCheckBox bullishThreeOutsideUp = new JCheckBox(StringManager.getString("bullishThreeOutsideUp"));
	private final JCheckBox bullishThreeInsideUp = new JCheckBox(StringManager.getString("bullishThreeInsideUp"));
	private final JCheckBox bullishThreeWhiteSoldiers = new JCheckBox(StringManager.getString("bullishThreeWhiteSoldiers"));
	private final JCheckBox bullishUpsideTasukiGap = new JCheckBox(StringManager.getString("bullishUpsideTasukiGap"));
	private final JCheckBox bullishUpsideGapThreeMethods = new JCheckBox(StringManager.getString("bullishUpsideGapThreeMethods"));
	private final JCheckBox bullishSideBySideWhiteLines = new JCheckBox(StringManager.getString("bullishSideBySideWhiteLines"));
	private final JCheckBox bullishConcealingBabySwallow = new JCheckBox(StringManager.getString("bullishConcealingBabySwallow"));
	private final JCheckBox bullishThreeLineStrike = new JCheckBox(StringManager.getString("bullishThreeLineStrike"));
	private final JCheckBox bullishThreeGaps = new JCheckBox(StringManager.getString("bullishThreeGaps"));
	private final JCheckBox bullishBreakaway = new JCheckBox(StringManager.getString("bullishBreakaway"));
	private final JCheckBox bullishLadderBottom = new JCheckBox(StringManager.getString("bullishLadderBottom"));
	private final JCheckBox bullishRisingThreeMethods = new JCheckBox(StringManager.getString("bullishRisingThreeMethods"));
	private final JCheckBox bullishMatHold = new JCheckBox(StringManager.getString("bullishMatHold"));

	private final JCheckBox bearishLongBlackDay = new JCheckBox(StringManager.getString("bearishLongBlackDay"));
	private final JCheckBox bearishBeltHold = new JCheckBox(StringManager.getString("bearishBeltHold"));
	private final JCheckBox bearishHangingMan = new JCheckBox(StringManager.getString("bearishHangingMan"));
	private final JCheckBox bearishDragonflyDoji = new JCheckBox(StringManager.getString("bearishDragonflyDoji"));
	private final JCheckBox bearishLongLeggedDoji = new JCheckBox(StringManager.getString("bearishLongLeggedDoji"));
	private final JCheckBox bearishShootingStar = new JCheckBox(StringManager.getString("bearishShootingStar"));
	private final JCheckBox bearishHarami = new JCheckBox(StringManager.getString("bearishHarami"));
	private final JCheckBox bearishHaramiCross = new JCheckBox(StringManager.getString("bearishHaramiCross"));
	private final JCheckBox bearishEngulfing = new JCheckBox(StringManager.getString("bearishEngulfing"));
	private final JCheckBox bearishGravestoneDoji = new JCheckBox(StringManager.getString("bearishGravestoneDoji"));
	private final JCheckBox bearishMeetingLines = new JCheckBox(StringManager.getString("bearishMeetingLines"));
	private final JCheckBox bearishDojiStar = new JCheckBox(StringManager.getString("bearishDojiStar"));
	private final JCheckBox bearishDescendingHawk = new JCheckBox(StringManager.getString("bearishDescendingHawk"));
	private final JCheckBox bearishMatchingHigh = new JCheckBox(StringManager.getString("bearishMatchingHigh"));
	private final JCheckBox bearishTweezerTop = new JCheckBox(StringManager.getString("bearishTweezerTop"));
	private final JCheckBox bearishKicking = new JCheckBox(StringManager.getString("bearishKicking"));
	private final JCheckBox bearishDarkCloudCover = new JCheckBox(StringManager.getString("bearishDarkCloudCover"));
	private final JCheckBox bearishSeparatingLines = new JCheckBox(StringManager.getString("bearishSeparatingLines"));
	private final JCheckBox bearishThrusting = new JCheckBox(StringManager.getString("bearishThrusting"));
	private final JCheckBox bearishOnNeck = new JCheckBox(StringManager.getString("bearishOnNeck"));
	private final JCheckBox bearishInNeck = new JCheckBox(StringManager.getString("bearishInNeck"));
	private final JCheckBox bearishTriStar = new JCheckBox(StringManager.getString("bearishTriStar"));
	private final JCheckBox bearishTwoCrows = new JCheckBox(StringManager.getString("bearishTwoCrows"));
	private final JCheckBox bearishAdvanceBlock = new JCheckBox(StringManager.getString("bearishAdvanceBlock"));
	private final JCheckBox bearishDeliberation = new JCheckBox(StringManager.getString("bearishDeliberation"));
	private final JCheckBox bearishAbandonedBaby = new JCheckBox(StringManager.getString("bearishAbandonedBaby"));
	private final JCheckBox bearishEveningDojiStar = new JCheckBox(StringManager.getString("bearishEveningDojiStar"));
	private final JCheckBox bearishEveningStar = new JCheckBox(StringManager.getString("bearishEveningStar"));
	private final JCheckBox bearishThreeOutsideDown = new JCheckBox(StringManager.getString("bearishThreeOutsideDown"));
	private final JCheckBox bearishThreeInsideDown = new JCheckBox(StringManager.getString("bearishThreeInsideDown"));
	private final JCheckBox bearishUpsideGapTwoCrows = new JCheckBox(StringManager.getString("bearishUpsideGapTwoCrows"));
	private final JCheckBox bearishThreeBlackCrows = new JCheckBox(StringManager.getString("bearishThreeBlackCrows"));
	private final JCheckBox bearishIdenticalThreeCrows = new JCheckBox(StringManager.getString("bearishIdenticalThreeCrows"));
	private final JCheckBox bearishDownsideTasukiGap = new JCheckBox(StringManager.getString("bearishDownsideTasukiGap"));
	private final JCheckBox bearishDownsideGapThreeMethods = new JCheckBox(StringManager.getString("bearishDownsideGapThreeMethods"));
	private final JCheckBox bearishSideBySideWhiteLines = new JCheckBox(StringManager.getString("bearishSideBySideWhiteLines"));
	private final JCheckBox bearishThreeLineStrike = new JCheckBox(StringManager.getString("bearishThreeLineStrike"));
	private final JCheckBox bearishThreeGaps = new JCheckBox(StringManager.getString("bearishThreeGaps"));
	private final JCheckBox bearishBreakaway = new JCheckBox(StringManager.getString("bearishBreakaway"));
	private final JCheckBox bearishFallingThreeMethods = new JCheckBox(StringManager.getString("bearishFallingThreeMethods"));

	// ----------------------------------------

	/**
	 * デフォルトコンストラクタです。
	 */
	public Analysis() {
		// レイアウトを処理します。
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		setLayout(layout);

		int y = 0;

		// [表示設定]
		addLabel(layout, c, y++, new JLabel(StringManager.getString("label.view")));
		addCheckBox(layout, c, y++, signalMarker);
		addCheckBox(layout, c, y++, splitMarker);
		splitMarker.setVisible(false);

		// [価格]
		addSeparator(layout, c, y++);
		addLabel(layout, c, y++, new JLabel(StringManager.getString("label.price")));
		addCheckBox(layout, c, y++, this.fixed);
		addComboBox(layout, c, y++, new JLabel(StringManager.getString("scale")), this.scale);
		addComboBox(layout, c, y++, new JLabel(StringManager.getString("chart")), this.chartType);


		addCheckBox(layout, c, y++, this.avgprice);
		addCheckBox(layout, c, y++, this.mp);
		// ティピカル・プライス
		addCheckBox(layout, c, y++, this.tp);
		// 加重終値
		addCheckBox(layout, c, y++, this.wc);

		// [出来高分析]
		addSeparator(layout, c, y++);
		addLabel(layout, c, y++, new JLabel(StringManager.getString("label.volume")));
		addComboBox(layout, c, y++, new JLabel(StringManager.getString("volume")), this.volumeType);

		// 出来高移動平均
		final JPanel vmaPanel = createVolumeMovingAveragePanel();
		addPanel(layout, c, y++, vmaPanel);
		this.volumeParamPanels.put(VolumeType.MOVING_AVERAGE, vmaPanel);

		// [トレンド系]
		addSeparator(layout, c, y++);
		addLabel(layout, c, y++, new JLabel(StringManager.getString("label.trend")));

		// 線形回帰トレンド
		addCheckBox(layout, c, y++, this.lr);
		final JPanel lrPanel = createLinearRegressionPanel();
		addPanel(layout, c, y++, lrPanel);
		this.paramPanels.put(this.lr, lrPanel);
		// 時系列カギ足
		addCheckBox(layout, c, y++, kagi);
		final JPanel kagiPanel = createKagiAshiPanel();
		addPanel(layout, c, y++, kagiPanel);
		paramPanels.put(kagi, kagiPanel);
		// Zig Zag
		addCheckBox(layout, c, y++, zigzag);
		final JPanel zigzagPanel = createZigZagPanel();
		addPanel(layout, c, y++, zigzagPanel);
		paramPanels.put(zigzag, zigzagPanel);

		// 移動平均線
		addCheckBox(layout, c, y++, this.ma);
		final JPanel maPanel = createMovingAveragePanel();
		addPanel(layout, c, y++, maPanel);
		this.paramPanels.put(this.ma, maPanel);

		// バンド系
		this.bandType.setMaximumRowCount(10);
		addComboBox(layout, c, y++, new JLabel(StringManager.getString("band")), this.bandType);

		// ボリンジャーバンド
		final JPanel bbPanel = createBollingerBandsPanel();
		addPanel(layout, c, y++, bbPanel);
		this.bandParamPanels.put(BandType.BOLLINGER_BANDS, bbPanel);
		// ドンチャンズ
		final JPanel donchianPanel = createDonchianPanel();
		addPanel(layout, c, y++, donchianPanel);
		this.bandParamPanels.put(BandType.DONCHIAN, donchianPanel);
		// エンベロープ
		final JPanel envelopePanel = createEnvelopePanel();
		addPanel(layout, c, y++, envelopePanel);
		this.bandParamPanels.put(BandType.ENVELOPE, envelopePanel);
		// チャネルシステム
		final JPanel hlmaPanel = createHighLowMovingAveragePanel();
		addPanel(layout, c, y++, hlmaPanel);
		this.bandParamPanels.put(BandType.HIGH_LOW_MOVING_AVERAGE, hlmaPanel);
		// ボラティリティ・システム
		final JPanel viPanel = createVolatilityIndexPanel();
		addPanel(layout, c, y++, viPanel);
		this.bandParamPanels.put(BandType.VIX, viPanel);
		// 一目均衡表
		final JPanel ichimokuPanel = createIchimokuPanel();
		addPanel(layout, c, y++, ichimokuPanel);
		this.bandParamPanels.put(BandType.ICHIMOKU, ichimokuPanel);

		// [オシレーター系]
		addSeparator(layout, c, y++);
		addLabel(layout, c, y++, new JLabel(StringManager.getString("label.osi")));

		// アルーン
		addCheckBox(layout, c, y++, this.aroon);
		final JPanel aroonPanel = createAroonPanel();
		addPanel(layout, c, y++, aroonPanel);
		this.paramPanels.put(this.aroon, aroonPanel);

		// ATR
		addCheckBox(layout, c, y++, atr);
		final JPanel atrPanel = createAverageTrueRangePanel();
		addPanel(layout, c, y++, atrPanel);
		paramPanels.put(atr, atrPanel);

		// NATR
		addCheckBox(layout, c, y++, natr);
		final JPanel natrPanel = createNormalizedAverageTrueRangePanel();
		addPanel(layout, c, y++, natrPanel);
		paramPanels.put(natr, natrPanel);

		// BMP
		addCheckBox(layout, c, y++, bmp);

		// CCI
		addCheckBox(layout, c, y++, this.cci);
		final JPanel cciPanel = createCommodityChannelIndexPanel();
		addPanel(layout, c, y++, cciPanel);
		this.paramPanels.put(this.cci, cciPanel);

		// チャイキンズ・ボラティリティ
		addCheckBox(layout, c, y++, this.chv);
		final JPanel chvPanel = createChaikinsVolatilityPanel();
		addPanel(layout, c, y++, chvPanel);
		this.paramPanels.put(this.chv, chvPanel);

		// CMF
		addCheckBox(layout, c, y++, this.cmf);
		final JPanel cmfPanel = createChaikinsMoneyFlowPanel();
		addPanel(layout, c, y++, cmfPanel);
		this.paramPanels.put(this.cmf, cmfPanel);

		// CMO
		addCheckBox(layout, c, y++, this.cmo);
		final JPanel cmoPanel = createChandeMomentumOscillatorPanel();
		addPanel(layout, c, y++, cmoPanel);
		this.paramPanels.put(this.cmo, cmoPanel);

		// コポック買い指標
		addCheckBox(layout, c, y++, this.coppock);
		final JPanel coppockPanel = createCoppockPanel();
		addPanel(layout, c, y++, coppockPanel);
		this.paramPanels.put(this.coppock, coppockPanel);

		// DPO
		addCheckBox(layout, c, y++, this.dpo);
		final JPanel dpoPanel = createDetrendedPriceOscillatorPanel();
		addPanel(layout, c, y++, dpoPanel);
		this.paramPanels.put(this.dpo, dpoPanel);

		// DMI
		addCheckBox(layout, c, y++, this.dmi);
		final JPanel dmiPanel = createDirectionalMovementIndexPanel();
		addPanel(layout, c, y++, dmiPanel);
		this.paramPanels.put(this.dmi, dmiPanel);

		// EMV
		addCheckBox(layout, c, y++, emv);
		final JPanel emvPanel = createEaseOfMomentumPanel();
		addPanel(layout, c, y++, emvPanel);
		paramPanels.put(emv, emvPanel);

		// ヒストリカル・ボラティリティ
		addCheckBox(layout, c, y++, this.hv);
		final JPanel hvPanel = createHistoricalVolatilityPanel();
		addPanel(layout, c, y++, hvPanel);
		this.paramPanels.put(this.hv, hvPanel);

		// 移動平均乖離率
		addCheckBox(layout, c, y++, this.kairi);
		final JPanel kairiPanel = createKairiPanel();
		addPanel(layout, c, y++, kairiPanel);
		this.paramPanels.put(this.kairi, kairiPanel);

		// マス・インデックス(MI)
		addCheckBox(layout, c, y++, this.mi);
		final JPanel miPanel = createMassIndexPanel();
		addPanel(layout, c, y++, miPanel);
		this.paramPanels.put(this.mi, miPanel);

		// モメンタム
		addCheckBox(layout, c, y++, this.mom);
		final JPanel momentumPanel = createMomentumPanel();
		addPanel(layout, c, y++, momentumPanel);
		this.paramPanels.put(this.mom, momentumPanel);

		// MFI
		addCheckBox(layout, c, y++, this.mfi);
		final JPanel mfiPanel = createMoneyFlowIndexPanel();
		addPanel(layout, c, y++, mfiPanel);
		this.paramPanels.put(this.mfi, mfiPanel);

		// MACD
		addCheckBox(layout, c, y++, this.macd);
		final JPanel macdPanel = createMovingAverageConvergenceDivergencePanel();
		addPanel(layout, c, y++, macdPanel);
		this.paramPanels.put(this.macd, macdPanel);

		// PAIN
		addCheckBox(layout, c, y++, this.pain);

		// PCR
		addCheckBox(layout, c, y++, pcr);
		final JPanel pcrPanel = createPercentOfResistancePanel();
		addPanel(layout, c, y++, pcrPanel);
		paramPanels.put(pcr, pcrPanel);

		// プライス・オシレータ(APO)
		addCheckBox(layout, c, y++, this.apo);
		final JPanel apoPanel = createAbsolutePriceOscillatorPanel();
		addPanel(layout, c, y++, apoPanel);
		this.paramPanels.put(this.apo, apoPanel);

		// プライス・オシレータ(PPO)
		addCheckBox(layout, c, y++, this.ppo);
		final JPanel ppoPanel = createPercentagePriceOscillatorPanel();
		addPanel(layout, c, y++, ppoPanel);
		this.paramPanels.put(this.ppo, ppoPanel);

		// サイコロジカル・ライン
		addCheckBox(layout, c, y++, this.psy);
		final JPanel psyPanel = createPsychologicalPanel();
		addPanel(layout, c, y++, psyPanel);
		this.paramPanels.put(this.psy, psyPanel);

		// Qstick
		addCheckBox(layout, c, y++, this.qstick);
		final JPanel qstickPanel = createQstickIndicatorPanel();
		addPanel(layout, c, y++, qstickPanel);
		this.paramPanels.put(this.qstick, qstickPanel);

		// RCI
		addCheckBox(layout, c, y++, this.rci);
		final JPanel rciPanel = createRankCorrelationIndexPanel();
		addPanel(layout, c, y++, rciPanel);
		this.paramPanels.put(this.rci, rciPanel);

		// ROC
		addCheckBox(layout, c, y++, this.roc);
		final JPanel rocPanel = createRateOfChangePanel();
		addPanel(layout, c, y++, rocPanel);
		this.paramPanels.put(this.roc, rocPanel);

		// RSI
		addCheckBox(layout, c, y++, rsi);
		final JPanel rsiPanel = createRelativeStrengthIndexPanel();
		addPanel(layout, c, y++, rsiPanel);
		paramPanels.put(rsi, rsiPanel);

		// RVI
		addCheckBox(layout, c, y++, rvi);
		final JPanel rviPanel = createRelativeVolatilityIndexPanel();
		addPanel(layout, c, y++, rviPanel);
		paramPanels.put(rvi, rviPanel);

		// 強弱レシオ(篠原レシオ)
		addCheckBox(layout, c, y++, this.shinohara);
		final JPanel shinoharaPanel = createShinoharaRatioPanel();
		addPanel(layout, c, y++, shinoharaPanel);
		this.paramPanels.put(this.shinohara, shinoharaPanel);

		// ストキャスティクス
		addCheckBox(layout, c, y++, this.srv);
		final JPanel srvPanel = createStochasticsPanel();
		addPanel(layout, c, y++, srvPanel);
		this.paramPanels.put(this.srv, srvPanel);

		// TII
		addCheckBox(layout, c, y++, this.tii);
		final JPanel tiiPanel = createTrendIntensityIndexPanel();
		addPanel(layout, c, y++, tiiPanel);
		this.paramPanels.put(this.tii, tiiPanel);

		// トリックス(Trix)
		addCheckBox(layout, c, y++, this.trix);
		final JPanel trixPanel = createTrixPanel();
		addPanel(layout, c, y++, trixPanel);
		this.paramPanels.put(this.trix, trixPanel);

		// TSI
		addCheckBox(layout, c, y++, this.tsi);
		final JPanel tsiPanel = createTrueStrengthIndexPanel();
		addPanel(layout, c, y++, tsiPanel);
		this.paramPanels.put(this.tsi, tsiPanel);

		// 究極のオシレータ
		addCheckBox(layout, c, y++, this.ultimate);
		final JPanel ultimatePanel = createUltimateOscillatorPanel();
		addPanel(layout, c, y++, ultimatePanel);
		this.paramPanels.put(this.ultimate, ultimatePanel);

		// ウィリアムズAD
		addCheckBox(layout, c, y++, this.wad);

		// ウィリアムズ%R
		addCheckBox(layout, c, y++, this.williamsR);
		final JPanel williamsRPanel = createWilliamsRPanel();
		addPanel(layout, c, y++, williamsRPanel);
		this.paramPanels.put(this.williamsR, williamsRPanel);

		// ------------------------------------------------------------

		// 出来高指標
		addSeparator(layout, c, y++);
		addLabel(layout, c, y++, new JLabel(StringManager.getString("label.vi")));

		// A/Dライン
		addCheckBox(layout, c, y++, this.ad);

		// チャインキンズA/Dオシレーター
		addCheckBox(layout, c, y++, this.cho);
		final JPanel choPanel = createChaikinAccumulationDistributionOscillatorPanel();
		addPanel(layout, c, y++, choPanel);
		this.paramPanels.put(this.cho, choPanel);

		// ボリューム・オシレータ(AVO)
		addCheckBox(layout, c, y++, this.avo);
		final JPanel avoPanel = createAbsoluteVolumeOscillatorPanel();
		addPanel(layout, c, y++, avoPanel);
		this.paramPanels.put(this.avo, avoPanel);

		// ボリューム・オシレータ(PVO)
		addCheckBox(layout, c, y++, this.pvo);
		final JPanel pvoPanel = createPercentageVolumeOscillatorPanel();
		addPanel(layout, c, y++, pvoPanel);
		this.paramPanels.put(this.pvo, pvoPanel);

		// 出来高乖離率
		addCheckBox(layout, c, y++, this.vkairi);
		final JPanel vbiasPanel = createVolumeBiasPanel();
		addPanel(layout, c, y++, vbiasPanel);
		this.paramPanels.put(this.vkairi, vbiasPanel);

		// VR1
		addCheckBox(layout, c, y++, this.vr1);
		final JPanel vr1Panel = createVolumeRatio1Panel();
		addPanel(layout, c, y++, vr1Panel);
		this.paramPanels.put(this.vr1, vr1Panel);

		// VR2
		addCheckBox(layout, c, y++, this.vr2);
		final JPanel vr2Panel = createVolumeRatio2Panel();
		addPanel(layout, c, y++, vr2Panel);
		this.paramPanels.put(this.vr2, vr2Panel);

		// 出来高ROC
		addCheckBox(layout, c, y++, this.vroc);
		final JPanel vrocPanel = createVolumeRateOfChangePanel();
		addPanel(layout, c, y++, vrocPanel);
		this.paramPanels.put(this.vroc, vrocPanel);

		// V-RSI
		addCheckBox(layout, c, y++, this.vrsi);
		final JPanel vrsiPanel = createVolumeRelativeStrengthIndexPanel();
		addPanel(layout, c, y++, vrsiPanel);
		this.paramPanels.put(this.vrsi, vrsiPanel);

		// WVR
		addCheckBox(layout, c, y++, this.wvr);
		final JPanel wvrPanel = createWakoVolumeRatioPanel();
		addPanel(layout, c, y++, wvrPanel);
		this.paramPanels.put(this.wvr, wvrPanel);

		// PVI
		addCheckBox(layout, c, y++, this.pvi);
		final JPanel pviPanel = createPositiveVolumeIndexPanel();
		addPanel(layout, c, y++, pviPanel);
		this.paramPanels.put(this.pvi, pviPanel);

		// NVI
		addCheckBox(layout, c, y++, this.nvi);
		final JPanel nviPanel = createNegativeVolumeIndexPanel();
		addPanel(layout, c, y++, nviPanel);
		this.paramPanels.put(this.nvi, nviPanel);

		// OBV
		addCheckBox(layout, c, y++, this.obv);
		final JPanel obvPanel = createOnBalanceVolumePanel();
		addPanel(layout, c, y++, obvPanel);
		this.paramPanels.put(this.obv, obvPanel);

		// PVT
		addCheckBox(layout, c, y++, this.pvt);

		// 価格帯別出来高
		addCheckBox(layout, c, y++, this.vp);
		final JPanel vpPanel = createVolumePricePanel();
		addPanel(layout, c, y++, vpPanel);
		this.paramPanels.put(this.vp, vpPanel);

		// ------------------------------------------------------------

		// その他
		addSeparator(layout, c, y++);
		addLabel(layout, c, y++, new JLabel(StringManager.getString("label.other")));

		// 信用倍率
		addCheckBox(layout, c, y++, this.ratio);
		final JPanel ratioPanel = createRatioPanel();
		addPanel(layout, c, y++, ratioPanel);
		this.paramPanels.put(this.ratio, ratioPanel);

		// 騰落価格
		addCheckBox(layout, c, y++, this.priceFluctuations);
		final JPanel priceFluctuationsPanel = createPriceFluctuationsPanel();
		addPanel(layout, c, y++, priceFluctuationsPanel);
		this.paramPanels.put(this.priceFluctuations, priceFluctuationsPanel);

		// 騰落率
		addCheckBox(layout, c, y++, this.fluctuations);
		final JPanel fluctuationsPanel = createFluctuationsPanel();
		addPanel(layout, c, y++, fluctuationsPanel);
		this.paramPanels.put(this.fluctuations, fluctuationsPanel);

		// [ローソク足パターン]
		addSeparator(layout, c, y++);
		addLabel(layout, c, y++, new JLabel(StringManager.getString("label.candle")));
		addPanel(layout, c, y++, createCandlestickTrendPanel());

		addLabel(layout, c, y++, new JLabel(StringManager.getString("label.candle.bullish")));
		addCheckBox(layout, c, y++, bullishLongWhiteDay);
		addCheckBox(layout, c, y++, bullishBeltHold);
		addCheckBox(layout, c, y++, bullishHammer);
		addCheckBox(layout, c, y++, bullishDragonflyDoji);
		addCheckBox(layout, c, y++, bullishLongLeggedDoji);
		addCheckBox(layout, c, y++, bullishInvertedHammer);
		addCheckBox(layout, c, y++, bullishHarami);
		addCheckBox(layout, c, y++, bullishHaramiCross);
		addCheckBox(layout, c, y++, bullishEngulfing);
		addCheckBox(layout, c, y++, bullishGravestoneDoji);
		addCheckBox(layout, c, y++, bullishMeetingLines);
		addCheckBox(layout, c, y++, bullishDojiStar);
		addCheckBox(layout, c, y++, bullishHomingPigeon);
		addCheckBox(layout, c, y++, bullishMatchingLow);
		addCheckBox(layout, c, y++, bullishTweezerBottom);
		addCheckBox(layout, c, y++, bullishKicking);
		addCheckBox(layout, c, y++, bullishPiercingLine);
		addCheckBox(layout, c, y++, bullishSeparatingLines);
		addCheckBox(layout, c, y++, bullishTriStar);
		addCheckBox(layout, c, y++, bullishThreeStarsInTheSouth);
		addCheckBox(layout, c, y++, bullishUniqueThreeRiverBottom);
		addCheckBox(layout, c, y++, bullishStickSandwich);
		addCheckBox(layout, c, y++, bullishAbandonedBaby);
		addCheckBox(layout, c, y++, bullishMorningDojiStar);
		addCheckBox(layout, c, y++, bullishMorningStar);
		addCheckBox(layout, c, y++, bullishThreeOutsideUp);
		addCheckBox(layout, c, y++, bullishThreeInsideUp);
		addCheckBox(layout, c, y++, bullishThreeWhiteSoldiers);
		addCheckBox(layout, c, y++, bullishUpsideTasukiGap);
		addCheckBox(layout, c, y++, bullishUpsideGapThreeMethods);
		addCheckBox(layout, c, y++, bullishSideBySideWhiteLines);
		addCheckBox(layout, c, y++, bullishConcealingBabySwallow);
		addCheckBox(layout, c, y++, bullishThreeLineStrike);
		addCheckBox(layout, c, y++, bullishThreeGaps);
		addCheckBox(layout, c, y++, bullishBreakaway);
		addCheckBox(layout, c, y++, bullishLadderBottom);
		addCheckBox(layout, c, y++, bullishRisingThreeMethods);
		addCheckBox(layout, c, y++, bullishMatHold);

		addLabel(layout, c, y++, new JLabel(StringManager.getString("label.candle.bearish")));
		addCheckBox(layout, c, y++, bearishLongBlackDay);
		addCheckBox(layout, c, y++, bearishBeltHold);
		addCheckBox(layout, c, y++, bearishHangingMan);
		addCheckBox(layout, c, y++, bearishDragonflyDoji);
		addCheckBox(layout, c, y++, bearishLongLeggedDoji);
		addCheckBox(layout, c, y++, bearishShootingStar);
		addCheckBox(layout, c, y++, bearishHarami);
		addCheckBox(layout, c, y++, bearishHaramiCross);
		addCheckBox(layout, c, y++, bearishEngulfing);
		addCheckBox(layout, c, y++, bearishGravestoneDoji);
		addCheckBox(layout, c, y++, bearishMeetingLines);
		addCheckBox(layout, c, y++, bearishDojiStar);
		addCheckBox(layout, c, y++, bearishDescendingHawk);
		addCheckBox(layout, c, y++, bearishMatchingHigh);
		addCheckBox(layout, c, y++, bearishTweezerTop);
		addCheckBox(layout, c, y++, bearishKicking);
		addCheckBox(layout, c, y++, bearishDarkCloudCover);
		addCheckBox(layout, c, y++, bearishSeparatingLines);
		addCheckBox(layout, c, y++, bearishThrusting);
		addCheckBox(layout, c, y++, bearishOnNeck);
		addCheckBox(layout, c, y++, bearishInNeck);
		addCheckBox(layout, c, y++, bearishTriStar);
		addCheckBox(layout, c, y++, bearishTwoCrows);
		addCheckBox(layout, c, y++, bearishAdvanceBlock);
		addCheckBox(layout, c, y++, bearishDeliberation);
		addCheckBox(layout, c, y++, bearishAbandonedBaby);
		addCheckBox(layout, c, y++, bearishEveningDojiStar);
		addCheckBox(layout, c, y++, bearishEveningStar);
		addCheckBox(layout, c, y++, bearishThreeOutsideDown);
		addCheckBox(layout, c, y++, bearishThreeInsideDown);
		addCheckBox(layout, c, y++, bearishUpsideGapTwoCrows);
		addCheckBox(layout, c, y++, bearishThreeBlackCrows);
		addCheckBox(layout, c, y++, bearishIdenticalThreeCrows);
		addCheckBox(layout, c, y++, bearishDownsideTasukiGap);
		addCheckBox(layout, c, y++, bearishDownsideGapThreeMethods);
		addCheckBox(layout, c, y++, bearishSideBySideWhiteLines);
		addCheckBox(layout, c, y++, bearishThreeLineStrike);
		addCheckBox(layout, c, y++, bearishThreeGaps);
		addCheckBox(layout, c, y++, bearishBreakaway);
		addCheckBox(layout, c, y++, bearishFallingThreeMethods);

		addLastSpace(layout, c, y);
	}

	// ------------------------------------------------------------
	// パラメータ入力用パネルの構築

	private JPanel createCandlestickTrendPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("label.candle.trend")), candlestickTrend);

//		panel.setVisible(false);
		return panel;
	}

	private JPanel createAverageTrueRangePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);
		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), atr_period);
		panel.setVisible(false);
		return panel;
	}
	
	private JPanel createNormalizedAverageTrueRangePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);
		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), natr_period);
		panel.setVisible(false);
		return panel;
	}

	/**
	 * 線形回帰トレンドのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createLinearRegressionPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.lr1Period);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period2")), this.lr2Period);

		panel.setVisible(false);
		return panel;
	}

	private JPanel createKagiAshiPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);
		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("rate")), kagi_rate);
		panel.setVisible(false);
		return panel;
	}

	private JPanel createZigZagPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);
		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("rate")), zigzag_rate);
		panel.setVisible(false);
		return panel;
	}

	/**
	 * 移動平均線のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createMovingAveragePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.maType);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.ma1Period);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period2")), this.ma2Period);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * エンベロープのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createEnvelopePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.envelopeMaType);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.envelopePeriod);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("rate")), this.envelopeRate);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * チャネルシステムのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createHighLowMovingAveragePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.hlmaMaType);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("high")), this.hmaPeriod);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("low")), this.lmaPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * ボリンジャーバンドのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createBollingerBandsPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.bbPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * ドンチャンズのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createDonchianPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.donchianPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * ボラティリティ・システムのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createVolatilityIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.atrPeriod);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("coefficient")), this.atrWeight);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 一目均衡表のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createIchimokuPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("ichimoku.kijun")), this.kijunPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("ichimoku.tenkan")), this.tenkanPeriod);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("ichimoku.span")), this.spanPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * アルーンのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createAroonPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.aroonPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 移動平均乖離率のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createKairiPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.biasMaType);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.biasPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.biasUpperSignal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.biasLowerSignal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * チャイキンズ・ボラティリティのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createChaikinsVolatilityPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.chv_period1);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period2")), this.chv_period2);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * CCIのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createCommodityChannelIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.cciPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.cciUpperSignal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.cciLowerSignal);

		panel.setVisible(false);
		return panel;
	}

	private JPanel createChaikinsMoneyFlowPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.cmf_period);

		panel.setVisible(false);
		return panel;
	}
	
	private JPanel createChandeMomentumOscillatorPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.cmo_period);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.cmo_upper_signal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.cmo_lower_signal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * コポック買い指標のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createCoppockPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.coppockMaType);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("roc")), this.coppockRocPeriod);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period")), this.coppockPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * DPOのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createDetrendedPriceOscillatorPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.dpoMaType);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period")), this.dpoPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * DMIのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createDirectionalMovementIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("di")), this.diPeriod);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("adx")), this.adxPeriod);

		panel.setVisible(false);
		return panel;
	}
	
	private JPanel createEaseOfMomentumPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);
		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), emv_period);
		panel.setVisible(false);
		return panel;
	}

	/**
	 * ヒストリカル・ボラティリティのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createHistoricalVolatilityPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.hvPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * マス・インデックス(MI)のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createMassIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.miMaType);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.miMaPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period2")), this.miSumPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * モメンタムのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createMomentumPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.mom_period);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * MFIのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createMoneyFlowIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.mfiPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.mfiUpperSignal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.mfiLowerSignal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * MACDのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createMovingAverageConvergenceDivergencePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.macdMa1Period);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period2")), this.macdMa2Period);
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("signal")), this.macdSignalMaType);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period")), this.macdSignalPeriod);

		panel.setVisible(false);
		return panel;
	}
	
	private JPanel createPercentOfResistancePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), pcr_period);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), pcr_upper_signal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), pcr_lower_signal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * プライス・オシレータ(APO)のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createAbsolutePriceOscillatorPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.apoMa1Period);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period2")), this.apoMa2Period);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * プライス・オシレータ(PPO)のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createPercentagePriceOscillatorPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.ppoMa1Period);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period2")), this.ppoMa2Period);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * サイコロジカル・ラインのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createPsychologicalPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.psy_period);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.psy_upper_signal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.psy_lower_signal);

		panel.setVisible(false);
		return panel;
	}
	
	private JPanel createQstickIndicatorPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.qstick_matype);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.qstick_period);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * RSIのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createRelativeStrengthIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.rsiPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.rsiUpperSignal);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.lower")), this.rsiLowerSignal);

		panel.setVisible(false);
		return panel;
	}
	
	private JPanel createRelativeVolatilityIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), rvi_period);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), rvi_upper_signal);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.lower")), rvi_lower_signal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * RCIのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createRankCorrelationIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.rciPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.rciUpperSignal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.rciLowerSignal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * ROCのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createRateOfChangePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.rocPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 強弱レシオ(篠原レシオ)のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createShinoharaRatioPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.shinoharaPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * ストキャスティクスのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createStochasticsPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("srv.k")), this.srvKPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("srv.d")), this.srvDPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.srvUpperSignal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.srvLowerSignal);

		panel.setVisible(false);
		return panel;
	}
	
	private JPanel createTrendIntensityIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.tii_matype);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.tii_period);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.tii_upper_signal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.tii_lower_signal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * トリックス(Trix)のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createTrixPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.trixPeriod);
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("signal")), this.trixSignalMaType);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period")), this.trixSignalPeriod);

		panel.setVisible(false);
		return panel;
	}

	private JPanel createTrueStrengthIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.tsi_period1);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period2")), this.tsi_period2);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.tsi_upper_signal);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.lower")), this.tsi_lower_signal);
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("signal")), this.tsi_signal_matype);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period")), this.tsi_signal_period);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 究極のオシレーターのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createUltimateOscillatorPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.ultimatePeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * ウィリアムズ%Rのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createWilliamsRPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.williamsRPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.williamsRUpperSignal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.williamsRLowerSignal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 出来高移動平均線のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createVolumeMovingAveragePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.vmaMaType);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.vma1Period);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period2")), this.vma2Period);

		panel.setVisible(false);
		return panel;
	}

	private JPanel createChaikinAccumulationDistributionOscillatorPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.cho_matype);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.cho_fast);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period2")), this.cho_slow);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 出来高乖離率のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createVolumeBiasPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.vkairiMaType);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.vkairiPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * ボリューム・オシレータ(AVO)のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createAbsoluteVolumeOscillatorPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.avoMa1Period);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period2")), this.avoMa2Period);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * ボリューム・オシレータ(PVO)のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createPercentageVolumeOscillatorPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.pvoMa1Period);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("period2")), this.pvoMa2Period);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 出来高ROCのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createVolumeRateOfChangePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.vrocPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * ボリュームレシオ1のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createVolumeRatio1Panel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.vr1Period);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.vr1UpperSignal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.vr1LowerSignal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * ボリュームレシオ2のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createVolumeRatio2Panel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.vr2Period);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.vr2UpperSignal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.vr2LowerSignal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * V-RSIのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createVolumeRelativeStrengthIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.vrsiPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.vrsiUpperSignal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.vrsiLowerSignal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 和光ボリュームレシオのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createWakoVolumeRatioPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period")), this.wvrPeriod);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.wvrUpperSignal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.wvrLowerSignal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * PVIのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createPositiveVolumeIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.pvi_matype);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.pvi_fast);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period2")), this.pvi_slow);

		panel.setVisible(false);
		return panel;
	}

	private JPanel createNegativeVolumeIndexPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubComboBox(panel, layout, c, y++, new JLabel(StringManager.getString("matype")), this.nvi_matype);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period1")), this.nvi_fast);
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("period2")), this.nvi_slow);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * OBVのパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createOnBalanceVolumePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.obvPeriod);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 価格帯別出来高のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createVolumePricePanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubSpinner(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("vp.count")), this.vpCount);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 信用倍率のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createRatioPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		final GridBagConstraints c = new GridBagConstraints();
		panel.setLayout(layout);

		int y = 0;
		addSubSpinner(panel, layout, c, y++, new JLabel(StringManager.getString("signal.upper")), this.ratioUpperSignal);
		addSubSpinner(panel, layout, c, y, new JLabel(StringManager.getString("signal.lower")), this.ratioLowerSignal);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 騰落価格のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createPriceFluctuationsPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubComboBox(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.priceFluctuationsPeriodType);

		panel.setVisible(false);
		return panel;
	}

	/**
	 * 騰落率のパラメータ入力用パネルを構築して返します。
	 */
	private JPanel createFluctuationsPanel() {
		final JPanel panel = new JPanel();
		final GridBagLayout layout = new GridBagLayout();
		panel.setLayout(layout);

		addSubComboBox(panel, layout, new GridBagConstraints(), 0, new JLabel(StringManager.getString("period")), this.fluctuationsPeriodType);

		panel.setVisible(false);
		return panel;
	}

	// ------------------------------------------------------------
	// 設定情報の保存/読込み

	/**
	 * 各コントロールの状態を指定された設定情報へ設定します。
	 * 
	 * @param settings 設定情報
	 */
	@Override
	public void save(final ChartSettings settings) {
		final TimeSeriesSettings s = settings.timeSeries;

		s.signalMarker = this.signalMarker.isSelected();
		s.splitMarker = this.splitMarker.isSelected();

		s.fixed		= this.fixed.isSelected();
		s.scale		= (PriceScaleType) this.scale.getSelectedItem();
		s.chartType	= (PriceChartType) this.chartType.getSelectedItem();

		s.avgprice = this.avgprice.isSelected();
		s.mp = this.mp.isSelected();
		// ティピカル・プライス
		s.tp = this.tp.isSelected();
		// 加重終値
		s.wc = this.wc.isSelected();

		// 移動平均線
		s.ma = this.ma.isSelected();
		s.maType = (MAType) this.maType.getSelectedItem();
		s.ma1Period = (Integer) this.ma1Period.getValue();
		s.ma2Period = (Integer) this.ma2Period.getValue();
		// 線形回帰トレンド
		s.lr = this.lr.isSelected();
		s.lr1Period = (Integer) this.lr1Period.getValue();
		s.lr2Period = (Integer) this.lr2Period.getValue();
		// 時系列カギ足
		s.kagi = kagi.isSelected();
		s.kagi_rate = (Integer) kagi_rate.getValue();
		// Zig Zag
		s.zigzag = zigzag.isSelected();
		s.zigzag_rate = (Integer) zigzag_rate.getValue();

		// バンド系
		s.bandType = (BandType) this.bandType.getSelectedItem();
		// ボリンジャーバンド
		s.bbPeriod = (Integer) this.bbPeriod.getValue();
		// ドンチャンズ
		s.donchianPeriod = (Integer) this.donchianPeriod.getValue();
		// エンベロープ
		s.envelopeMaType = (MAType) this.envelopeMaType.getSelectedItem();
		s.envelopePeriod = (Integer) this.envelopePeriod.getValue();
		s.envelopeRate = (Integer) this.envelopeRate.getValue();
		// チャネルシステム
		s.hlmaMaType = (MAType) this.hlmaMaType.getSelectedItem();
		s.hmaPeriod = (Integer) this.hmaPeriod.getValue();
		s.lmaPeriod = (Integer) this.lmaPeriod.getValue();
		// 一目均衡表
		s.kijunPeriod = (Integer) this.kijunPeriod.getValue();
		s.tenkanPeriod = (Integer) this.tenkanPeriod.getValue();
		s.spanPeriod = (Integer) this.spanPeriod.getValue();
		// ボラティリティ・システム
		s.atrPeriod = (Integer) this.atrPeriod.getValue();
		s.atrWeight = (Double) this.atrWeight.getValue();

		// アルーン
		s.aroon = this.aroon.isSelected();
		s.aroonPeriod = (Integer) this.aroonPeriod.getValue();
		// ATR
		s.atr = atr.isSelected();
		s.atr_period = (Integer) atr_period.getValue();
		// NATR
		s.natr = natr.isSelected();
		s.natr_period = (Integer) natr_period.getValue();
		// BMP
		s.bop = bmp.isSelected();
		// チャイキンズ・ボラティリティ
		s.chv = this.chv.isSelected();
		s.chv_period1 = (Integer) this.chv_period1.getValue();
		s.chv_period2 = (Integer) this.chv_period2.getValue();
		// CCI
		s.cci = this.cci.isSelected();
		s.cciPeriod = (Integer) this.cciPeriod.getValue();
		s.cciUpperSignal = (Integer) this.cciUpperSignal.getValue();
		s.cciLowerSignal = (Integer) this.cciLowerSignal.getValue();
		// CMF
		s.cmf = this.cmf.isSelected();
		s.cmf_period = (Integer) this.cmf_period.getValue();
		// CMO
		s.cmo = this.cmo.isSelected();
		s.cmo_period = (Integer) this.cmo_period.getValue();
		s.cmo_upper_signal = (Integer) this.cmo_upper_signal.getValue();
		s.cmo_lower_signal = (Integer) this.cmo_lower_signal.getValue();
		// コポック
		s.coppock = this.coppock.isSelected();
		s.coppockRocPeriod = (Integer) this.coppockRocPeriod.getValue();
		s.coppockMaType = (MAType) this.coppockMaType.getSelectedItem();
		s.coppockPeriod = (Integer) this.coppockPeriod.getValue();
		// DPO
		s.dpo = this.dpo.isSelected();
		s.dpoMaType = (MAType) this.dpoMaType.getSelectedItem();
		s.dpoPeriod = (Integer) this.dpoPeriod.getValue();
		// DMI
		s.dmi = this.dmi.isSelected();
		s.diPeriod = (Integer) this.diPeriod.getValue();
		s.adxPeriod = (Integer) this.adxPeriod.getValue();
		// EMV
		s.emv = emv.isSelected();
		s.emv_period = (Integer) emv_period.getValue();
		// ヒストリカル・ボラティリティ
		s.hv = this.hv.isSelected();
		s.hvPeriod = (Integer) this.hvPeriod.getValue();
		// BIAS (移動平均乖離率)
		s.kairi = this.kairi.isSelected();
		s.biasMaType = (MAType) this.biasMaType.getSelectedItem();
		s.biasPeriod = (Integer) this.biasPeriod.getValue();
		s.biasUpperSignal = (Integer) this.biasUpperSignal.getValue();
		s.biasLowerSignal = (Integer) this.biasLowerSignal.getValue();
		// マス・インデックス(MI)
		s.mi = this.mi.isSelected();
		s.miMaType = (MAType) this.miMaType.getSelectedItem();
		s.miMaPeriod = (Integer) this.miMaPeriod.getValue();
		s.miSumPeriod = (Integer) this.miSumPeriod.getValue();
		// モメンタム
		s.mom = this.mom.isSelected();
		s.mom_period = (Integer) this.mom_period.getValue();
		// MFI
		s.mfi = this.mfi.isSelected();
		s.mfiPeriod = (Integer) this.mfiPeriod.getValue();
		s.mfiUpperSignal = (Integer) this.mfiUpperSignal.getValue();
		s.mfiLowerSignal = (Integer) this.mfiLowerSignal.getValue();
		// MACD
		s.macd = this.macd.isSelected();
		s.macdMa1Period = (Integer) this.macdMa1Period.getValue();
		s.macdMa2Period = (Integer) this.macdMa2Period.getValue();
		s.macdSignalMaType = (MAType) this.macdSignalMaType.getSelectedItem();
		s.macdSignalPeriod = (Integer) this.macdSignalPeriod.getValue();
		// PAIN
		s.pain = this.pain.isSelected();
		// PCR
		s.pcr = pcr.isSelected();
		s.pcr_period = (Integer) pcr_period.getValue();
		s.pcr_upper_signal = (Integer) pcr_upper_signal.getValue();
		s.pcr_lower_signal = (Integer) pcr_lower_signal.getValue();
		// プライス・オシレータ(APO)
		s.apo = this.apo.isSelected();
		s.apoMa1Period = (Integer) this.apoMa1Period.getValue();
		s.apoMa2Period = (Integer) this.apoMa2Period.getValue();
		// プライス・オシレータ(PPO)
		s.ppo = this.ppo.isSelected();
		s.ppoMa1Period = (Integer) this.ppoMa1Period.getValue();
		s.ppoMa2Period = (Integer) this.ppoMa2Period.getValue();
		// サイコロジカル・ライン
		s.psy = this.psy.isSelected();
		s.psy_period = (Integer) this.psy_period.getValue();
		s.psy_upper_signal = (Integer) this.psy_upper_signal.getValue();
		s.psy_lower_signal = (Integer) this.psy_lower_signal.getValue();
		// Qstick
		s.qstick = this.qstick.isSelected();
		s.qstick_matype = (MAType) this.qstick_matype.getSelectedItem();
		s.qstick_period = (Integer) this.qstick_period.getValue();
		// RCI (順位相関指数)
		s.rci = this.rci.isSelected();
		s.rciPeriod = (Integer) this.rciPeriod.getValue();
		s.rciUpperSignal = (Integer) this.rciUpperSignal.getValue();
		s.rciLowerSignal = (Integer) this.rciLowerSignal.getValue();
		// ROC
		s.roc = this.roc.isSelected();
		s.rocPeriod = (Integer) this.rocPeriod.getValue();
		// RSI (相対力指数)
		s.rsi = this.rsi.isSelected();
		s.rsiPeriod = (Integer) this.rsiPeriod.getValue();
		s.rsiUpperSignal = (Integer) this.rsiUpperSignal.getValue();
		s.rsiLowerSignal = (Integer) this.rsiLowerSignal.getValue();
		// RVI
		s.rvi = rvi.isSelected();
		s.rvi_period = (Integer) rvi_period.getValue();
		s.rvi_upper_signal = (Integer) rvi_upper_signal.getValue();
		s.rvi_lower_signal = (Integer) rvi_lower_signal.getValue();
		// 強弱レシオ(篠原レシオ)
		s.shinohara = this.shinohara.isSelected();
		s.shinoharaPeriod = (Integer) this.shinoharaPeriod.getValue();
		// ストキャスティクス
		s.srv = this.srv.isSelected();
		s.srvKPeriod = (Integer) this.srvKPeriod.getValue();
		s.srvDPeriod = (Integer) this.srvDPeriod.getValue();
		s.srvUpperSignal = (Integer) this.srvUpperSignal.getValue();
		s.srvLowerSignal = (Integer) this.srvLowerSignal.getValue();
		// TII
		s.tii = this.tii.isSelected();
		s.tii_matype = (MAType) this.tii_matype.getSelectedItem();
		s.tii_period = (Integer) this.tii_period.getValue();
		s.tii_upper_signal = (Integer) this.tii_upper_signal.getValue();
		s.tii_lower_signal = (Integer) this.tii_lower_signal.getValue();
		// トリックス(Trix)
		s.trix = this.trix.isSelected();
		s.trixPeriod = (Integer) this.trixPeriod.getValue();
		s.trixSignalMaType = (MAType) this.trixSignalMaType.getSelectedItem();
		s.trixSignalPeriod = (Integer) this.trixSignalPeriod.getValue();
		// TSI
		s.tsi = this.tsi.isSelected();
		s.tsi_period1 = (Integer) this.tsi_period1.getValue();
		s.tsi_period2 = (Integer) this.tsi_period2.getValue();
		s.tsi_signal_matype = (MAType) this.tsi_signal_matype.getSelectedItem();
		s.tsi_signal_period = (Integer) this.tsi_signal_period.getValue();
		s.tsi_upper_signal = (Integer) this.tsi_upper_signal.getValue();
		s.tsi_lower_signal = (Integer) this.tsi_lower_signal.getValue();
		// 究極のオシレーター
		s.ultimate = this.ultimate.isSelected();
		s.ultimatePeriod = (Integer) this.ultimatePeriod.getValue();
		// ウィリアムズAD
		s.wad = this.wad.isSelected();
		// ウィリアムズ%R
		s.williamsR = this.williamsR.isSelected();
		s.williamsRPeriod = (Integer) this.williamsRPeriod.getValue();
		s.williamsRUpperSignal = (Integer) this.williamsRUpperSignal.getValue();
		s.williamsRLowerSignal = (Integer) this.williamsRLowerSignal.getValue();

		// 出来高
		s.volumeType = (VolumeType) this.volumeType.getSelectedItem();
		// A/Dライン
		s.ad = this.ad.isSelected();
		// チャイキンズA/Dオシレーター
		s.cho = this.cho.isSelected();
		s.cho_matype = (MAType) this.cho_matype.getSelectedItem();
		s.cho_fast = (Integer) this.cho_fast.getValue();
		s.cho_slow = (Integer) this.cho_slow.getValue();
		// 出来高移動平均線
		s.vmaMaType = (MAType) this.vmaMaType.getSelectedItem();
		s.vma1Period = (Integer) this.vma1Period.getValue();
		s.vma2Period = (Integer) this.vma2Period.getValue();
		// 出来高乖離率
		s.vkairi = this.vkairi.isSelected();
		s.vbiasMaType = (MAType) this.vkairiMaType.getSelectedItem();
		s.vbiasPeriod = (Integer) this.vkairiPeriod.getValue();
		// ボリューム・オシレータ(AVO)
		s.avo = this.avo.isSelected();
		s.avoMa1Period = (Integer) this.avoMa1Period.getValue();
		s.avoMa2Period = (Integer) this.avoMa2Period.getValue();
		// ボリューム・オシレータ(PVO)
		s.pvo = this.pvo.isSelected();
		s.pvoMa1Period = (Integer) this.pvoMa1Period.getValue();
		s.pvoMa2Period = (Integer) this.pvoMa2Period.getValue();
		// 出来高ROC
		s.vroc = this.vroc.isSelected();
		s.vrocPeriod = (Integer) this.vrocPeriod.getValue();
		// ボリュームレシオ1
		s.vr1 = this.vr1.isSelected();
		s.vr1Period = (Integer) this.vr1Period.getValue();
		s.vr1UpperSignal = (Integer) this.vr1UpperSignal.getValue();
		s.vr1LowerSignal = (Integer) this.vr1LowerSignal.getValue();
		// ボリュームレシオ2
		s.vr2 = this.vr2.isSelected();
		s.vr2Period = (Integer) this.vr2Period.getValue();
		s.vr2UpperSignal = (Integer) this.vr2UpperSignal.getValue();
		s.vr2LowerSignal = (Integer) this.vr2LowerSignal.getValue();
		// V-RSI (出来高相対力指数)
		s.vrsi = this.vrsi.isSelected();
		s.vrsiPeriod = (Integer) this.vrsiPeriod.getValue();
		s.vrsiUpperSignal = (Integer) this.vrsiUpperSignal.getValue();
		s.vrsiLowerSignal = (Integer) this.vrsiLowerSignal.getValue();
		// 和光ボリュームレシオ
		s.wvr = this.wvr.isSelected();
		s.wvrPeriod = (Integer) this.wvrPeriod.getValue();
		s.wvrUpperSignal = (Integer) this.wvrUpperSignal.getValue();
		s.wvrLowerSignal = (Integer) this.wvrLowerSignal.getValue();
		// PVI
		s.pvi = this.pvi.isSelected();
		s.pvi_matype = (MAType) this.pvi_matype.getSelectedItem();
		s.pvi_fast = (Integer) pvi_fast.getValue();
		s.pvi_slow = (Integer) pvi_slow.getValue();
		// NVI
		s.nvi = nvi.isSelected();
		s.nvi_matype = (MAType) nvi_matype.getSelectedItem();
		s.nvi_fast = (Integer) nvi_fast.getValue();
		s.nvi_slow = (Integer) nvi_slow.getValue();
		// OBV
		s.obv = obv.isSelected();
		s.obvPeriod = (Integer) obvPeriod.getValue();
		// PVT
		s.pvt = pvt.isSelected();

		// 価格帯別出来高
		s.vp = vp.isSelected();
		s.vpCount = (Integer) vpCount.getValue();

		// 信用倍率
		s.ratio = ratio.isSelected();
		s.ratioUpperSignal = (Double) ratioUpperSignal.getValue();
		s.ratioLowerSignal = (Double) ratioLowerSignal.getValue();
		// 騰落価格
		s.price_performance = priceFluctuations.isSelected();
		s.priceFluctuationsPeriodType = (PeriodType) priceFluctuationsPeriodType.getSelectedItem();
		// 騰落率
		s.percent_performance = fluctuations.isSelected();
		s.performancePeriodType = (PeriodType) fluctuationsPeriodType.getSelectedItem();

		// ローソク足パターン
		s.candleTrend = (ChartScreenType) candlestickTrend.getSelectedItem();

		s.bullishLongWhiteDay = bullishLongWhiteDay.isSelected();
		s.bullishBeltHold = bullishBeltHold.isSelected();
		s.bullishHammer = bullishHammer.isSelected();
		s.bullishDragonflyDoji = bullishDragonflyDoji.isSelected();
		s.bullishLongLeggedDoji = bullishLongLeggedDoji.isSelected();
		s.bullishInvertedHammer = bullishInvertedHammer.isSelected();
		s.bullishHarami = bullishHarami.isSelected();
		s.bullishHaramiCross = bullishHaramiCross.isSelected();
		s.bullishEngulfing = bullishEngulfing.isSelected();
		s.bullishGravestoneDoji = bullishGravestoneDoji.isSelected();
		s.bullishMeetingLines = bullishMeetingLines.isSelected();
		s.bullishDojiStar = bullishDojiStar.isSelected();
		s.bullishHomingPigeon = bullishHomingPigeon.isSelected();
		s.bullishMatchingLow = bullishMatchingLow.isSelected();
		s.bullishTweezerBottom = bullishTweezerBottom.isSelected();
		s.bullishKicking = bullishKicking.isSelected();
		s.bullishPiercingLine = bullishPiercingLine.isSelected();
		s.bullishSeparatingLines = bullishSeparatingLines.isSelected();
		s.bullishTriStar = bullishTriStar.isSelected();
		s.bullishThreeStarsInTheSouth = bullishThreeStarsInTheSouth.isSelected();
		s.bullishUniqueThreeRiverBottom = bullishUniqueThreeRiverBottom.isSelected();
		s.bullishStickSandwich = bullishStickSandwich.isSelected();
		s.bullishAbandonedBaby = bullishAbandonedBaby.isSelected();
		s.bullishMorningDojiStar = bullishMorningDojiStar.isSelected();
		s.bullishMorningStar = bullishMorningStar.isSelected();
		s.bullishThreeOutsideUp = bullishThreeOutsideUp.isSelected();
		s.bullishThreeInsideUp = bullishThreeInsideUp.isSelected();
		s.bullishThreeWhiteSoldiers = bullishThreeWhiteSoldiers.isSelected();
		s.bullishUpsideTasukiGap = bullishUpsideTasukiGap.isSelected();
		s.bullishUpsideGapThreeMethods = bullishUpsideGapThreeMethods.isSelected();
		s.bullishSideBySideWhiteLines = bullishSideBySideWhiteLines.isSelected();
		s.bullishConcealingBabySwallow = bullishConcealingBabySwallow.isSelected();
		s.bullishThreeLineStrike = bullishThreeLineStrike.isSelected();
		s.bullishThreeGaps = bullishThreeGaps.isSelected();
		s.bullishBreakaway = bullishBreakaway.isSelected();
		s.bullishLadderBottom = bullishLadderBottom.isSelected();
		s.bullishRisingThreeMethods = bullishRisingThreeMethods.isSelected();
		s.bullishMatHold = bullishMatHold.isSelected();

		s.bearishLongBlackDay = bearishLongBlackDay.isSelected();
		s.bearishBeltHold = bearishBeltHold.isSelected();
		s.bearishHangingMan = bearishHangingMan.isSelected();
		s.bearishDragonflyDoji = bearishDragonflyDoji.isSelected();
		s.bearishLongLeggedDoji = bearishLongLeggedDoji.isSelected();
		s.bearishShootingStar = bearishShootingStar.isSelected();
		s.bearishHarami = bearishHarami.isSelected();
		s.bearishHaramiCross = bearishHaramiCross.isSelected();
		s.bearishEngulfing = bearishEngulfing.isSelected();
		s.bearishGravestoneDoji = bearishGravestoneDoji.isSelected();
		s.bearishMeetingLines = bearishMeetingLines.isSelected();
		s.bearishDojiStar = bearishDojiStar.isSelected();
		s.bearishDescendingHawk = bearishDescendingHawk.isSelected();
		s.bearishMatchingHigh = bearishMatchingHigh.isSelected();
		s.bearishTweezerTop = bearishTweezerTop.isSelected();
		s.bearishKicking = bearishKicking.isSelected();
		s.bearishDarkCloudCover = bearishDarkCloudCover.isSelected();
		s.bearishSeparatingLines = bearishSeparatingLines.isSelected();
		s.bearishThrusting = bearishThrusting.isSelected();
		s.bearishOnNeck = bearishOnNeck.isSelected();
		s.bearishInNeck = bearishInNeck.isSelected();
		s.bearishTriStar = bearishTriStar.isSelected();
		s.bearishTwoCrows = bearishTwoCrows.isSelected();
		s.bearishAdvanceBlock = bearishAdvanceBlock.isSelected();
		s.bearishDeliberation = bearishDeliberation.isSelected();
		s.bearishAbandonedBaby = bearishAbandonedBaby.isSelected();
		s.bearishEveningDojiStar = bearishEveningDojiStar.isSelected();
		s.bearishEveningStar = bearishEveningStar.isSelected();
		s.bearishThreeOutsideDown = bearishThreeOutsideDown.isSelected();
		s.bearishThreeInsideDown = bearishThreeInsideDown.isSelected();
		s.bearishUpsideGapTwoCrows = bearishUpsideGapTwoCrows.isSelected();
		s.bearishThreeBlackCrows = bearishThreeBlackCrows.isSelected();
		s.bearishIdenticalThreeCrows = bearishIdenticalThreeCrows.isSelected();
		s.bearishDownsideTasukiGap = bearishDownsideTasukiGap.isSelected();
		s.bearishDownsideGapThreeMethods = bearishDownsideGapThreeMethods.isSelected();
		s.bearishSideBySideWhiteLines = bearishSideBySideWhiteLines.isSelected();
		s.bearishThreeLineStrike = bearishThreeLineStrike.isSelected();
		s.bearishThreeGaps = bearishThreeGaps.isSelected();
		s.bearishBreakaway = bearishBreakaway.isSelected();
		s.bearishFallingThreeMethods = bearishFallingThreeMethods.isSelected();
	}

	@Override
	public void load(final ChartSettings settings) {
		setVisibleAdvancedOptions(settings.advancedOptions);
		final TimeSeriesSettings s = settings.timeSeries;

		this.signalMarker.setSelected(s.signalMarker);
		this.splitMarker.setSelected(s.splitMarker);

		this.fixed.setSelected(s.fixed);
		this.scale.setSelectedItem(s.scale);
		this.chartType.setSelectedItem(s.chartType);

		this.avgprice.setSelected(s.avgprice);
		this.mp.setSelected(s.mp);
		// ティピカル・プライス
		this.tp.setSelected(s.tp);
		// 加重終値
		this.wc.setSelected(s.wc);

		// 移動平均線
		this.ma.setSelected(s.ma);
		this.maType.setSelectedItem(s.maType);
		this.ma1Period.setValue(s.ma1Period);
		this.ma2Period.setValue(s.ma2Period);
		// 線形回帰トレンド
		this.lr.setSelected(s.lr);
		this.lr1Period.setValue(s.lr1Period);
		this.lr2Period.setValue(s.lr2Period);
		// 時系列カギ足
		kagi.setSelected(s.kagi);
		kagi_rate.setValue(s.kagi_rate);
		// Zig Zag
		zigzag.setSelected(s.zigzag);
		zigzag_rate.setValue(s.zigzag_rate);

		// バンド系
		this.bandType.setSelectedItem(s.bandType);
		// ボリンジャーバンド
		this.bbPeriod.setValue(s.bbPeriod);
		// ドンチャンズ
		this.donchianPeriod.setValue(s.donchianPeriod);
		// エンベロープ
		this.envelopeMaType.setSelectedItem(s.envelopeMaType);
		this.envelopePeriod.setValue(s.envelopePeriod);
		this.envelopeRate.setValue(s.envelopeRate);
		// チャネルシステム
		this.hlmaMaType.setSelectedItem(s.hlmaMaType);
		this.hmaPeriod.setValue(s.hmaPeriod);
		this.lmaPeriod.setValue(s.lmaPeriod);
		// 一目均衡表
		this.kijunPeriod.setValue(s.kijunPeriod);
		this.tenkanPeriod.setValue(s.tenkanPeriod);
		this.spanPeriod.setValue(s.spanPeriod);
		// ボラティリティ・システム
		this.atrPeriod.setValue(s.atrPeriod);
		this.atrWeight.setValue(s.atrWeight);

		// アルーン
		this.aroon.setSelected(s.aroon);
		this.aroonPeriod.setValue(s.aroonPeriod);

		// ATR
		atr.setSelected(s.atr);
		atr_period.setValue(s.atr_period);
		// NATR
		natr.setSelected(s.natr);
		natr_period.setValue(s.natr_period);
		// BMP
		bmp.setSelected(s.bop);
		// チャイキンズ・ボラティリティ
		this.chv.setSelected(s.chv);
		this.chv_period1.setValue(s.chv_period1);
		this.chv_period2.setValue(s.chv_period2);
		// CCI
		this.cci.setSelected(s.cci);
		this.cciPeriod.setValue(s.cciPeriod);
		this.cciUpperSignal.setValue(s.cciUpperSignal);
		this.cciLowerSignal.setValue(s.cciLowerSignal);
		// CMF
		this.cmf.setSelected(s.cmf);
		this.cmf_period.setValue(s.cmf_period);
		// CMO
		this.cmo.setSelected(s.cmo);
		this.cmo_period.setValue(s.cmo_period);
		this.cmo_upper_signal.setValue(s.cmo_upper_signal);
		this.cmo_lower_signal.setValue(s.cmo_lower_signal);
		// コポック
		this.coppock.setSelected(s.coppock);
		this.coppockRocPeriod.setValue(s.coppockRocPeriod);
		this.coppockMaType.setSelectedItem(s.coppockMaType);
		this.coppockPeriod.setValue(s.coppockPeriod);
		// DPO
		this.dpo.setSelected(s.dpo);
		this.dpoMaType.setSelectedItem(s.dpoMaType);
		this.dpoPeriod.setValue(s.dpoPeriod);
		// DMI
		this.dmi.setSelected(s.dmi);
		this.diPeriod.setValue(s.diPeriod);
		this.adxPeriod.setValue(s.adxPeriod);
		// EMV
		emv.setSelected(s.emv);
		emv_period.setValue(s.emv_period);
		// ヒストリカル・ボラティリティ
		this.hv.setSelected(s.hv);
		this.hvPeriod.setValue(s.hvPeriod);
		// BIAS (移動平均乖離率)
		this.kairi.setSelected(s.kairi);
		this.biasMaType.setSelectedItem(s.biasMaType);
		this.biasPeriod.setValue(s.biasPeriod);
		this.biasUpperSignal.setValue(s.biasUpperSignal);
		this.biasLowerSignal.setValue(s.biasLowerSignal);
		// マス・インデックス(MI)
		this.mi.setSelected(s.mi);
		this.miMaType.setSelectedItem(s.miMaType);
		this.miMaPeriod.setValue(s.miMaPeriod);
		this.miSumPeriod.setValue(s.miSumPeriod);
		// モメンタム
		this.mom.setSelected(s.mom);
		this.mom_period.setValue(s.mom_period);
		// MFI
		this.mfi.setSelected(s.mfi);
		this.mfiPeriod.setValue(s.mfiPeriod);
		this.mfiUpperSignal.setValue(s.mfiUpperSignal);
		this.mfiLowerSignal.setValue(s.mfiLowerSignal);
		// MACD
		this.macd.setSelected(s.macd);
		this.macdMa1Period.setValue(s.macdMa1Period);
		this.macdMa2Period.setValue(s.macdMa2Period);
		this.macdSignalMaType.setSelectedItem(s.macdSignalMaType);
		this.macdSignalPeriod.setValue(s.macdSignalPeriod);
		// PAIN
		this.pain.setSelected(s.pain);
		// PCR
		pcr.setSelected(s.pcr);
		pcr_period.setValue(s.pcr_period);
		pcr_upper_signal.setValue(s.pcr_upper_signal);
		pcr_lower_signal.setValue(s.pcr_lower_signal);
		// プライス・オシレータ(APO)
		this.apo.setSelected(s.apo);
		this.apoMa1Period.setValue(s.apoMa1Period);
		this.apoMa2Period.setValue(s.apoMa2Period);
		// プライス・オシレータ(PPO)
		this.ppo.setSelected(s.ppo);
		this.ppoMa1Period.setValue(s.ppoMa1Period);
		this.ppoMa2Period.setValue(s.ppoMa2Period);
		// サイコロジカル・ライン
		this.psy.setSelected(s.psy);
		this.psy_period.setValue(s.psy_period);
		this.psy_upper_signal.setValue(s.psy_upper_signal);
		this.psy_lower_signal.setValue(s.psy_lower_signal);
		// qstick
		this.qstick.setSelected(s.qstick);
		this.qstick_matype.setSelectedItem(s.qstick_matype);
		this.qstick_period.setValue(s.qstick_period);
		// RCI (順位相関指数)
		this.rci.setSelected(s.rci);
		this.rciPeriod.setValue(s.rciPeriod);
		this.rciUpperSignal.setValue(s.rciUpperSignal);
		this.rciLowerSignal.setValue(s.rciLowerSignal);
		// ROC
		this.roc.setSelected(s.roc);
		this.rocPeriod.setValue(s.rocPeriod);
		// RSI (相対力指数)
		this.rsi.setSelected(s.rsi);
		this.rsiPeriod.setValue(s.rsiPeriod);
		this.rsiUpperSignal.setValue(s.rsiUpperSignal);
		this.rsiLowerSignal.setValue(s.rsiLowerSignal);
		// RVI
		rvi.setSelected(s.rvi);
		rvi_period.setValue(s.rvi_period);
		rvi_upper_signal.setValue(s.rvi_upper_signal);
		rvi_lower_signal.setValue(s.rvi_lower_signal);
		// 強弱レシオ(篠原レシオ)
		this.shinohara.setSelected(s.shinohara);
		this.shinoharaPeriod.setValue(s.shinoharaPeriod);
		// ストキャスティクス
		this.srv.setSelected(s.srv);
		this.srvKPeriod.setValue(s.srvKPeriod);
		this.srvDPeriod.setValue(s.srvDPeriod);
		this.srvUpperSignal.setValue(s.srvUpperSignal);
		this.srvLowerSignal.setValue(s.srvLowerSignal);
		// TII
		this.tii.setSelected(s.tii);
		this.tii_matype.setSelectedItem(s.tii_matype);
		this.tii_period.setValue(s.tii_period);
		this.tii_upper_signal.setValue(s.tii_upper_signal);
		this.tii_lower_signal.setValue(s.tii_lower_signal);
		// トリックス(Trix)
		this.trix.setSelected(s.trix);
		this.trixPeriod.setValue(s.trixPeriod);
		this.trixSignalMaType.setSelectedItem(s.trixSignalMaType);
		this.trixSignalPeriod.setValue(s.trixSignalPeriod);
		// TSI
		this.tsi.setSelected(s.tsi);
		this.tsi_period1.setValue(s.tsi_period1);
		this.tsi_period2.setValue(s.tsi_period2);
		this.tsi_signal_matype.setSelectedItem(s.tsi_signal_matype);
		this.tsi_signal_period.setValue(s.tsi_signal_period);
		this.tsi_upper_signal.setValue(s.tsi_upper_signal);
		this.tsi_lower_signal.setValue(s.tsi_lower_signal);
		// 究極のオシレータ
		this.ultimate.setSelected(s.ultimate);
		this.ultimatePeriod.setValue(s.ultimatePeriod);
		// ウィリアムズAD
		this.wad.setSelected(s.wad);
		// ウィリアムズ%R
		this.williamsR.setSelected(s.williamsR);
		this.williamsRPeriod.setValue(s.williamsRPeriod);
		this.williamsRUpperSignal.setValue(s.williamsRUpperSignal);
		this.williamsRLowerSignal.setValue(s.williamsRLowerSignal);

		// 出来高
		this.volumeType.setSelectedItem(s.volumeType);
		// A/Dライン
		this.ad.setSelected(s.ad);
		// チャイキンズA/Dオシレーター
		this.cho.setSelected(s.cho);
		this.cho_matype.setSelectedItem(s.cho_matype);
		this.cho_fast.setValue(s.cho_fast);
		this.cho_slow.setValue(s.cho_slow);
		// 出来高移動平均
		this.vmaMaType.setSelectedItem(s.vmaMaType);
		this.vma1Period.setValue(s.vma1Period);
		this.vma2Period.setValue(s.vma2Period);
		// 出来高乖離率
		this.vkairi.setSelected(s.vkairi);
		this.vkairiMaType.setSelectedItem(s.vbiasMaType);
		this.vkairiPeriod.setValue(s.vbiasPeriod);
		// ボリューム・オシレータ(AVO)
		this.avo.setSelected(s.avo);
		this.avoMa1Period.setValue(s.avoMa1Period);
		this.avoMa2Period.setValue(s.avoMa2Period);
		// ボリューム・オシレータ(PVO)
		this.pvo.setSelected(s.pvo);
		this.pvoMa1Period.setValue(s.pvoMa1Period);
		this.pvoMa2Period.setValue(s.pvoMa2Period);
		// 出来高ROC
		this.vroc.setSelected(s.vroc);
		this.vrocPeriod.setValue(s.vrocPeriod);
		// ボリュームレシオ1
		this.vr1.setSelected(s.vr1);
		this.vr1Period.setValue(s.vr1Period);
		this.vr1UpperSignal.setValue(s.vr1UpperSignal);
		this.vr1LowerSignal.setValue(s.vr1LowerSignal);
		// ボリュームレシオ2
		this.vr2.setSelected(s.vr2);
		this.vr2Period.setValue(s.vr2Period);
		this.vr2UpperSignal.setValue(s.vr2UpperSignal);
		this.vr2LowerSignal.setValue(s.vr2LowerSignal);
		// V-RSI (出来高相対力指数)
		this.vrsi.setSelected(s.vrsi);
		this.vrsiPeriod.setValue(s.vrsiPeriod);
		this.vrsiUpperSignal.setValue(s.vrsiUpperSignal);
		this.vrsiLowerSignal.setValue(s.vrsiLowerSignal);
		// 和光ボリュームレシオ
		this.wvr.setSelected(s.wvr);
		this.wvrPeriod.setValue(s.wvrPeriod);
		this.wvrUpperSignal.setValue(s.wvrUpperSignal);
		this.wvrLowerSignal.setValue(s.wvrLowerSignal);
		// PVI
		this.pvi.setSelected(s.pvi);
		this.pvi_matype.setSelectedItem(s.pvi_matype);
		this.pvi_fast.setValue(s.pvi_fast);
		this.pvi_slow.setValue(s.pvi_slow);
		// NVI
		this.nvi.setSelected(s.nvi);
		this.nvi_matype.setSelectedItem(s.nvi_matype);
		this.nvi_fast.setValue(s.nvi_fast);
		this.nvi_slow.setValue(s.nvi_slow);
		// OBV
		this.obv.setSelected(s.obv);
		this.obvPeriod.setValue(s.obvPeriod);
		// PVT
		this.pvt.setSelected(s.pvt);

		// 価格帯別出来高
		this.vp.setSelected(s.vp);
		this.vpCount.setValue(s.vpCount);

		// 信用倍率
		this.ratio.setSelected(s.ratio);
		this.ratioUpperSignal.setValue(s.ratioUpperSignal);
		this.ratioLowerSignal.setValue(s.ratioLowerSignal);
		// 騰落価格
		this.priceFluctuations.setSelected(s.price_performance);
		this.priceFluctuationsPeriodType.setSelectedItem(s.priceFluctuationsPeriodType);
		// 騰落率
		this.fluctuations.setSelected(s.percent_performance);
		this.fluctuationsPeriodType.setSelectedItem(s.performancePeriodType);

		// ローソク足パターン
		candlestickTrend.setSelectedItem(s.candleTrend);
		bullishLongWhiteDay.setSelected(s.bullishLongWhiteDay);
		bullishBeltHold.setSelected(s.bullishBeltHold);
		bullishHammer.setSelected(s.bullishHammer);
		bullishDragonflyDoji.setSelected(s.bullishDragonflyDoji);
		bullishLongLeggedDoji.setSelected(s.bullishLongLeggedDoji);
		bullishInvertedHammer.setSelected(s.bullishInvertedHammer);
		bullishHarami.setSelected(s.bullishHarami);
		bullishHaramiCross.setSelected(s.bullishHaramiCross);
		bullishEngulfing.setSelected(s.bullishEngulfing);
		bullishGravestoneDoji.setSelected(s.bullishGravestoneDoji);
		bullishMeetingLines.setSelected(s.bullishMeetingLines);
		bullishDojiStar.setSelected(s.bullishDojiStar);
		bullishHomingPigeon.setSelected(s.bullishHomingPigeon);
		bullishMatchingLow.setSelected(s.bullishMatchingLow);
		bullishTweezerBottom.setSelected(s.bullishTweezerBottom);
		bullishKicking.setSelected(s.bullishKicking);
		bullishPiercingLine.setSelected(s.bullishPiercingLine);
		bullishSeparatingLines.setSelected(s.bullishSeparatingLines);
		bullishTriStar.setSelected(s.bullishTriStar);
		bullishThreeStarsInTheSouth.setSelected(s.bullishThreeStarsInTheSouth);
		bullishUniqueThreeRiverBottom.setSelected(s.bullishUniqueThreeRiverBottom);
		bullishStickSandwich.setSelected(s.bullishStickSandwich);
		bullishAbandonedBaby.setSelected(s.bullishAbandonedBaby);
		bullishMorningDojiStar.setSelected(s.bullishMorningDojiStar);
		bullishMorningStar.setSelected(s.bullishMorningStar);
		bullishThreeOutsideUp.setSelected(s.bullishThreeOutsideUp);
		bullishThreeInsideUp.setSelected(s.bullishThreeInsideUp);
		bullishThreeWhiteSoldiers.setSelected(s.bullishThreeWhiteSoldiers);
		bullishUpsideTasukiGap.setSelected(s.bullishUpsideTasukiGap);
		bullishUpsideGapThreeMethods.setSelected(s.bullishUpsideGapThreeMethods);
		bullishSideBySideWhiteLines.setSelected(s.bullishSideBySideWhiteLines);
		bullishConcealingBabySwallow.setSelected(s.bullishConcealingBabySwallow);
		bullishThreeLineStrike.setSelected(s.bullishThreeLineStrike);
		bullishThreeGaps.setSelected(s.bullishThreeGaps);
		bullishBreakaway.setSelected(s.bullishBreakaway);
		bullishLadderBottom.setSelected(s.bullishLadderBottom);
		bullishRisingThreeMethods.setSelected(s.bullishRisingThreeMethods);
		bullishMatHold.setSelected(s.bullishMatHold);

		bearishLongBlackDay.setSelected(s.bearishLongBlackDay);
		bearishBeltHold.setSelected(s.bearishBeltHold);
		bearishHangingMan.setSelected(s.bearishHangingMan);
		bearishDragonflyDoji.setSelected(s.bearishDragonflyDoji);
		bearishLongLeggedDoji.setSelected(s.bearishLongLeggedDoji);
		bearishShootingStar.setSelected(s.bearishShootingStar);
		bearishHarami.setSelected(s.bearishHarami);
		bearishHaramiCross.setSelected(s.bearishHaramiCross);
		bearishEngulfing.setSelected(s.bearishEngulfing);
		bearishGravestoneDoji.setSelected(s.bearishGravestoneDoji);
		bearishMeetingLines.setSelected(s.bearishMeetingLines);
		bearishDojiStar.setSelected(s.bearishDojiStar);
		bearishDescendingHawk.setSelected(s.bearishDescendingHawk);
		bearishMatchingHigh.setSelected(s.bearishMatchingHigh);
		bearishTweezerTop.setSelected(s.bearishTweezerTop);
		bearishKicking.setSelected(s.bearishKicking);
		bearishDarkCloudCover.setSelected(s.bearishDarkCloudCover);
		bearishSeparatingLines.setSelected(s.bearishSeparatingLines);
		bearishThrusting.setSelected(s.bearishThrusting);
		bearishOnNeck.setSelected(s.bearishOnNeck);
		bearishInNeck.setSelected(s.bearishInNeck);
		bearishTriStar.setSelected(s.bearishTriStar);
		bearishTwoCrows.setSelected(s.bearishTwoCrows);
		bearishAdvanceBlock.setSelected(s.bearishAdvanceBlock);
		bearishDeliberation.setSelected(s.bearishDeliberation);
		bearishAbandonedBaby.setSelected(s.bearishAbandonedBaby);
		bearishEveningDojiStar.setSelected(s.bearishEveningDojiStar);
		bearishEveningStar.setSelected(s.bearishEveningStar);
		bearishThreeOutsideDown.setSelected(s.bearishThreeOutsideDown);
		bearishThreeInsideDown.setSelected(s.bearishThreeInsideDown);
		bearishUpsideGapTwoCrows.setSelected(s.bearishUpsideGapTwoCrows);
		bearishThreeBlackCrows.setSelected(s.bearishThreeBlackCrows);
		bearishIdenticalThreeCrows.setSelected(s.bearishIdenticalThreeCrows);
		bearishDownsideTasukiGap.setSelected(s.bearishDownsideTasukiGap);
		bearishDownsideGapThreeMethods.setSelected(s.bearishDownsideGapThreeMethods);
		bearishSideBySideWhiteLines.setSelected(s.bearishSideBySideWhiteLines);
		bearishThreeLineStrike.setSelected(s.bearishThreeLineStrike);
		bearishThreeGaps.setSelected(s.bearishThreeGaps);
		bearishBreakaway.setSelected(s.bearishBreakaway);
		bearishFallingThreeMethods.setSelected(s.bearishFallingThreeMethods);
	}

	// ------------------------------------------------------------

	@Override
	public void datasetSwitch(final ChartEvent e) {
		super.notify = false;
		final boolean enabled = e.getDataset() != null;

		this.signalMarker.setEnabled(enabled);
		this.splitMarker.setEnabled(enabled);

		this.fixed.setEnabled(enabled);
		this.scale.setEnabled(enabled);
		this.chartType.setEnabled(enabled);

		this.avgprice.setEnabled(enabled);
		this.mp.setEnabled(enabled);
		// ティピカルプライス
		this.tp.setEnabled(enabled);
		// 加重終値
		this.wc.setEnabled(enabled);

		// 移動平均線
		this.ma.setEnabled(enabled);
		this.maType.setEnabled(enabled);
		this.ma1Period.setEnabled(enabled);
		this.ma2Period.setEnabled(enabled);
		// 線形回帰トレンド
		this.lr.setEnabled(enabled);
		this.lr1Period.setEnabled(enabled);
		this.lr2Period.setEnabled(enabled);
		// 時系列カギ足
		kagi.setEnabled(enabled);
		kagi_rate.setEnabled(enabled);
		// Zig Zag
		zigzag.setEnabled(enabled);
		zigzag_rate.setEnabled(enabled);

		// バンド系
		this.bandType.setEnabled(enabled);
		// ボリンジャーバンド
		this.bbPeriod.setEnabled(enabled);
		// ドンチャンズ
		this.donchianPeriod.setEnabled(enabled);
		// エンベロープ
		this.envelopeMaType.setEnabled(enabled);
		this.envelopePeriod.setEnabled(enabled);
		this.envelopeRate.setEnabled(enabled);
		// チャネルシステム
		this.hlmaMaType.setEnabled(enabled);
		this.hmaPeriod.setEnabled(enabled);
		this.lmaPeriod.setEnabled(enabled);
		// ボラティリティ・システム
		this.atrPeriod.setEnabled(enabled);
		this.atrWeight.setEnabled(enabled);
		// 一目均衡表
		this.kijunPeriod.setEnabled(enabled);
		this.tenkanPeriod.setEnabled(enabled);
		this.spanPeriod.setEnabled(enabled);

		// アルーン
		this.aroon.setEnabled(enabled);
		this.aroonPeriod.setEnabled(enabled);
		// ATR
		atr.setEnabled(enabled);
		natr.setEnabled(enabled);
		// BMP
		bmp.setEnabled(enabled);
		// チャイキンズ・ボラティリティ
		this.chv.setEnabled(enabled);
		this.chv_period1.setEnabled(enabled);
		this.chv_period2.setEnabled(enabled);
		// CCI
		this.cci.setEnabled(enabled);
		this.cciPeriod.setEnabled(enabled);
		this.cciUpperSignal.setEnabled(enabled);
		this.cciLowerSignal.setEnabled(enabled);
		// CMF
		this.cmf.setEnabled(enabled);
		this.cmf_period.setEnabled(enabled);
		// CMO
		this.cmo.setEnabled(enabled);
		this.cmo_period.setEnabled(enabled);
		this.cmo_upper_signal.setEnabled(enabled);
		this.cmo_lower_signal.setEnabled(enabled);
		// コポック
		this.coppock.setEnabled(enabled);
		this.coppockRocPeriod.setEnabled(enabled);
		this.coppockMaType.setEnabled(enabled);
		this.coppockPeriod.setEnabled(enabled);
		// DPO
		this.dpo.setEnabled(enabled);
		this.dpoMaType.setEnabled(enabled);
		this.dpoPeriod.setEnabled(enabled);
		// DMI
		this.dmi.setEnabled(enabled);
		this.diPeriod.setEnabled(enabled);
		this.adxPeriod.setEnabled(enabled);
		// EMV
		emv.setEnabled(enabled);
		emv_period.setEnabled(enabled);
		// ヒストリカル・ボラティリティ
		this.hv.setEnabled(enabled);
		this.hvPeriod.setEnabled(enabled);
		// BIAS (移動平均乖離率)
		this.kairi.setEnabled(enabled);
		this.biasMaType.setEnabled(enabled);
		this.biasPeriod.setEnabled(enabled);
		this.biasUpperSignal.setEnabled(enabled);
		this.biasLowerSignal.setEnabled(enabled);
		// マス・インデックス(MI)
		this.mi.setEnabled(enabled);
		this.miMaType.setEnabled(enabled);
		this.miMaPeriod.setEnabled(enabled);
		this.miSumPeriod.setEnabled(enabled);
		// モメンタム
		this.mom.setEnabled(enabled);
		this.mom_period.setEnabled(enabled);
		// MFI
		this.mfi.setEnabled(enabled);
		this.mfiPeriod.setEnabled(enabled);
		this.mfiUpperSignal.setEnabled(enabled);
		this.mfiLowerSignal.setEnabled(enabled);
		// MACD
		this.macd.setEnabled(enabled);
		this.macdMa1Period.setEnabled(enabled);
		this.macdMa2Period.setEnabled(enabled);
		this.macdSignalMaType.setEnabled(enabled);
		this.macdSignalPeriod.setEnabled(enabled);
		// PAIN
		this.pain.setEnabled(enabled);
		// PCR
		pcr.setEnabled(enabled);
		pcr_period.setEnabled(enabled);
		pcr_upper_signal.setEnabled(enabled);
		pcr_lower_signal.setEnabled(enabled);
		// プライス・オシレータ(APO)
		this.apo.setEnabled(enabled);
		this.apoMa1Period.setEnabled(enabled);
		this.apoMa2Period.setEnabled(enabled);
		// プライス・オシレータ(PPO)
		this.ppo.setEnabled(enabled);
		this.ppoMa1Period.setEnabled(enabled);
		this.ppoMa2Period.setEnabled(enabled);
		// サイコロジカル・ライン
		this.psy.setEnabled(enabled);
		this.psy_period.setEnabled(enabled);
		this.psy_upper_signal.setEnabled(enabled);
		this.psy_lower_signal.setEnabled(enabled);
		// qstick
		this.qstick.setEnabled(enabled);
		this.qstick_matype.setEnabled(enabled);
		this.qstick_period.setEnabled(enabled);
		// RCI (順位相関指数)
		this.rci.setEnabled(enabled);
		this.rciPeriod.setEnabled(enabled);
		this.rciUpperSignal.setEnabled(enabled);
		this.rciLowerSignal.setEnabled(enabled);
		// ROC
		this.roc.setEnabled(enabled);
		this.rocPeriod.setEnabled(enabled);
		// RSI (相対力指数)
		this.rsi.setEnabled(enabled);
		this.rsiPeriod.setEnabled(enabled);
		this.rsiUpperSignal.setEnabled(enabled);
		this.rsiLowerSignal.setEnabled(enabled);
		// RVI
		rvi.setEnabled(enabled);
		rvi_period.setEnabled(enabled);
		rvi_upper_signal.setEnabled(enabled);
		rvi_lower_signal.setEnabled(enabled);
		// 強弱レシオ(篠原レシオ)
		this.shinohara.setEnabled(enabled);
		this.shinoharaPeriod.setEnabled(enabled);
		// ストキャスティクス
		this.srv.setEnabled(enabled);
		this.srvKPeriod.setEnabled(enabled);
		this.srvDPeriod.setEnabled(enabled);
		this.srvUpperSignal.setEnabled(enabled);
		this.srvLowerSignal.setEnabled(enabled);
		// TII
		this.tii.setEnabled(enabled);
		this.tii_matype.setEnabled(enabled);
		this.tii_period.setEnabled(enabled);
		this.tii_upper_signal.setEnabled(enabled);
		this.tii_lower_signal.setEnabled(enabled);
		// トリックス(Trix)
		this.trix.setEnabled(enabled);
		this.trixPeriod.setEnabled(enabled);
		this.trixSignalMaType.setEnabled(enabled);
		this.trixSignalPeriod.setEnabled(enabled);
		// TSI
		this.tsi.setEnabled(enabled);
		this.tsi_period1.setEnabled(enabled);
		this.tsi_period2.setEnabled(enabled);
		this.tsi_signal_matype.setEnabled(enabled);
		this.tsi_signal_period.setEnabled(enabled);
		this.tsi_upper_signal.setEnabled(enabled);
		this.tsi_lower_signal.setEnabled(enabled);
		// 究極のオシレーター
		this.ultimate.setEnabled(enabled);
		this.ultimatePeriod.setEnabled(enabled);
		// ウィリアムズAD
		this.wad.setEnabled(enabled);
		// ウィリアムズ%R
		this.williamsR.setEnabled(enabled);
		this.williamsRPeriod.setEnabled(enabled);
		this.williamsRUpperSignal.setEnabled(enabled);
		this.williamsRLowerSignal.setEnabled(enabled);

		// 出来高
		this.volumeType.setEnabled(enabled);
		// A/Dライン
		this.ad.setEnabled(enabled);
		// チャイキンズA/Dオシレーター
		this.cho.setEnabled(enabled);
		this.cho_matype.setEnabled(enabled);
		this.cho_fast.setEnabled(enabled);
		this.cho_slow.setEnabled(enabled);
		// 出来高移動平均
		this.vmaMaType.setEnabled(enabled);
		this.vma1Period.setEnabled(enabled);
		this.vma2Period.setEnabled(enabled);
		// 出来高乖離率
		this.vkairi.setEnabled(enabled);
		this.vkairiMaType.setEnabled(enabled);
		this.vkairiPeriod.setEnabled(enabled);
		// ボリューム・オシレータ(AVO)
		this.avo.setEnabled(enabled);
		this.avoMa1Period.setEnabled(enabled);
		this.avoMa2Period.setEnabled(enabled);
		// ボリューム・オシレータ(PVO)
		this.pvo.setEnabled(enabled);
		this.pvoMa1Period.setEnabled(enabled);
		this.pvoMa2Period.setEnabled(enabled);
		// 出来高ROC
		this.vroc.setEnabled(enabled);
		this.vrocPeriod.setEnabled(enabled);
		// ボリュームレシオ1
		this.vr1.setEnabled(enabled);
		this.vr1Period.setEnabled(enabled);
		this.vr1UpperSignal.setEnabled(enabled);
		this.vr1LowerSignal.setEnabled(enabled);
		// ボリュームレシオ2
		this.vr2.setEnabled(enabled);
		this.vr2Period.setEnabled(enabled);
		this.vr2UpperSignal.setEnabled(enabled);
		this.vr2LowerSignal.setEnabled(enabled);
		// V-RSI (出来高相対力指数)
		this.vrsi.setEnabled(enabled);
		this.vrsiPeriod.setEnabled(enabled);
		this.vrsiUpperSignal.setEnabled(enabled);
		this.vrsiLowerSignal.setEnabled(enabled);
		// 和光ボリュームレシオ
		this.wvr.setEnabled(enabled);
		this.wvrPeriod.setEnabled(enabled);
		this.wvrUpperSignal.setEnabled(enabled);
		this.wvrLowerSignal.setEnabled(enabled);
		// PVI
		this.pvi.setEnabled(enabled);
		this.pvi_matype.setEnabled(enabled);
		this.pvi_fast.setEnabled(enabled);
		this.pvi_slow.setEnabled(enabled);
		// NVI
		this.nvi.setEnabled(enabled);
		this.nvi_matype.setEnabled(enabled);
		this.nvi_fast.setEnabled(enabled);
		this.nvi_slow.setEnabled(enabled);
		// OBV
		this.obv.setEnabled(enabled);
		this.obvPeriod.setEnabled(enabled);
		// PVT
		this.pvt.setEnabled(enabled);

		// 価格帯別出来高
		this.vp.setEnabled(enabled);
		this.vpCount.setEnabled(enabled);

		// 信用倍率
		this.ratio.setEnabled(enabled);
		this.ratioUpperSignal.setEnabled(enabled);
		this.ratioLowerSignal.setEnabled(enabled);
		// 騰落価格
		this.priceFluctuations.setEnabled(enabled);
		this.priceFluctuationsPeriodType.setEnabled(enabled);
		// 騰落率
		this.fluctuations.setEnabled(enabled);
		this.fluctuationsPeriodType.setEnabled(enabled);

		// ローソク足パターン
		candlestickTrend.setEnabled(enabled);

		bullishLongWhiteDay.setEnabled(enabled);
		bullishBeltHold.setEnabled(enabled);
		bullishHammer.setEnabled(enabled);
		bullishDragonflyDoji.setEnabled(enabled);
		bullishLongLeggedDoji.setEnabled(enabled);
		bullishInvertedHammer.setEnabled(enabled);
		bullishHarami.setEnabled(enabled);
		bullishHaramiCross.setEnabled(enabled);
		bullishEngulfing.setEnabled(enabled);
		bullishGravestoneDoji.setEnabled(enabled);
		bullishMeetingLines.setEnabled(enabled);
		bullishDojiStar.setEnabled(enabled);
		bullishHomingPigeon.setEnabled(enabled);
		bullishMatchingLow.setEnabled(enabled);
		bullishTweezerBottom.setEnabled(enabled);
		bullishKicking.setEnabled(enabled);
		bullishPiercingLine.setEnabled(enabled);
		bullishSeparatingLines.setEnabled(enabled);
		bullishTriStar.setEnabled(enabled);
		bullishThreeStarsInTheSouth.setEnabled(enabled);
		bullishUniqueThreeRiverBottom.setEnabled(enabled);
		bullishStickSandwich.setEnabled(enabled);
		bullishAbandonedBaby.setEnabled(enabled);
		bullishMorningDojiStar.setEnabled(enabled);
		bullishMorningStar.setEnabled(enabled);
		bullishThreeOutsideUp.setEnabled(enabled);
		bullishThreeInsideUp.setEnabled(enabled);
		bullishThreeWhiteSoldiers.setEnabled(enabled);
		bullishUpsideTasukiGap.setEnabled(enabled);
		bullishUpsideGapThreeMethods.setEnabled(enabled);
		bullishSideBySideWhiteLines.setEnabled(enabled);
		bullishConcealingBabySwallow.setEnabled(enabled);
		bullishThreeLineStrike.setEnabled(enabled);
		bullishThreeGaps.setEnabled(enabled);
		bullishBreakaway.setEnabled(enabled);
		bullishLadderBottom.setEnabled(enabled);
		bullishRisingThreeMethods.setEnabled(enabled);
		bullishMatHold.setEnabled(enabled);

		bearishLongBlackDay.setEnabled(enabled);
		bearishBeltHold.setEnabled(enabled);
		bearishHangingMan.setEnabled(enabled);
		bearishDragonflyDoji.setEnabled(enabled);
		bearishLongLeggedDoji.setEnabled(enabled);
		bearishShootingStar.setEnabled(enabled);
		bearishHarami.setEnabled(enabled);
		bearishHaramiCross.setEnabled(enabled);
		bearishEngulfing.setEnabled(enabled);
		bearishGravestoneDoji.setEnabled(enabled);
		bearishMeetingLines.setEnabled(enabled);
		bearishDojiStar.setEnabled(enabled);
		bearishDescendingHawk.setEnabled(enabled);
		bearishMatchingHigh.setEnabled(enabled);
		bearishTweezerTop.setEnabled(enabled);
		bearishKicking.setEnabled(enabled);
		bearishDarkCloudCover.setEnabled(enabled);
		bearishSeparatingLines.setEnabled(enabled);
		bearishThrusting.setEnabled(enabled);
		bearishOnNeck.setEnabled(enabled);
		bearishInNeck.setEnabled(enabled);
		bearishTriStar.setEnabled(enabled);
		bearishTwoCrows.setEnabled(enabled);
		bearishAdvanceBlock.setEnabled(enabled);
		bearishDeliberation.setEnabled(enabled);
		bearishAbandonedBaby.setEnabled(enabled);
		bearishEveningDojiStar.setEnabled(enabled);
		bearishEveningStar.setEnabled(enabled);
		bearishThreeOutsideDown.setEnabled(enabled);
		bearishThreeInsideDown.setEnabled(enabled);
		bearishUpsideGapTwoCrows.setEnabled(enabled);
		bearishThreeBlackCrows.setEnabled(enabled);
		bearishIdenticalThreeCrows.setEnabled(enabled);
		bearishDownsideTasukiGap.setEnabled(enabled);
		bearishDownsideGapThreeMethods.setEnabled(enabled);
		bearishSideBySideWhiteLines.setEnabled(enabled);
		bearishThreeLineStrike.setEnabled(enabled);
		bearishThreeGaps.setEnabled(enabled);
		bearishBreakaway.setEnabled(enabled);
		bearishFallingThreeMethods.setEnabled(enabled);

		if (enabled)
			load(e.getSettings());

		super.notify = true;
	}

	/**
	 * この実装は何も行いません。
	 */
	@Override
	public void periodSwitch(final ChartEvent e) {}

	/**
	 * この実装は何も行いません。
	 */
	@Override
	public void settingChanged(final ChartEvent e) {}

	/**
	 * この実装は何も行いません。
	 */
	@Override
	public void positionChanged(final ChartScreenEvent e) {}

	// ------------------------------------------------------------
	// コントロールイベント

	/**
	 * コンボボックスの選択値が変更されると呼び出され、パラメータ入力用パネルの表示/非表示を切替えます。
	 */
	@Override
	public void actionPerformed(final ActionEvent e) {
		// 目盛り
		if (e.getSource().equals(this.scale)) {
			final PriceScaleType type = (PriceScaleType) this.scale.getSelectedItem();
			final boolean b = (type == PriceScaleType.LOG);
			this.fixed.setEnabled(!b);
			if (b && this.fixed.isSelected())
				this.fixed.setSelected(false);
		// バンド系
		} else if (e.getSource().equals(this.bandType)) {
			for (final JPanel panel : this.bandParamPanels.values())
				panel.setVisible(false);
			final JPanel panel = this.bandParamPanels.get(this.bandType.getSelectedItem());
			if (panel != null)
				panel.setVisible(true);
		// 出来高
		} else if (e.getSource().equals(this.volumeType)) {
			for (final JPanel panel : this.volumeParamPanels.values())
				panel.setVisible(false);
			final JPanel panel = this.volumeParamPanels.get(this.volumeType.getSelectedItem());
			if (panel != null)
				panel.setVisible(true);
		}

		super.actionPerformed(e);
	}

	/**
	 * チェックボックスの値が変更されると呼び出され、パラメータ入力用パネルの表示/非表示を切替えます。
	 */
	@Override
	public void itemStateChanged(final ItemEvent e) {
		final Object obj = e.getSource();

		if (obj instanceof JCheckBox) {
			final JPanel panel = this.paramPanels.get(obj);
			if (panel != null) {
				final JCheckBox check = (JCheckBox) obj;
				panel.setVisible(check.isSelected());
			}
		}

		super.itemStateChanged(e);
	}

	@Override
	public void setVisibleAdvancedOptions(final boolean visible) {
		this.fixed.setVisible(visible);

		this.lr.setVisible(visible);
		this.paramPanels.get(this.lr).setVisible(visible && this.lr.isSelected());
		this.avgprice.setVisible(visible);
		this.mp.setVisible(visible);
		this.tp.setVisible(visible);
		this.wc.setVisible(visible);

		this.aroon.setVisible(visible);
		this.paramPanels.get(this.aroon).setVisible(visible && this.aroon.isSelected());
		this.chv.setVisible(visible);
		this.paramPanels.get(this.chv).setVisible(visible && this.chv.isSelected());
		this.cci.setVisible(visible);
		this.paramPanels.get(this.cci).setVisible(visible && this.cci.isSelected());
		this.cmf.setVisible(visible);
		this.paramPanels.get(this.cmf).setVisible(visible && this.cmf.isSelected());
		this.cmo.setVisible(visible);
		this.paramPanels.get(this.cmo).setVisible(visible && this.cmo.isSelected());
		this.coppock.setVisible(visible);
		this.paramPanels.get(this.coppock).setVisible(visible && this.coppock.isSelected());
		this.dpo.setVisible(visible);
		this.paramPanels.get(this.dpo).setVisible(visible && this.dpo.isSelected());
		this.mi.setVisible(visible);
		this.paramPanels.get(this.mi).setVisible(visible && this.mi.isSelected());
		this.hv.setVisible(visible);
		this.paramPanels.get(this.hv).setVisible(visible && this.hv.isSelected());
		this.pain.setVisible(visible);
		this.apo.setVisible(visible);
		this.paramPanels.get(this.apo).setVisible(visible && this.apo.isSelected());
		this.ppo.setVisible(visible);
		this.paramPanels.get(this.ppo).setVisible(visible && this.ppo.isSelected());
		this.qstick.setVisible(visible);
		this.paramPanels.get(this.qstick).setVisible(visible && this.qstick.isSelected());
		this.shinohara.setVisible(visible);
		this.paramPanels.get(this.shinohara).setVisible(visible && this.shinohara.isSelected());
		this.tii.setVisible(visible);
		this.paramPanels.get(this.tii).setVisible(visible && this.tii.isSelected());
		this.trix.setVisible(visible);
		this.paramPanels.get(this.trix).setVisible(visible && this.trix.isSelected());
		this.tsi.setVisible(visible);
		this.paramPanels.get(this.tsi).setVisible(visible && this.tsi.isSelected());
		this.ultimate.setVisible(visible);
		this.paramPanels.get(this.ultimate).setVisible(visible && this.ultimate.isSelected());
		this.wad.setVisible(visible);

		this.ad.setVisible(visible);
		this.cho.setVisible(visible);
		this.paramPanels.get(this.cho).setVisible(visible && this.cho.isSelected());
		this.vkairi.setVisible(visible);
		this.paramPanels.get(this.vkairi).setVisible(visible && this.vkairi.isSelected());
		this.avo.setVisible(visible);
		this.paramPanels.get(this.avo).setVisible(visible && this.avo.isSelected());
		this.pvo.setVisible(visible);
		this.paramPanels.get(this.pvo).setVisible(visible && this.pvo.isSelected());
		this.vroc.setVisible(visible);
		this.paramPanels.get(this.vroc).setVisible(visible && this.vroc.isSelected());
		this.vrsi.setVisible(visible);
		this.paramPanels.get(this.vrsi).setVisible(visible && this.vrsi.isSelected());
		this.wvr.setVisible(visible);
		this.paramPanels.get(this.wvr).setVisible(visible && this.wvr.isSelected());
		this.pvi.setVisible(visible);
		this.paramPanels.get(this.pvi).setVisible(visible && this.pvi.isSelected());
		this.nvi.setVisible(visible);
		this.paramPanels.get(this.nvi).setVisible(visible && this.nvi.isSelected());
		this.obv.setVisible(visible);
		this.paramPanels.get(this.obv).setVisible(visible && this.obv.isSelected());
		this.pvt.setVisible(visible);

//		this.ratio.setVisible(visible);
//		this.paramPanels.get(this.ratio).setVisible(visible && this.ratio.isSelected());
		this.priceFluctuations.setVisible(visible);
		this.paramPanels.get(this.priceFluctuations).setVisible(visible && this.priceFluctuations.isSelected());
		this.fluctuations.setVisible(visible);
		this.paramPanels.get(this.fluctuations).setVisible(visible && this.fluctuations.isSelected());
	}

}
