/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.ui.screen;

import java.awt.BorderLayout;

import javax.swing.JScrollPane;
import javax.swing.JTextArea;

import jp.sf.orangesignal.chart.ChartSettings;
import jp.sf.orangesignal.chart.data.BasicChartDataset;
import jp.sf.orangesignal.chart.event.ChartEvent;
import jp.sf.orangesignal.chart.ui.Icons;
import jp.sf.orangesignal.chart.util.StringManager;
import jp.sf.orangesignal.ta.util.StringUtils;

/**
 * 履歴画面を提供します。
 * 
 * @author 杉澤 浩二
 */
public class HistoricalDataScreen extends ChartScreen {

	private static final long serialVersionUID = 2858523354616362299L;

	/**
	 * 区切り文字を表します。
	 */
	private static final char SEPARATOR = '\t';

	/**
	 * テキストエリアを保持します。
	 */
	private final JTextArea text = new JTextArea();

	/**
	 * コンストラクタです。
	 * 
	 * @param icons アイコン情報
	 */
	public HistoricalDataScreen(final Icons icons) {
		this.text.setEditable(false);

		final JScrollPane scrollPane = new JScrollPane();
		scrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED);
		scrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_AS_NEEDED);
		scrollPane.getViewport().add(this.text);

		// レイアウトを処理します。
		setLayout(new BorderLayout());
		add(scrollPane, BorderLayout.CENTER);
	}

	@Override
	public void datasetSwitch(final ChartEvent e) {
		this.text.setText(createText((BasicChartDataset)e.getDataset(), e.getSettings()));
	}

	/**
	 * この実装は何も行いません。
	 */
	@Override public void periodSwitch(final ChartEvent e) {}

	@Override
	public void settingChanged(final ChartEvent e) {
		this.text.setText(createText((BasicChartDataset)e.getDataset(), e.getSettings()));
	}

	/**
	 * 
	 * @param dataset データセット
	 * @param settings 設定情報
	 * @return
	 */
	private String createText(final BasicChartDataset dataset, final ChartSettings settings) {
		if (dataset == null || dataset.getCount() <= 0) {
			return StringManager.getString("nodata");
		}

		final StringBuilder sb = new StringBuilder();
		sb.append(StringManager.getString("_date"));
		sb.append(SEPARATOR);
		sb.append(StringManager.getString("_open"));
		sb.append(SEPARATOR);
		sb.append(StringManager.getString("_high"));
		sb.append(SEPARATOR);
		sb.append(StringManager.getString("_low"));
		sb.append(SEPARATOR);
		sb.append(StringManager.getString("_close"));
		sb.append(SEPARATOR);
		sb.append(StringManager.getString("_volume"));
		sb.append("\n");

		final String format = StringManager.getString("format.number", settings.precision);

		final int max = dataset.getCount();
		for (int i = 0; i < max; i++) {
			sb.append(StringUtils.defaultString(String.format(StringManager.getString("format.date"), dataset.date[i])));

			sb.append(SEPARATOR);
			if (dataset.open[i] != null) {
				sb.append(StringUtils.defaultString(String.format(format, dataset.open[i].doubleValue())));
			}
			sb.append(SEPARATOR);
			if (dataset.high[i] != null) {
				sb.append(StringUtils.defaultString(String.format(format, dataset.high[i].doubleValue())));
			}
			sb.append(SEPARATOR);
			if (dataset.low[i] != null) {
				sb.append(StringUtils.defaultString(String.format(format, dataset.low[i].doubleValue())));
			}
			sb.append(SEPARATOR);
			if (dataset.close[i] != null) {
				sb.append(StringUtils.defaultString(String.format(format, dataset.close[i].doubleValue())));
			}
			sb.append(SEPARATOR);
			if (dataset.volume[i] != null) {
				sb.append(StringUtils.defaultString(String.format(format, dataset.volume[i].doubleValue())));
			}
			sb.append("\n");
		}

		return sb.toString();
	}

}
