/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.unit;

import java.util.Collections;

/**
 * ポイント＆フィギュアのポイント単位情報を提供します。
 * 
 * @author 杉澤 浩二
 */
public class PointAndFigurePriceUnits extends PriceUnits {

	private static final long serialVersionUID = 6261285398124999614L;

	/**
	 * デフォルトコンストラクタです。
	 */
	public PointAndFigurePriceUnits() {
		units.add(new PriceUnit(5000000, 100000D));
		units.add(new PriceUnit(1000000,  20000D));
		units.add(new PriceUnit( 500000,  10000D));
		units.add(new PriceUnit( 100000,   2000D));
		units.add(new PriceUnit(  50000,   1000D));
		units.add(new PriceUnit(  10000,    200D));
		units.add(new PriceUnit(   5000,    100D));
		units.add(new PriceUnit(   1000,     20D));
		units.add(new PriceUnit(    200,     10D));
		units.add(new PriceUnit(    100,      5D));
		units.add(new PriceUnit(      1,    2.5D));
        Collections.sort(units);
	}

}
