/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.unit;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;

import org.junit.Test;

/**
 * {@link PointAndFigurePriceUnits} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class PointAndFigurePriceUnitsTest {

	@Test
	public void testPointAndFigurePriceUnits() {
		// Act
		final PointAndFigurePriceUnits pf = new PointAndFigurePriceUnits();
		// Assert
		assertThat(pf.units.size(), is(11));
		assertThat(pf.units.get( 0).getPrice(), is(5000000));
		assertThat(pf.units.get( 1).getPrice(), is(1000000));
		assertThat(pf.units.get( 2).getPrice(), is( 500000));
		assertThat(pf.units.get( 3).getPrice(), is( 100000));
		assertThat(pf.units.get( 4).getPrice(), is(  50000));
		assertThat(pf.units.get( 5).getPrice(), is(  10000));
		assertThat(pf.units.get( 6).getPrice(), is(   5000));
		assertThat(pf.units.get( 7).getPrice(), is(   1000));
		assertThat(pf.units.get( 8).getPrice(), is(    200));
		assertThat(pf.units.get( 9).getPrice(), is(    100));
		assertThat(pf.units.get(10).getPrice(), is(      1));
		assertThat(pf.units.get( 0).getPoint(), is(100000D));
		assertThat(pf.units.get( 1).getPoint(), is( 20000D));
		assertThat(pf.units.get( 2).getPoint(), is( 10000D));
		assertThat(pf.units.get( 3).getPoint(), is(  2000D));
		assertThat(pf.units.get( 4).getPoint(), is(  1000D));
		assertThat(pf.units.get( 5).getPoint(), is(   200D));
		assertThat(pf.units.get( 6).getPoint(), is(   100D));
		assertThat(pf.units.get( 7).getPoint(), is(    20D));
		assertThat(pf.units.get( 8).getPoint(), is(    10D));
		assertThat(pf.units.get( 9).getPoint(), is(     5D));
		assertThat(pf.units.get(10).getPoint(), is(   2.5D));
	}

	@Test
	public void testAdd() {
		// Arrange
		final PointAndFigurePriceUnits pf = new PointAndFigurePriceUnits();
		// Act
		pf.add(new PriceUnit(0, 0D));
		pf.add(new PriceUnit(10000000, 200000D));
		// Assert
		assertThat(pf.units.size(), is(13));
		assertThat(pf.units.get( 0).getPrice(), is(10000000));
		assertThat(pf.units.get( 0).getPoint(), is( 200000D));
		assertThat(pf.units.get(12).getPrice(), is(       0));
		assertThat(pf.units.get(12).getPoint(), is(      0D));
	}

	@Test
	public void testGetCeilingUnitUnit() {
		// Arrange
		final PointAndFigurePriceUnits pf = new PointAndFigurePriceUnits();
		// Act + Assert
		assertThat(pf.getCeilingPriceUnit(new PriceUnit(       0, 0D)).getPrice(), is(      1));
		assertThat(pf.getCeilingPriceUnit(new PriceUnit(       1, 0D)).getPrice(), is(      1));
		assertThat(pf.getCeilingPriceUnit(new PriceUnit(      50, 0D)).getPrice(), is(      1));
		assertThat(pf.getCeilingPriceUnit(new PriceUnit(     100, 0D)).getPrice(), is(    100));
		assertThat(pf.getCeilingPriceUnit(new PriceUnit(     150, 0D)).getPrice(), is(    100));
		assertThat(pf.getCeilingPriceUnit(new PriceUnit(     200, 0D)).getPrice(), is(    200));
		assertThat(pf.getCeilingPriceUnit(new PriceUnit( 5000000, 0D)).getPrice(), is(5000000));
		assertThat(pf.getCeilingPriceUnit(new PriceUnit(10000000, 0D)).getPrice(), is(5000000));
	}

	@Test
	public void testGetCeilingUnitInt() {
		// Arrange
		final PointAndFigurePriceUnits pf = new PointAndFigurePriceUnits();
		// Act + Assert
		assertThat(pf.getCeilingPriceUnit(       0).getPrice(), is(      1));
		assertThat(pf.getCeilingPriceUnit(       1).getPrice(), is(      1));
		assertThat(pf.getCeilingPriceUnit(      50).getPrice(), is(      1));
		assertThat(pf.getCeilingPriceUnit(     100).getPrice(), is(    100));
		assertThat(pf.getCeilingPriceUnit(     150).getPrice(), is(    100));
		assertThat(pf.getCeilingPriceUnit(     200).getPrice(), is(    200));
		assertThat(pf.getCeilingPriceUnit( 5000000).getPrice(), is(5000000));
		assertThat(pf.getCeilingPriceUnit(10000000).getPrice(), is(5000000));
	}

}
