/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.chart.unit;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

/**
 * {@link PriceUnit} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class PriceUnitTest {

	@Test
	public void testPriceUnit() {
		new PriceUnit(1234, 5D);
	}

	@Test
	public void testGetPrice() {
		final PriceUnit unit = new PriceUnit(1234, 5D);
		assertThat(unit.getPrice(), is(1234));
	}

	@Test
	public void testGetPoint() {
		final PriceUnit unit = new PriceUnit(1234, 5D);
		assertThat(unit.getPoint(), is(5D));
	}

	@Test
	public void testCompareTo() {
		final PriceUnit unit = new PriceUnit(1234, 5D);
		assertTrue(unit.compareTo(new PriceUnit(1233, 5D)) == -1);
		assertTrue(unit.compareTo(new PriceUnit(1234, 5D)) ==  0);
		assertTrue(unit.compareTo(new PriceUnit(1235, 5D)) ==  1);
	}

}
