/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta;

/**
 * 百分率の尺度を表す列挙型を提供します。
 * 
 * @author 杉澤 浩二
 */
public enum PercentageScale {

	/**
	 * 1 を基準とした尺度を表します。
	 */
	RATE { @Override public double scale() { return 1.0; } },

	/**
	 * 100 を基準とした尺度を表します。
	 */
	PERCENT { @Override public double scale() { return 100.0; } },

	/**
	 * -1 を基準とした尺度を表します。
	 */
	REVERSE_RATE { @Override public double scale() { return -1.0; } },

	/**
	 * -100 を基準とした尺度を表します。
	 */
	REVERSE_PERCENT { @Override public double scale() { return -100.0; } };

	/**
	 * この列挙型が表す尺度の基準値を返します。
	 * 
	 * @return 尺度の上限値
	 */
	public abstract double scale();

}
