/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.candle.generator;

import jp.sf.orangesignal.ta.candle.TrendType;

/**
 * パラボリック SAR データからトレンド情報を処理するトレンドプロセッサークラスを提供します。
 * 
 * @author 杉澤 浩二
 */
public final class ParabolicSarTrendProcessor implements TrendProcessor {

	/**
	 * パラボリック SAR データ
	 */
	private Number[] sar;

	/**
	 * コンストラクタです。
	 * 
	 * @param sar パラボリック SAR データ
	 */
	public ParabolicSarTrendProcessor(final Number[] sar) {
		this.sar = sar;
	}

	/**
	 * この実装は単にパラボリック SAR データとローソク足の終値を比較して判断します。
	 * <p>
	 * 判断基準は以下の通りです。
	 * <ul>
	 * <li>終値の方が低い場合は下降トレンド</li>
	 * <li>終値の方が高い場合は上昇トレンド</li>
	 * </ul>
	 * </p>
	 */
	@Override
	public void execute(final DefaultCandlestick[] c) {
		final int len = Math.min(sar.length, c.length);
		for (int i = 0; i < len; i++) {
			if (sar[i] == null || c[i] == null)
				continue;
			final double x = sar[i].doubleValue();
			if (c[i].getClose() < x)
				c[i].trend = TrendType.DOWN;
			else if (c[i].getClose() > x)
				c[i].trend = TrendType.UP;
		}
	}

}
