/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

/**
 * <p>ローソク足情報生成用の既定クラスを提供します。</p>
 * <p>以下はとりあえずコードを実行してみたい人向けの最も簡単な使用例です。<br></p>
 * <pre style="border:1px solid gray">
<font color="green">// 4本値データを用意します。</font>
Number[] open  = new Number[]{ ... };
Number[] high  = new Number[]{ ... };
Number[] low   = new Number[]{ ... };
Number[] close = new Number[]{ ... };
<font color="green">// 4本値データからローソク足情報を生成します。</font>
Candlestick[] candles = new CandlestickGenerator().generate(open, high, low, close);
<font color="green">// ローソク足情報を使用して、以下の例ではカラカサ線(たくり線)パターンを分析します。</font>
boolean[] bullishHammer = CandlestickPatterns.bullishHammer(candles);
</pre>
<p>
上記の例ではトレンド情報が分析に用いられない為、あまり実践的ではありません。<br>
以下はトレンド情報も分析に用いる使用例です。
</p>
<pre style="border:1px solid gray">
<font color="green">// 4本値データと日時データを用意します。</font>
Date[]   date  = new Date[]  { ... };
Number[] open  = new Number[]{ ... };
Number[] high  = new Number[]{ ... };
Number[] low   = new Number[]{ ... };
Number[] close = new Number[]{ ... };
<font color="green">// トレンドデータとしてポイント＆フィギュアデータを使用します。</font>
List&lt;Step&gt; pf = TechnicalAnalysis.pf(date, close, 2, 3);
<font color="green">// トレンドデータをトレンドプロセッサーへセットします。</font>
TrendProcessor processor = new PointFigureTrendProcessor(pf);
<font color="green">// 日時や4本値データ、トレンドプロセッサーを指定してローソク足情報を生成します。</font>
Candlestick[] candles = new CandlestickGenerator().generate(date, open, high, low, close, processor);
<font color="green">// ローソク足情報を使用して、以下の例ではカラカサ線(たくり線)パターンを分析します。</font>
boolean[] bullishHammer = CandlestickPatterns.bullishHammer(candles);
</pre>
 */
package jp.sf.orangesignal.ta.candle.generator;
