/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta.data;

import jp.sf.orangesignal.csv.CsvConfig;

/**
 * CSV データ設定情報を提供します。
 * 
 * @author 杉澤 浩二
 * @since 2.2
 */
public class CsvDataConfig {

	// ------------------------------------------------------------------------
	// ファイル

	/**
	 * CSV データファイルの基準ディレクトリを保持します。
	 */
	private String path;

	/**
	 * CSV データファイルのエンコーディングを保持します。
	 */
	private String encoding;

	/**
	 * CSV データファイルの圧縮形式の種類を保持します。
	 */
	private CsvFileType type = CsvFileType.CSV;

	// ------------------------------------------------------------------------
	// CSV

	/**
	 * CSV 形式情報を保持します。
	 */
	private CsvConfig csvConfig;

	/**
	 * 取得データの並び順を逆にするかどうかを保持します。
	 */
	private boolean reverseOrder;

	// ------------------------------------------------------------------------

	/**
	 * デフォルトコンストラクタです。
	 */
	public CsvDataConfig() {}

	// ------------------------------------------------------------------------

	/**
	 * CSV データファイルの基準ディレクトリを返します。
	 * 
	 * @return CSV データファイルの基準ディレクトリ
	 */
	public String getPath() { return path; }

	/**
	 * CSV データファイルの基準ディレクトリを設定します。
	 * 
	 * @param path CSV データファイルの基準ディレクトリ
	 */
	public void setPath(final String path) { this.path = path; }

	/**
	 * CSV データファイルのエンコーディングを設定します。
	 * 
	 * @return CSV データファイルのエンコーディング
	 */
	public String getEncoding() { return encoding; }

	/**
	 * CSV データファイルのエンコーディングを返します。
	 * 
	 * @param encoding CSV データファイルのエンコーディング
	 */
	public void setEncoding(final String encoding) { this.encoding = encoding; }

	/**
	 * CSV データファイルの圧縮形式の種類を返します。
	 * 
	 * @return CSV データファイルの圧縮形式の種類
	 */
	public CsvFileType getType() { return type; }

	/**
	 * CSV データファイルの圧縮形式の種類を設定します。
	 * 
	 * @param type CSV データファイルの圧縮形式の種類
	 */
	public void setType(final CsvFileType type) { this.type = type; }

	/**
	 * CSV 形式情報を返します。
	 * 
	 * @return CSV 形式情報
	 */
	public CsvConfig getCsvConfig() { return csvConfig; }

	/**
	 * CSV 形式情報を設定します。
	 * 
	 * @param csvConfig CSV 形式情報
	 */
	public void setCsvConfig(final CsvConfig csvConfig) { this.csvConfig = csvConfig; }

	/**
	 * 取得データの並び順を逆にするかどうかを返します。
	 * 
	 * @return 取得データの並び順を逆にするかどうか
	 */
	public boolean isReverseOrder() { return reverseOrder; }

	/**
	 * 取得データの並び順を逆にするかどうかを設定します。
	 * 
	 * @param reverseOrder 取得データの並び順を逆にするかどうか
	 */
	public void setReverseOrder(final boolean reverseOrder) { this.reverseOrder = reverseOrder; }

}
