/*
 * Copyright (c) 2008-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.ta;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.fail;

import org.junit.Test;

/**
 * {@link PercentageScale} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class PercentageScaleTest {

	@Test
	public void testValues() {
		for (final PercentageScale value : PercentageScale.values()) {
			switch (value) {
				case RATE: case PERCENT: case REVERSE_RATE: case REVERSE_PERCENT:
					break;
				default:
					fail();
			}
		}
	}

	@Test
	public void testScale() {
		assertThat(PercentageScale.RATE.scale(), is(1.0));
		assertThat(PercentageScale.PERCENT.scale(), is(100.0));
		assertThat(PercentageScale.REVERSE_RATE.scale(), is(-1.0));
		assertThat(PercentageScale.REVERSE_PERCENT.scale(), is(-100.0));
	}

}
