/*
 * Copyright (c) 2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */
package jp.sf.orangesignal.ta.util;

import static org.hamcrest.core.Is.is;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

/**
 * {@link StringUtils} クラスの単体テストです。
 * 
 * @author 杉澤 浩二
 */
public class StringUtilsTest {

	@Test
	public void testIsEmpty() {
		assertTrue(StringUtils.isEmpty(null));
		assertTrue(StringUtils.isEmpty(""));
		assertFalse(StringUtils.isEmpty(" "));
		assertFalse(StringUtils.isEmpty("abc"));
		assertFalse(StringUtils.isEmpty("  abc  "));
	}

	@Test
	public void testIsNotEmpty() {
		assertFalse(StringUtils.isNotEmpty(null));
		assertFalse(StringUtils.isNotEmpty(""));
		assertTrue(StringUtils.isNotEmpty(" "));
		assertTrue(StringUtils.isNotEmpty("abc"));
		assertTrue(StringUtils.isNotEmpty("  abc  "));
	}

	@Test
	public void testDefaultStringString() {
		assertThat(StringUtils.defaultString(null), is(""));
		assertThat(StringUtils.defaultString(""), is(""));
		assertThat(StringUtils.defaultString("abc"), is("abc"));
	}

	@Test
	public void testDefaultStringStringString() {
		assertThat(StringUtils.defaultString(null, "NULL"), is("NULL"));
		assertThat(StringUtils.defaultString("", "NULL"), is(""));
		assertThat(StringUtils.defaultString("abc", "NULL"), is("abc"));
	}

	@Test
	public void testDefaultIfEmpty() {
		assertThat(StringUtils.defaultIfEmpty(null, "NULL"), is("NULL"));
		assertThat(StringUtils.defaultIfEmpty("", "NULL"), is("NULL"));
		assertThat(StringUtils.defaultIfEmpty("abc", "NULL"), is("abc"));
	}

}
