/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.stats.report;

import java.io.IOException;

import jp.sf.orangesignal.trading.backtest.Backtester;
import jp.sf.orangesignal.trading.stats.Stats;
import jp.sf.orangesignal.trading.stats.Summary;

/**
 * パフォーマンス情報出力機能のインターフェースを提供します。
 * 
 * @author 杉澤 浩二
 */
public interface Reporter {

	/**
	 * パフォーマンス概要情報を出力します。
	 * 
	 * @param summary パフォーマンス概要情報
	 * @param backtester バックテスト実行オブジェクト
	 * @throws IOException 入出力操作で例外が発生した場合
	 */
	public void report(Summary summary, Backtester backtester) throws IOException;

	/**
	 * パフォーマンス統計情報を出力します。
	 * 
	 * @param stats パフォーマンス統計情報
	 * @throws IOException 入出力操作で例外が発生した場合
	 */
	public void report(Stats stats) throws IOException;

}
