/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.filters;

import jp.sf.orangesignal.ta.candle.Candlestick;
import jp.sf.orangesignal.trading.strategy.TradingStrategySupport;

/**
 * 価格の範囲でフィルターするストラテジーを提供します。
 * 
 * @author 杉澤 浩二
 */
public class PriceFilter extends TradingStrategySupport {

	/**
	 * デフォルトコンストラクタです。
	 */
	public PriceFilter() {}

	/**
	 * 上限価格を保持します。
	 */
	private double upper;

	/**
	 * 上限価格を返します。
	 * 
	 * @return 上限価格
	 */
	public double getUpper() { return upper; }

	/**
	 * 上限価格を設定します。
	 * 
	 * @param upper 上限価格
	 */
	public void setUpper(final double upper) { this.upper = upper; }

	/**
	 * 下限価格を保持します。
	 */
	private double lower = 50;

	/**
	 * 下限価格を返します。
	 * 
	 * @return 下限価格
	 */
	public double getLower() { return lower; }

	/**
	 * 下限価格を設定します。
	 * 
	 * @param lower 下限価格
	 */
	public void setLower(final double lower) { this.lower = lower; }

	@Override
	public boolean execute() {
		final Candlestick c = getCandlestick();
		return (c != null && ((upper > 0 && c.getHigh() > upper) || (lower > 0 && c.getLow() < lower)));
	}

}
