/*
 * Copyright (c) 2006-2009 OrangeSignal.com All rights reserved.
 * 
 * これは Apache ライセンス Version 2.0 (以下、このライセンスと記述) に
 * 従っています。このライセンスに準拠する場合以外、このファイルを使用
 * してはなりません。このライセンスのコピーは以下から入手できます。
 * 
 * http://www.apache.org/licenses/LICENSE-2.0.txt
 * 
 * 適用可能な法律がある、あるいは文書によって明記されている場合を除き、
 * このライセンスの下で配布されているソフトウェアは、明示的であるか暗黙の
 * うちであるかを問わず、「保証やあらゆる種類の条件を含んでおらず」、
 * 「あるがまま」の状態で提供されるものとします。
 * このライセンスが適用される特定の許諾と制限については、このライセンス
 * を参照してください。
 */

package jp.sf.orangesignal.trading.strategy.systems;

/**
 * 価格と短期移動平均、中期移動平均、長期移動平均の交差で売りポジションを建てるストラテジーを提供します。
 */
public class MovingAverage3LineCrossShortEntry extends MovingAverage3LineCross {

	@Override
	public boolean execute() {
		final int i = getCurrentDataIndex();
		if (condition(i) && !condition(i - 1))
			sellShort(getStrategyName());
		return false;
	}

	protected boolean condition(final int i) {
		if (prices[i] != null && ma_fast[i] != null && ma_mid[i] != null && ma_slow[i] != null) {
			final double price = prices[i].doubleValue();
			final double fast  = ma_fast[i].doubleValue();
			final double mid   = ma_mid[i].doubleValue();
			final double slow  = ma_slow[i].doubleValue();
			return (price < fast && fast < mid && mid < slow);			
		}
		return false;
	}

}
