using System;
using System.Collections.Generic;
using System.Text;

namespace Orbiter.Interfaces
{
    public interface MeshGroupTransformation
    {
        int Mesh { get; set;}
        int[] Group { get; set;}
        IntPtr Native { get;}
    }

    public interface MeshGroupRotation : MeshGroupTransformation
    {
        Vector3 Reference { get; set;}
        Vector3 Axis { get; set;}
        float Angle { get; set;}
    }

    public interface MeshGroupTranslation : MeshGroupTransformation
    {
        Vector3 Shift { get; set;}
    }

    public interface MeshGroupScale : MeshGroupTransformation
    {
        Vector3 Reference { get; set;}
        Vector3 Scale { get; set;}
    }
}
