//#include <vcclr.h>
#include "orbitersdk.h"
#include "MeshGroupTransformations.h"

using namespace System;
using namespace System::Reflection;
using namespace System::Runtime::InteropServices;
using namespace Orbiter;

[assembly:AssemblyVersionAttribute("1.0.0.0")];

namespace Orbiter
{
	namespace Wrapper
	{
		MeshGroupTransformation::MeshGroupTransformation(){native=new MGROUP_TRANSFORM();}
		MeshGroupTransformation::MeshGroupTransformation(int mesh, cli::array<int,1> ^group)
		{
			native=new MGROUP_TRANSFORM();
			Mesh=mesh;
			Group=group;
		}
		int MeshGroupTransformation::Mesh::get(){return (int)native->mesh;}
		void MeshGroupTransformation::Mesh::set(int value){native->mesh=value;}
		array<int> ^MeshGroupTransformation::Group::get()
		{
			array<int> ^result=gcnew array<int>(native->ngrp);
			for(UINT i=0;i<native->ngrp;i++) result[i]=(int)native->grp[i];
			return result;
		}
		void MeshGroupTransformation::Group::set(array<int>^ value)
		{
			native->ngrp=(UINT)value->Length;
			native->grp=new UINT[value->Length];
			for(UINT i=0;i<native->ngrp;i++) native->grp[i]=(UINT)value[i];
		}
		IntPtr MeshGroupTransformation::Native::get(){return (IntPtr)native;}
		void MeshGroupTransformation::SetNative(MGROUP_TRANSFORM *value){native=value;}

		MeshGroupRotation::MeshGroupRotation(int mesh, cli::array<int,1> ^group, Orbiter::Interfaces::Vector3 ^reference, Orbiter::Interfaces::Vector3 ^axis, float angle)
		{
			SetNative((MGROUP_TRANSFORM *)new MGROUP_ROTATE(0,0,0,_V(0,0,0), _V(0,0,0), 0));
			Mesh=mesh;
			Group=group;
			Reference=reference;
			Axis=axis;
			Angle=angle;
		}
		Orbiter::Interfaces::Vector3^ MeshGroupRotation::Reference::get()
		{
			VECTOR3 ref=((MGROUP_ROTATE *)(MGROUP_TRANSFORM *)(void *)Native)->ref;
			return gcnew Orbiter::Interfaces::Vector3(ref.x, ref.y, ref.z);
		}
		void MeshGroupRotation::Reference::set(Orbiter::Interfaces::Vector3^ value){((MGROUP_ROTATE *)(MGROUP_TRANSFORM *)(void *)Native)->ref=_V(value->X, value->Y, value->Z);}
		Orbiter::Interfaces::Vector3^ MeshGroupRotation::Axis::get()
		{
			VECTOR3 ref=((MGROUP_ROTATE *)(MGROUP_TRANSFORM *)(void *)Native)->axis;
			return gcnew Orbiter::Interfaces::Vector3(ref.x, ref.y, ref.z);
		}
		void MeshGroupRotation::Axis::set(Orbiter::Interfaces::Vector3^ value){((MGROUP_ROTATE *)(MGROUP_TRANSFORM *)(void *)Native)->axis=_V(value->X, value->Y, value->Z);}
		float MeshGroupRotation::Angle::get(){return ((MGROUP_ROTATE *)(MGROUP_TRANSFORM *)(void *)Native)->angle;}
		void MeshGroupRotation::Angle::set(float value){((MGROUP_ROTATE *)(MGROUP_TRANSFORM *)(void *)Native)->angle=value;}

		MeshGroupTranslation::MeshGroupTranslation(int mesh, array<int>^ group, Orbiter::Interfaces::Vector3 ^shift)
		{
			SetNative((MGROUP_TRANSFORM *)new MGROUP_TRANSLATE(0, 0, 0, _V(0,0,0)));
			Mesh=mesh;
			Group=group;
			Shift=shift;
		}
		Orbiter::Interfaces::Vector3^ MeshGroupTranslation::Shift::get()
		{
			VECTOR3 ref=((MGROUP_TRANSLATE *)(MGROUP_TRANSFORM *)(void *)Native)->shift;
			return gcnew Orbiter::Interfaces::Vector3(ref.x, ref.y, ref.z);
		}
		void MeshGroupTranslation::Shift::set(Orbiter::Interfaces::Vector3^ value){((MGROUP_TRANSLATE *)(MGROUP_TRANSFORM *)(void *)Native)->shift=_V(value->X, value->Y, value->Z);}

		MeshGroupScale::MeshGroupScale(int mesh, array<int> ^group, Orbiter::Interfaces::Vector3 ^reference, Orbiter::Interfaces::Vector3 ^scale)
		{
			SetNative((MGROUP_TRANSFORM *)new MGROUP_SCALE(0, 0, 0, _V(0,0,0), _V(0,0,0)));
			Mesh=mesh;
			Group=group;
			Reference=reference;
			Scale=scale;
		}
		Orbiter::Interfaces::Vector3^ MeshGroupScale::Reference::get()
		{
			VECTOR3 ref=((MGROUP_SCALE *)(MGROUP_TRANSFORM *)(void *)Native)->ref;
			return gcnew Orbiter::Interfaces::Vector3(ref.x, ref.y, ref.z);
		}
		void MeshGroupScale::Reference::set(Orbiter::Interfaces::Vector3^ value){((MGROUP_SCALE *)(MGROUP_TRANSFORM *)(void *)Native)->ref=_V(value->X, value->Y, value->Z);}
		Orbiter::Interfaces::Vector3^ MeshGroupScale::Scale::get()
		{
			VECTOR3 ref=((MGROUP_SCALE *)(MGROUP_TRANSFORM *)(void *)Native)->scale;
			return gcnew Orbiter::Interfaces::Vector3(ref.x, ref.y, ref.z);
		}
		void MeshGroupScale::Scale::set(Orbiter::Interfaces::Vector3^ value){((MGROUP_SCALE *)(MGROUP_TRANSFORM *)(void *)Native)->scale=_V(value->X, value->Y, value->Z);}
	};
};

