//#include <vcclr.h>
#include "orbitersdk.h"
#include "OAPI.h"

using namespace System;
using namespace Orbiter;

namespace Orbiter
{
	namespace Wrapper
	{
		Interfaces::AtmosphereConstants OAPI::GetPlanetAtmConstants(System::IntPtr body)
		{
			const ATMCONST *atm=oapiGetPlanetAtmConstants((OBJHANDLE)(void *)body);
			return Interfaces::AtmosphereConstants(
				atm->p0, atm->rho0, atm->R, atm->gamma, atm->C,
				atm->O2pp, atm->altlimit, atm->radlimit, atm->horizonalt,
				gcnew Interfaces::Vector3(atm->color0.x,atm->color0.y,atm->color0.z));
		}
		double OAPI::GetInducedDrag(double cl, double aspectRatio, double efficiency){return oapiGetInducedDrag(cl, aspectRatio, efficiency);}
		double OAPI::GetWaveDrag(double mach, double mach1, double mach2, double mach3, double maximumWaveDragCooefficient){return oapiGetWaveDrag(mach, mach1, mach2, mach3, maximumWaveDragCooefficient);}
		bool OAPI::ReadItem(System::IntPtr file, System::String^ name, bool %flag)
		{
			IntPtr buf=Marshal::StringToHGlobalAnsi(name);
			bool internalFlag;
			bool result=oapiReadItem_bool((FILEHANDLE)(void *)file, (char *)(void *)buf, internalFlag);
			flag=internalFlag;
			Marshal::FreeHGlobal(buf);
			return result;
		}
		void OAPI::ParticleSetLevelReference(IntPtr particleStream, Interfaces::DoublePointer ^reference){oapiParticleSetLevelRef((PSTREAM_HANDLE)(void *)particleStream, (double *)(void *)reference->Native);}
		IntPtr OAPI::LoadMeshGlobal(System::String ^name)
		{
			IntPtr buf=Marshal::StringToHGlobalAnsi(name);
			IntPtr result=(IntPtr)oapiLoadMeshGlobal((char *)(void *)buf);
			Marshal::FreeHGlobal(buf);			
			return result;
		}
		IntPtr OAPI::CreateTextureSurface(int width, int height){return (IntPtr)oapiCreateTextureSurface(width, height);}
		IntPtr OAPI::GetTextureHandle(System::IntPtr mesh, unsigned int textureIndex){return (IntPtr)oapiGetTextureHandle((MESHHANDLE)(void *)mesh, textureIndex);}
		void OAPI::Blt(System::IntPtr target, System::IntPtr source, int targetX, int targetY, int sourceX, int sourceY, int width, int height, unsigned int colorKey){oapiBlt((SURFHANDLE)(void *)target, (SURFHANDLE)(void *)source, targetX, targetY, sourceX, sourceY, width, height, colorKey);}
		void OAPI::Blt(System::IntPtr target, System::IntPtr source, int targetX, int targetY, int sourceX, int sourceY, int width, int height){oapiBlt((SURFHANDLE)(void *)target, (SURFHANDLE)(void *)source, targetX, targetY, sourceX, sourceY, width, height);}
		double OAPI::SimTime::get(){return oapiGetSimTime();}
		double OAPI::SimStep::get(){return oapiGetSimStep();}
		double OAPI::SysTime::get(){return oapiGetSysTime();}
		double OAPI::SysStep::get(){return oapiGetSysStep();}
		double OAPI::SimMJD::get(){return oapiGetSimMJD();}
		double OAPI::SysMJD::get(){return oapiGetSysMJD();}
		double OAPI::FrameRate::get(){return oapiGetFrameRate();}
		double OAPI::TimeAcceleration::get(){return oapiGetTimeAcceleration();}
		void OAPI::TimeAcceleration::set(double value){oapiSetTimeAcceleration(value);}
		bool OAPI::Pause::get(){return oapiGetPause();}
		void OAPI::Pause::set(bool value){oapiSetPause(value);}
		Interfaces::CockpitMode OAPI::CockpitMode::get(){return (Interfaces::CockpitMode)oapiCockpitMode();}
	}
}