#pragma once
#include <vcclr.h>
#include "orbitersdk.h"

using namespace System;
using namespace System::Runtime::InteropServices;
using namespace Orbiter;

namespace Orbiter
{
	namespace Wrapper
	{
		class Vessel2;
		ref class Vessel;
		public ref class Vessel2Base : Interfaces::Vessel2
		{
		public:
			Vessel2Base(Vessel2 *vessel2);
			~Vessel2Base();
			virtual property Interfaces::Vessel^ This { Interfaces::Vessel^ get(void); void set(Interfaces::Vessel^ value);}
			virtual property Interfaces::Vessel2^ Base { Interfaces::Vessel2^ get(void); void set(Interfaces::Vessel2^ value);}
			virtual property Interfaces::Vessel2Callback CallbackSetting { Interfaces::Vessel2Callback get(void);}
			virtual void DisposeThis();
			virtual void SetClassCaps (IntPtr configuration);
			virtual void SaveState (IntPtr scenario);
			virtual void LoadStateEx (IntPtr scenario, IntPtr status);
			virtual void SetStateEx (Interfaces::VesselStatus2 status);
			virtual void PostCreation ();
			virtual void FocusChanged (bool getFocus, IntPtr newVessel, IntPtr oldVessel);
			virtual void PreStep (double simt, double simdt, double mjd);
			virtual void PostStep (double simt, double simdt, double mjd);
			virtual bool PlaybackEvent (double simt, double event_t, String^ event_type, String^ event_name);
			virtual void VisualCreated (IntPtr vis, int refCount);
			virtual void VisualDestroyed (IntPtr vis, int refCount);
			virtual void DrawHUD (int mode, Interfaces::HudPaintSpecification hps, IntPtr hDC);
			virtual void RCSMode (int mode);
			virtual void ADCtrlMode (int mode);
			virtual void HUDMode (int mode);
			virtual void MFDMode (int mfd, int mode);
			virtual void NavMode (int mode, bool active);
			virtual void DockEvent (int dock, IntPtr mate);
			virtual void Animate (double simt);
			virtual int  ConsumeDirectKey (IntPtr keyState);
			virtual int  ConsumeBufferedKey (int key, bool down, IntPtr keyState);
			virtual bool LoadGenericCockpit ();
			virtual bool LoadPanel (int id);
			virtual bool PanelMouseEvent (int id, int mouseEvent, int mx, int my);
			virtual bool PanelRedrawEvent (int id, int mouseEvent, IntPtr surface);
			virtual bool LoadVC (int id);
			virtual bool VCMouseEvent (int id, int mouseEvent, Interfaces::Vector3^ p);
			virtual bool VCRedrawEvent (int id, int mouseEvent, IntPtr surface);

		private:
			Interfaces::Vessel^ me;
			Interfaces::Vessel2^ myBase;
			Vessel2 *vessel2;
		};
	}
}