require 'typhoeus/easy_factory'

module Typhoeus
  class EasyFactory
    alias_method :get_orig, :get
    def get(*args)
      easy = get_orig(*args)
      if ENV['CURL_CA_BUNDLE']
        Ethon::Curl.set_option(:cainfo, ENV['CURL_CA_BUNDLE'], easy.handle)
      else
        ["#{ENV['HOME']}/.config/osdn/ca-certificates.crt"] + %w(
           /usr/local/share/curl/curl-ca-bundle.crt
           /usr/share/curl/ca-bundle.crt
           /etc/ssl/certs/ca-certificates.crt
           /etc/ssl/certs/ca-certificates.pem
           /etc/pki/tls/certs/ca-bundle.crt
           /etc/pki/tls/certs/ca-bundle.pem
           /etc/ssl/ca-bundle.pem
        ).each do |ca|
          next unless File.exists? ca
          Ethon::Curl.set_option(:cainfo, ca, easy.handle)
        end
      end
      if OSDN::CLI._show_progress
        Ethon::Curl.set_option(:noprogress, false, easy.handle)
        
      else
        Ethon::Curl.set_option(:noprogress, true, easy.handle)
      end
      easy
    end
  end
end
