<?php
namespace sfjp\Wiki\Processor;
class Auto extends Base {
	public function process($text) {
		$match = null;
		$typemap = array();
		if (preg_match('/\A#!\/\S+\/(?:env\s+)?(ada|asm|asw|bash|csh|perl|python|ruby|sh|tcsh|zsh|php)/',
			       $text, $match)) {
			$type = array_key_exists($match[1], $typemap) ? $typemap[$match[1]] : $match[1];
			$p = new Code(array($type));
		} else {
			$p = new Pre();
		}
		$p->setContext($this->getContext());
		$p->setFormatter($this->getFormatter());
		$this->formatted_text = $p->process($text)->getFormattedText();
		if (!$this->hasContext("parent_processor"))
			$this->formatted_text .= $this->getFormatter()->cleanup();
		return $this;
	}
}
