<?php
namespace sfjp\Wiki\Formatter;
class HTML extends Base {
	static public $singleton_tags = array('line', 'hr', 'image', 'img', 'newline', 'br');

	public $tagmap;

	function __construct() {
		$this->tagmap = array(
				      "bold"        => "strong",
				      "italic"      => "em",
				      "strike"      => "del",
				      "underline"   => array('span', array('style' => 'text-decoration: underline;')),
				      "monospace"   => "tt",
				      "superscript" => "sup",
				      "subscript"   => "sub",
				      "table_row"   => "tr",
				      "table_col"   => "td",
				      "list_mark"   => "ul",
				      "list_num"    => "ol",
				      "list_roma"   => array("ol", array('style' => 'list-style-type: lower-roman;')),
				      "list_ROMA"   => array("ol", array('style' => 'list-style-type: upper-roman;')),
				      "list_alpha"  => array("ol", array('style' => 'list-style-type: lower-alpha;')),
				      "list_ALPHA"  => array("ol", array('style' => 'list-style-type: upper-alpha;')),
				      "list_item"   => "li",
				      "quote"       => array("blockquote", array("class" => "citation")),
				      "paragraph"   => "p",
				      "heading1"    => "h1",
				      "heading2"    => "h2",
				      "heading3"    => "h3",
				      "heading4"    => "h4",
				      "heading5"    => "h5",
				      "heading6"    => "h6",
				      "line"        => "hr",
				      "indent"      => array('div', array('class' => 'indent')),
				      "image"       => "img",
				      "newline"     => "br",
				      "error"       => array("span", array('class' => 'wiki-system-error')),
				      );
	}

	public function reset() {
		; # nothing
			  }

	public function cleanup() {
    
	}

	public function raw_node($string) {
		return $string;
	}

	public function text_node($text) {
		return htmlspecialchars($text);
	}

	public function open_element($name, $opt=null) {
		if (!isset($opt)) $opt = array();
		switch ($name) {
		case "bolditalic":
			return self::tag_builder("strong", $opt)."<em>";
		case "table":
			return
				self::tag_builder("table",
						  array_merge(array("class" => "wikitable"),
							      $opt))
				. '<tbody>';
		case "link":
			return self::tag_builder("a", $opt);
		default:
			if (array_key_exists($name, $this->tagmap)) {
				$taginfo = self::merge_tagopt($this->tagmap[$name], $opt);
				return self::tag_builder($taginfo[0], $taginfo[1]);
			} else {
				return self::merge_tagopt($name, $opt);
			}
		}
	}

	public function close_element($name, $opt=array()) {
		if (in_array($name, static::$singleton_tags))
			return ''; # no close tag.
		switch ($name) {
		case "bolditalic":
		return "</em></strong>";
		case "table":
			return "</tbody></table>";
		case "link":
			return "</a>";
		default:
			if (array_key_exists($name, $this->tagmap)) {
				$taginfo = self::merge_tagopt($this->tagmap[$name], $opt);
				return self::tag_builder($taginfo[0], $taginfo[1], false);
			} else {
				return "</$name>";
			}
		}
	}

	public function element($name, $text = '', $opts = array()) {
		return $this->open_element($name, $opts) . 
			$this->text_node($text) .
			$this->close_element($name, $opts);
	}

	static protected function merge_tagopt($taginfo, $newopt) {
		if (!is_array($taginfo))
			$taginfo = array($taginfo, array());
		if (!isset($newopt)) return $taginfo;
		$taginfo[1] = $taginfo[1] + $newopt;
		return $taginfo;
	}

	static function tag_builder($name, $opt=null, $open=true) {
		$ret = "<".($open ? '' : '/').htmlspecialchars($name);

		if ($name == "a" && array_key_exists("href", $opt) &&
		    !(array_key_exists("pass_unsecure", $opt) && $opt["pass_unsecure"])) {
			$opt["href"] = preg_replace('/^(javascript|telnet|tel):/i', '', $opt["href"]);
		}

		if ($open && isset($opt) && is_array($opt) && count($opt) > 0 ) {
			foreach($opt as $pname => $pvalue) {
				if ($pname === "id")  {
					$pvalue = self::escape_id_value($pvalue);
				}
				if (isset($pvalue)) {
					$ret .= " " . htmlspecialchars($pname) . '="'. htmlspecialchars($pvalue) .'"';
				} else {
					$ret .= " " . htmlspecialchars($pname);
				}
			}
		} else if ($open && isset($opt) && !empty($opt)) {
			$ret .= " $opt";
		}
		
		$close = in_array($name, static::$singleton_tags) ? ' />' : '>';
		return $ret . $close;
	}
}