      subroutine calc_sigmoid(A,B)
      use index_np
      implicit real*8 (a-h,o-z)
      
      integer N,max_iter,iter
      real*8 A,B
      real*8 prior1,prior0,min_step,sigma,eps,hiTarget,loTarget
      real*8 fApB,p,q,h11,h22,h21,g1,g2,det,dA,dB,gd,stepsize
      real*8 newA,newB,newf,d1,d2,fval
      real*8,allocatable::t(:),f(:),y(:)

      parameter (max_iter=1000,min_step=1e-10,sigma=1e-12,eps=1e-5)

      N=0
      do k=1,NB
        N=N+npset(k)+nnset(k)
      end do
      allocate (t(N),f(N),y(N))

      ii=1
      do k=1,NB
        do i=1,npset(k)+nnset(k)
          y(ii)=yt(i,k)
          f(ii)=ff(i,k)
          ii=ii+1
        end do
      end do

      prior1=0.d0
      prior0=0.d0
      do i=1,N
        if (y(i) .gt. 0.d0) then
          prior1=prior1+1.d0
        else
          prior0=prior0+1.d0
        end if
      end do
      
      hiTarget=(prior1+1.d0)/(prior1+2.d0)
      loTarget=1.d0/(prior0+2.d0)
      
      A=0.d0
      B=log((prior0+1.d0)/(prior1+1.d0))
      fval=0.d0
      do i=1,N
        if (y(i) .gt. 0.d0) then
          t(i)=hiTarget
        else
          t(i)=loTarget
        end if
        fApB=f(i)*A+B
        if (fApB .ge. 0.d0) then
          fval=fval+t(i)*fApB+log(1.d0+exp(-fApB))
        else
          fval=fval+(t(i)-1.d0)*fApB+log(1.d0+exp(fApB))
        end if
      end do

      do iter=1,max_iter
        h11=sigma
        h22=sigma
        h21=0.d0
        g1=0.d0
        g2=0.d0
        do i=1,N
          fApB=f(i)*A+B
          if (fApB .ge. 0.d0) then
            p=exp(-fApB)/(1.d0+exp(-fApB))
            q=1.d0/(1.d0+exp(-fApB))
          else
            p=1.d0/(1.d0+exp(fApB))
            q=exp(fApB)/(1.d0+exp(fApB))
          end if
          d2=p*q
          h11=h11+f(i)*f(i)*d2
          h22=h22+d2
          h21=h21+f(i)*d2
          d1=t(i)-p
          g1=g1+f(i)*d1
          g2=g2+d1
        end do
      
        if (abs(g1) .lt. eps .and. abs(g2) .lt. eps) exit

        det=h11*h22-h21*h21
        dA=-(h22*g1-h21*g2)/det
        dB=-(-h21*g1+h11*g2)/det
        gd=g1*dA+g2*dB
      
        stepsize=1.d0
        do while (stepsize .ge. min_step)
          newA=A+stepsize*dA
          newB=B+stepsize*dB

          newf=0.d0
          do i=1,N
            fApB=f(i)*newA+newB
            if (fApB .ge. 0.d0) then
              newf=newf+t(i)*fApB+log(1.d0+exp(-fApB))
            else
              newf=newf+(t(i)-1.d0)*fApB+log(1.d0+exp(fApB))
            end if
          end do

          if (newf .lt. fval+0.0001d0*stepsize*gd) then
            A=newA; B=newB; fval=newf
            exit
          else
            stepsize=stepsize*0.5d0
          end if
        end do

      end do
  
      if (iter .gt. max_iter) then
        write(0,*) 'Reaching maximal iterations'
      end if
      deallocate (t,f,y)

      end
