      subroutine mk_subQP(N,M,MS,y,alpha,ss,ix
     &     ,Ker,Qmat,qq,yy,ay)
      use kernel_params
      implicit real*8(a-h,o-z)

      integer N,M,MS,ix(N)
      real*8  y(N),alpha(N),ss(N)
      real*8  Ker(MS,N),Qmat(MS,MS),qq(MS),yy(MS),ay,t
      real*8  a1(MS),a2(MS),s1(MS)

!$omp parallel do
      do i=1,MS
        yy(i)=y(ix(i))
        a1(i)=alpha(ix(i))
        s1(i)=ss(ix(i))
      end do

      L=mod(MS,8)
      do i=1,L
        do j=1,MS
          Qmat(j,i)=yy(i)*yy(j)*Ker(j,i)
        end do
      end do
!$omp parallel do private(j)
      do i=L+1,MS,8
        do j=1,MS
          Qmat(j,i)=yy(i)*yy(j)*Ker(j,i)
          Qmat(j,i+1)=yy(i+1)*yy(j)*Ker(j,i+1)
          Qmat(j,i+2)=yy(i+2)*yy(j)*Ker(j,i+2)
          Qmat(j,i+3)=yy(i+3)*yy(j)*Ker(j,i+3)
          Qmat(j,i+4)=yy(i+4)*yy(j)*Ker(j,i+4)
          Qmat(j,i+5)=yy(i+5)*yy(j)*Ker(j,i+5)
          Qmat(j,i+6)=yy(i+6)*yy(j)*Ker(j,i+6)
          Qmat(j,i+7)=yy(i+7)*yy(j)*Ker(j,i+7)
        end do
      end do

      call dgemv('N', MS, MS, 1.d0, Qmat, MS, a1, 1, 0.d0, a2, 1)
        
!$omp parallel do
      do i=1,MS
        qq(i)=1.d0-yy(i)*s1(i)+a2(i)
      end do

      ay=0.d0
!$omp parallel do reduction(+:ay) private(ii)
      do i=MS+1,N
        ii=ix(i)
        ay=ay-alpha(ii)*y(ii)
      end do
      
      return
      end
      
