      subroutine solve_QP(N,Qmat,y,q,ay,a,C,tau,eps_g,eps_m)

      implicit real*8(a-h,o-z)

      integer N,MAX
      real*8 Qmat(N,N),y(N),a(N),b(N),z(N),w(N),rho(N),lambda
      real*8,allocatable::aa(:,:),gg(:)
      real*8 q(N),ay
      real*8 mu,gnrm,g_min
      real*8 Newton

      parameter (MAX=18)

      allocate (aa(N,MAX),gg(MAX))

      mu=1.0d0
      call initial_a(a,b,z,w,rho,lambda,y,ay,C,mu,N)
      do itr=1,MAX
c        write(*,'(A12,I4,A5,1P,E24.15$)') 'outer loop',itr,'mu=',mu
        gnrm=Newton(Qmat,y,q,ay,a,b,z,w,rho,lambda,C,mu,N,eps_g)
c        write(*,'(A7,1P,E24.15)') 'gnrm=',gnrm
c        call flush(6)
        gg(itr)=gnrm
        aa(1:N,itr)=a(1:N)
        if (mu .lt. eps_m .and. gnrm .lt. eps_g) exit
        mu=mu*tau
      end do

      if (itr .ge. MAX) then
        j=1; g_min=gg(1)
        do i=2,MAX
          if (gg(i) .lt. g_min) then
            j=i; g_min=gg(i)
          end if
        end do
        a(1:N)=aa(1:N,j)
c        write(*,'(A7,1P,E24.15)') 'gnrm=',gg(j)
c        call flush(6)
      end if

      deallocate (aa,gg)
      
      return
      end
