<?php
require_once P2_LIB_DIR . '/filectl.class.php';
require_once P2_LIB_DIR . '/Session.php';

/**
 * p2 - OCF؂NX
 * 
 * @created  2005/6/14
 */
class Login
{
    var $user;   // [UiIȂ́j
    var $user_u; // [Ui[UƒڐG镔j
    var $pass_x; // ÍꂽpX[h

    /**
     * @constructor
     */
    function Login()
    {
        $login_user = $this->setdownLoginUser();
    
        // [Uw肳ĂȂ
        if (strlen($login_user) == 0) {

            // OCɎsAOCʂ\ďI
            require_once P2_LIB_DIR . '/login_first.inc.php';
            printLoginFirst($this);
            exit;
        }

        $this->setUser($login_user);
        $this->pass_x = NULL;
    }

    /**
     * [UZbg
     *
     * @access  public
     * @return  void
     */ 
    function setUser($user)
    {
        $this->user_u = $user;
        $this->user = $user;
    }
    
    /**
     * @return  boolean
     */
    function validLoginId($login_id)
    {
        $add_mail = empty($GLOBALS['brazil']) ? '' : '.,@+-';
        
        if (preg_match("/^[0-9a-zA-Z_{$add_mail}]+$/", $login_id)) {
            return true;
        }
        return false;
    }
    
    /**
     * OC[U̎w𓾂
     *
     * @static
     * @access  public
     * @return  string|null
     */
    function setdownLoginUser()
    {
        $login_user = null;

        // [U̗D揇ʂɉ

        // OCtH[̎w
        if (isset($_REQUEST['form_login_id']) and $this->validLoginId($_REQUEST['form_login_id'])) {
            $login_user = $this->setdownLoginUserWithRequest();

        // GETł̎w
        } elseif (isset($_REQUEST['user']) and $this->validLoginId($_REQUEST['user'])) {
            $login_user = $_REQUEST['user'];

        // CookieŎw
        } elseif (isset($_COOKIE['cid']) and ($user = Login::getUserFromCid($_COOKIE['cid'])) !== false) {
            if ($this->validLoginId($user)) {
                $login_user = $user;
            }

        // SessionŎw
        } elseif (isset($_SESSION['login_user']) and $this->validLoginId($_SESSION['login_user'])) {
            $login_user = $_SESSION['login_user'];
        
        /*
        // BasicF؂Ŏw
        } elseif (isset($_REQUEST['basic']) and !empty($_REQUEST['basic'])) {
        
            if (isset($_SERVER['PHP_AUTH_USER']) && ($this->validLoginId($_SERVER['PHP_AUTH_USER']))) {
                $login_user = $_SERVER['PHP_AUTH_USER'];
        
            } else {
                header('WWW-Authenticate: Basic realm="zone"');
                header('HTTP/1.0 401 Unauthorized');
                echo 'Login Failed. [UF؂Ɏs܂B';
                exit;
            }
        */

        }
        
        return $login_user;
    }

    /**
     * REQUEST烍OC[U̎w𓾂
     *
     * @static
     * @access  private
     * @return  string|null
     */
    function setdownLoginUserWithRequest()
    {
        return isset($_REQUEST['form_login_id']) ? $_REQUEST['form_login_id'] : null;
    }
    
    /**
     * F؂s
     *
     * @access  public
     * @return  void
     */
    function authorize()
    {
        global $_conf, $_p2session;
        
        // F؃`FbN
        if (!$this->authCheck()) {
            // OCs
            require_once P2_LIB_DIR . '/login_first.inc.php';
            printLoginFirst($this);
            exit;
        }

        
        // OCOKȂ
        
        // {{{ OAEg̎w肪
        
        if (!empty($_REQUEST['logout'])) {
        
            // ZbVNAiANeBuAANeBu킸j
            Session::unSession();
            
            // ⏕F؂NA
            $this->clearCookieAuth();
            
            $mobile = &Net_UserAgent_Mobile::singleton();
            
            if (isset($_SERVER['HTTP_X_UP_SUBNO'])) {
                file_exists($_conf['auth_ez_file']) && unlink($_conf['auth_ez_file']);
                
            } elseif ($mobile->isSoftBank()) {
                file_exists($_conf['auth_jp_file']) && unlink($_conf['auth_jp_file']);
            
            /* DoCoMo̓OCʂ\̂ŁA⏕F؏jȂ
            } elseif ($mobile->isDoCoMo()) {
                file_exists($_conf['auth_docomo_file']) && unlink($_conf['auth_docomo_file']);
            */
            }
            
            // $user_u_q = empty($_conf['ktai']) ? '' : '?user=' . $this->user_u;

            // indexy[Wɓ]
            $url = rtrim(dirname(P2Util::getMyUrl()), '/') . '/'; // . $user_u_q;
            
            header('Location: '.$url);
            exit;
        }
        
        // }}}
        // {{{ ZbVpĂȂAZbVϐ̍XV
        
        if (isset($_p2session)) {
            
            // [UƃpXXXV
            $_SESSION['login_user']   = $this->user_u;
            $_SESSION['login_pass_x'] = $this->pass_x;
        }
        
        // }}}
        
        // v΁A⏕F؂o^
        $this->registCookie();
        $this->registKtaiId();
        
        // F،̓ZbV
        session_write_close();
    }

    /**
     * F؃[Uݒ̃t@C𒲂ׂāAȃf[^Ȃ̂ĂĂ܂
     *
     * @access  public
     * @return  void
     */
    function cleanInvalidAuthUserFile()
    {
        global $_conf;
        
        if (@include($_conf['auth_user_file'])) {
            // [U񂪂ȂAt@ĈĂĔ
            if (empty($rec_login_user_u) || empty($rec_login_pass_x)) {
                unlink($_conf['auth_user_file']);
            }
        }
    }

    /**
     * F؂̃`FbNs
     *
     * @access  private
     * @return  boolean
     */
    function authCheck()
    {
        global $_conf;
        global $_login_failed_flag;
        global $_p2session;

        $this->cleanInvalidAuthUserFile();
        
        // F؃[Uݒit@Cjǂݍ݂ł
        if (file_exists($_conf['auth_user_file'])) {
            include $_conf['auth_user_file'];

            // [UAF؎sŔ
            if ($this->user_u != $rec_login_user_u) {
                P2Util::pushInfoHtml('<p class="infomsg">p2 error: OCG[</p>');
                
                // OCsOL^
                if (!empty($_conf['login_log_rec'])) {
                    $recnum = isset($_conf['login_log_rec_num']) ? intval($_conf['login_log_rec_num']) : 100;
                    P2Util::recAccessLog($_conf['login_failed_log_file'], $recnum);
                }
                
                return false;
            }
            
            // pX[hݒ肪΁AZbg
            if (isset($rec_login_pass_x) && strlen($rec_login_pass_x) > 0) {
                $this->pass_x = $rec_login_pass_x;
            }
        }
        
        // Fؐݒ or pX[hL^Ȃꍇ͂܂
        if (!$this->pass_x) {

            // VKo^ȊO̓G[bZ[W\
            if (empty($_POST['submit_new'])) {
                P2Util::pushInfoHtml('<p class="infomsg">p2 error: OCG[</p>');
            }
            return false;
        }

        // {{{ NbL[F؃X[pX
        
        if (isset($_COOKIE['cid'])) {
        
            if ($this->checkUserPwWithCid($_COOKIE['cid'])) {
                return true;
                
            // CookieF؂ʂȂ
            } else {
                // ÂNbL[NAĂ
                $this->clearCookieAuth();
            }
        }
        
        // }}}
        
        $mobile = &Net_UserAgent_Mobile::singleton();
        if (PEAR::isError($mobile)) {
            trigger_error($mobile->toString(), E_USER_WARNING);
        
        } elseif ($mobile and !$mobile->isNonMobile()) {
        
            // EZwebF؃X[pX TuXNCoID
            if ($mobile->isEZweb() && isset($_SERVER['HTTP_X_UP_SUBNO']) && file_exists($_conf['auth_ez_file'])) {
                include $_conf['auth_ez_file'];
                if ($_SERVER['HTTP_X_UP_SUBNO'] == $registed_ez) {
                    if (isset($_p2session)) {
                        //$_p2session->regenerateId();
                        $_p2session->updateSecure();
                    }
                    return true;
                }
            }
        
            // SoftBank(J-PHONE)F؃X[pX
            // pPbgΉ@ v[UIDʒmON̐ݒ [VAԍ
            // http://www.dp.j-phone.com/dp/tool_dl/web/useragent.php
            if (HostCheck::isAddrSoftBank() and $sn = P2Util::getSoftBankID()) {
                if (file_exists($_conf['auth_jp_file'])) {
                    include $_conf['auth_jp_file'];
                    if ($sn == $registed_jp) {
                        if (isset($_p2session)) {
                            //  session_regenerate_id(true) Ɛڑr؂ꂽɃOCʂɖ߂炵B
                            // [F؂ĂȂAZbV`FbN܂ōsȂ͂Ȃ̂ɕsvcB
                            //$_p2session->regenerateId();
                            $_p2session->updateSecure();
                        }
                        return true;
                    }
                    $this->registAuthOff($_conf['auth_jp_file']);
                }
            }
        
            // DoCoMo UTNF
            // OCtH[͂͗pApF؃N̂ݗp
            if (empty($_POST['form_login_id'])) {

                if ($mobile->isDoCoMo() && ($sn = $mobile->getSerialNumber()) !== NULL) {
                    if (file_exists($_conf['auth_docomo_file'])) {
                        include $_conf['auth_docomo_file'];
                        if ($sn == $registed_docomo) {
                            if (isset($_p2session)) {
                                // DoCoMoŏ񂾌ɖ߂肷ƍĔF؂ɂȂĕs
                                //$_p2session->regenerateId();
                                $_p2session->updateSecure();
                            }
                            return true;
                        }
                    }
                }
            }
        }
        
        // {{{ łɃZbVo^ĂAZbVŔF
        
        if (isset($_SESSION['login_user']) && isset($_SESSION['login_pass_x'])) {
        
            // ZbVpĂȂAZbV̑Ó`FbN
            if (isset($_p2session)) {
                if ($msg = $_p2session->getSecureSessionErrorMsg()) {
                    P2Util::pushInfoHtml('<p>p2 error: ' . htmlspecialchars($msg) . '</p>');
                    //$_p2session->unSession();
                    // OCs
                    return false;
                }
            }

            if ($this->user_u == $_SESSION['login_user']) {
                if ($_SESSION['login_pass_x'] != $this->pass_x) {
                    $_p2session->unSession();
                    return false;

                } else {
                    return true;
                }
            }
        }
        
        // }}}
        
        // tH[烍OC
        if (!empty($_POST['submit_member'])) {

            // tH[OCȂ
            if ($_POST['form_login_id'] == $this->user_u and sha1($_POST['form_login_pass']) == $this->pass_x) {
                
                // ÂNbL[NAĂ
                $this->clearCookieAuth();

                // OCOL^
                $this->logLoginSuccess();
                if (isset($_p2session)) {
                    $_p2session->regenerateId();
                    $_p2session->updateSecure();
                }
                return true;
            
            // tH[OCsȂ
            } else {
                P2Util::pushInfoHtml('<p class="infomsg">p2 info: OCł܂łB<br>[UpX[hႢ܂B</p>');
                $_login_failed_flag = true;
                
                // OCsOL^
                $this->logLoginFailed();
                return false;
            }
        }
    
        /*
        // BasicF
        if (!empty($_REQUEST['basic'])) {
            if (isset($_SERVER['PHP_AUTH_USER']) and ($_SERVER['PHP_AUTH_USER'] == $this->user_u) && (sha1($_SERVER['PHP_AUTH_PW']) == $this->pass_x)) {
                
                // ÂNbL[NAĂ
                $this->clearCookieAuth();

                // OCOL^
                $this->logLoginSuccess();
                
                if (isset($_p2session)) {
                    $_p2session->regenerateId();
                    $_p2session->updateSecure();
                }
                return true;
                
            } else {
                header('WWW-Authenticate: Basic realm="zone"');
                header('HTTP/1.0 401 Unauthorized');
                echo 'Login Failed. [UF؂Ɏs܂B';
                
                // OCsOL^
                $this->logLoginFailed();
                
                exit;
            }
        }
        */
        
        return false;
    }
    
    /**
     * OCOL^
     *
     * @access  private
     * @return  boolean|null  s|Ȃꍇ
     */
    function logLoginSuccess()
    {
        global $_conf;

        if ($_conf['login_log_rec']) {
            $recnum = isset($_conf['login_log_rec_num']) ? intval($_conf['login_log_rec_num']) : 100;
            return P2Util::recAccessLog($_conf['login_log_file'], $recnum);
        }
        
        return null;
    }

    /**
     * OCsOL^
     *
     * @access  private
     * @return  boolean|null  s|Ȃꍇ
     */
    function logLoginFailed()
    {
        global $_conf;
        
        if ($_conf['login_log_rec']) {
            $recnum = isset($_conf['login_log_rec_num']) ? intval($_conf['login_log_rec_num']) : 100;
            return P2Util::recAccessLog($_conf['login_failed_log_file'], $recnum, 'txt');
        }
        
        return null;
    }

    /**
     * gїp[ID̔Fؓo^Zbg
     *
     * @access  public
     */
    function registKtaiId()
    {
        global $_conf;
        
        $mobile = &Net_UserAgent_Mobile::singleton();
        
        // {{{ Fؓo^ EZweb
        
        if (!empty($_REQUEST['ctl_regist_ez'])) {
            if ($_REQUEST['regist_ez'] == '1') {
                if (!empty($_SERVER['HTTP_X_UP_SUBNO'])) {
                    $this->registAuth('registed_ez', $_SERVER['HTTP_X_UP_SUBNO'], $_conf['auth_ez_file']);
                } else {
                    P2Util::pushInfoHtml('<p class="infomsg">~EZwebpTuXNCoIDł̔Fؓo^͂ł܂ł</p>');
                }
            } else {
                $this->registAuthOff($_conf['auth_ez_file']);
            }
    
        // }}}
        // {{{ Fؓo^ SoftBank
        
        } elseif (!empty($_REQUEST['ctl_regist_jp'])) {
            if ($_REQUEST['regist_jp'] == '1') {
                if (HostCheck::isAddrSoftBank() and $sn = P2Util::getSoftBankID()) {
                    $this->registAuth('registed_jp', $sn, $_conf['auth_jp_file']);
                } else {
                    P2Util::pushInfoHtml('<p class="infomsg">~SoftBankpŗLIDł̔Fؓo^͂ł܂ł</p>');
                }
            } else {
                $this->registAuthOff($_conf['auth_jp_file']);
            }
        
        // }}}
        // {{{ Fؓo^ DoCoMo
        
        } elseif (!empty($_REQUEST['ctl_regist_docomo'])) {
            if ($_REQUEST['regist_docomo'] == '1') {
                // UAɊ܂܂VAID擾
                if ($mobile->isDoCoMo() && ($sn = $mobile->getSerialNumber()) !== NULL) {
                    $this->registAuth('registed_docomo', $sn, $_conf['auth_docomo_file']);
                } else {
                    P2Util::pushInfoHtml('<p class="infomsg">~DoCoMopŗLIDł̔Fؓo^͂ł܂ł</p>');
                }
            } else {
                $this->registAuthOff($_conf['auth_docomo_file']);
            }
        }
        
        // }}}
    }

    /**
     * [IDF؃t@Co^
     *
     * @access  private
     * @return  boolean
     */
    function registAuth($key, $sub_id, $auth_file)
    {
        global $_conf;
    
        $cont = <<<EOP
<?php
\${$key}='{$sub_id}';
?>
EOP;
        FileCtl::make_datafile($auth_file, $_conf['pass_perm']);

        if (false === file_put_contents($auth_file, $cont, LOCK_EX)) {
            P2Util::pushInfoHtml("<p>Error: f[^ۑł܂łBFؓo^sB</p>");
            return false;
        }
        
        return true;
    }
    
    /**
     * o^[ŨpX[hiVK/ύXjۑ
     *
     * @access  public
     * @return  boolean
     */
    function savaRegistUserPass($user_u, $pass)
    {
        global $_conf;

        $pass_x = sha1($pass);
        $auth_user_cont = <<<EOP
<?php
\$rec_login_user_u = '{$user_u}';
\$rec_login_pass_x = '{$pass_x}';
?>
EOP;
        FileCtl::make_datafile($_conf['auth_user_file'], $_conf['pass_perm']);
        
        if (false === file_put_contents($_conf['auth_user_file'], $auth_user_cont, LOCK_EX)) {
            P2Util::pushInfoHtml(sprintf(
                '<p>p2 error: %s ۑł܂łBF؃[Uo^sB</p>',
                hs($_conf['auth_user_file'])
            ));
            return false;
        }
        
        // ZbVϐ
        if (isset($_SESSION['login_pass_x'])) {
            $_SESSION['login_pass_x'] = $pass_x;
        }
        
        // Cookie
        if (!empty($_COOKIE['cid'])) {
            $this->setCookieCid($user_u, $pass_x);
        }
        
        return true;
    }
    
    /**
     * [ID̔F؃t@Co^O
     *
     * @access  private
     * @return  boolean
     */
    function registAuthOff($auth_file)
    {
        if (file_exists($auth_file)) {
            return unlink($auth_file);
        }
        return true;
    }

    /**
     * VK[U쐬
     *
     * @access  public
     * @return  boolean
     */
    function makeUser($user_u, $pass)
    {
        global $_conf;
        
        if (!$this->savaRegistUserPass($user_u, $pass)) {
            p2die('[Uo^ł܂łB');
            return false;
        }
        
        return true;
    }

    /**
     * cookieF؂o^/
     *
     * @access  public
     * @return  boolean
     */
    function registCookie()
    {
        $r = true;
        
        if (!empty($_REQUEST['ctl_regist_cookie'])) {
            if ($_REQUEST['regist_cookie'] == '1') {
            
                $ignore_cip = false;
                if (!empty($_POST['ignore_cip'])) {
                    $ignore_cip = true;
                }
                $r = $this->setCookieCid($this->user_u, $this->pass_x, $ignore_cip);
            } else {
                // NbL[NA
                $r = $this->clearCookieAuth();
            }
        }
        return $r;
    }

    /**
     * CookieF؂NA
     *
     * @access  public
     * @return  boolean
     */
     function clearCookieAuth()
     {
        $r = setcookie('cid', '', time() - 3600);
        
        setcookie('p2_user', '', time() - 3600);    //  p~vf 2005/6/13
        setcookie('p2_pass', '', time() - 3600);    //  p~vf 2005/6/13
        setcookie('p2_pass_x', '', time() - 3600);  //  p~vf 2005/6/13
        
        $_COOKIE = array();
        
        return $r;
     }

    /**
     * CIDcookieɃZbg
     *
     * @access  protected
     * @return  boolean
     */
    function setCookieCid($user_u, $pass_x, $ignore_cip = null)
    {
        global $_conf;
        
        $time = time() + 60*60*24 * $_conf['cid_expire_day'];
        
        if (!is_null($ignore_cip)) {
            if ($ignore_cip) {
                setcookie('ignore_cip', '1', $time);
                $_COOKIE['ignore_cip'] = '1';
            } else {
                setcookie('ignore_cip', '', time() - 3600);
                unset($_COOKIE['ignore_cip']);
            }
        }
        
        if ($cid = $this->makeCid($user_u, $pass_x)) {
            // httponly̑ΉPHP5.2.0
            if (version_compare(phpversion(), '5.2.0', '<')) {
                return setcookie('cid', $cid, $time, $path = '', $domain = '', $secure = 0);
            } else {
                return setcookie('cid', $cid, $time, $path = '', $domain = '', $secure = 0, $this->isAcceptableCookieHttpOnly());
            }
        }
        return false;
    }
    
    /**
     * cookieHttpOnly\ł true Ԃ
     *
     * @access  private
     * @return  boolean
     */
    function isAcceptableCookieHttpOnly()
    {
        /*
        if (version_compare(phpversion(), '5.2.0', '<')) {
            return false;
        }
        */
        
        $ua = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : null;
        
        // Mac IÉAsǂN炵ۂ̂őΏۂOBiΉĂȂj
        // MAC IE5.1  Mozilla/4.0 (compatible; MSIE 5.16; Mac_PowerPC)
        if (preg_match('/MSIE \d\\.\d+; Mac/', $ua)) {
            return false;
        }
        
        return true;
    }
    
    /**
     * IDPASSƎԂ߂ĈÍCookieiCIDj𐶐擾
     *
     * @access  private
     * @return  string|false
     */
    function makeCid($user_u, $pass_x)
    {
        if (is_null($user_u) || is_null($pass_x)) {
            return false;
        }
        
        require_once P2_LIB_DIR . '/md5_crypt.inc.php';
        
        $user_time  = $user_u . ':' . time() . ':';
        $md5_utpx = md5($user_time . $pass_x);
        $cid_src  = $user_time . $md5_utpx;
        return $cid = md5_encrypt($cid_src, $this->getMd5CryptPassForCid());
    }

    /**
     * CookieiCIDj烆[U𓾂
     *
     * @static
     * @access  private
     * @return  array|false  ΔzAsȂ false Ԃ
     */
    function getCidInfo($cid)
    {
        global $_conf;
        
        require_once P2_LIB_DIR . '/md5_crypt.inc.php';
        
        $dec = md5_decrypt($cid, Login::getMd5CryptPassForCid());
        
        $user = $time = $md5_utpx = null;
        list($user, $time, $md5_utpx) = split(':', $dec, 3);
        if (!strlen($user) || !$time || !$md5_utpx) {
            return false;
        }
        
        // L 
        if (time() > $time + (60*60*24 * $_conf['cid_expire_day'])) {
            return false; // ؂
        }
        return array($user, $time, $md5_utpx);
    }
    
    /**
     * CookieiCIDjuser𓾂
     *
     * @static
     * @access  public
     * @return  string|false
     */
    function getUserFromCid($cid)
    {
        if (!$ar = Login::getCidInfo($cid)) {
            return false;
        }
        
        return $user = $ar[0];
    }
    
    /**
     * CookieiCIDjuser, passƍ
     *
     * @access  public
     * @return  boolean
     */
    function checkUserPwWithCid($cid)
    {
        global $_conf;
        
        if (is_null($this->user_u) || is_null($this->pass_x) || is_null($cid)) {
            return false;
        }
        
        if (!$ar = $this->getCidInfo($cid)) {
            return false;
        }
        
        $time     = $ar[1];
        $md5_utpx = $ar[2];
        
        
        return ($md5_utpx == md5($this->user_u . ':' . $time . ':' . $this->pass_x));
    }
    
    /**
     * md5_encrypt, md5_decrypt ̂߂ password(salt) 𓾂
     * iNbL[cid̐ɗpĂj
     *
     * @static
     * @access  private
     * @return  string
     */
    function getMd5CryptPassForCid()
    {
        //return md5($_SERVER['SERVER_NAME'] . $_SERVER['HTTP_USER_AGENT'] . $_SERVER['SERVER_SOFTWARE']);
        
        //$seed = $_SERVER['SERVER_NAME'] . $_SERVER['SERVER_SOFTWARE'];
        $seed = $_SERVER['SERVER_SOFTWARE'];
        
        require_once P2_LIB_DIR . '/HostCheck.php';
        
        // [J`FbNāAHostCheck::isAddrDocomo() ȂǂŃzXg@炷
        $notK = (bool)(HostCheck::isAddrLocal() || HostCheck::isAddrPrivate());
        
        // gє肳ꂽꍇ́A IP`FbNȂ
        if (
            !$notK and 
            //!$_conf['cid_seed_ip'] or
            UA::isK(geti($_SERVER['HTTP_USER_AGENT']))
            || HostCheck::isAddrDocomo() || HostCheck::isAddrAu() || HostCheck::isAddrSoftBank()
            || HostCheck::isAddrWillcom()
            || HostCheck::isAddrJigWeb() || HostCheck::isAddrJig()
            || HostCheck::isAddrIbis()
        ) {
            ;
        } elseif (!empty($_COOKIE['ignore_cip'])) {
            ;
        } else {
            $now_ips = explode('.', $_SERVER['REMOTE_ADDR']);
            $seed .= $now_ips[0];
        }
        
        return md5($seed);
    }

}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
