<?php
require_once 'Net/UserAgent/Mobile.php';

$GLOBALS['_SecureSession_version_id'] = 1; // ZbṼo[WiSẲғrZbVjUP肷j

/**
 * IR, UA, ANZXԂ̃`FbN𔺂AZLAȃZbVǗNX
 * قƂǎœ̂ł܂CɂAʏʂ $_SESSION ̒l舵΂悢B
 * A$_SESSION[$this->sess_array]i$_SESSION['_secure_session']j ͗\ƂȂĂB
 *
 * p
 * $_session =& new Session(); // RXgN^̎_PHPWZbVX^[g
 * // ZLAȃZbV`FbN
 * if ($error_msg = $_session->getSecureSessionErrorMsg()) {
 *     die('Error: ' . $error_msg);
 * }
 *
 * $_SESSIONւ̃ANZXÍAsession_write_close() ĂƂ悢낤B
 *
 * dv
 * php.ini  session.auto_start = 0 (PHP̃ftHĝ܂) ɂȂĂ邱ƁB
 * ȂƂقƂǂ̃ZbV֘Ãp[^XNvgŕύXłȂB
 * .htaccessŕύXĂȂ
 *
 * <IfModule mod_php4.c>
 *    php_flag session.auto_start Off
 * </IfModule>
 *
 * łOKB
 *
 * ܂āANX SecureSession ɉ\
 */
class Session
{
    var $sess_array = '_secure_session';
    var $_expire_minutes = 120;
    
    /**
     * @constructor
     *
     * RXgN^̎_ŁAPHP̕WZbVX^[g
     */
    function Session($session_name = NULL, $session_id = NULL)
    {
        $this->setCookieHttpOnly();
        
        session_cache_limiter('none'); // LbVȂ
        
        if ($session_name) { session_name($session_name); }
        if ($session_id)   { session_id($session_id); }
        
        session_start();
        
        $this->outputAddRewirteSID();
        
        /*
        Expires: Thu, 19 Nov 1981 08:52:00 GMT
        Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0
        Pragma: no-cache
        */
    }
    
    /**
     * ZbV̗LԂݒ肷ij
     *
     * @access public
     * @see    checkAcTime()
     */
    function setExpireMinutes($minutes)
    {
        $this->_expire_minutes = $minutes;
    }
    
    /**
     * @access public
     * @return boolean
     */
    function regenerateId()
    {
        //$oldID = session_id();

        // 萔SIDύXɒǐ悤BCookieLȎASID͋󕶎""ƂȂB
        if (!session_regenerate_id(true)) {
            return false;
        }
        //$sessionFile = session_save_path() . "/sess_$oldID";
        //file_exists($sessionFile) && unlink($sessionFile);
        
        return $this->outputAddRewirteSID();
    }
    
    /**
     * @access private
     * @return boolean
     */
    function outputAddRewirteSID()
    {
        global $_conf;
        
        $session_name = session_name();
        if (!ini_get('session.use_trans_sid') and !isset($_COOKIE[$session_name]) || !empty($_conf['disable_cookie'])) {
            return output_add_rewrite_var($session_name, session_id());
        }
        return true;
    }
    
    /**
     * ZLAȃZbVǗJn
     *
     * @access  public
     * @return  boolean
     */
    function startSecure()
    {
        // ZLAZbVϐ܂o^ĂȂ΁A
        if (!$this->isSecureActive()) {
        
            // ZbVŒUisession fixationj΍
            // http://tdiary.ishinao.net/20060825.html#p02
            // OCシ regenerateId() ̂悢B
            $this->regenerateId();
            
            $this->updateSecure();
            
            // ZbVϐ̓o^ɎsĂAG[
            if (!$this->isSecureActive()) {
                trigger_error(__CLASS__ . '->' . __FUNCTION__ . '() ZbVϐo^ł܂łB', E_USER_WARNING);
                die('Error: Session');
                return false;
            }
        }
        
        return true;
    }
    
    /**
     * ZLAZbVϐ/XV
     *
     * @access  public
     * @return  void
     */
    function updateSecure()
    {
        $_SESSION[$this->sess_array] = array();
        
        $_SESSION[$this->sess_array]['actime']     = time();
        $_SESSION[$this->sess_array]['ip']         = $_SERVER['REMOTE_ADDR'];
        $_SESSION[$this->sess_array]['ua']         = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : null;
        // $_SESSION[$this->sess_array]['referer'] = $_SERVER['HTTP_REFERER'];
        $_SESSION[$this->sess_array]['version']    = $GLOBALS['_SecureSession_version_id'];
    }
    
    /**
     * ZLAZbVғԂłtrueԂ
     *
     * @access  private
     * @return  boolean
     */
    function isSecureActive()
    {
        return isset($_SESSION[$this->sess_array]['actime']);
    }
    
    // ݊pigetSessionErrorMsg()  getSecureSessionErrorMsg() ɖ̕ύXĂj
    function getSessionErrorMsg()
    {
        return $this->getSecureSessionErrorMsg();
    }
    
    /**
     * ZLAZbV̑Ó`FbNāAG[΃bZ[W𓾂B
     * ZLAZbVϐ̍XVōsB
     * 
     * @access  public
     * @return  null|string G[΁AiunSession()ājG[bZ[WԂBȂ null ԂB
     */
    function getSecureSessionErrorMsg()
    {
        // ZLAZbVJn
        $this->startSecure();
        
        $error_msg = '';
        
        if (!$this->isSecureActive()) {
            $error_msg = 'ZbV@\Ă܂B';

        } else {
        
            if (!$this->checkAcTime()) {
                $error_msg = 'ZbV̎Ԑ؂łBēxOCĂB';
            }
        
            if (!$this->checkVersion()) {
                $error_msg = 'ZbṼo[W܂B'
                    .'i̓VXẽo[WAbvɂāAꎞIɋN邱Ƃ̂錻ۂłj';
            }
            
            if (!$this->checkIP()) {
                $error_msg = 'ZbVIP܂B';
            }
            
            if (!$this->checkUA()) {
                $error_msg = 'ZbVUA܂B';
            }
        }
        
        // G[΁AiunSession()ājG[bZ[WԂB
        if ($error_msg) {
            $this->unSession();
            return $error_msg;
        }
        
        // Ȃ΁AZLAZbVϐXV
        $this->updateSecure();
        
        // NG[SIDtꍇ́A session_regenerate_id() AAƏs
        // ߋANZX5ȑO𖳌ɂƂłA
        /*
        $session_name = session_name();
        if (!isset($_COOKIE[$session_name])) {
            $this->regenerateId();
        }
        */
        
        return null;
    }
    
    /**
     * ZbṼANZXԂ`FbN
     *
     * @access  private
     * @return  boolean
     */
    function checkAcTime()
    {
        // ŏIANZXԂA莞Ԉȏオo߂ĂExpire
        if ($_SESSION[$this->sess_array]['actime'] + $this->_expire_minutes * 60 < time()) {
            return false;
        } else {
            return true;
        }
    }
    
    /**
     * ZbṼo[W`FbN
     *
     * @access  private
     * @return  boolean
     */
    function checkVersion()
    {
        if ($_SESSION[$this->sess_array]['version'] == $GLOBALS['_SecureSession_version_id']) {
            return true;
        } else {
            return false;
        }
    }
    
    /**
     * IPAhXÓ`FbN
     *
     * @access  private
     * @return  boolean
     */
    function checkIP()
    {
        $check_level = 1; // 0`4 IP낱ςDoCoMolƁA1܂
        
        $ses_ips = explode('.', $_SESSION[$this->sess_array]['ip']);
        $now_ips = explode('.', $_SERVER['REMOTE_ADDR']);
    
        for ($i = 0; $i++; $i < $check_level) {
            if ($ses_ips[$i] != $now_ips[$i]) {
                return false;
            }
        }
        return true;
    }

    /**
     * UAŃZbV̑Ó`FbN
     *
     * @access  private
     * @return  boolean
     */
    function checkUA()
    {
        // ibisBrowser 219.117.203.9
        // Mozilla/4.0 (compatible; ibisBrowser; ip210.153.84.0; ser0123456789ABCDE) 
        // http://qb5.2ch.net/test/read.cgi/operate/1141521195/748
        if ($_SERVER['REMOTE_ADDR'] == '219.117.203.9') {
            return true;
        }
        
        // {{{ DoCoMoUTNUA㕔ς̂ŋ@햼Ō؂
        
        $mobile = &Net_UserAgent_Mobile::singleton();
        if ($mobile->isDoCoMo()) {
            $mobile_b = &Net_UserAgent_Mobile::factory($_SESSION[$this->sess_array]['ua']);
            if ($mobile_b->getModel() == $mobile->getModel()) {
                return true;
            }
        }
        
        // }}}
        
        $ua = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : null;
        // $offset = 12;
        if (empty($offset)) {
            $offset = strlen($ua);
        }
        if (substr($ua, 0, $offset) == substr($_SESSION[$this->sess_array]['ua'], 0, $offset)) {
            return true;
        }
        return false;
    }

    /**
     * $_SESSIONŃZbVj
     *
     * ZbVȂA͐ȂꍇȂǂ
     * http://jp.php.net/manual/ja/function.session-destroy.php
     *
     * @static
     * @access  public
     * @return  void
     */
    function unSession()
    {
        global $_conf;
        
        // ZbV̏
        // session_name("something")gpĂꍇ͓ɂYȂ悤!
        session_start();

        // ZbVϐSĉ
        $_SESSION = array();
        
        // ZbVؒfɂ̓ZbVNbL[폜B
        $session_name = session_name();
        if (isset($_COOKIE[$session_name])) {
           unset($_COOKIE[$session_name]);
           setcookie($session_name, '', time() - 42000);
        }
        
        // ŏIIɁAZbVj󂷂
        if (isset($_conf['session_dir'])) {
            $session_file = $_conf['session_dir'] . '/sess_' . session_id();
            
        } else {
            $session_file = session_save_path() . '/sess_' . session_id();
        }
        
        session_destroy();
        file_exists($session_file) and unlink($session_file);
    }

    /**
     * ZbVsetcookieHttpOnlyw肷
     * http://msdn2.microsoft.com/ja-jp/library/system.web.httpcookie.httponly(VS.80).aspx
     *
     * @access  private
     * @return  void
     */
    function setCookieHttpOnly()
    {
        $ua = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : null;
        
        // Mac IÉAsǂN炵ۂ̂őΏۂOBiΉĂȂj
        // Mozilla/4.0 (compatible; MSIE 5.16; Mac_PowerPC)
        if (preg_match('/MSIE \d\\.\d+; Mac/', $ua)) {
            return;
        }
        
        ini_set('session.cookie_httponly', true);
    }
}
