<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=0 fdm=marker: */
/* mi: charset=Shift_JIS */

require_once 'HTML/QuickForm/Rule.php';

// QuickForm̃[i͈̔́AQuickForm̃Tvpj
class RuleNumericRange extends HTML_QuickForm_Rule
{
    function validate($value, $options)
    {
        if (isset($options['min']) && floatval($value) < $options['min']) {
            return false;
        }
        if (isset($options['max']) && floatval($value) > $options['max']) {
            return false;
        }
        return true;
    }

    function getValidationScript($options = null)
    {
        $jsCheck = array();
        if (isset($options['min'])) {
            $jsCheck[] = 'Number({jsVar}) >= ' . $options['min'];
        }
        if (isset($options['max'])) {
            $jsCheck[] = 'Number({jsVar}) <= ' . $options['max'];
        }
        return array('', "{jsVar} != '' && !(" . implode(' && ', $jsCheck) . ')');
    } // end func getValidationScript
}

// QuickForm̃[izɗvf邩j
class RuleInArray extends HTML_QuickForm_Rule
{
    function validate($value, $options)
    {
        if (in_array($value, $options)) {
            return true;
        }
        return false;
    }
}

// QuickForm̃[izɗvf邩j
class RuleInArrayKeys extends HTML_QuickForm_Rule
{
    function validate($value, $options)
    {
        if (isset($options[$value])) {
            return true;
        }
        return false;
    }
}

?>
