<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=0 fdm=marker: */
/* mi: charset=Shift_JIS */
/*
    p2 - {[hj[NX for menu.php
*/

require_once (P2_LIBRARY_DIR . '/filectl.class.php');

//==========================================================
// {[hj[NX
//==========================================================
class BrdMenu{

    var $categories; // NX BrdMenuCate ̃IuWFNgi[z
    var $num; // i[ꂽ BrdMenuCate IuWFNg̐
    var $format; // html`Abrd`("html", "brd")
    var $cate_match; // JeS[}b``
    var $ita_match; // }b``

    function BrdMenu()
    {
        $this->num = 0;
    }

    /**
     * JeS[ǉ
     */
    function addBrdMenuCate(&$aBrdMenuCate)
    {
        $this->categories[] = &$aBrdMenuCate;
        $this->num++;
    }

    /**
     * p^[}b`̌`o^
     */
    function setBrdMatch($brdName)
    {
        // html`
        if (preg_match('/(html?|cgi)$/', $brdName)) {
            $this->format = 'html';
            $this->cate_match = "/<B>(.+)<\/B><BR>.*$/i";
            $this->ita_match = "/^<A HREF=\"?(http:\/\/(.+)\/([^\/]+)\/([^\/]+\.html?)?)\"?( target=\"?_blank\"?)?>(.+)<\/A>(<br>)?$/i";
        // brd`
        } else {
            $this->format = 'brd';
            $this->cate_match = "/^(.+)\t([0-9])$/";
            $this->ita_match = "/^\t?(.+)\t(.+)\t(.+)$/";
        }
    }

    /**
     * f[^ǂݍŁAJeSƔo^
     */
    function setBrdList($data)
    {
        global $_conf, $word, $word_fm, $k_filter_marker;

        if (empty($data)) { return false; }

        // OURLXg
        $not_bbs_list = array('http://members.tripod.co.jp/Backy/del_2ch/');

        // zXg-}bsOz
        $hostMap = array();

        foreach ($data as $v) {
            $v = rtrim($v);

            // JeST
            if (preg_match($this->cate_match, $v, $matches)) {
                $aBrdMenuCate = &new BrdMenuCate($matches[1]);
                if ($this->format == 'brd') {
                    $aBrdMenuCate->is_open = $matches[2];
                }
                $this->addBrdMenuCate($aBrdMenuCate);
            // T
            } elseif (preg_match($this->ita_match, $v, $matches)) {
                // html`Ȃ珜OURLO
                if ($this->format == 'html') {
                    foreach ($not_bbs_list as $not_a_bbs) {
                        if ($not_a_bbs == $matches[1]) { continue 2; }
                    }
                }
                $aBrdMenuIta = &new BrdMenuIta;
                // html`
                if ($this->format == 'html') {
                    $aBrdMenuIta->host = $matches[2];
                    $aBrdMenuIta->bbs = $matches[3];
                    $itaj_match = $matches[6];
                // brd`
                } else {
                    $aBrdMenuIta->host = $matches[1];
                    $aBrdMenuIta->bbs = $matches[2];
                    $itaj_match = $matches[3];
                }
                $aBrdMenuIta->setItaj(rtrim($itaj_match));

                $hostMap[] = implode('<>', array($aBrdMenuIta->host, $aBrdMenuIta->bbs, $aBrdMenuIta->itaj));

                // }b` ===================================

                //K\
                if ($word_fm) {
                    if (StrCtl::filterMatch($word_fm, $aBrdMenuIta->itaj)) {
                        $this->categories[$this->num-1]->match_attayo=true;
                        $GLOBALS['ita_mikke']['num']++;

                        // }[LO
                        if ($_conf['ktai']) {
                            if ($k_filter_marker) {
                                $aBrdMenuIta->itaj_ht = StrCtl::filterMarking($word_fm, $aBrdMenuIta->itaj, $k_filter_marker);
                            }
                        } else {
                            $aBrdMenuIta->itaj_ht = StrCtl::filterMarking($word_fm, $aBrdMenuIta->itaj);
                        }

                    // ȂāAɌgт̎
                    } else {
                        if ($_conf['ktai']) {
                            continue;
                        }
                    }
                }

                if ($this->num) {
                    $this->categories[$this->num-1]->addBrdMenuIta($aBrdMenuIta);
                }
            }
        }

        // host-bbs̑Ή\LbV
        if (count($hostMap) > 0) {
            $hostMap = array_unique($hostMap);
            $hostMapCache = $_conf['pref_dir'] . '/p2_host_bbs_map.txt';
            $fp = fopen($hostMapCache, 'wb') or die("Error: {$hostMapCache} XVł܂ł");
            foreach ($hostMap as $line) {
                fputs($fp, $line);
                fputs($fp, "\n");
            }
            fclose($fp);
        }

    }

    /**
    * brdt@C𐶐
    *
    * @return   string  brdt@C̃pX
    */
    function makeBrdFile($cachefile)
    {
        global $_conf, $_info_msg_ht, $word;

        $p2brdfile = $cachefile.".p2.brd";
        FileCtl::make_datafile($p2brdfile, $_conf['p2_perm']);
        $data = @file($cachefile);
        $cont = '';
        $this->setBrdMatch($cachefile); // p^[}b``o^
        $this->setBrdList($data); // JeS[ƔZbg
        if ($this->categories) {
            foreach ($this->categories as $cate) {
                if ($cate->num > 0) {
                    $cont .= $cate->name."\t0\n";
                    foreach ($cate->menuitas as $mita) {
                        $cont .= "\t{$mita->host}\t{$mita->bbs}\t{$mita->itaj}\n";
                    }
                }
            }
        }

        if ($cont) {
            if (FileCtl::file_write_contents($p2brdfile, $cont) === FALSE) {
                die("p2 error: {$p2brdfile} XVł܂ł");
            }
            return $p2brdfile;
        } else {
            if (!$word) {
                $_info_msg_ht .=  "<p>p2 error: {$cachefile} j[𐶐邱Ƃ͂ł܂łB</p>\n";
            }
            return false;
        }
    }

}

/**
 * {[hj[JeS[NX
 */
class BrdMenuCate{

    var $name;      // JeS[̖O
    var $menuitas;  // NXBrdMenuItãIuWFNgi[z
    var $num;       // i[ꂽBrdMenuItaIuWFNg̐
    var $is_open;   // J(bool)
    var $match_attayo;

    /**
     * RXgN^
     */
    function BrdMenuCate($name)
    {
        $this->num = 0;
        $this->menuitas = array();

        $this->name = $name;
    }

    function addBrdMenuIta(&$aBrdMenuIta)
    {
        $this->menuitas[] = &$aBrdMenuIta;
        $this->num++;
    }

}

/**
 * {[hj[NX
 */
class BrdMenuIta{
    var $host;
    var $bbs;
    var $itaj;  // 
    var $itaj_en;   // GR[h
    var $itaj_ht;   // HTMLŏo͂itB^Ój

    function setItaj($itaj)
    {
        $this->itaj = $itaj;
        $this->itaj_en = rawurlencode(base64_encode($this->itaj));
        $this->itaj_ht = htmlspecialchars($this->itaj);
    }
}

?>
