<?php
require_once P2_LIB_DIR . '/P2Util.php';
require_once P2_LIB_DIR . '/FileCtl.php';

// {{{ BbsMap

/**
 * BbsMapNX
 * -zXg̑Ή\쐬AɊÂăzXg̓s
 *
 * @static
 */
class BbsMap
{
    // {{{ static properties

    /**
     * -zXg̑Ή\
     *
     * @var array
     */
    static private $_map = null;

    // }}}
    // {{{ getCurrentHost()

    /**
     * ŐṼzXg擾
     *
     * @param   string  $host   zXg
     * @param   string  $bbs    
     * @param   bool    $autosync   ړ]oƂɎœ邩ۂ
     * @return  string  ɑΉŐṼzXg
     */
    static public function getCurrentHost($host, $bbs, $autosync = true)
    {
        global $_info_msg_ht;
        static $synced = false;

        // }bsOǂݍ
        $map = self::_getMapping();
        if (!$map) {
            return $host;
        }
        $type = self::_detectHostType($host);

        // `FbN
        if (isset($map[$type]) && isset($map[$type][$bbs])) {
            $new_host = $map[$type][$bbs]['host'];
            if ($host != $new_host && $autosync && !$synced) {
                // ړ]o炨CɔACɃXAŋߓǂ񂾃Xœ
                $msg_fmt = '<p>rep2 info: zXg̈ړ]o܂B(%s/%s  %s/%s)<br>';
                $msg_fmt .= 'CɔACɃXAŋߓǂ񂾃Xœ܂B</p>';
                $_info_msg_ht .= sprintf($msg_fmt, $host, $bbs, $new_host, $bbs);
                self::syncFav();
                $synced = true;
            }
            $host = $new_host;
        }

        return $host;
    }

    // }}}
    // {{{ getBbsName()

    /**
     * LONG擾
     *
     * @param   string  $host   zXg
     * @param   string  $bbs    
     * @return  string  j[ɋLڂĂ
     */
    static public function getBbsName($host, $bbs)
    {
        // }bsOǂݍ
        $map = self::_getMapping();
        if (!$map) {
            return $bbs;
        }
        $type = self::_detectHostType($host);

        // `FbN
        if (isset($map[$type]) && isset($map[$type][$bbs])) {
            $itaj = $map[$type][$bbs]['itaj'];
        } else {
            $itaj = $bbs;
        }

        return $itaj;
    }

    // }}}
    // {{{ syncBrd()

    /**
     * CɔȂǂbrdt@C𓯊
     *
     * @param   string  $brd_path   brdt@C̃pX
     * @return  void
     */
    static public function syncBrd($brd_path)
    {
        global $_conf, $_info_msg_ht;
        static $done = array();

        // {{{ Ǎ

        if (isset($done[$brd_path])) {
            return;
        }

        if (!($lines = FileCtl::file_read_lines($brd_path))) {
            return;
        }
        $map = self::_getMapping();
        if (!$map) {
            return;
        }
        $neolines = array();
        $updated = false;

        // }}}
        // {{{ 

        foreach ($lines as $line) {
            $setitaj = false;
            $data = explode("\t", rtrim($line, "\n"));
            $hoge = $data[0]; // \?
            $host = $data[1];
            $bbs  = $data[2];
            $itaj = $data[3];
            $type = self::_detectHostType($host);

            if (isset($map[$type]) && isset($map[$type][$bbs])) {
                $newhost = $map[$type][$bbs]['host'];
                if ($itaj === '') {
                    $itaj = $map[$type][$bbs]['itaj'];
                    if ($itaj != $bbs) {
                        $setitaj = true;
                    } else {
                        $itaj = '';
                    }
                }
            } else {
                $newhost = $host;
            }

            if ($host != $newhost || $setitaj) {
                $neolines[] = "{$hoge}\t{$newhost}\t{$bbs}\t{$itaj}\n";
                $updated = true;
            } else {
                $neolines[] = $line;
            }
        }

        // }}}
        // {{{ 

        $brd_name = htmlspecialchars(basename($brd_path), ENT_QUOTES);
        if ($updated) {
            self::_writeData($brd_path, $neolines);
            $_info_msg_ht .= sprintf('<p class="info-msg">rep2 info: %s 𓯊܂B</p>', $brd_name);
        } else {
            $_info_msg_ht .= sprintf('<p class="info-msg">rep2 info: %s ͕ύX܂łB</p>', $brd_name);
        }
        $done[$brd_path] = true;

        // }}}
    }

    // }}}
    // {{{ syncIdx()

    /**
     * CɃXȂǂidxt@C𓯊
     *
     * @param   string  $idx_path   idxt@C̃pX
     * @return  void
     */
    static public function syncIdx($idx_path)
    {
        global $_conf, $_info_msg_ht;
        static $done = array();

        // {{{ Ǎ

        if (isset($done[$idx_path])) {
            return;
        }

        if (!($lines = FileCtl::file_read_lines($idx_path))) {
            return;
        }
        $map = self::_getMapping();
        if (!$map) {
            return;
        }
        $neolines = array();
        $updated = false;

        // }}}
        // {{{ 

        foreach ($lines as $line) {
            $data = explode('<>', rtrim($line, "\n"));
            $host = $data[10];
            $bbs  = $data[11];
            $type = self::_detectHostType($host);

            if (isset($map[$type]) && isset($map[$type][$bbs])) {
                $newhost = $map[$type][$bbs]['host'];
            } else {
                $newhost = $host;
            }

            if ($host != $newhost) {
                $data[10] = $newhost;
                $neolines[] = implode('<>', $data) . "\n";
                $updated = true;
            } else {
                $neolines[] = $line;
            }
        }

        // }}}
        // {{{ 

        $idx_name = htmlspecialchars(basename($idx_path), ENT_QUOTES);
        if ($updated) {
            self::_writeData($idx_path, $neolines);
            $_info_msg_ht .= sprintf('<p class="info-msg">rep2 info: %s 𓯊܂B</p>', $idx_name);
        } else {
            $_info_msg_ht .= sprintf('<p class="info-msg">rep2 info: %s ͕ύX܂łB</p>', $idx_name);
        }
        $done[$idx_path] = true;

        // }}}
    }

    // }}}
    // {{{ syncFav()

    /**
     * CɔACɃXAŋߓǂ񂾃X𓯊
     *
     * @return  void
     */
    static public function syncFav()
    {
        global $_conf;
        self::syncBrd($_conf['favita_brd']);
        self::syncIdx($_conf['favlist_idx']);
        self::syncIdx($_conf['recent_idx']);
    }

    // }}}
    // {{{ _getMapping()

    /**
     * 2chj[p[XA-zXg̑Ή\쐬
     *
     * @return  array   site/bbs/(host,itaj) ̑Azz
     *                  _E[hɎsƂ false
     */
    static private function _getMapping()
    {
        global $_conf, $_info_msg_ht;

        // {{{ ݒ

        $bbsmenu_url = 'http://menu.2ch.net/bbsmenu.html';  // j[ URL
        $altmenu_url = 'http://www.2ch.se/bbsmenu.html';    // փj[ URL
        $map_cache_path = $_conf['cache_dir'] . '/host_bbs_map.txt';
        $map_cache_lifetime = 600; // TTL͏Z߂
        $err_fmt = '<p>rep2 error: BbsMap: %s - %s _E[hł܂łB</p>';
        $use_alt = false;

        // }}}
        // {{{ LbVmF

        if (!is_null(self::$_map)) {
            return self::$_map;
        } elseif (file_exists($map_cache_path)) {
            $mtime = filemtime($map_cache_path);
            $expires = $mtime + $map_cache_lifetime;
            if (time() < $expires) {
                $map_cahce = file_get_contents($map_cache_path);
                self::$_map = unserialize($map_cahce);
                return self::$_map;
            }
        } else {
            FileCtl::mkdir_for($map_cache_path);
        }
        touch($map_cache_path);
        clearstatcache();

        // }}}
        // {{{ j[_E[h

        if (!class_exists('HTTP_Request', false)) {
            require 'HTTP/Request.php';
        }

        $params = array();
        $params['timeout'] = $_conf['fsockopen_time_limit'];
        //$params['readTimeout'] = array($_conf['fsockopen_time_limit'], 0);
        if (isset($mtime)) {
            $params['requestHeaders'] = array('If-Modified-Since' => http_date($mtime));
        }
        if ($_conf['proxy_use']) {
            $params['proxy_host'] = $_conf['proxy_host'];
            $params['proxy_port'] = $_conf['proxy_port'];
        }
        $req = new HTTP_Request($bbsmenu_url, $params);
        $req->setMethod('GET');
        $err = $req->sendRequest(true);

        // G[̂ƂÃj[gĂ݂
        if (PEAR::isError($err) && $use_alt) {
            $_info_msg_ht .= sprintf($err_fmt, htmlspecialchars($err->getMessage(), ENT_QUOTES), htmlspecialchars($bbsmenu_url, ENT_QUOTES));
            $_info_msg_ht .= sprintf("<p> %s _E[h܂B</p>", htmlspecialchars($altmenu_url, ENT_QUOTES));
            $bbsmenu_url = $altmenu_url;
            unset ($req, $err);
            $req = new HTTP_Request($bbsmenu_url, $params);
            $req->setMethod('GET');
            $err = $req->sendRequest(true);
        }

        // G[
        if (PEAR::isError($err)) {
            $_info_msg_ht .= sprintf($err_fmt, htmlspecialchars($err->getMessage(), ENT_QUOTES), htmlspecialchars($bbsmenu_url, ENT_QUOTES));
            if (file_exists($map_cache_path)) {
                return unserialize(file_get_contents($map_cache_path));
            } else {
                return false;
            }
        }

        // X|XR[h
        $code = $req->getResponseCode();
        if ($code == 304) {
            $map_cahce = file_get_contents($map_cache_path);
            self::$_map = unserialize($map_cahce);
            return self::$_map;
        } elseif ($code != 200) {
            $_info_msg_ht .= sprintf($err_fmt, htmlspecialchars(strval($code), ENT_QUOTES), htmlspecialchars($bbsmenu_url, ENT_QUOTES));
            if (file_exists($map_cache_path)) {
                return unserialize(file_get_contents($map_cache_path));
            } else {
                return false;
            }
        }

        $res_body = $req->getResponseBody();

        // }}}
        // {{{ p[X

        $regex = '!<A HREF=http://(\w+\.(?:2ch\.net|bbspink\.com|machi\.to|mathibbs\.com))/(\w+)/(?: TARGET=_blank)?>(.+?)</A>!';
        preg_match_all($regex, $res_body, $matches, PREG_SET_ORDER);

        $map = array();
        foreach ($matches as $match) {
            $host = $match[1];
            $bbs  = $match[2];
            $itaj = $match[3];
            $type = self::_detectHostType($host);
            if (!isset($map[$type])) {
                $map[$type] = array();
            }
            $map[$type][$bbs] = array('host' => $host, 'itaj' => $itaj);
        }

        // }}}
        // {{{ LbV

        $map_cache = serialize($map);
        if (FileCtl::file_write_contents($map_cache_path, $map_cache) === false) {
            p2die("cannot write file. ({$map_cache_path})");
        }

        // }}}

        return (self::$_map = $map);
    }

    // }}}
    // {{{ _writeData()

    /**
     * XṼf[^
     *
     * @param   string  $path   ރt@C̃pX
     * @param   array   $neolines   ރf[^̔z
     * @return  void
     */
    static private function _writeData($path, $neolines)
    {
        if (is_array($neolines) && count($neolines) > 0) {
            $cont = implode('', $neolines);
        /*} elseif (is_scalar($neolines)) {
            $cont = strval($neolines);*/
        } else {
            $cont = '';
        }
        if (FileCtl::file_write_contents($path, $cont) === false) {
            p2die("cannot write file. ({$path})");
        }
    }

    // }}}
    // {{{ _detectHostType()

    /**
     * zXg̎ނ𔻒肷
     *
     * @param   string  $host   zXg
     * @return  string  zXg̎
     */
    static private function _detectHostType($host)
    {
        if (P2Util::isHostBbsPink($host)) {
            $type = 'bbspink';
        } elseif (P2Util::isHost2chs($host)) {
            $type = '2channel';
        } elseif (P2Util::isHostMachiBbs($host)) {
            $type = 'machibbs';
        } elseif (P2Util::isHostJbbsShitaraba($host)) {
            $type = 'jbbs';
        } else {
            $type = $host;
        }
        return $type;
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
