<?php
require_once 'PEAR.php';

// {{{ Google_Search_Common

/**
 * Google Web APIs 𗘗pČNX
 *
 * SOAP̎gPHP4(PEAR)PHP5(extension)őSقȂ̂ŁA
 * ̃NXpĂꂼɑΉNXB
 */
abstract class Google_Search_Common
{
    // {{{ properties

    /**
     * Google Search WSDLt@C̃pX
     *
     * @var string
     */
    protected $_wsdl;

    /**
     * Google Web APIs ̃CZXL[
     *
     * @var string
     * @access protected
     */
    protected $_key;

    /**
     * SOAP̃\bhĂԂƂ̃IvV
     *
     * @var array
     *
     * @link http://jp.php.net/manual/ja/function.soap-soapclient-call.php
     * @see PEAR's SOAP/Client.php SOAP_Client::call()
     */
    protected $_options;

    /**
     * ۂGoogleNX̃CX^X
     *
     * @var object
     */
    protected $_soapClient;

    // }}}
    // {{{ setConf()

    /**
     * ݒ̏
     *
     * @param string $wsdl  Google Search WSDLt@C̃pX
     * @param string $key   Google Web APIs ̃CZXL[
     * @return void
     */
    public function setConf($wsdl, $key)
    {
        $this->_wsdl = $wsdl;
        $this->_key  = $key;
        $this->_options = array('namespace' => 'urn:GoogleSearch', 'trace' => 0);
    }

    // }}}
    // {{{ prepareParams()

    /**
     * GoogleɑMl
     *
     * @param string  $q  L[[h
     * @param integer $start  ʂ擾ʒu
     * @param integer $maxResults  ʂ擾ő吔
     * @return array
     */
    public function prepareParams($q, $maxResults = 10, $start = 0)
    {
        //$q = mb_encode_numericentity($q, array(0x80, 0xFFFF, 0, 0xFFFF), 'UTF-8');
        // p[^
        // <!-- note, ie and oe are ignored by server; all traffic is UTF-8. -->
        // <message name="doGoogleSearch">
        return array(
            'key'   => $this->_key, // <part name="key"        type="xsd:string"/>
            'q'     => $q,          // <part name="q"          type="xsd:string"/>
            'start' => $start,      // <part name="start"      type="xsd:int"/>
            'maxResults' => $maxResults, // <part name="maxResults" type="xsd:int"/>
            'filter'    => FALSE,   // <part name="filter"     type="xsd:boolean"/>
            'restrict' => '',       // <part name="restrict"   type="xsd:string"/>
            'safeSearch' => FALSE,  // <part name="safeSearch" type="xsd:boolean"/>
            'lr' => '',             // <part name="lr"         type="xsd:string"/>
            'ie' => 'utf-8',        // <part name="ie"         type="xsd:string"/>
            'oe' => 'utf-8'         // <part name="oe"         type="xsd:string"/>
        );
        // </message>
    }

    // }}}
    // {{{ init()

    /**
     * SOAPNCAg̃CX^X𐶐
     *
     * ̃NXł̓C^[tF[X̒񋟂̂
     *
     * @param string $wsdl  Google Search WSDLt@C̃pX
     * @param string $key   Google Web APIs ̃CZXL[
     * @return boolean
     */
    abstract public function init($wsdl, $key);

    // }}}
    // {{{ doSearch()

    /**
     * s
     *
     * ̃NXł̓C^[tF[X̒񋟂̂
     *
     * @param string  $q  L[[h
     * @param integer $start  ʂ擾ʒu
     * @param integer $maxResults  ʂ擾ő吔
     * @return object
     */
    abstract public function doSearch($q, $maxResults = 10, $start = 0);

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
