<?php

require_once 'Net/UserAgent/Mobile.php';

$GLOBALS['_SESS_VERSION'] = 1; // ZbṼo[WiSẲғrZbVjUP肷j

/**
 * Session Class
 *
 * IR, UA, ANZXԂ̃`FbN𔺂AZLAȃZbVǗNX
 * قƂǎœ̂ł܂CɂAʏʂ $_SESSION ̒l舵΂悢B
 * A$_SESSION[$this->sess_array]i$_SESSION['_sess_array']j ͗\ƂȂĂB
 *
 * p
 * $_session =& new Session(); // ̎_PHPWZbVX^[g
 * if ($msg = $_session->checkSessionError()) { // ZLAȃZbV`FbN
 *     die('Error: ' . $msg);
 * }
 *
 * $_SESSIONւ̃ANZXÍAsession_write_close()ĂƂ悢낤B
 *
 * dv
 * php.ini  session.auto_start = 0 (PHP̃ftHĝ܂) ɂȂĂ邱ƁB
 * ȂƂقƂǂ̃ZbV֘Ãp[^XNvgŕύXłȂB
 * .htaccessŕύXĂȂ
 *
 * <IfModule mod_php4.c>
 *    php_flag session.auto_start Off
 * </IfModule>
 *
 * łOKB
 */
class Session{

    var $sess_array = '_sess_array';

    /**
     * RXgN^
     *
     * PHP̕WZbVX^[g
     */
    function Session($session_name = NULL, $session_id = NULL)
    {
        session_cache_limiter('none'); // LbVȂ

        if ($session_name) { session_name($session_name); }
        if ($session_id)   { session_id($session_id); }
        session_start();

        /*
        Expires: Thu, 19 Nov 1981 08:52:00 GMT
        Cache-Control: no-store, no-cache, must-revalidate, post-check=0, pre-check=0
        Pragma: no-cache
        */

    }

    /**
     * ZLAȃZbVǗJn
     *
     * @access private
     */
    function autoBegin()
    {
        // ܂ZbVn܂ĂȂ
        if (!isset($_SESSION[$this->sess_array]['actime'])) {

            // ZbVϐ($this->sess_array)Zbg
            $this->initSess();

            // ZbVϐ̓o^ɎsAG[
            if (!isset($_SESSION[$this->sess_array]['actime'])) {
                trigger_error('Session::autoBegin() ZbVϐo^ł܂łB', E_USER_WARNING);
                die('Error: Session');
                return false;
            }
        }

        return true;
    }

    /**
     * ZbVn߂ɕϐZbg
     *
     * @access private
     */
    function initSess()
    {
        // 
        $_SESSION[$this->sess_array] = array();

        $_SESSION[$this->sess_array]['actime']     = time();
        $_SESSION[$this->sess_array]['ip']         = $_SERVER['REMOTE_ADDR'];
        $_SESSION[$this->sess_array]['ua']         = $_SERVER['HTTP_USER_AGENT'];
        // $_SESSION[$this->sess_array]['referer'] = $_SERVER['HTTP_REFERER'];
        $_SESSION[$this->sess_array]['version']    = $GLOBALS['_SESS_VERSION'];

        return true;
    }

    /**
     * ZbV̑Ó`FbNāAG[΃bZ[W𓾂BANZXԂ̍XVŁB
     *
     * @access public
     * @return mixed G[΁AiunSession()ājG[bZ[WԂBȂfalseԂB
     */
    function checkSessionError()
    {
        // ZbV
        $this->autoBegin();

        $error_msg = '';

        if (!isset($_SESSION[$this->sess_array]['actime'])) {
            $error_msg = 'ZbV@\Ă܂B';

        } else {

            if (!$this->checkAcTime()) {
                $error_msg = 'ZbV̎Ԑ؂łBēxOCĂB';
            }

            if (!$this->checkVersion()) {
                $error_msg = 'ZbṼo[W܂B'
                    .'i̓VXẽo[WAbvɂāAꎞIɋN邱Ƃ̂錻ۂłj';
            }

            if (!$this->checkIP()) {
                $error_msg = 'ZbVIP܂B';
            }

            if (!$this->checkUA()) {
                $error_msg = 'ZbVUA܂B';
            }
        }

        // G[΁AiunSession()ājG[bZ[WԂB
        if ($error_msg) {
            $this->unSession();
            return $error_msg;
        }

        // Ȃ΁AANZXԂXV
        $_SESSION[$this->sess_array]['actime'] = time();

        // NG[SIDtꍇ́A session_regenerate_id() AAƏs
        // ߋANZX5ȑO𖳌ɂƂłA
        /*
        $sname = session_name();
        if (!$_COOKIE[$sname]) {
            $oldID = session_id();
            session_regenerate_id();
            unlink(session_save_path() . "/sess_$oldID");
        }
        */

        return false;
    }

    /**
     * ZbṼANZXԂ`FbN
     *
     * @access private
     */
    function checkAcTime($minutes = 30)
    {
        // ŏIANZXԂA莞Ԉȏオo߂ĂExpire
        if ($_SESSION[$this->sess_array]['actime'] + $minutes * 60 < time()) {
            return false;
        } else {
            return true;
        }
    }

    /**
     * ZbṼo[W`FbN
     *
     * @access private
     */
    function checkVersion()
    {
        if ($_SESSION[$this->sess_array]['version'] == $GLOBALS['_SESS_VERSION']) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * IPAhXÓ`FbN
     *
     * @access private
     * @return bool
     */
    function checkIP()
    {
        $check_level = 1; // 0`4 DoCoMolƁA1܂

        $ses_ips = explode('.', $_SESSION[$this->sess_array]['ip']);
        $now_ips = explode('.', $_SERVER['REMOTE_ADDR']);

        for ($i = 0; $i++; $i < $check_level) {
            if ($ses_ips[$i] != $now_ips[$i]) {
                return false;
            }
        }
        return true;
    }

    /**
     * UAŃZbV̑Ó`FbN
     *
     * @access private
     */
    function checkUA()
    {
        // {{{ DoCoMoUTNUA㕔ς̂ŋ@햼Ō؂

        $mobile = &Net_UserAgent_Mobile::singleton();
        if ($mobile->isDoCoMo()) {
            $mobile_b = &Net_UserAgent_Mobile::factory($_SESSION[$this->sess_array]['ua']);
            if ($mobile_b->getModel() == $mobile->getModel()) {
                return true;
            }
        }

        // }}}

        // $offset = 12;
        if (empty($offset)) {
            $offset = strlen($_SERVER['HTTP_USER_AGENT']);
        }
        if (substr($_SERVER['HTTP_USER_AGENT'], 0, $offset) == substr($_SESSION[$this->sess_array]['ua'], 0, $offset)) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * $_SESSIONŃZbVj
     *
     * ZbVȂA͐ȂꍇȂǂ
     * http://jp.php.net/manual/ja/function.session-destroy.php
     *
     * @access public
     * NX\bh Session::unSession() łĂяo
     */
    function unSession()
    {
        global $_conf;

        // ZbV̏
        // session_name("something")gpĂꍇ͓ɂYȂ悤!
        session_start();

        // ZbVϐSĉ
        $_SESSION = array();

        // ZbVؒfɂ̓ZbVNbL[폜B
        // Note: ZbV񂾂łȂZbVj󂷂B
        if (isset($_COOKIE[session_name()])) {
           unset($_COOKIE[session_name()]);
           setcookie(session_name(), '', time() - 42000);
        }

        // ŏIIɁAZbVj󂷂
        if (isset($_conf['session_dir'])) {
            $session_file = $_conf['session_dir'] . '/sess_' . session_id();

        } else {
            $session_file = session_save_path() . '/sess_' . session_id();
        }

        session_destroy();
        file_exists($session_file) and unlink($session_file);

        return;
    }

}

?>
