<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=4 fdm=marker: */
/* mi: charset=Shift_JIS */

// p2@\gpbN - RSSp[T

require_once P2EX_LIBRARY_DIR . '/rss/common.inc.php';
require_once 'XML/RSS.php';

if ($GLOBALS['_conf']['expack.rss.with_imgcache'] &&
    ((!$GLOBALS['_conf']['ktai'] && $GLOBALS['_conf']['expack.ic2.enabled'] % 2 == 1) ||
    ($GLOBALS['_conf']['ktai'] && $GLOBALS['_conf']['expack.ic2.enabled'] >= 2))
) {
    require_once P2EX_LIBRARY_DIR . '/rss/getimage.inc.php';
    define('P2_RSS_IMAGECACHE_AVAILABLE', 1);
} else {
    define('P2_RSS_IMAGECACHE_AVAILABLE', 0);
}


/**
 * RSS_E[hAp[XʂԂ
 */
function &p2GetRSS($remotefile, $atom=0)
{
    global $_conf, $_info_msg_ht;

    $refresh = (!empty($_GET['refresh']) || !empty($_POST['refresh']));

    $localpath = rss_get_save_path($remotefile);
    if (PEAR::isError($localpath)) {
        $_info_msg_ht .= "<p>" . $localpath->getMessage() . "</p>\n";
        return $localpath;
    }

    // ۑpfBNgȂ΂
    if (!is_dir(dirname($localpath))) {
        require_once P2_LIBRARY_DIR . '/filectl.class.php';
        FileCtl::mkdir_for($localpath);
    }

    // If-Modified-SinceŃ_E[hit@CAÂA[ĥƂj
    if (!file_exists($localpath) || $refresh ||
        filemtime($localpath) < (time() - $_conf['expack.rss.check_interval'] * 60)
    ) {
        $dl = &P2Util::fileDownload($remotefile, $localpath);
        if ($dl->is_success()) {
            chmod($localpath, $_conf['expack.rss.setting_perm']);
        }
    }

    // LbVXVȂA_E[hȂRSSp[X
    if (file_exists($localpath) && (!isset($dl) || $dl->is_success())) {
        if ($atom) {
            $atom = (isset($dl) && $dl->code == 200) ? 2 : 1;
        }
        $rss = &p2ParseRSS($localpath, $atom);
        return $rss;
    } else {
        return $dl;
    }

}


/**
 * RSSp[X
 */
function &p2ParseRSS($xmlpath, $atom=0)
{
    global $_info_msg_ht;

    // $atom^ȂXSLgRSS 1.0ɕϊ
    // iϊς݃t@C݂ȂA$atom==2̂ƂɎsj
    // XML(Atom)encodingw肳ĂXSLTvZbT
    // R[hUTF-8(XSLŎw肵R[h)ɕϊĂ
    if ($atom) {
        $xslpath = P2EX_LIBRARY_DIR . '/rss/atom03-to-rss10.xsl';
        $rsspath = $xmlpath . '.rss';
        if (file_exists($rsspath) && $atom != 2) {
            // OK
        } elseif (extension_loaded('xslt') || extension_loaded('xsl')) {
            if (!atom_to_rss($xmlpath, $xslpath, $rsspath)) {
                $retval = false;
                return $retval;
            }
        } else {
            $_info_msg_ht = '<p>p2 error: AtomtB[hǂނɂPHPXSLT@\g܂XSL@\gKvłB</p>';
            $retval = false;
            return $retval;
        }
    } else {
        $rsspath = $xmlpath;
    }

    // GR[fBO𔻒肵AXML_RSSNX̃CX^X𐶐
    // 2006-02-01 蓮p~
    /*$srcenc = 'UTF-8';
    $tgtenc = 'UTF-8';
    if ($fp = @fopen($rsspath, 'rb')) {
        $content = fgets($fp, 64);
        if (preg_match('/<\\?xml version=(["\'])1.0\\1 encoding=(["\'])(.+?)\\2 ?\\?>/', $content, $matches)) {
            $srcenc = $matches[3];
        }
        fclose($fp);
    }
    $rss = &new XML_RSS($rsspath, $srcenc, $tgtenc);*/
    $rss = &new XML_RSS($rsspath);
    if (PEAR::isError($rss)) {
        $_info_msg_ht = '<p>p2 error: RSS - ' . $rss->getMessage() . '</p>';
        return $rss;
    }
    // ͑Ώۂ̃^O㏑
    $rss->channelTags = array_unique(array_merge($rss->channelTags, array (
        'CATEGORY', 'CLOUD', 'COPYRIGHT', 'DESCRIPTION', 'DOCS', 'GENERATOR', 'IMAGE',
        'ITEMS', 'LANGUAGE', 'LASTBUILDDATE', 'LINK', 'MANAGINGEditor', 'PUBDATE',
        'RATING', 'SKIPDAYS', 'SKIPHOURS', 'TEXTINPUT', 'TITLE', 'TTL', 'WEBMASTER'
    )));
    $rss->itemTags = array_unique(array_merge($rss->itemTags, array (
        'AUTHOR', 'CATEGORY', 'COMMENTS', 'CONTENT:ENCODED', 'DESCRIPTION',
        'ENCLOSURE', 'GUID', 'LINK', 'PUBDATE', 'SOURCE', 'TITLE'
    )));
    $rss->imageTags = array_unique(array_merge($rss->imageTags, array (
        'DESCRIPTION', 'HEIGHT', 'LINK', 'TITLE', 'URL', 'WIDTH'
    )));
    $rss->textinputTags = array_unique(array_merge($rss->textinputTags, array (
        'DESCRIPTION', 'LINK', 'NAME', 'TITLE'
    )));
    $rss->moduleTags = array_unique(array_merge($rss->moduleTags, array (
        'BLOGCHANNEL:BLOGROLL', 'BLOGCHANNEL:CHANGES', 'BLOGCHANNEL:MYSUBSCRIPTIONS',
        'CC:LICENSE', 'CONTENT:ENCODED', 'DC:CONTRIBUTOR', 'DC:COVERAGE',
        'DC:CREATOR', 'DC:DATE', 'DC:DESCRIPTION', 'DC:FORMAT', 'DC:IDENTIFIER',
        'DC:LANGUAGE', 'DC:PUBDATE', 'DC:PUBLISHER', 'DC:RELATION', 'DC:RIGHTS',
        'DC:SOURCE', 'DC:SUBJECT', 'DC:TITLE', 'DC:TYPE',
        'SY:UPDATEBASE', 'SY:UPDATEFREQUENCY', 'SY:UPDATEPERIOD'
    )));
    // RSSp[X
    $result = $rss->parse();
    if (PEAR::isError($result)) {
        $_info_msg_ht = '<p>p2 error: RSS - ' . $result->getMessage() . '</p>';
        return $result;
    }

    return $rss;
}

/**
 * Atom 0.3  RSS 1.0 ɕϊiʁj
 */
function atom_to_rss($input, $stylesheet, $output)
{
    global $_conf, $_info_msg_ht;

    // ۑpfBNgȂ΂
    if (!is_dir(dirname($output))) {
        require_once P2_LIBRARY_DIR . '/filectl.class.php';
        FileCtl::mkdir_for($output);
    }

    // ϊ
    if (extension_loaded('xslt')) { // PHP4, Sablotron
        $rss_content = atom_to_rss_by_xslt($input, $stylesheet, $output);
    } elseif (extension_loaded('xsl')) { // PHP5, LibXSLT
        $rss_content = atom_to_rss_by_xsl($input, $stylesheet, $output);
    }

    // `FbN
    if (!$rss_content) {
        if (file_exists($output)) {
            unlink($output);
        }
        return FALSE;
    }
    chmod($output, $_conf['expack.rss.setting_perm']);

    // FreeBSD 5.3 Ports  textproc/php4-xslt ł̓oÔϊ̍ۂɖOԂ̂ŕ␳
    // (php4-xslt-4.3.10_2, expat-1.95.8, libiconv-1.9.2_1, Sablot-1.0.1)
    // oÔȂȂ牽ςȂEEE͂B
    $rss_fix_patterns = array(
        '/<(\/)?(RDF|Seq|li)( .+?)?>/u'       => '<$1rdf:$2$3>',
        '/<(channel|item) about=/u'           => '<$1 rdf:about=',
        '/<(\/)?(encoded)>/u'                 => '<$1content:$2>',
        '/<(\/)?(creator|subject|date|pubdate)>/u' => '<$1dc:$2>');
    $rss_fixed = preg_replace(array_keys($rss_fix_patterns), array_values($rss_fix_patterns), $rss_content);
    if (md5($rss_content) != md5($rss_fixed)) {
        $fp = @fopen($output, 'wb') or die("Error: cannot write. ( $output )");
        flock($fp, LOCK_EX);
        fwrite($fp, $rss_fixed);
        flock($fp, LOCK_UN);
        fclose($fp);
    }

    return TRUE;
}


/**
 * Atom 0.3  RSS 1.0 ɕϊiPHP4, XSLTj
 */
function atom_to_rss_by_xslt($input, $stylesheet, $output)
{
    global $_info_msg_ht;

    $xh = xslt_create();
    if (!@xslt_process($xh, $input, $stylesheet, $output)) {
        $errmsg = xslt_errno($xh) . ': ' . xslt_error($xh);
        $_info_msg_ht = '<p>p2 error: XSLT - AtomRSSɕϊł܂łB(' . $errmsg . ')</p>';
        xslt_free($xh);
        return FALSE;
    }
    xslt_free($xh);

    return file_get_contents($output);
}


/**
 * Atom 0.3  RSS 1.0 ɕϊiPHP5, DOM & XSLj
 */
function atom_to_rss_by_xsl($input, $stylesheet, $output)
{
    global $_info_msg_ht;

    // PHP4݊[hł͎gȂAPIĝŁAꎞIɓ[hOffɂ
    ini_set('zend.ze1_compatibility_mode', 'Off');

    $xmlDoc = &new DomDocument;
    $xmlDoc->load($input);
    $xslDoc = &new DomDocument;
    $xslDoc->load($stylesheet);
    $proc = &new XSLTProcessor;
    $proc->importStyleSheet($xslDoc);
    $rssDoc = $proc->transformToDoc($xmlDoc);
    $rssDoc->save($output);

    // p2͊{IPHP4OƂĂ̂PHP4݊[hɖ߂
    ini_set('zend.ze1_compatibility_mode', 'On');

    $rss_content = file_get_contents($output);
    if (!$rss_content) {
        $_info_msg_ht = '<p>p2 error: XSL - AtomRSSɕϊł܂łB</p>';
        return FALSE;
    }

    return $rss_content;
}

/**
 * RSSitemvfɔCӂ̎qvf邩ǂ`FbN
 * vf͖
 */
function rss_item_exists(&$items, $element)
{
    foreach ($items as $item) {
        if (isset($item[$element]) && strlen(trim($item[$element])) > 0) {
            return TRUE;
        }
    }
    return FALSE;
}


/**
 * RSS̓t\pɒ
 */
function rss_format_date($date)
{
    if (preg_match('/(?P<date>(\d\d)?\d\d-\d\d-\d\d)T(?P<time>\d\d:\d\d(:\d\d)?)(?P<zone>([+\-])(\d\d):(\d\d)|Z)?/', $date, $t)) {
        $time = $t['date'].' '.$t['time'].' ';
        if ($t['zone'] && $t['zone'] != 'Z') {
            $time .= $t[6].$t[7].$t[8]; // [+-]HHMM
        } else {
            $time .= 'GMT';
        }
        return date('y/m/d H:i:s', strtotime($time));
    }
    return htmlspecialchars($date, ENT_QUOTES);
}


/**
 * RSSdescriptionvf\pɒ
 */
function rss_desc_converter($description)
{
    // HTML^OȂCR+LF/CR/LF<br>+LFɂȂǁAy`
    if (!preg_match('/<(\/?[A-Za-z]+[1-6]?)( [^>]+>)?( ?\/)?>/', $description)) {
        return preg_replace('/[ \t]*(\r\n?|\n)[ \t]*/', "<br>\n", trim($description));
    }

    // ^Oꗗ
    $allowed_tags = '<a><b><i><u><s><strong><em><code><br><h1><h2><h3><h4><h5><h6><p><div><address><blockquote><ol><ul><li><img>';

    // scriptvfstylevf͒gƂ܂Ƃ߂ď
    $description = preg_replace('/<(script|style)(?: .+?)?>(.+?)?<\/\1>/is', '', $description);
    // s̃^O
    $description = strip_tags($description, $allowed_tags);
    // ^Ȏ`FbN
    $description = preg_replace_callback('/<(\/?[A-Za-z]+[1-6]?)( [^>]+?)?>/', 'rss_desc_tag_cleaner', $description);

    return $description;
}

/**
 * ^OȂǂR[obN֐
 */
function rss_desc_tag_cleaner($tag)
{
    global $_conf;

    $element = strtolower($tag[1]);
    $attributes = trim($tag[2]);
    $close = trim($tag[3]); // HTML 4.01`ŕ\̂Ŗ

    // I^OȂ
    if (!$attributes || substr($element, 0, 1) == '/') {
        return '<'.$element.'>';
    }

    $tag = '<'.$element;
    if (preg_match_all('/(?:^| )([A-Za-z\-]+)\s*=\s*("[^"]*"|\'[^\']*\'|\w[^ ]*)(?: |$)/', $attributes, $matches, PREG_SET_ORDER)) {

        foreach ($matches as $attr) {
            $key = strtolower($attr[1]);
            $value = $attr[2];

            // JavaScriptCxgnhEX^CV[gE^[QbgȂǂ̑͋֎~
            if (preg_match('/^(on[a-z]+|style|class|id|target)$/', $key)) {
                continue;
            }

            // l̈p폜
            $q = substr($value, 0, 1);
            if ($q == "'") {
                $value = str_replace('"', '&quot;', substr($value, 1, -1));
            } elseif ($q == '"') {
                $value = substr($value, 1, -1);
            }

            // ŕ
            switch ($key) {
                case 'href':
                    if ($element != 'a' || preg_match('/^javascript:/i', $value)) {
                        break; // avfȊOhref֎~
                    }
                    return '<a href="'.P2Util::throughIme($value).'"'.$_conf['ext_win_target_at'].'>';
                case 'src':
                    if ($element != 'img' || preg_match('/^javascript:/i', $value)) {
                        break; // imgvfȊOsrc֎~
                    }
                    if (P2_RSS_IMAGECACHE_AVAILABLE) {
                        $image = rss_get_image($value, $GLOBALS['channel']['title']);
                        if ($image[3] != P2_IMAGECACHE_OK) {
                            if ($_conf['ktai']) {
                                // ځ[摜 - g
                                switch ($image[3]) {
                                    case P2_IMAGECACHE_ABORN:return '[p2:ځ[摜]';
                                    case P2_IMAGECACHE_BROKEN: return '[p2:]'; // 
                                    case P2_IMAGECACHE_LARGE: return '[p2:]'; // ͌ł͖
                                    case P2_IMAGECACHE_VIRUS: return '[p2:EBXx]';
                                    default : return '[p2:unknown error]'; // \
                                }
                            } else {
                                // ځ[摜 - PC
                                return "<img src=\"{$image[0][0]}\" {$image[0][1]}>";
                            }
                        } elseif ($_conf['ktai']) {
                            // CC\ - gсiPCpTlCTCYj
                            return "<img src=\"{$image[1][0]}\" {$image[1][1]}>";
                        } else {
                            // CC\ - PCitTCYj
                            return "<img src=\"{$image[0][0]}\" {$image[0][1]}>";
                        }
                    }
                    // C[WLbV̂Ƃ摜͕\Ȃ
                    break '';
                case 'alt':
                    if ($element == 'img' && !P2_RSS_IMAGECACHE_AVAILABLE) {
                        return ' [img:'.$value.']'; // 摜altɕ\
                    }
                    $tag .= ' ="'.$value.'"';
                    break;
                case 'width':
                case 'height':
                    // Ƃ肠
                    break;
                default:
                    $tag .= ' ="'.$value.'"';
            }

        } // endforeach

        // vfōŏImF
        switch ($element) {
            // hrefȂavf
            case 'a':
                return '<a>';
            // altȂimgvf
            case 'img':
                return '';
        }
    } // endif
    $tag .= '>';

    return $tag;
}

?>
