<?php
/* vim: set fileencoding=cp932 ai et ts=4 sw=4 sts=4 fdm=marker: */
/* mi: charset=Shift_JIS */
/*
    p2@\gpbN - RSS摜LbV
*/

require_once P2EX_LIBRARY_DIR . '/ic2/db_images.class.php';
require_once P2EX_LIBRARY_DIR . '/ic2/thumbnail.class.php';

/**
 * C[WLbVURLƉ摜TCYԂ
 */
function rss_get_image($src_url, $memo='')
{
    static $cache = array();

    $key = md5(serialize(func_get_args()));

    if (!isset($cache[$key])) {
        $cache[$key] = rss_get_image_ic2($src_url, $memo);
    }

    return $cache[$key];
}

/**
 * C[WLbVURLƉ摜TCYԂ (ImageCache2)
 */
function rss_get_image_ic2($src_url, $memo='')
{
    $icdb = &new IC2DB_images;
    static $thumbnailer = NULL;
    static $thumbnailer_k = NULL;
    if (is_null($thumbnailer)) {
        $thumbnailer = &new ThumbNailer(1);
        $thumbnailer_k = &new ThumbNailer(2);
    }

    if ($thumbnailer->ini['General']['automemo'] && $memo !== '') {
        $img_memo = IC2DB_Images::uniform($memo, 'SJIS-win');
        if ($memo !== '') {
            $hint = mb_convert_encoding('@', 'UTF-8', 'SJIS-win');
            $img_memo_query = '&amp;hint=' . rawurlencode($hint);
            $img_memo_query .= '&amp;memo=' . rawurlencode($img_memo);
        } else {
            $img_memo = NULL;
            $img_memo_query = '';
        }
    } else {
        $img_memo = NULL;
        $img_memo_query = '';
    }

    $url_en = rawurlencode($src_url);

    // 摜\@
    //   r=0:HTML;r=1:_CNg;r=2:PHPŕ\
    //   CC\pTlC̓IWiLbVĂURLZȂ̂r=2
    //   gїpTlCiSʕ\ړIj̓CC\Ȃ̂r=0
    // TlC̑傫
    //   t=0:IWi;t=1:PCpTlC;t=2:gїpTlC;t=3:ԃC[W
    $img_url = 'ic2.php?r=1&amp;uri=' . $url_en;
    $img_size = '';
    $thumb_url = 'ic2.php?r=2&amp;t=1&amp;uri=' . $url_en;
    $thumb_url2 = 'ic2.php?r=2&amp;t=1&amp;id=';
    $thumb_size = '';
    $thumb_k_url = 'ic2.php?r=0&amp;t=2&amp;uri=' . $url_en;
    $thumb_k_url2 = 'ic2.php?r=0&amp;t=1&amp;id=';
    $thumb_k_size = '';
    $src_exists = FALSE;

    // DBɉ摜񂪓o^ĂƂ
    if ($icdb->get($src_url)) {

        // EBXɊĂt@ĈƂ
        if ($icdb->mime == 'clamscan/infected') {
            $aborn_img = array('./img/x04.png', 'width="32" height="32"');
            return array($aborn_img, $aborn_img, $aborn_img, P2_IMAGECACHE_ABORN);
        }
        // ځ[摜̂Ƃ
        if ($icdb->rank < 0) {
            $virus_img = array('./img/x01.png', 'width="32" height="32"');
            return array($virus_img, $virus_img, $virus_img, P2_IMAGECACHE_VIRUS);
        }

        // IWiLbVĂƂ͉摜𒼐ړǂݍ
        $_img_url = $thumbnailer->srcPath($icdb->size, $icdb->md5, $icdb->mime);
        if (file_exists($_img_url)) {
            $img_url = $_img_url;
            $img_size = "width=\"{$icdb->width}\" height=\"{$icdb->height}\"";
            $src_exists = TRUE;
        }

        // TlC쐬ĂĂƂ͉摜𒼐ړǂݍ
        $_thumb_url = $thumbnailer->thumbPath($icdb->size, $icdb->md5, $icdb->mime);
        if (file_exists($_thumb_url)) {
            $thumb_url = $_thumb_url;
            // ^Cg@\ONŃ^CgL^ĂȂƂDBXV
            if (!is_null($img_memo) && !strstr($icdb->memo, $img_memo)){
                $update = &new IC2DB_images;
                if (!is_null($icdb->memo) && strlen($icdb->memo) > 0) {
                    $update->memo = $img_memo . ' ' . $icdb->memo;
                } else {
                    $update->memo = $img_memo;
                }
                $update->whereAddQuoted('uri', '=', $src_url);
                $update->update();
            }
        } elseif ($src_exists) {
            $thumb_url = $thumb_url2 . $icdb->id;
        }

        // gїpTlC쐬ĂĂƂ͉摜𒼐ړǂݍ
        $_thumb_k_url = $thumbnailer_k->thumbPath($icdb->size, $icdb->md5, $icdb->mime);
        if (file_exists($_thumb_k_url)) {
            $thumb_k_url = $_thumb_k_url;
        } elseif ($src_exists) {
            $thumb_k_url = $thumb_k_url2 . $icdb->id;
        }

        // TlC̉摜TCY
        $thumb_size = $thumbnailer->calc($icdb->width, $icdb->height);
        $thumb_size = preg_replace('/(\d+)x(\d+)/', 'width="$1" height="$2"', $thumb_size);

        // gїpTlC̉摜TCY
        $thumb_k_size = $thumbnailer_k->calc($icdb->width, $icdb->height);
        $thumb_k_size = preg_replace('/(\d+)x(\d+)/', 'width="$1" height="$2"', $thumb_k_size);

    // 摜LbVĂȂƂ
    // ^Cg@\ONȂNGUTF-8GR[h^Cg܂߂
    } else {
        $img_url .= $img_memo_query;
        $thumb_url .= $img_memo_query;
        $thumb_k_url .= $img_memo_query;
    }

    $result = array();
    $result[] = array($img_url, $img_size);
    $result[] = array($thumb_url, $thumb_size);
    $result[] = array($thumb_k_url, $thumb_k_size);
    $result[] = P2_IMAGECACHE_OK;

    return $result;
}

?>
