<?php

// {{{ MatomeCacheList

/**
 * ܂Ƃߓǂ݃LbVXgNX
 */
class MatomeCacheList
{
    // {{{ add()

    /**
     * VGgǉ
     *
     * @param string $content
     * @param array $metaData
     * @param bool $isRawFile   trueȂ$content̓t@CŁA̓e
     *                          deflatek+Base64GR[hꂽf[^
     * @return string
     */
    static public function add($content, array $metaData, $isRawFile = false)
    {
        $key = sprintf('%s%0.6f', self::getKeyPrefix(), microtime(true));

        if ($isRawFile) {
            MatomeCacheDataStore::setRaw($key, file_get_contents($content));
        } else {
            MatomeCacheDataStore::set($key, $content);
        }

        MatomeCacheMetaDataStore::set($key, $metaData);

        return $key;
    }

    // }}}
    // {{{ getKeyPrefix()

    /**
     * L[ړ擾
     *
     * @param string $type
     * @return array
     */
    static public function getKeyPrefix($type = null)
    {
        global $_conf, $_login;

        if ($type === null) {
            if ($_conf['iphone']) {
                $type = 'iphone';
            } elseif ($_conf['ktai']) {
                $type = 'ktai';
            } else {
                $type = 'pc';
            }
        }

        return $_login->user_u . '/' . $type . '/';
    }

    // }}}
    // {{{ getList()

    /**
     * ܂Ƃߓǂ݃LbṼXg擾
     *
     * @param string $type
     * @return array
     */
    static public function getList($type = null)
    {
        $prefix = self::getKeyPrefix($type);
        $orderBy = array('mtime' => 'DESC', 'key' => 'DESC');

        return MatomeCacheMetaDataStore::getKVS()->getAll($prefix, $orderBy);
    }

    // }}}
    // {{{ getAllList()

    /**
     * S܂Ƃߓǂ݃LbṼXg擾
     *
     * @return array
     */
    static public function getAllList()
    {
        $types = array('pc', 'ktai', 'iphone');
        $lists = array();
        foreach ($types as $type) {
            $lists[$type] = self::getList($type);
        }
        return $list;
    }

    // }}}
    // {{{ trim()

    /**
     * cw肵ăLbV폜
     *
     * @param int $length
     * @param string $type
     * @return int
     */
    static public function trim($length, $type = null)
    {
        // $length̏ꍇ͍폜Ȃ
        if ($length < 0) {
            return false;
        }

        $prefix = self::getKeyPrefix($type);

        // $length[̏ꍇ͑S폜
        if ($length == 0) {
            $numRemoved = MatomeCacheDataStore::clear($prefix);
            if ($numRemoved === false) {
                return false;
            }
            MatomeCacheMetaDataStore::clear($prefix);
            return $numRemoved;
        }

        // XVɃ\[g$length+1Ԗڂ̃R[h擾
        $kvs = MatomeCacheDataStore::getKVS();
        $orderBy = array('mtime' => 'DESC', 'key' => 'DESC');
        $result = $kvs->getAll($prefix, $orderBy, 1, $length, true);
        if (empty($result)) {
            return 0;
        }

        $key = key($result);
        $mtime = current($result)->mtime;
        $query = 'DELETE FROM $__table WHERE '
               . P2KeyValueStore::C_KEY_BEGINS
               . ' AND $__mtime <= :mtime';

        // R[hƁAXVÂf[^폜
        $stmt = $kvs->prepare($query);
        $kvs->bindValueForPrefixSearch($stmt, $prefix);
        $stmt->bindValue(':mtime', $mtime, PDO::PARAM_INT);
        if ($stmt->execute()) {
            $numRemoved = $stmt->rowCount();
        } else {
            return false;
        }

        // ^f[^폜
        $kvs = MatomeCacheMetaDataStore::getKVS();
        $stmt = $kvs->prepare($query);
        $kvs->bindValueForPrefixSearch($stmt, $prefix);
        $stmt->bindValue(':mtime', $mtime, PDO::PARAM_INT);
        if ($stmt->execute()) {
            if ($stmt->rowCount() != $numRemoved) {
                // ^f[^̕uxđ}邽߁AHɃf[^
                // mtimeƃ^f[^mtimeقȂ邱ƂAɓB
                $kvs->delete($key);
            }
        }

        // 폜f[^Ԃ
        return $numRemoved;
    }

    // }}}
    // {{{ optimize()

    /**
     * ܂Ƃߓǂ݃LbVœK
     *
     * @param void
     * @return void
     */
    static public function optimize()
    {
        MatomeCacheDataStore::getKVS()->optimize();
        MatomeCacheMetaDataStore::getKVS()->optimize();
    }

    // }}}
}

// }}}

/*
 * Local Variables:
 * mode: php
 * coding: cp932
 * tab-width: 4
 * c-basic-offset: 4
 * indent-tabs-mode: nil
 * End:
 */
// vim: set syn=php fenc=cp932 ai et ts=4 sw=4 sts=4 fdm=marker:
